/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import com.atilika.kuromoji.compile.CharacterDefinitionsCompiler;
import com.atilika.kuromoji.compile.ConnectionCostsCompiler;
import com.atilika.kuromoji.compile.DoubleArrayTrieCompiler;
import com.atilika.kuromoji.compile.ProgressLog;
import com.atilika.kuromoji.compile.TokenInfoDictionaryCompilerBase;
import com.atilika.kuromoji.compile.UnknownDictionaryCompiler;
import com.atilika.kuromoji.trie.DoubleArrayTrie;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public abstract class DictionaryCompilerBase {
    public void build(String inputDirname, String outputDirname, String encoding, boolean compactTries) throws IOException {
        File outputDir = new File(outputDirname);
        outputDir.mkdirs();
        this.buildTokenInfoDictionary(inputDirname, outputDirname, encoding, compactTries);
        this.buildUnknownWordDictionary(inputDirname, outputDirname, encoding);
        this.buildConnectionCosts(inputDirname, outputDirname);
    }

    private void buildTokenInfoDictionary(String inputDirname, String outputDirname, String encoding, boolean compactTrie) throws IOException {
        ProgressLog.begin("compiling tokeninfo dict");
        TokenInfoDictionaryCompilerBase tokenInfoCompiler = this.getTokenInfoDictionaryCompiler(encoding);
        ProgressLog.println("analyzing dictionary features");
        tokenInfoCompiler.analyzeTokenInfo(tokenInfoCompiler.combinedSequentialFileInputStream(new File(inputDirname)));
        ProgressLog.println("reading tokeninfo");
        tokenInfoCompiler.readTokenInfo(tokenInfoCompiler.combinedSequentialFileInputStream(new File(inputDirname)));
        tokenInfoCompiler.compile();
        List<String> surfaces = tokenInfoCompiler.getSurfaces();
        ProgressLog.begin("compiling double array trie");
        DoubleArrayTrie trie = DoubleArrayTrieCompiler.build(surfaces, compactTrie);
        FileOutputStream daTrieOutput = new FileOutputStream(outputDirname + File.separator + "doubleArrayTrie.bin");
        trie.write(daTrieOutput);
        ((OutputStream)daTrieOutput).close();
        try {
            ProgressLog.println("validating saved double array trie");
            DoubleArrayTrie daTrie = DoubleArrayTrie.read(new FileInputStream(outputDirname + File.separator + "doubleArrayTrie.bin"));
            for (String surface : surfaces) {
                if (daTrie.lookup(surface) >= 0) continue;
                ProgressLog.println("failed to look up [" + surface + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ProgressLog.end();
        ProgressLog.begin("processing target map");
        for (int i = 0; i < surfaces.size(); ++i) {
            int doubleArrayId = trie.lookup(surfaces.get(i));
            assert (doubleArrayId > 0);
            tokenInfoCompiler.addMapping(doubleArrayId, i);
        }
        tokenInfoCompiler.write(outputDirname);
        ProgressLog.end();
        ProgressLog.end();
    }

    protected abstract TokenInfoDictionaryCompilerBase getTokenInfoDictionaryCompiler(String var1);

    protected void buildUnknownWordDictionary(String inputDirname, String outputDirname, String encoding) throws IOException {
        ProgressLog.begin("compiling unknown word dict");
        CharacterDefinitionsCompiler charDefCompiler = new CharacterDefinitionsCompiler(new BufferedOutputStream(new FileOutputStream(new File(outputDirname, "characterDefinitions.bin"))));
        charDefCompiler.readCharacterDefinition(new BufferedInputStream(new FileInputStream(new File(inputDirname, "char.def"))), encoding);
        charDefCompiler.compile();
        UnknownDictionaryCompiler unkDefCompiler = new UnknownDictionaryCompiler(charDefCompiler.makeCharacterCategoryMap(), new FileOutputStream(new File(outputDirname, "unknownDictionary.bin")));
        unkDefCompiler.readUnknownDefinition(new BufferedInputStream(new FileInputStream(new File(inputDirname, "unk.def"))), encoding);
        unkDefCompiler.compile();
        ProgressLog.end();
    }

    private void buildConnectionCosts(String inputDirname, String outputDirname) throws IOException {
        ProgressLog.begin("compiling connection costs");
        ConnectionCostsCompiler connectionCostsCompiler = new ConnectionCostsCompiler(new FileOutputStream(new File(outputDirname, "connectionCosts.bin")));
        connectionCostsCompiler.readCosts(new FileInputStream(new File(inputDirname, "matrix.def")));
        connectionCostsCompiler.compile();
        ProgressLog.end();
    }

    protected void build(String[] args) throws IOException {
        String inputDirname = args[0];
        String outputDirname = args[1];
        String inputEncoding = args[2];
        boolean compactTries = Boolean.parseBoolean(args[3]);
        ProgressLog.println("dictionary compiler");
        ProgressLog.println("");
        ProgressLog.println("input directory: " + inputDirname);
        ProgressLog.println("output directory: " + outputDirname);
        ProgressLog.println("input encoding: " + inputEncoding);
        ProgressLog.println("compact tries: " + compactTries);
        ProgressLog.println("");
        this.build(inputDirname, outputDirname, inputEncoding, compactTries);
    }
}

