/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Singleton
public class DefaultTransformationManager
implements TransformationManager {
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private RenderingConfiguration configuration;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    @Deprecated
    public void performTransformations(XDOM dom, Syntax syntax) throws TransformationException {
        this.performTransformations((Block)dom, new TransformationContext(dom, syntax));
    }

    @Override
    public void performTransformations(Block block, TransformationContext context) throws TransformationException {
        boolean error = false;
        for (Transformation transformation : this.getTransformations()) {
            try {
                ((MutableRenderingContext)this.renderingContext).transformInContext(transformation, context, block);
            }
            catch (Exception e) {
                this.logger.error("Failed to execute transformation", (Throwable)e);
                error = true;
            }
        }
        if (error) {
            throw new TransformationException("One or several transformations failed to execute properly. See the logs for details.");
        }
    }

    public List<Transformation> getTransformations() {
        ArrayList<Transformation> transformations = new ArrayList<Transformation>();
        for (String hint : this.configuration.getTransformationNames()) {
            try {
                transformations.add((Transformation)((ComponentManager)this.componentManagerProvider.get()).getInstance(Transformation.class, hint));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to locate transformation with hint [" + hint + "], ignoring it.");
            }
        }
        Collections.sort(transformations);
        return transformations;
    }
}

