/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.data.DataTileManager;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Way;
import net.osmand.shared.ColorPalette;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.routing.RouteColorize;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelLayer;
import net.osmand.util.MapUtils;

public class MapPointsLayer
implements MapPanelLayer {
    private MapPanel map;
    private DataTileManager<Entity> points;
    private Color color = Color.black;
    private int size = 3;
    private String tagToShow = OSMSettings.OSMTagKey.NAME.getValue();
    private Map<Point, Node> pointsToDraw = new LinkedHashMap<Point, Node>();
    private List<LineObject> linesToDraw = new ArrayList<LineObject>();
    private Font whiteFont;
    GpxFile gpxFile;
    public RouteColorize.ColorizationType colorizationType = RouteColorize.ColorizationType.NONE;
    private boolean isGrey = true;

    @Override
    public void destroyLayer() {
    }

    @Override
    public void initLayer(MapPanel map) {
        this.map = map;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPointSize(int size) {
        this.size = size;
    }

    public void setTagToShow(String tag) {
        this.tagToShow = tag;
    }

    @Override
    public void paintLayer(Graphics2D g) {
        this.drawLines(g);
        this.drawPoints(g);
    }

    private void drawLines(Graphics2D g) {
        List<LineObject> linesToDraw = this.linesToDraw;
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        boolean upDown = true;
        for (LineObject e : linesToDraw) {
            Line2D p = e.line;
            Way w = e.w;
            String name = null;
            boolean white = false;
            if (w != null) {
                if (e.nameDraw) {
                    name = w.getTag("name");
                }
                if (white = "white".equalsIgnoreCase(w.getTag("color"))) {
                    g.setColor(Color.gray);
                } else if (w.getTag("colour") != null) {
                    try {
                        Color clr = (Color)Color.class.getField(w.getTag("colour").toUpperCase()).get(null);
                        g.setColor(clr);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    g.setColor(this.color);
                }
            }
            AffineTransform transform = new AffineTransform();
            transform.translate(p.getX1(), p.getY1());
            transform.rotate(p.getX2() - p.getX1(), p.getY2() - p.getY1());
            xPoints[0] = 0;
            xPoints[1] = 0;
            xPoints[2] = xPoints[3] = (int)Math.sqrt((p.getX2() - p.getX1()) * (p.getX2() - p.getX1()) + (p.getY2() - p.getY1()) * (p.getY2() - p.getY1())) + 1;
            yPoints[0] = 0;
            yPoints[3] = 0;
            yPoints[1] = 2;
            yPoints[2] = 2;
            for (int i = 0; i < 4; ++i) {
                Point2D po = transform.transform(new Point(xPoints[i], yPoints[i]), null);
                xPoints[i] = (int)po.getX();
                yPoints[i] = (int)po.getY();
            }
            g.drawPolygon(xPoints, yPoints, 4);
            g.fillPolygon(xPoints, yPoints, 4);
            if (name == null || name.length() <= 0 || this.map.getZoom() < 16) continue;
            Stroke prevStroke = g.getStroke();
            g.setStroke(new BasicStroke(3.0f));
            g.drawOval((int)p.getX2() - 6, (int)p.getY2() - 6, 10, 10);
            Font prevFont = g.getFont();
            Color prevColor = g.getColor();
            AffineTransform prev = g.getTransform();
            double flt = Math.atan2(p.getX2() - p.getX1(), p.getY2() - p.getY1());
            AffineTransform ps = new AffineTransform(prev);
            ps.translate(p.getX2(), p.getY2());
            if (flt < Math.PI && flt > 0.0) {
                ps.rotate(p.getX2() - p.getX1(), p.getY2() - p.getY1());
            } else {
                ps.rotate(-(p.getX2() - p.getX1()), -(p.getY2() - p.getY1()));
            }
            g.setTransform(ps);
            GlyphVector gv = this.whiteFont.createGlyphVector(g.getFontRenderContext(), name);
            int shiftX = (int)(gv.getVisualBounds().getWidth() / 2.0);
            int shiftY = upDown ? 15 : -15;
            upDown = !upDown;
            Shape textShape = gv.getOutline(-shiftX, -shiftY);
            g.setColor(Color.white);
            g.setFont(this.whiteFont);
            g.draw(textShape);
            if (white) {
                g.setColor(Color.lightGray);
            } else {
                g.setColor(Color.DARK_GRAY);
            }
            g.drawString(name, -shiftX, -shiftY);
            g.setStroke(prevStroke);
            g.setColor(prevColor);
            g.setTransform(prev);
            g.setFont(prevFont);
        }
    }

    private void drawPoints(Graphics2D g) {
        Map<Point, Node> pointsToDraw = this.pointsToDraw;
        g.setColor(this.color);
        if (this.whiteFont == null) {
            this.whiteFont = g.getFont().deriveFont(21).deriveFont(1);
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        for (Point p : pointsToDraw.keySet()) {
            int k;
            boolean showGpxPointNumber;
            Node n = pointsToDraw.get(p);
            if (n.getTag("colour") != null) {
                try {
                    Color clr = (Color)Color.class.getField(n.getTag("colour").toUpperCase()).get(null);
                    g.setColor(clr);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else {
                g.setColor(this.color);
            }
            g.drawOval(p.x, p.y, this.size, this.size);
            g.fillOval(p.x, p.y, this.size, this.size);
            boolean bl = showGpxPointNumber = !this.isGpx(n) || DataExtractionSettings.getSettings().isAnimateRouting() && this.map.getZoom() >= 18;
            if (this.tagToShow == null || n.getTag(this.tagToShow) == null || !showGpxPointNumber || this.map.getZoom() <= 14) continue;
            int i = 0;
            String s = n.getTag(this.tagToShow);
            while ((k = s.indexOf(10)) != -1) {
                g.drawString(s.substring(0, k), p.x, p.y + i++ * 15);
                s = s.substring(k + 1);
            }
            g.drawString(s, p.x, p.y + i++ * 15);
        }
        if (this.colorizationType != RouteColorize.ColorizationType.NONE) {
            this.colorizeRoute(g);
        }
    }

    private boolean isGpx(Node n) {
        return n.getTag("gpx") != null;
    }

    @Override
    public void prepareToDraw() {
        if (this.points != null) {
            LinkedHashMap<Point, Node> pointsToDraw = new LinkedHashMap<Point, Node>();
            ArrayList<LineObject> linesToDraw = new ArrayList<LineObject>();
            double xTileLeft = this.map.getXTile() - this.map.getCenterPointX() / this.map.getTileSize();
            double xTileRight = this.map.getXTile() + this.map.getCenterPointX() / this.map.getTileSize();
            double yTileUp = this.map.getYTile() - this.map.getCenterPointY() / this.map.getTileSize();
            double yTileDown = this.map.getYTile() + this.map.getCenterPointY() / this.map.getTileSize();
            double latDown = MapUtils.getLatitudeFromTile((float)this.map.getZoom(), (double)yTileDown);
            double longDown = MapUtils.getLongitudeFromTile((double)this.map.getZoom(), (double)xTileRight);
            double latUp = MapUtils.getLatitudeFromTile((float)this.map.getZoom(), (double)yTileUp);
            double longUp = MapUtils.getLongitudeFromTile((double)this.map.getZoom(), (double)xTileLeft);
            List objects = this.points.getObjects(latUp, longUp, latDown, longDown);
            pointsToDraw.clear();
            linesToDraw.clear();
            for (Entity e : objects) {
                if (e instanceof Way) {
                    List nodes = ((Way)e).getNodes();
                    if (nodes.size() <= 1) continue;
                    int prevPixX = 0;
                    int prevPixY = 0;
                    for (int i = 0; i < nodes.size(); ++i) {
                        Node n = (Node)nodes.get(i);
                        int pixX = (int)((double)MapUtils.getPixelShiftX((float)this.map.getZoom(), (double)n.getLongitude(), (double)this.map.getLongitude(), (double)this.map.getTileSize()) + this.map.getCenterPointX());
                        int pixY = (int)((double)MapUtils.getPixelShiftY((float)this.map.getZoom(), (double)n.getLatitude(), (double)this.map.getLatitude(), (double)this.map.getTileSize()) + this.map.getCenterPointY());
                        if (i > 0) {
                            linesToDraw.add(new LineObject((Way)e, new Line2D.Float(pixX, pixY, prevPixX, prevPixY), i == 1));
                        }
                        prevPixX = pixX;
                        prevPixY = pixY;
                    }
                    continue;
                }
                if (!(e instanceof Node)) continue;
                Node n = (Node)e;
                int pixX = (int)((double)MapUtils.getPixelShiftX((float)this.map.getZoom(), (double)n.getLongitude(), (double)this.map.getLongitude(), (double)this.map.getTileSize()) + this.map.getCenterPointX());
                int pixY = (int)((double)MapUtils.getPixelShiftY((float)this.map.getZoom(), (double)n.getLatitude(), (double)this.map.getLatitude(), (double)this.map.getTileSize()) + this.map.getCenterPointY());
                if (pixX < 0 || pixY < 0) continue;
                pointsToDraw.put(new Point(pixX, pixY), n);
            }
            this.linesToDraw = linesToDraw;
            this.pointsToDraw = pointsToDraw;
        }
    }

    public DataTileManager<Entity> getPoints() {
        return this.points;
    }

    public void setPoints(DataTileManager<Entity> points) {
        this.points = points;
    }

    public void setColorizationType(GpxFile gpxFile, RouteColorize.ColorizationType colorizationType, boolean grey) {
        this.gpxFile = gpxFile;
        this.colorizationType = colorizationType;
        this.isGrey = grey;
    }

    private void colorizeRoute(Graphics2D g) {
        if (this.gpxFile == null || this.colorizationType == RouteColorize.ColorizationType.NONE) {
            return;
        }
        ColorPalette palette = this.isGrey ? ColorPalette.Companion.parsePalette((double[][])new double[][]{{0.0, ColorPalette.Companion.getLIGHT_GREY()}, {1.0, ColorPalette.Companion.getDARK_GREY()}}) : (this.colorizationType == RouteColorize.ColorizationType.SLOPE ? ColorPalette.Companion.getSLOPE_PALETTE() : ColorPalette.Companion.getMIN_MAX_PALETTE());
        RouteColorize routeColorize = new RouteColorize(this.gpxFile, this.colorizationType, palette, false);
        routeColorize.setPalette(palette);
        List dataList = routeColorize.getSimplifiedResult(this.map.getZoom());
        for (int i = 1; i < dataList.size(); ++i) {
            int pixX1 = (int)((double)MapUtils.getPixelShiftX((float)this.map.getZoom(), (double)((RouteColorize.RouteColorizationPoint)dataList.get(i - 1)).getLon(), (double)this.map.getLongitude(), (double)this.map.getTileSize()) + this.map.getCenterPointX());
            int pixY1 = (int)((double)MapUtils.getPixelShiftY((float)this.map.getZoom(), (double)((RouteColorize.RouteColorizationPoint)dataList.get(i - 1)).getLat(), (double)this.map.getLatitude(), (double)this.map.getTileSize()) + this.map.getCenterPointY());
            int pixX2 = (int)((double)MapUtils.getPixelShiftX((float)this.map.getZoom(), (double)((RouteColorize.RouteColorizationPoint)dataList.get(i)).getLon(), (double)this.map.getLongitude(), (double)this.map.getTileSize()) + this.map.getCenterPointX());
            int pixY2 = (int)((double)MapUtils.getPixelShiftY((float)this.map.getZoom(), (double)((RouteColorize.RouteColorizationPoint)dataList.get(i)).getLat(), (double)this.map.getLatitude(), (double)this.map.getTileSize()) + this.map.getCenterPointY());
            GradientPaint gp = new GradientPaint(pixX1, pixY1, new Color(((RouteColorize.RouteColorizationPoint)dataList.get(i - 1)).getPrimaryColor()), pixX2, pixY2, new Color(((RouteColorize.RouteColorizationPoint)dataList.get(i)).getPrimaryColor()), false);
            g.setPaint(gp);
            g.setStroke(new BasicStroke(10.0f));
            g.draw(new Line2D.Float(pixX1, pixY1, pixX2, pixY2));
        }
    }

    @Override
    public void applySettings() {
    }

    private static class LineObject {
        Way w;
        Line2D line;
        boolean nameDraw;

        public LineObject(Way w, Line2D line, boolean nameDraw) {
            this.w = w;
            this.line = line;
            this.nameDraw = nameDraw;
        }
    }
}

