/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.palette.data.solid;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import net.osmand.shared.ColorPalette;
import net.osmand.shared.io.KFile;
import net.osmand.shared.palette.data.PaletteIO;
import net.osmand.shared.palette.data.PaletteUtils;
import net.osmand.shared.palette.data.solid.SolidPaletteFactory;
import net.osmand.shared.palette.domain.Palette;
import net.osmand.shared.palette.domain.PaletteItem;
import net.osmand.shared.palette.domain.PaletteItemSource;
import net.osmand.shared.util.Localization;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\nH\u0002J \u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0002H\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lnet/osmand/shared/palette/data/solid/SolidPaletteIO;", "Lnet/osmand/shared/palette/data/PaletteIO;", "Lnet/osmand/shared/palette/domain/Palette$SolidCollection;", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "HEADER", "", "paletteDirectory", "Lnet/osmand/shared/io/KFile;", "getPaletteDirectory", "()Lnet/osmand/shared/io/KFile;", "sync", "", "oldPalette", "newPalette", "createDefault", "paletteId", "read", "readInternal", "file", "createSolidCollection", "items", "", "Lnet/osmand/shared/palette/domain/PaletteItem$Solid;", "write", "palette", "getFileForId", "id", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nSolidPaletteIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolidPaletteIO.kt\nnet/osmand/shared/palette/data/solid/SolidPaletteIO\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n66#2:161\n52#2,22:162\n1053#3:184\n1062#3:185\n1187#3,2:186\n1261#3,4:188\n1863#3,2:192\n*S KotlinDebug\n*F\n+ 1 SolidPaletteIO.kt\nnet/osmand/shared/palette/data/solid/SolidPaletteIO\n*L\n62#1:161\n62#1:162,22\n117#1:184\n125#1:185\n129#1:186,2\n129#1:188,4\n135#1:192,2\n*E\n"})
public final class SolidPaletteIO
implements PaletteIO<Palette.SolidCollection> {
    @NotNull
    public static final SolidPaletteIO INSTANCE = new SolidPaletteIO();
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("SolidPaletteIO");
    @NotNull
    private static final String HEADER = "# Index,R,G,B,A";

    private SolidPaletteIO() {
    }

    private final KFile getPaletteDirectory() {
        return PlatformUtil.INSTANCE.getOsmAndContext().getColorPaletteDir();
    }

    @Override
    public void sync(@Nullable Palette.SolidCollection oldPalette, @NotNull Palette.SolidCollection newPalette) {
        Intrinsics.checkNotNullParameter((Object)newPalette, (String)"newPalette");
        if (!Intrinsics.areEqual((Object)oldPalette, (Object)newPalette)) {
            this.write(newPalette);
        }
    }

    @Override
    @Nullable
    public Palette.SolidCollection createDefault(@NotNull String paletteId) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        if (!Intrinsics.areEqual((Object)paletteId, (Object)"user_palette_default")) {
            return null;
        }
        Palette.SolidCollection solidCollection = this.createSolidCollection(this.getFileForId("user_palette_default"), CollectionsKt.emptyList());
        if (solidCollection == null) {
            return null;
        }
        Palette.SolidCollection emptyCollection = solidCollection;
        return SolidPaletteFactory.INSTANCE.fillWithDefaults(emptyCollection);
    }

    @Override
    @Nullable
    public Palette.SolidCollection read(@NotNull String paletteId) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        KFile file = this.getFileForId(paletteId);
        if (!file.exists()) {
            return null;
        }
        return this.readInternal(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Palette.SolidCollection readInternal(KFile file) {
        String string = file.getFileNameWithoutExtension();
        if (string == null) {
            string = "";
        }
        String fileName = string;
        List items = new ArrayList();
        HashSet<String> usedIds = new HashSet<String>();
        if (!file.exists()) return this.createSolidCollection(file, items);
        try {
            Unit unit;
            Throwable thrown$iv;
            block21: {
                Closeable $this$use$iv = (Closeable)Okio.buffer((Source)file.source());
                boolean $i$f$use = false;
                thrown$iv = null;
                try {
                    BufferedSource source = (BufferedSource)$this$use$iv;
                    boolean bl = false;
                    long baseTime = Clock.System.INSTANCE.now().toEpochMilliseconds();
                    int lineIndex = 0;
                    while (true) {
                        String line;
                        if (source.readUtf8Line() == null) {
                            unit = Unit.INSTANCE;
                            break;
                        }
                        String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                        if (((CharSequence)trimmed).length() == 0 || StringsKt.startsWith$default((String)trimmed, (String)"#", (boolean)false, (int)2, null)) continue;
                        ColorPalette.ColorValue colorValue = ColorPalette.Companion.parseColorValue(trimmed);
                        if (colorValue != null) {
                            int colorInt = colorValue.getClr();
                            String uniqueId = PaletteUtils.INSTANCE.generateSolidUniqueId((Set<String>)usedIds);
                            usedIds.add(uniqueId);
                            String string2 = ColorPalette.Companion.colorToHex(colorInt);
                            PaletteItemSource.CollectionRecord collectionRecord = new PaletteItemSource.CollectionRecord(fileName);
                            int n = (int)colorValue.getValue();
                            long l = baseTime - (long)lineIndex * 1000L;
                            items.add(new PaletteItem.Solid(uniqueId, string2, collectionRecord, false, n, l, colorInt, 8, null));
                        }
                        ++lineIndex;
                    }
                }
                catch (Throwable t$iv) {
                    try {
                        thrown$iv = t$iv;
                        unit = null;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block22: {
                            try {
                                Closeable closeable = $this$use$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv2) {
                                if (thrown$iv == null) {
                                    thrown$iv = t$iv2;
                                    break block22;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
            }
            Unit result$iv = unit;
            Throwable throwable = thrown$iv;
            if (throwable == null) return this.createSolidCollection(file, items);
            throw throwable;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        return this.createSolidCollection(file, items);
    }

    private final Palette.SolidCollection createSolidCollection(KFile file, List<PaletteItem.Solid> items) {
        String string = file.getFileNameWithoutExtension();
        if (string == null) {
            return null;
        }
        String fileName = string;
        String string2 = PaletteUtils.INSTANCE.extractPaletteName(fileName);
        if (string2 == null) {
            return null;
        }
        String paletteName = string2;
        String displayName = Intrinsics.areEqual((Object)paletteName, (Object)"default") ? Localization.INSTANCE.getString("user_palette") : PaletteUtils.INSTANCE.buildDisplayName(paletteName);
        Iterable $this$sortedBy$iv = items;
        boolean $i$f$sortedBy = false;
        return new Palette.SolidCollection(fileName, displayName, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PaletteItem.Solid it = (PaletteItem.Solid)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getHistoryIndex());
                it = (PaletteItem.Solid)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHistoryIndex()));
            }
        }), true, file);
    }

    /*
     * WARNING - void declaration
     */
    private final void write(Palette.SolidCollection palette) {
        void $this$associateTo$iv$iv;
        List<PaletteItem.Solid> originalOrder = palette.getItems();
        Iterable $this$sortedByDescending$iv = originalOrder;
        boolean $i$f$sortedByDescending = false;
        List lastUsedOrder = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PaletteItem.Solid it = (PaletteItem.Solid)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLastUsedTime());
                it = (PaletteItem.Solid)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastUsedTime()));
            }
        });
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)originalOrder);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getValue(), (Object)(it.getIndex() + 1));
            map.put(it.getFirst(), it.getSecond());
        }
        Map indexMap = destination$iv$iv;
        KFile file = palette.getSourceFile();
        StringBuilder $this$write_u24lambda_u245 = capacity$iv = new StringBuilder();
        boolean bl = false;
        $this$write_u24lambda_u245.append(HEADER);
        $this$write_u24lambda_u245.append("\n");
        Iterable $this$forEach$iv = lastUsedOrder;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PaletteItem.Solid item = (PaletteItem.Solid)element$iv;
            boolean bl2 = false;
            Integer n = (Integer)indexMap.get(item);
            int index = n != null ? n : 0;
            PaletteItem.Solid copy = PaletteItem.Solid.copy$default(item, null, null, null, false, index, 0L, 0, 111, null);
            ColorPalette.ColorValue cv = copy.getColorValue();
            $this$write_u24lambda_u245.append(ColorPalette.Companion.formatColorValue(cv));
            $this$write_u24lambda_u245.append("\n");
        }
        String string = capacity$iv.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String content = string;
        try {
            KFile dir = file.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.createDirectories();
            }
            file.writeText(content);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    private final KFile getFileForId(String id) {
        return new KFile(this.getPaletteDirectory(), id + ".txt");
    }
}

