/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.palette.data.gradient;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import net.osmand.shared.ColorPalette;
import net.osmand.shared.io.KFile;
import net.osmand.shared.palette.data.PaletteIO;
import net.osmand.shared.palette.data.PaletteUtils;
import net.osmand.shared.palette.data.gradient.GradientSettingsHelper;
import net.osmand.shared.palette.data.gradient.GradientSettingsItem;
import net.osmand.shared.palette.domain.GradientPoint;
import net.osmand.shared.palette.domain.GradientProperties;
import net.osmand.shared.palette.domain.Palette;
import net.osmand.shared.palette.domain.PaletteItem;
import net.osmand.shared.palette.domain.PaletteItemSource;
import net.osmand.shared.palette.domain.category.GradientPaletteCategory;
import net.osmand.shared.palette.domain.filetype.GradientFileType;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J,\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lnet/osmand/shared/palette/data/gradient/GradientPaletteIO;", "Lnet/osmand/shared/palette/data/PaletteIO;", "Lnet/osmand/shared/palette/domain/Palette$GradientCollection;", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "COMMENT_PREFIX", "", "HEADER", "settingsHelper", "Lnet/osmand/shared/palette/data/gradient/GradientSettingsHelper;", "paletteDirectory", "Lnet/osmand/shared/io/KFile;", "getPaletteDirectory", "()Lnet/osmand/shared/io/KFile;", "sync", "", "oldPalette", "newPalette", "read", "paletteId", "readCollection", "category", "Lnet/osmand/shared/palette/domain/category/GradientPaletteCategory;", "readItem", "Lnet/osmand/shared/palette/domain/PaletteItem$Gradient;", "file", "fileType", "Lnet/osmand/shared/palette/domain/filetype/GradientFileType;", "settingsItem", "Lnet/osmand/shared/palette/data/gradient/GradientSettingsItem;", "lastUsedTime", "", "writeItem", "item", "saveSettings", "palette", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGradientPaletteIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradientPaletteIO.kt\nnet/osmand/shared/palette/data/gradient/GradientPaletteIO\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,261:1\n1202#2,2:262\n1230#2,4:264\n1557#2:268\n1628#2,3:269\n1202#2,2:272\n1230#2,4:274\n1053#2:278\n1863#2,2:302\n1863#2,2:304\n1062#2:306\n1863#2,2:307\n66#3:279\n52#3,22:280\n*S KotlinDebug\n*F\n+ 1 GradientPaletteIO.kt\nnet/osmand/shared/palette/data/gradient/GradientPaletteIO\n*L\n31#1:262,2\n31#1:264,4\n45#1:268\n45#1:269,3\n78#1:272,2\n78#1:274,4\n109#1:278\n211#1:302,2\n228#1:304,2\n248#1:306\n250#1:307,2\n132#1:279\n132#1:280,22\n*E\n"})
public final class GradientPaletteIO
implements PaletteIO<Palette.GradientCollection> {
    @NotNull
    public static final GradientPaletteIO INSTANCE = new GradientPaletteIO();
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("GradientPaletteIO");
    @NotNull
    private static final String COMMENT_PREFIX = "#";
    @NotNull
    private static final String HEADER = "# Value,R,G,B,A";
    @NotNull
    private static final GradientSettingsHelper settingsHelper = new GradientSettingsHelper(null, 1, null);

    private GradientPaletteIO() {
    }

    private final KFile getPaletteDirectory() {
        return PlatformUtil.INSTANCE.getOsmAndContext().getColorPaletteDir();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sync(@Nullable Palette.GradientCollection oldPalette, @NotNull Palette.GradientCollection newPalette) {
        Map map;
        Object object;
        Intrinsics.checkNotNullParameter((Object)newPalette, (String)"newPalette");
        Object object2 = oldPalette;
        if (object2 != null && (object2 = ((Palette.GradientCollection)object2).getItems()) != null) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = (Iterable)object2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                PaletteItem.Gradient gradient = (PaletteItem.Gradient)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.put(it.getId(), element$iv$iv);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        Map oldItemsMap = map;
        List<PaletteItem.Gradient> newItems = newPalette.getItems();
        for (PaletteItem.Gradient newItem : newItems) {
            PaletteItem.Gradient oldItem = (PaletteItem.Gradient)oldItemsMap.get(newItem.getId());
            if (oldItem != null && Intrinsics.areEqual((Object)newItem, (Object)oldItem)) continue;
            this.writeItem(newItem);
        }
        if (oldPalette != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = newItems;
            boolean $i$f$map = false;
            Iterable capacity$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (PaletteItem.Gradient)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getId());
            }
            Set newIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            for (PaletteItem.Gradient oldItem : oldPalette.getItems()) {
                KFile file;
                if (newIds.contains(oldItem.getId()) || !(file = new KFile(this.getPaletteDirectory(), oldItem.getSource().getFileName())).exists()) continue;
                file.delete();
            }
        }
        this.saveSettings(newPalette);
    }

    @Override
    @Nullable
    public Palette.GradientCollection read(@NotNull String paletteId) {
        GradientPaletteCategory targetCategory;
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        GradientPaletteCategory category = GradientPaletteCategory.Companion.fromKey(paletteId);
        GradientPaletteCategory gradientPaletteCategory = category;
        if (gradientPaletteCategory == null) {
            GradientFileType gradientFileType = GradientFileType.Companion.fromFileName(paletteId);
            gradientPaletteCategory = gradientFileType != null ? gradientFileType.getCategory() : null;
        }
        if ((targetCategory = gradientPaletteCategory) == null) {
            return null;
        }
        return this.readCollection(targetCategory);
    }

    /*
     * WARNING - void declaration
     */
    private final Palette.GradientCollection readCollection(GradientPaletteCategory category) {
        Iterator $this$associateByTo$iv$iv;
        ArrayList<PaletteItem.Gradient> items = new ArrayList<PaletteItem.Gradient>();
        List<GradientSettingsItem> settingsItems = settingsHelper.getItems(category.getId());
        Iterable $this$associateBy$iv = settingsItems;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object element$iv$iv = iterator.next();
            GradientSettingsItem gradientSettingsItem = (GradientSettingsItem)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getPaletteName(), element$iv$iv);
        }
        Map settingsMap = destination$iv$iv;
        long baseTime = Clock.System.INSTANCE.now().toEpochMilliseconds();
        List list = this.getPaletteDirectory().listFiles();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List files = list;
        for (KFile file : files) {
            String paletteName;
            int indexInList;
            long lastUsedTime;
            GradientSettingsItem metadata;
            PaletteItem.Gradient item;
            GradientFileType fileType;
            String fileName = file.name();
            GradientFileType gradientFileType = fileType = GradientFileType.Companion.fromFileName(fileName);
            if ((gradientFileType != null ? gradientFileType.getCategory() : null) != category || !PaletteUtils.INSTANCE.isPaletteFileExt(fileName) || (item = this.readItem(file, fileType, metadata, lastUsedTime = (indexInList = CollectionsKt.indexOf(settingsItems, (Object)(metadata = (GradientSettingsItem)settingsMap.get(paletteName = PaletteUtils.INSTANCE.extractPaletteName(fileName))))) >= 0 ? baseTime - (long)indexInList * 1000L : 0L)) == null) continue;
            items.add(item);
        }
        Iterable $this$sortedBy$iv = items;
        boolean $i$f$sortedBy = false;
        return new Palette.GradientCollection(category.getId(), category.getDisplayName(), category, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PaletteItem.Gradient it = (PaletteItem.Gradient)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getHistoryIndex());
                it = (PaletteItem.Gradient)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHistoryIndex()));
            }
        }), category.getEditable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PaletteItem.Gradient readItem(KFile file, GradientFileType fileType, GradientSettingsItem settingsItem, long lastUsedTime) {
        if (!file.exists()) {
            return null;
        }
        List points = new ArrayList();
        List comments = new ArrayList();
        Map unrecognized = new LinkedHashMap();
        Integer noDataColor = null;
        try {
            Unit unit;
            Throwable thrown$iv;
            block26: {
                Closeable $this$use$iv = (Closeable)Okio.buffer((Source)file.source());
                boolean $i$f$use = false;
                thrown$iv = null;
                try {
                    BufferedSource source = (BufferedSource)$this$use$iv;
                    boolean bl = false;
                    while (true) {
                        String line;
                        if (source.readUtf8Line() == null) {
                            unit = Unit.INSTANCE;
                            break;
                        }
                        String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                        if (((CharSequence)trimmed).length() == 0) continue;
                        if (StringsKt.startsWith$default((String)trimmed, (String)COMMENT_PREFIX, (boolean)false, (int)2, null)) {
                            comments.add(trimmed);
                            continue;
                        }
                        ColorPalette.ColorValue colorValue = ColorPalette.Companion.parseColorValue(trimmed);
                        if (colorValue != null) {
                            if (Double.isNaN(colorValue.getValue())) {
                                noDataColor = colorValue.getClr();
                                continue;
                            }
                            points.add(new GradientPoint((float)colorValue.getValue(), colorValue.getClr()));
                            continue;
                        }
                        unrecognized.put(trimmed, trimmed);
                    }
                }
                catch (Throwable t$iv) {
                    try {
                        thrown$iv = t$iv;
                        unit = null;
                        break block26;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block27: {
                            try {
                                Closeable closeable = $this$use$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv2) {
                                if (thrown$iv == null) {
                                    thrown$iv = t$iv2;
                                    break block27;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
            }
            Unit result$iv = unit;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to read gradient file: " + file.getPath(), e);
            return null;
        }
        if (points.isEmpty()) {
            return null;
        }
        String fileName = file.name();
        String paletteId = fileType.getCategory().getId();
        String string = PaletteUtils.INSTANCE.extractPaletteName(fileName);
        if (string == null) {
            return null;
        }
        String paletteName = string;
        String displayName = PaletteUtils.INSTANCE.buildDisplayName(paletteName);
        GradientSettingsItem gradientSettingsItem = settingsItem;
        int historyIndex = gradientSettingsItem != null ? gradientSettingsItem.getIndex() : (int)file.lastModified();
        GradientProperties properties = new GradientProperties(fileType, fileType.getRangeType(), null, comments, unrecognized, 4, null);
        return new PaletteItem.Gradient(paletteName, displayName, new PaletteItemSource.GradientFile(paletteId, fileName), PaletteUtils.INSTANCE.isDefaultPalette(paletteName), false, historyIndex, lastUsedTime, points, noDataColor, properties, 16, null);
    }

    private final void writeItem(PaletteItem.Gradient item) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        StringBuilder stringBuilder;
        String fileName = item.getSource().getFileName();
        KFile file = new KFile(this.getPaletteDirectory(), fileName);
        StringBuilder $this$writeItem_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!((Collection)item.getProperties().getComments()).isEmpty()) {
            $this$forEach$iv = item.getProperties().getComments();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String comment = (String)element$iv;
                boolean bl2 = false;
                $this$writeItem_u24lambda_u247.append(comment);
                $this$writeItem_u24lambda_u247.append("\n");
            }
        } else {
            $this$writeItem_u24lambda_u247.append(HEADER);
            $this$writeItem_u24lambda_u247.append("\n");
        }
        if (item.getNoDataColor() != null) {
            ColorPalette.ColorValue noDataVal = new ColorPalette.ColorValue(Double.NaN, item.getNoDataColor());
            $this$writeItem_u24lambda_u247.append(ColorPalette.Companion.formatColorValue(noDataVal));
            $this$writeItem_u24lambda_u247.append("\n");
        }
        $this$forEach$iv = item.getPoints();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradientPoint point = (GradientPoint)element$iv;
            boolean bl3 = false;
            ColorPalette.ColorValue cv = point.toColorValue();
            $this$writeItem_u24lambda_u247.append(ColorPalette.Companion.formatColorValue(cv));
            $this$writeItem_u24lambda_u247.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String content = string;
        try {
            KFile parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.createDirectories();
            }
            file.writeText(content);
        }
        catch (Exception e) {
            LOG.error("Failed to write gradient item: " + file.getPath(), e);
        }
    }

    private final void saveSettings(Palette.GradientCollection palette) {
        List<PaletteItem.Gradient> originalOrder = palette.getItems();
        Iterable $this$sortedByDescending$iv = originalOrder;
        boolean $i$f$sortedByDescending = false;
        List lastUsedOrder = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PaletteItem.Gradient it = (PaletteItem.Gradient)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLastUsedTime());
                it = (PaletteItem.Gradient)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastUsedTime()));
            }
        });
        List settingsItems = new ArrayList();
        Iterable $this$forEach$iv = lastUsedOrder;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PaletteItem.Gradient item = (PaletteItem.Gradient)element$iv;
            boolean bl = false;
            settingsItems.add(new GradientSettingsItem(item.getPaletteCategory().getId(), item.getId(), originalOrder.indexOf(item) + 1));
        }
        settingsHelper.saveItems(palette.getCategory().getId(), settingsItems);
    }
}

