/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.PolymorphicModuleBuilder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuilder;
import net.osmand.shared.KAsyncTask;
import net.osmand.shared.api.KStateChangedListener;
import net.osmand.shared.api.SettingsAPI;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.SmartFolderHelper;
import net.osmand.shared.gpx.SmartFolderUpdateListener;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.data.SmartFolder;
import net.osmand.shared.gpx.filters.BaseTrackFilter;
import net.osmand.shared.gpx.filters.FolderTrackFilter;
import net.osmand.shared.gpx.filters.TrackFilterList;
import net.osmand.shared.gpx.filters.TrackFiltersHelper;
import net.osmand.shared.gpx.organization.OrganizeByParams;
import net.osmand.shared.gpx.organization.OrganizeByRangeParams;
import net.osmand.shared.gpx.organization.OrganizeTracksResourceMapper;
import net.osmand.shared.io.KFile;
import net.osmand.shared.settings.enums.AltitudeMetrics;
import net.osmand.shared.settings.enums.MetricsConstants;
import net.osmand.shared.settings.enums.SpeedConstants;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.KCollectionUtils;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0004\u0011\u0014\u0017\u001a\u0018\u0000 Y2\u00020\u0001:\u0002YZB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u001dJ\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"J\b\u0010#\u001a\u00020\u001dH\u0002J\u0006\u0010$\u001a\u00020\u001dJ-\u0010%\u001a\u0012\u0012\u0004\u0012\u00020'0(j\b\u0012\u0004\u0012\u00020'`&2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010*H\u0002\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00062\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010*J\u001e\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\"2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010*J\u0006\u00100\u001a\u00020\u001dJ\u0010\u00101\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u00103\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u00104\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u000e\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u000bJ\u000e\u00107\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u000bJ\b\u00108\u001a\u00020\u001dH\u0002J\u000e\u00109\u001a\u00020\r2\u0006\u0010/\u001a\u00020\"J\u0012\u0010:\u001a\u0004\u0018\u00010\u00062\u0006\u0010/\u001a\u00020\"H\u0002J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00060*J\u0016\u0010<\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\"J\u000e\u0010>\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0006J\u000e\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\tJ\u0014\u0010A\u001a\u00020\u001d2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\t0\u0005J$\u0010C\u001a\u00020\u001d2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010E\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020GJ\u0016\u0010H\u001a\u00020\u001d2\u0006\u0010I\u001a\u00020G2\u0006\u0010J\u001a\u00020GJ\u0010\u0010K\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u0010L\u001a\u0004\u0018\u00010\u00062\u0006\u0010/\u001a\u00020\"J\u0010\u0010M\u001a\u0004\u0018\u00010\u00062\u0006\u0010N\u001a\u00020\"J\u000e\u0010O\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0006J\u001b\u0010P\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`Q\u00a2\u0006\u0002\u0010RJ\b\u0010S\u001a\u00020\u001dH\u0002J\u0018\u0010T\u001a\u00020\u001d2\u0006\u0010U\u001a\u00020\"2\b\u0010V\u001a\u0004\u0018\u00010WJ\u0010\u0010X\u001a\u0004\u0018\u00010W2\u0006\u0010U\u001a\u00020\"R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006["}, d2={"Lnet/osmand/shared/gpx/SmartFolderHelper;", "", "<init>", "()V", "smartFolderCollection", "", "Lnet/osmand/shared/gpx/data/SmartFolder;", "allAvailableTrackItems", "Ljava/util/HashSet;", "Lnet/osmand/shared/gpx/TrackItem;", "updateListeners", "Lnet/osmand/shared/gpx/SmartFolderUpdateListener;", "isWritingSettings", "", "osmAndSettings", "Lnet/osmand/shared/api/SettingsAPI;", "settingsChangedListener", "net/osmand/shared/gpx/SmartFolderHelper$settingsChangedListener$1", "Lnet/osmand/shared/gpx/SmartFolderHelper$settingsChangedListener$1;", "metricSystemListener", "net/osmand/shared/gpx/SmartFolderHelper$metricSystemListener$1", "Lnet/osmand/shared/gpx/SmartFolderHelper$metricSystemListener$1;", "altitudeSystemListener", "net/osmand/shared/gpx/SmartFolderHelper$altitudeSystemListener$1", "Lnet/osmand/shared/gpx/SmartFolderHelper$altitudeSystemListener$1;", "speedSystemListener", "net/osmand/shared/gpx/SmartFolderHelper$speedSystemListener$1", "Lnet/osmand/shared/gpx/SmartFolderHelper$speedSystemListener$1;", "onSettingsChanged", "", "onUnitsSettingsChanged", "readSettings", "readJson", "settingsJson", "", "updateSmartFolderSettings", "resetSmartFoldersItems", "getEnabledFilters", "Lkotlin/collections/ArrayList;", "Lnet/osmand/shared/gpx/filters/BaseTrackFilter;", "Ljava/util/ArrayList;", "filters", "", "(Ljava/util/List;)Ljava/util/ArrayList;", "saveSmartFolder", "smartFolder", "saveNewSmartFolder", "name", "notifyUpdateListeners", "notifyFolderCreatedListeners", "notifyFolderUpdatedListeners", "notifyFolderSavedListeners", "notifyFolderRenamedListeners", "addUpdateListener", "listener", "removeUpdateListener", "writeSettings", "isSmartFolderPresent", "getSmartFolderByName", "getSmartFolders", "renameSmartFolder", "newName", "deleteSmartFolder", "addTrackItemToSmartFolder", "item", "addTrackItemsToSmartFolder", "items", "addTracksToSmartFolders", "smartFolders", "onGpxFileDeleted", "gpxFile", "Lnet/osmand/shared/io/KFile;", "onTrackRenamed", "srcTrackFile", "destTrackFile", "updateSmartFolderItems", "getSmartFolder", "getSmartFolderById", "id", "refreshSmartFolder", "getAllAvailableTrackItems", "Lkotlin/collections/HashSet;", "()Ljava/util/HashSet;", "updateAllSmartFoldersItems", "setOrganizeByParams", "folderId", "params", "Lnet/osmand/shared/gpx/organization/OrganizeByParams;", "getOrganizeByParams", "Companion", "SmartFoldersUpdateTask", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nSmartFolderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartFolderHelper.kt\nnet/osmand/shared/gpx/SmartFolderHelper\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 SerializersModuleBuilders.kt\nkotlinx/serialization/modules/SerializersModuleBuildersKt\n+ 4 PolymorphicModuleBuilder.kt\nkotlinx/serialization/modules/PolymorphicModuleBuilderKt\n*L\n1#1,387:1\n113#2:388\n31#3,2:389\n254#3,7:391\n261#3,2:399\n254#3,7:401\n261#3,2:409\n33#3:411\n118#4:398\n118#4:408\n*S KotlinDebug\n*F\n+ 1 SmartFolderHelper.kt\nnet/osmand/shared/gpx/SmartFolderHelper\n*L\n226#1:388\n37#1:389,2\n38#1:391,7\n38#1:399,2\n41#1:401,7\n41#1:409,2\n37#1:411\n39#1:398\n42#1:408\n*E\n"})
public final class SmartFolderHelper {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private List<SmartFolder> smartFolderCollection = CollectionsKt.emptyList();
    @NotNull
    private HashSet<TrackItem> allAvailableTrackItems = new HashSet();
    @NotNull
    private List<? extends SmartFolderUpdateListener> updateListeners = CollectionsKt.emptyList();
    private boolean isWritingSettings;
    @Nullable
    private final SettingsAPI osmAndSettings;
    @NotNull
    private final settingsChangedListener.1 settingsChangedListener;
    @NotNull
    private final metricSystemListener.1 metricSystemListener;
    @NotNull
    private final altitudeSystemListener.1 altitudeSystemListener;
    @NotNull
    private final speedSystemListener.1 speedSystemListener;
    @NotNull
    public static final String TRACK_FILTERS_SETTINGS_PREF = "track_filters_settings_pref";
    @NotNull
    private static final String METRIC_SYSTEM_PREF = "default_metric_system";
    @NotNull
    private static final String ALTITUDE_SYSTEM_PREF = "altitude_metrics";
    @NotNull
    private static final String SPEED_SYSTEM_PREF = "default_speed_system";
    @NotNull
    private static final SerializersModule trackFilterSerializersModule;
    @NotNull
    private static final Json json;

    public SmartFolderHelper() {
        SettingsAPI settingsAPI;
        SmartFolderHelper smartFolderHelper;
        SmartFolderHelper smartFolderHelper2 = this;
        try {
            smartFolderHelper = smartFolderHelper2;
            settingsAPI = PlatformUtil.INSTANCE.getOsmAndContext().getSettings();
        }
        catch (Exception e) {
            smartFolderHelper = smartFolderHelper2;
            settingsAPI = null;
        }
        smartFolderHelper.osmAndSettings = settingsAPI;
        this.settingsChangedListener = new KStateChangedListener<String>(this){
            final /* synthetic */ SmartFolderHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void stateChanged(String change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                SmartFolderHelper.access$onSettingsChanged(this.this$0);
            }
        };
        this.metricSystemListener = new KStateChangedListener<MetricsConstants>(this){
            final /* synthetic */ SmartFolderHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void stateChanged(MetricsConstants change) {
                Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
                this.this$0.onUnitsSettingsChanged();
            }
        };
        this.altitudeSystemListener = new KStateChangedListener<AltitudeMetrics>(this){
            final /* synthetic */ SmartFolderHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void stateChanged(AltitudeMetrics change) {
                Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
                this.this$0.onUnitsSettingsChanged();
            }
        };
        this.speedSystemListener = new KStateChangedListener<SpeedConstants>(this){
            final /* synthetic */ SmartFolderHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void stateChanged(SpeedConstants change) {
                Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
                this.this$0.onUnitsSettingsChanged();
            }
        };
        if (this.osmAndSettings != null) {
            this.osmAndSettings.registerPreference(TRACK_FILTERS_SETTINGS_PREF, "", true, true);
            this.osmAndSettings.addStringPreferenceListener(TRACK_FILTERS_SETTINGS_PREF, this.settingsChangedListener);
            this.osmAndSettings.addEnumPreferenceListener(METRIC_SYSTEM_PREF, this.metricSystemListener);
            this.osmAndSettings.addEnumPreferenceListener(ALTITUDE_SYSTEM_PREF, this.altitudeSystemListener);
            this.osmAndSettings.addEnumPreferenceListener(SPEED_SYSTEM_PREF, this.speedSystemListener);
            this.readSettings();
        }
    }

    private final void onSettingsChanged() {
        if (!this.isWritingSettings) {
            this.updateSmartFolderSettings();
        }
    }

    public final void onUnitsSettingsChanged() {
        OrganizeTracksResourceMapper.INSTANCE.clearCache();
        for (SmartFolder smartFolder : this.smartFolderCollection) {
            smartFolder.invalidateCache();
        }
        this.notifyUpdateListeners();
    }

    private final void readSettings() {
        SettingsAPI settingsAPI = this.osmAndSettings;
        String settingsJson = settingsAPI != null ? settingsAPI.getStringPreference(TRACK_FILTERS_SETTINGS_PREF) : null;
        this.readJson(settingsJson);
    }

    public final void readJson(@Nullable String settingsJson) {
        ArrayList newCollection = new ArrayList();
        if (!KAlgorithms.INSTANCE.isEmpty(settingsJson)) {
            String string = settingsJson;
            Intrinsics.checkNotNull((Object)string);
            List<SmartFolder> list = TrackFilterList.INSTANCE.parseFilters(string);
            if (list != null) {
                List<SmartFolder> savedFilters = list;
                boolean bl = false;
                for (SmartFolder smartFolder : savedFilters) {
                    if (smartFolder.getFilters() != null) {
                        List<BaseTrackFilter> it;
                        boolean bl2 = false;
                        List newFilters = new ArrayList();
                        for (BaseTrackFilter filter : it) {
                            BaseTrackFilter newFilter = TrackFiltersHelper.INSTANCE.createFilter(filter.getTrackFilterType(), null);
                            newFilter.initWithValue(filter);
                            newFilters.add(newFilter);
                        }
                        smartFolder.setFilters(newFilters);
                    }
                    smartFolder.initTracksOrganizer();
                }
                newCollection.addAll(savedFilters);
            }
        }
        this.smartFolderCollection = newCollection;
    }

    private final void updateSmartFolderSettings() {
        new SmartFoldersUpdateTask().execute(new Unit[0]);
    }

    public final void resetSmartFoldersItems() {
        ArrayList collection = new ArrayList(this.smartFolderCollection);
        Iterator iterator = collection.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            SmartFolder smartFolder = (SmartFolder)iterator2.next();
            smartFolder.resetItems();
        }
    }

    private final ArrayList<BaseTrackFilter> getEnabledFilters(List<BaseTrackFilter> filters) {
        ArrayList<BaseTrackFilter> enabledFilters;
        block1: {
            enabledFilters = new ArrayList<BaseTrackFilter>();
            List<BaseTrackFilter> list = filters;
            if (list == null) break block1;
            List<BaseTrackFilter> it = list;
            boolean bl = false;
            for (BaseTrackFilter filter : filters) {
                if (!filter.isEnabled()) continue;
                enabledFilters.add(filter);
            }
        }
        return enabledFilters;
    }

    public final void saveSmartFolder(@NotNull SmartFolder smartFolder, @Nullable List<BaseTrackFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)smartFolder, (String)"smartFolder");
        ArrayList<BaseTrackFilter> enabledFilters = this.getEnabledFilters(filters);
        smartFolder.setFilters((List<? extends BaseTrackFilter>)enabledFilters);
        this.writeSettings();
        this.updateSmartFolderItems(smartFolder);
        this.notifyFolderSavedListeners(smartFolder);
    }

    public final void saveNewSmartFolder(@NotNull String name, @Nullable List<BaseTrackFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ArrayList<BaseTrackFilter> enabledFilters = this.getEnabledFilters(filters);
        SmartFolder newFolder = new SmartFolder(name);
        newFolder.setCreationTime(ClockExtensionsKt.currentTimeMillis());
        newFolder.setFilters((List<? extends BaseTrackFilter>)enabledFilters);
        this.smartFolderCollection = KCollectionUtils.INSTANCE.addToList((Collection)this.smartFolderCollection, newFolder);
        this.updateSmartFolderItems(newFolder);
        this.writeSettings();
        this.notifyFolderCreatedListeners(newFolder);
    }

    public final void notifyUpdateListeners() {
        for (SmartFolderUpdateListener smartFolderUpdateListener : this.updateListeners) {
            smartFolderUpdateListener.onSmartFoldersUpdated();
        }
    }

    private final void notifyFolderCreatedListeners(SmartFolder smartFolder) {
        for (SmartFolderUpdateListener smartFolderUpdateListener : this.updateListeners) {
            smartFolderUpdateListener.onSmartFolderCreated(smartFolder);
        }
    }

    private final void notifyFolderUpdatedListeners(SmartFolder smartFolder) {
        for (SmartFolderUpdateListener smartFolderUpdateListener : this.updateListeners) {
            smartFolderUpdateListener.onSmartFolderUpdated(smartFolder);
        }
    }

    private final void notifyFolderSavedListeners(SmartFolder smartFolder) {
        for (SmartFolderUpdateListener smartFolderUpdateListener : this.updateListeners) {
            smartFolderUpdateListener.onSmartFolderSaved(smartFolder);
        }
    }

    private final void notifyFolderRenamedListeners(SmartFolder smartFolder) {
        for (SmartFolderUpdateListener smartFolderUpdateListener : this.updateListeners) {
            smartFolderUpdateListener.onSmartFolderRenamed(smartFolder);
        }
    }

    public final void addUpdateListener(@NotNull SmartFolderUpdateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!this.updateListeners.contains(listener)) {
            this.updateListeners = KCollectionUtils.INSTANCE.addToList((Collection)this.updateListeners, listener);
        }
    }

    public final void removeUpdateListener(@NotNull SmartFolderUpdateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (this.updateListeners.contains(listener)) {
            this.updateListeners = KCollectionUtils.INSTANCE.removeFromList((Collection)this.updateListeners, listener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeSettings() {
        void $this$encodeToString$iv;
        this.isWritingSettings = true;
        StringFormat stringFormat = (StringFormat)json;
        List<SmartFolder> value$iv = this.smartFolderCollection;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String jsonStr = $this$encodeToString$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(SmartFolder.Companion.serializer()), value$iv);
        SettingsAPI settingsAPI = this.osmAndSettings;
        if (settingsAPI != null) {
            settingsAPI.setStringPreference(TRACK_FILTERS_SETTINGS_PREF, jsonStr);
        }
        this.isWritingSettings = false;
    }

    public final boolean isSmartFolderPresent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getSmartFolderByName(name) != null;
    }

    private final SmartFolder getSmartFolderByName(String name) {
        for (SmartFolder folder : this.smartFolderCollection) {
            if (!KAlgorithms.INSTANCE.stringsEqual(folder.getFolderName(), name)) continue;
            return folder;
        }
        return null;
    }

    @NotNull
    public final List<SmartFolder> getSmartFolders() {
        return new ArrayList(this.smartFolderCollection);
    }

    public final void renameSmartFolder(@NotNull SmartFolder smartFolder, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)smartFolder, (String)"smartFolder");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        smartFolder.setFolderName(newName);
        this.writeSettings();
        this.notifyFolderRenamedListeners(smartFolder);
    }

    public final void deleteSmartFolder(@NotNull SmartFolder smartFolder) {
        Intrinsics.checkNotNullParameter((Object)smartFolder, (String)"smartFolder");
        this.smartFolderCollection = KCollectionUtils.INSTANCE.removeFromList((Collection)this.smartFolderCollection, smartFolder);
        this.writeSettings();
        this.notifyUpdateListeners();
    }

    public final void addTrackItemToSmartFolder(@NotNull TrackItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        HashSet<TrackItem> newSet = this.allAvailableTrackItems;
        newSet.add(item);
        this.allAvailableTrackItems = newSet;
        Object[] objectArray = new TrackItem[]{item};
        this.addTracksToSmartFolders(CollectionsKt.arrayListOf((Object[])objectArray), this.smartFolderCollection);
    }

    public final void addTrackItemsToSmartFolder(@NotNull List<TrackItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.smartFolderCollection.isEmpty()) {
            return;
        }
        HashSet<TrackItem> newSet = this.allAvailableTrackItems;
        newSet.addAll((Collection<TrackItem>)items);
        this.allAvailableTrackItems = newSet;
        this.addTracksToSmartFolders(items, this.smartFolderCollection);
    }

    private final void addTracksToSmartFolders(List<TrackItem> items, List<SmartFolder> smartFolders) {
        for (TrackItem item : items) {
            for (SmartFolder smartFolder : smartFolders) {
                boolean trackAccepted = false;
                trackAccepted = true;
                if (smartFolder.getFilters() != null) {
                    List<BaseTrackFilter> smartFolderFilters;
                    boolean bl = false;
                    for (BaseTrackFilter filter : smartFolderFilters) {
                        if (filter.isTrackAccepted(item)) continue;
                        trackAccepted = false;
                        break;
                    }
                }
                if (trackAccepted) {
                    smartFolder.addTrackItem(item, true);
                    continue;
                }
                SmartFolder.removeTrackItem$default(smartFolder, item, false, 2, null);
            }
        }
    }

    public final void onGpxFileDeleted(@NotNull KFile gpxFile) {
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        HashSet newAllTracks = new HashSet(this.allAvailableTrackItems);
        Iterator iterator = newAllTracks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TrackItem trackItem = (TrackItem)e;
            if (!Intrinsics.areEqual((Object)trackItem.getPath(), (Object)gpxFile.absolutePath())) continue;
            newAllTracks.remove(trackItem);
            this.allAvailableTrackItems = newAllTracks;
            break;
        }
        this.updateAllSmartFoldersItems();
    }

    public final void onTrackRenamed(@NotNull KFile srcTrackFile, @NotNull KFile destTrackFile) {
        Intrinsics.checkNotNullParameter((Object)srcTrackFile, (String)"srcTrackFile");
        Intrinsics.checkNotNullParameter((Object)destTrackFile, (String)"destTrackFile");
        HashSet<TrackItem> newAllTracks = new HashSet<TrackItem>((Collection)this.allAvailableTrackItems);
        Iterator iterator = newAllTracks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TrackItem trackItem = (TrackItem)e;
            if (!Intrinsics.areEqual((Object)trackItem.getPath(), (Object)srcTrackFile.absolutePath())) continue;
            newAllTracks.remove(trackItem);
            newAllTracks.add(new TrackItem(destTrackFile));
            this.allAvailableTrackItems = newAllTracks;
            break;
        }
        this.updateAllSmartFoldersItems();
        this.notifyUpdateListeners();
    }

    private final void updateSmartFolderItems(SmartFolder smartFolder) {
        smartFolder.resetItems();
        Object[] objectArray = new SmartFolder[]{smartFolder};
        this.addTracksToSmartFolders(new ArrayList(this.allAvailableTrackItems), CollectionsKt.arrayListOf((Object[])objectArray));
        this.notifyFolderUpdatedListeners(smartFolder);
    }

    @Nullable
    public final SmartFolder getSmartFolder(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (SmartFolder folder : this.smartFolderCollection) {
            if (!KAlgorithms.INSTANCE.stringsEqual(folder.getFolderName(), name)) continue;
            return folder;
        }
        return null;
    }

    @Nullable
    public final SmartFolder getSmartFolderById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        for (SmartFolder folder : this.smartFolderCollection) {
            if (!KAlgorithms.INSTANCE.stringsEqual(folder.getId(), id)) continue;
            return folder;
        }
        return null;
    }

    public final void refreshSmartFolder(@NotNull SmartFolder smartFolder) {
        Intrinsics.checkNotNullParameter((Object)smartFolder, (String)"smartFolder");
        this.updateSmartFolderItems(smartFolder);
    }

    @NotNull
    public final HashSet<TrackItem> getAllAvailableTrackItems() {
        return this.allAvailableTrackItems;
    }

    private final void updateAllSmartFoldersItems() {
        for (SmartFolder smartFolder : this.smartFolderCollection) {
            this.updateSmartFolderItems(smartFolder);
        }
    }

    public final void setOrganizeByParams(@NotNull String folderId, @Nullable OrganizeByParams params) {
        SmartFolder folder;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        SmartFolder smartFolder = folder = this.getSmartFolderById(folderId);
        if (smartFolder != null) {
            smartFolder.setOrganizeByParams(params);
        }
        this.writeSettings();
        SmartFolder smartFolder2 = folder;
        if (smartFolder2 == null) {
            return;
        }
        this.notifyFolderUpdatedListeners(smartFolder2);
    }

    @Nullable
    public final OrganizeByParams getOrganizeByParams(@NotNull String folderId) {
        SmartFolder folder;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        SmartFolder smartFolder = folder = this.getSmartFolderById(folderId);
        return smartFolder != null ? smartFolder.getOrganizeByParams() : null;
    }

    private static final Unit json$lambda$7(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setLenient(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setUseArrayPolymorphism(false);
        $this$Json.setEncodeDefaults(true);
        $this$Json.setClassDiscriminator("className");
        $this$Json.setClassDiscriminatorMode(ClassDiscriminatorMode.NONE);
        $this$Json.setSerializersModule(trackFilterSerializersModule);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$onSettingsChanged(SmartFolderHelper $this) {
        $this.onSettingsChanged();
    }

    static {
        SerializersModuleBuilder $this$polymorphic_u24default$iv;
        PolymorphicModuleBuilder $this$subclass$iv;
        PolymorphicModuleBuilder builder$iv;
        SerializersModuleBuilder builder$iv2;
        Companion = new Companion(null);
        boolean $i$f$SerializersModule = false;
        SerializersModuleBuilder $this$trackFilterSerializersModule_u24lambda_u246 = builder$iv2 = new SerializersModuleBuilder();
        boolean bl = false;
        SerializersModuleBuilder serializersModuleBuilder = $this$trackFilterSerializersModule_u24lambda_u246;
        KClass baseClass$iv = Reflection.getOrCreateKotlinClass(BaseTrackFilter.class);
        KSerializer baseSerializer$iv = null;
        boolean $i$f$polymorphic = false;
        PolymorphicModuleBuilder $this$trackFilterSerializersModule_u24lambda_u246_u24lambda_u244 = builder$iv = new PolymorphicModuleBuilder(baseClass$iv, baseSerializer$iv);
        boolean bl2 = false;
        PolymorphicModuleBuilder polymorphicModuleBuilder = $this$trackFilterSerializersModule_u24lambda_u246_u24lambda_u244;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(FolderTrackFilter.class);
        boolean $i$f$subclass = false;
        $this$subclass$iv.subclass(clazz$iv, FolderTrackFilter.Companion.serializer());
        builder$iv.buildTo($this$polymorphic_u24default$iv);
        $this$polymorphic_u24default$iv = $this$trackFilterSerializersModule_u24lambda_u246;
        baseClass$iv = Reflection.getOrCreateKotlinClass(OrganizeByParams.class);
        baseSerializer$iv = null;
        $i$f$polymorphic = false;
        PolymorphicModuleBuilder $this$trackFilterSerializersModule_u24lambda_u246_u24lambda_u245 = builder$iv = new PolymorphicModuleBuilder(baseClass$iv, baseSerializer$iv);
        boolean bl3 = false;
        $this$subclass$iv = $this$trackFilterSerializersModule_u24lambda_u246_u24lambda_u245;
        clazz$iv = Reflection.getOrCreateKotlinClass(OrganizeByRangeParams.class);
        $i$f$subclass = false;
        $this$subclass$iv.subclass(clazz$iv, OrganizeByRangeParams.Companion.serializer());
        builder$iv.buildTo($this$polymorphic_u24default$iv);
        trackFilterSerializersModule = builder$iv2.build();
        json = JsonKt.Json$default(null, SmartFolderHelper::json$lambda$7, (int)1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lnet/osmand/shared/gpx/SmartFolderHelper$Companion;", "", "<init>", "()V", "TRACK_FILTERS_SETTINGS_PREF", "", "METRIC_SYSTEM_PREF", "ALTITUDE_SYSTEM_PREF", "SPEED_SYSTEM_PREF", "trackFilterSerializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Json getJson() {
            return json;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00022\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0007\"\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/osmand/shared/gpx/SmartFolderHelper$SmartFoldersUpdateTask;", "Lnet/osmand/shared/KAsyncTask;", "", "<init>", "(Lnet/osmand/shared/gpx/SmartFolderHelper;)V", "doInBackground", "params", "", "([Lkotlin/Unit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onPostExecute", "result", "(Lkotlin/Unit;)V", "OsmAnd-shared"})
    private final class SmartFoldersUpdateTask
    extends KAsyncTask<Unit, Unit, Unit> {
        public SmartFoldersUpdateTask() {
            super(false, null, null, 7, null);
        }

        @Nullable
        public Object doInBackground(@NotNull Unit[] params, @NotNull Continuation<? super Unit> $completion) {
            SmartFolderHelper.this.readSettings();
            SmartFolderHelper.this.updateAllSmartFoldersItems();
            return Unit.INSTANCE;
        }

        @Override
        public void onPostExecute(@NotNull Unit result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            SmartFolderHelper.this.notifyUpdateListeners();
        }
    }
}

