/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.osmand.data.LatLon;
import net.osmand.gpx.GPXFile;
import net.osmand.gpx.GPXTrackAnalysis;
import net.osmand.gpx.GPXUtilities;
import net.osmand.util.MapUtils;

public class TrkSegmentSplitter {
    private static final double DIST_THRESHOLD = 20.0;

    public static void main(String[] args) {
        File dir = new File("/Users/victorshcherb/osmand/gpx/downhill");
        File[] fs = dir.listFiles();
        long time = System.currentTimeMillis();
        LatLon start = new LatLon(48.34764, 24.41092);
        LatLon end = new LatLon(48.35351, 24.41589);
        ArrayList<GPXUtilities.TrkSegment> res = new ArrayList<GPXUtilities.TrkSegment>();
        int files = 0;
        for (File f : fs) {
            if (!f.getName().endsWith(".gpx")) continue;
            ++files;
            GPXFile g = GPXUtilities.loadGPXFile(f, null, false);
            for (GPXUtilities.Track t : g.tracks) {
                for (GPXUtilities.TrkSegment s : t.segments) {
                    TrkSegmentSplitter.process(f, s, start, end, res);
                }
            }
        }
        time = System.currentTimeMillis() - time;
        System.out.printf("Processed %d files in %.2f seconds, found %d segments:\n", files, (double)time / 1000.0, res.size());
        Collections.sort(res, new Comparator<GPXUtilities.TrkSegment>(){

            @Override
            public int compare(GPXUtilities.TrkSegment o1, GPXUtilities.TrkSegment o2) {
                return Long.compare(o1.points.get((int)0).time, o2.points.get((int)0).time);
            }
        });
        for (int k = 0; k < res.size(); ++k) {
            GPXUtilities.TrkSegment s = (GPXUtilities.TrkSegment)res.get(k);
            GPXFile g = new GPXFile("");
            g.tracks.add(new GPXUtilities.Track());
            g.tracks.get((int)0).segments.add(s);
            long tm = s.points.get((int)0).time;
            GPXTrackAnalysis an = g.getAnalysis(tm);
            System.out.printf("%d. %s\n %s, distance %.3f km, duration %.1f s, points %d\n    Up %.0f m, down %.0f m, \n    Avg speed: %.1f kmh, max speed %.1f kmh\n", k + 1, s.name, new Date(tm), Float.valueOf(an.getTotalDistance() / 1000.0f), (double)an.getDurationInMs() / 1000.0, s.points.size(), an.getDiffElevationUp(), an.getDiffElevationDown(), (double)an.getAvgSpeed() * 3.6, (double)an.getMaxSpeed() * 3.6);
        }
    }

    private static double lat(GPXUtilities.TrkSegment s, int ind) {
        return s.points.get((int)ind).lat;
    }

    private static double lon(GPXUtilities.TrkSegment s, int ind) {
        return s.points.get((int)ind).lon;
    }

    private static long time(GPXUtilities.TrkSegment s, int ind) {
        return s.points.get((int)ind).time;
    }

    private static void process(File f, GPXUtilities.TrkSegment s, LatLon start, LatLon end, List<GPXUtilities.TrkSegment> res) {
        int startInd = -1;
        for (int i = 1; i < s.points.size(); ++i) {
            LatLon pnt = startInd == -1 ? start : end;
            double dist = MapUtils.getOrthogonalDistance(pnt.getLatitude(), pnt.getLongitude(), s.points.get((int)(i - 1)).lat, s.points.get((int)(i - 1)).lon, s.points.get((int)i).lat, s.points.get((int)i).lon);
            if (!(dist < 20.0)) continue;
            int ind = i;
            for (int j = ind + 1; j < s.points.size() && j < ind + 10; ++j) {
                double d2 = MapUtils.getOrthogonalDistance(pnt.getLatitude(), pnt.getLongitude(), s.points.get((int)(j - 1)).lat, s.points.get((int)(j - 1)).lon, s.points.get((int)j).lat, s.points.get((int)j).lon);
                if (!(d2 < dist)) continue;
                dist = d2;
                i = j;
            }
            if (startInd == -1) {
                startInd = i;
                continue;
            }
            int finalInd = i;
            GPXUtilities.TrkSegment r = new GPXUtilities.TrkSegment();
            LatLon startProj = MapUtils.getProjection(start.getLatitude(), start.getLongitude(), TrkSegmentSplitter.lat(s, startInd - 1), TrkSegmentSplitter.lon(s, startInd - 1), TrkSegmentSplitter.lat(s, startInd), TrkSegmentSplitter.lon(s, startInd));
            double stPercent = MapUtils.getDistance(startProj, TrkSegmentSplitter.lat(s, startInd), TrkSegmentSplitter.lon(s, startInd)) / MapUtils.getDistance(TrkSegmentSplitter.lat(s, startInd - 1), TrkSegmentSplitter.lon(s, startInd - 1), TrkSegmentSplitter.lat(s, startInd), TrkSegmentSplitter.lon(s, startInd));
            GPXUtilities.WptPt st = new GPXUtilities.WptPt(startProj.getLatitude(), startProj.getLongitude());
            st.time = TrkSegmentSplitter.time(s, startInd - 1) + (long)(stPercent * (double)(TrkSegmentSplitter.time(s, startInd) - TrkSegmentSplitter.time(s, startInd - 1)));
            st.ele = s.points.get((int)startInd).ele;
            LatLon endProj = MapUtils.getProjection(end.getLatitude(), end.getLongitude(), TrkSegmentSplitter.lat(s, finalInd - 1), TrkSegmentSplitter.lon(s, finalInd - 1), TrkSegmentSplitter.lat(s, finalInd), TrkSegmentSplitter.lon(s, finalInd));
            double enPercent = MapUtils.getDistance(endProj, TrkSegmentSplitter.lat(s, finalInd), TrkSegmentSplitter.lon(s, finalInd)) / MapUtils.getDistance(TrkSegmentSplitter.lat(s, finalInd - 1), TrkSegmentSplitter.lon(s, finalInd - 1), TrkSegmentSplitter.lat(s, finalInd), TrkSegmentSplitter.lon(s, finalInd));
            GPXUtilities.WptPt en = new GPXUtilities.WptPt(endProj.getLatitude(), endProj.getLongitude());
            en.time = TrkSegmentSplitter.time(s, finalInd - 1) + (long)(enPercent * (double)(TrkSegmentSplitter.time(s, finalInd) - TrkSegmentSplitter.time(s, finalInd - 1)));
            en.ele = s.points.get((int)finalInd).ele;
            r.points.add(st);
            for (int k = startInd + 1; k <= finalInd; ++k) {
                r.points.add(s.points.get(k));
            }
            r.points.add(en);
            r.name = f.getName() + " " + startInd + " threshold=" + String.format("%.2f m", MapUtils.getDistance(startProj, start) + MapUtils.getDistance(endProj, end));
            res.add(r);
            startInd = -1;
        }
    }
}

