/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.util.Algorithms;

public class BinaryMapIndexReaderStats {

    public static class MapObjectStat {
        public int lastStringNamesSize;
        public int lastObjectIdSize;
        public int lastObjectHeaderInfo;
        public int lastObjectAdditionalTypes;
        public int lastObjectTypes;
        public int lastObjectCoordinates;
        public int lastObjectLabelCoordinates;
        public int lastObjectSize;
        public int lastBlockStringTableSize;
        public int lastBlockHeaderInfo;

        public void addBlockHeader(int typesFieldNumber, int sizeL) {
            this.lastBlockHeaderInfo += CodedOutputStream.computeTagSize(typesFieldNumber) + CodedOutputStream.computeRawVarint32Size(sizeL);
        }

        public void addTagHeader(int typesFieldNumber, int sizeL) {
            this.lastObjectHeaderInfo += CodedOutputStream.computeTagSize(typesFieldNumber) + CodedOutputStream.computeRawVarint32Size(sizeL);
        }

        public void clearObjectStats() {
            this.lastStringNamesSize = 0;
            this.lastObjectIdSize = 0;
            this.lastObjectHeaderInfo = 0;
            this.lastObjectAdditionalTypes = 0;
            this.lastObjectTypes = 0;
            this.lastObjectCoordinates = 0;
            this.lastObjectLabelCoordinates = 0;
        }
    }

    public static class SearchStat {
        private static final boolean TO_DETAILED_STRING = false;
        long lastReq = 0L;
        long subSize = 0L;
        public long totalTime = 0L;
        public long totalBytes = 0L;
        public int prevResultsSize = 0;
        public String requestWord = "";
        Map<BinaryMapIndexReaderApiName, StatByAPI> byApis = new HashMap<BinaryMapIndexReaderApiName, StatByAPI>();
        Map<String, WordSearchStat> wordStats = new HashMap<String, WordSearchStat>();

        public Map<String, WordSearchStat> getWordStats() {
            return this.wordStats;
        }

        public Map<BinaryMapIndexReaderApiName, StatByAPI> getByApis() {
            return this.byApis;
        }

        public List<SubStatByAPI> getSubStatsSummary() {
            HashMap<String, SubStatByAPI> grouped = new HashMap<String, SubStatByAPI>();
            for (StatByAPI apiStats : this.byApis.values()) {
                if (apiStats == null || apiStats.subApis == null) continue;
                for (SubStatByAPI st : apiStats.subApis.values()) {
                    if (st == null) continue;
                    String mapName = st.mapName == null ? "" : st.mapName;
                    String key = st.api.name() + "|" + st.subApi.name() + "|" + mapName;
                    SubStatByAPI agg = grouped.computeIfAbsent(key, k -> new SubStatByAPI(st.api, st.subApi, st.mapName));
                    agg.time += st.time;
                    agg.count += st.count;
                    agg.bytes += st.bytes;
                    agg.calls += st.calls;
                }
            }
            ArrayList<SubStatByAPI> result = new ArrayList<SubStatByAPI>(grouped.values());
            result.sort((a, b) -> Long.compare(b.time, a.time));
            return result;
        }

        public long beginSearchStats(BinaryMapIndexReaderApiName api, BinaryMapIndexReader.SearchRequest<?> req, BinaryIndexPart part, CodedInputStream codedIS, String extraInfo) {
            this.lastReq = System.nanoTime();
            codedIS.resetBytesCounter();
            this.prevResultsSize = req != null && req.getSearchResults() != null ? req.getSearchResults().size() : 0;
            this.requestWord = req != null && !Algorithms.isEmpty(req.nameQuery) ? req.nameQuery : "";
            return this.lastReq;
        }

        public void endSearchStats(long statReq, BinaryMapIndexReaderApiName api, List<?> objects, BinaryIndexPart part, CodedInputStream codedIS, String extraInfo) {
            WordSearchStat wordStat;
            if (statReq != this.lastReq) {
                System.err.println("ERROR: in stats counting to fix ! " + statReq + " != " + this.lastReq);
            }
            if (this.requestWord == null) {
                this.requestWord = "";
            }
            if ((wordStat = this.wordStats.get(this.requestWord)) == null) {
                wordStat = new WordSearchStat();
                wordStat.requestWord = this.requestWord;
                this.wordStats.put(this.requestWord, wordStat);
            }
            ++wordStat.apis;
            wordStat.results += objects.size();
            wordStat.apiCalls.compute(api, (k, cnt) -> cnt == null ? 1 : cnt + 1);
            for (Object o : objects) {
                wordStat.resultCounts.compute(o.getClass().getSimpleName(), (k, cnt) -> cnt == null ? 1 : cnt + 1);
            }
            long timeCall = System.nanoTime() - statReq;
            long bytes = codedIS.getBytesCounter();
            this.totalTime += timeCall;
            this.totalBytes += bytes;
            StatByAPI statByAPI = this.byApis.get((Object)api);
            if (statByAPI == null) {
                statByAPI = new StatByAPI();
                statByAPI.api = api;
                this.byApis.put(api, statByAPI);
            }
            statByAPI.bytes += bytes;
            ++statByAPI.calls;
            statByAPI.time += timeCall;
        }

        public long beginSubSearchStats(int size) {
            long subStart = System.nanoTime();
            this.subSize = size;
            return subStart;
        }

        public void endSubSearchStats(long statReq, BinaryMapIndexReaderApiName api, BinaryMapIndexReaderSubApiName op, String obf, int size, long bytes) {
            long timeCall = System.nanoTime() - statReq;
            StatByAPI statByAPI = this.byApis.get((Object)api);
            if (statByAPI == null) {
                statByAPI = new StatByAPI();
                statByAPI.api = api;
                this.byApis.put(api, statByAPI);
            }
            SubStatByAPI subStatByAPI = statByAPI.getSubApi(op, obf);
            subStatByAPI.add(timeCall, (long)size - this.subSize, bytes);
        }

        public String toString() {
            return String.format("Search stat: time %.3f, bytes %,d KB, by apis - %s; words %s", (double)this.totalTime / 1.0E9, this.totalBytes / 1024L, this.byApis.values(), this.wordStats);
        }

        private String toDetailedString() {
            DetailedStringData data = this.buildDetailedStringData();
            return this.renderDetailedString(data);
        }

        private DetailedStringData buildDetailedStringData() {
            String c1 = "API       ";
            String c2 = "Sub-API / Top-2 OBF                       ";
            String c3 = "Time (s)";
            String c4 = "Count (O)";
            String c5 = "Volume (KB)";
            String c6 = "Calls";
            HashMap<BinaryMapIndexReaderApiName, Map<BinaryMapIndexReaderSubApiName, List<SubStatByAPI>>> rows = new HashMap<BinaryMapIndexReaderApiName, Map<BinaryMapIndexReaderSubApiName, List<SubStatByAPI>>>();
            HashMap<BinaryMapIndexReaderApiName, Map<BinaryMapIndexReaderSubApiName, SubStatByAPI>> totalsByApiSubApi = new HashMap<BinaryMapIndexReaderApiName, Map<BinaryMapIndexReaderSubApiName, SubStatByAPI>>();
            HashMap<BinaryMapIndexReaderApiName, SubStatByAPI> totalsByApi = new HashMap<BinaryMapIndexReaderApiName, SubStatByAPI>();
            for (StatByAPI apiStats : this.byApis.values()) {
                if (apiStats == null || apiStats.api == null || apiStats.subApis == null) continue;
                if (apiStats.subApis.isEmpty()) {
                    SubStatByAPI apiTotal = totalsByApi.computeIfAbsent(apiStats.api, k -> new SubStatByAPI(apiStats.api, null, ""));
                    apiTotal.time += apiStats.time;
                    apiTotal.bytes += apiStats.bytes;
                    apiTotal.calls += (long)apiStats.calls;
                    rows.computeIfAbsent(apiStats.api, k -> new HashMap());
                    continue;
                }
                for (SubStatByAPI st : apiStats.subApis.values()) {
                    if (st == null || st.subApi == null) continue;
                    rows.computeIfAbsent(apiStats.api, k -> new HashMap()).computeIfAbsent(st.subApi, k -> new ArrayList()).add(st);
                    totalsByApiSubApi.computeIfAbsent(apiStats.api, k -> new HashMap());
                    SubStatByAPI subTotal = ((Map)totalsByApiSubApi.get((Object)apiStats.api)).computeIfAbsent(st.subApi, k -> new SubStatByAPI(apiStats.api, st.subApi, ""));
                    subTotal.time += st.time;
                    subTotal.count += st.count;
                    subTotal.bytes += st.bytes;
                    subTotal.calls += st.calls;
                    SubStatByAPI apiTotal = totalsByApi.computeIfAbsent(apiStats.api, k -> new SubStatByAPI(apiStats.api, st.subApi, ""));
                    apiTotal.time += st.time;
                    apiTotal.count += st.count;
                    apiTotal.bytes += st.bytes;
                    apiTotal.calls += st.calls;
                }
            }
            ArrayList<BinaryMapIndexReaderApiName> apis = new ArrayList<BinaryMapIndexReaderApiName>(totalsByApi.keySet());
            apis.sort((a, b) -> Long.compare(((SubStatByAPI)totalsByApi.get((Object)((Object)((Object)b)))).time, ((SubStatByAPI)totalsByApi.get((Object)((Object)((Object)a)))).time));
            return new DetailedStringData(c1, c2, c3, c4, c5, c6, rows, totalsByApiSubApi, totalsByApi, apis);
        }

        private String renderDetailedString(DetailedStringData data) {
            int w1 = data.c1.length();
            int w2 = data.c2.length();
            int w3 = data.c3.length();
            int w4 = data.c4.length();
            int w5 = data.c5.length();
            int w6 = data.c6.length();
            for (BinaryMapIndexReaderApiName api : data.apis) {
                if (api == null) continue;
                w1 = Math.max(w1, api.name().length());
                Map<BinaryMapIndexReaderSubApiName, SubStatByAPI> bySub = data.totalsByApiSubApi.get((Object)api);
                if (bySub == null) continue;
                ArrayList<BinaryMapIndexReaderSubApiName> subApis = new ArrayList<BinaryMapIndexReaderSubApiName>(bySub.keySet());
                subApis.sort((a, b) -> Long.compare(((SubStatByAPI)bySub.get((Object)((Object)((Object)b)))).time, ((SubStatByAPI)bySub.get((Object)((Object)((Object)a)))).time));
                for (BinaryMapIndexReaderSubApiName subApi : subApis) {
                    if (subApi == null) continue;
                    w2 = Math.max(w2, subApi.name().length());
                    List detail = data.rows.getOrDefault((Object)api, Collections.emptyMap()).getOrDefault((Object)subApi, Collections.emptyList());
                    detail.sort((a, b) -> Long.compare(b.time, a.time));
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(Locale.US, "Search stat: time %.3f, bytes % d KB, by APIs:", (double)this.totalTime / 1.0E9, this.totalBytes / 1024L));
            sb.append("\n");
            sb.append(SearchStat.padRight(data.c1, w1)).append(", ").append(SearchStat.padRight(data.c2, w2)).append(", ").append(SearchStat.padRight(data.c3, w3)).append(", ").append(SearchStat.padRight(data.c4, w4)).append(", ").append(SearchStat.padRight(data.c5, w5)).append(", ").append(SearchStat.padRight(data.c6, w6));
            for (BinaryMapIndexReaderApiName api : data.apis) {
                SubStatByAPI apiTotal;
                if (api == null || (apiTotal = data.totalsByApi.get((Object)api)) == null) continue;
                sb.append("\n");
                sb.append(SearchStat.padRight(api.name(), w1)).append(", ").append(SearchStat.padRight("", w2)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "%.2f", (double)apiTotal.time / 1.0E9), w3)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", apiTotal.count), w4)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", apiTotal.bytes / 1024L), w5)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", apiTotal.calls), w6));
                Map<BinaryMapIndexReaderSubApiName, SubStatByAPI> bySub = data.totalsByApiSubApi.get((Object)api);
                if (bySub == null) continue;
                ArrayList<BinaryMapIndexReaderSubApiName> subApis = new ArrayList<BinaryMapIndexReaderSubApiName>(bySub.keySet());
                subApis.sort((a, b) -> Long.compare(((SubStatByAPI)bySub.get((Object)((Object)((Object)b)))).time, ((SubStatByAPI)bySub.get((Object)((Object)((Object)a)))).time));
                for (BinaryMapIndexReaderSubApiName subApi : subApis) {
                    SubStatByAPI subTotal;
                    if (subApi == null || (subTotal = bySub.get((Object)subApi)) == null) continue;
                    sb.append("\n");
                    sb.append(SearchStat.padRight("", w1)).append(", ").append(SearchStat.padRight(subApi.name(), w2)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "%.2f", (double)subTotal.time / 1.0E9), w3)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", subTotal.count), w4)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", subTotal.bytes / 1024L), w5)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", subTotal.calls), w6));
                    List detail = data.rows.getOrDefault((Object)api, Collections.emptyMap()).getOrDefault((Object)subApi, Collections.emptyList());
                    detail.sort((a, b) -> Long.compare(b.time, a.time));
                    for (int i = 0; i < detail.size() && i < 2; ++i) {
                        SubStatByAPI st = (SubStatByAPI)detail.get(i);
                        if (st == null) continue;
                        sb.append("\n");
                        sb.append(SearchStat.padRight("", w1)).append(", ").append(SearchStat.padRight(st.mapName == null ? "" : st.mapName, w2)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "%.2f", (double)st.time / 1.0E9), w3)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", st.count), w4)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", st.bytes / 1024L), w5)).append(", ").append(SearchStat.padLeft(String.format(Locale.US, "% d", st.calls), w6));
                    }
                }
            }
            sb.append("\nWords ").append(this.wordStats);
            return sb.toString();
        }

        private static String padRight(String value, int width) {
            return String.format("%-" + width + "s", value == null ? "" : value);
        }

        private static String padLeft(String value, int width) {
            return String.format("%" + width + "s", value == null ? "" : value);
        }

        private record DetailedStringData(String c1, String c2, String c3, String c4, String c5, String c6, Map<BinaryMapIndexReaderApiName, Map<BinaryMapIndexReaderSubApiName, List<SubStatByAPI>>> rows, Map<BinaryMapIndexReaderApiName, Map<BinaryMapIndexReaderSubApiName, SubStatByAPI>> totalsByApiSubApi, Map<BinaryMapIndexReaderApiName, SubStatByAPI> totalsByApi, List<BinaryMapIndexReaderApiName> apis) {
        }
    }

    public static class WordSearchStat {
        public int results;
        public int apis;
        public Map<String, Integer> resultCounts = new HashMap<String, Integer>();
        public Map<BinaryMapIndexReaderApiName, Integer> apiCalls = new HashMap<BinaryMapIndexReaderApiName, Integer>();
        public String requestWord;

        public String toString() {
            return String.format("api %s, results %s ", this.apiCalls, this.resultCounts);
        }
    }

    public static class StatByAPI {
        BinaryMapIndexReaderApiName api;
        public int calls;
        public long time;
        public long bytes;
        Map<String, SubStatByAPI> subApis = new HashMap<String, SubStatByAPI>();

        public SubStatByAPI getSubApi(BinaryMapIndexReaderSubApiName subApi, String mapName) {
            String key = subApi.name() + "|" + mapName;
            SubStatByAPI subStat = this.subApis.get(key);
            if (!this.subApis.containsKey(key)) {
                subStat = new SubStatByAPI(this.api, subApi, mapName);
                this.subApis.put(key, subStat);
            }
            return subStat;
        }

        public String toString() {
            return String.format("API %s [call %d, time %.2f, %,d KB]", new Object[]{this.api, this.calls, (double)this.time / 1.0E9, this.bytes / 1024L});
        }
    }

    public static class SubStatByAPI {
        public final BinaryMapIndexReaderApiName api;
        public final BinaryMapIndexReaderSubApiName subApi;
        public final String mapName;
        private long time = 0L;
        private long count = 0L;
        private long calls = 0L;
        private long bytes = 0L;

        SubStatByAPI(BinaryMapIndexReaderApiName api, BinaryMapIndexReaderSubApiName subApi, String mapName) {
            this.api = api;
            this.subApi = subApi;
            this.mapName = mapName;
        }

        void add(long timeNs, long count, long bytes) {
            this.time += timeNs;
            this.count += count;
            this.bytes += bytes;
            ++this.calls;
        }

        public long getTime() {
            return this.time;
        }

        public long getBytes() {
            return this.bytes;
        }

        public long getCalls() {
            return this.calls;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static enum BinaryMapIndexReaderSubApiName {
        ADDRESS_NAME_INDEX,
        ADDRESS_NAME_REFERENCES,
        ADDRESS_NAME_OBJECTS,
        POI_NAME_INDEX,
        POI_NAME_REFERENCES,
        POI_NAME_OBJECTS,
        POI_NAME_GROUPS_BBOXES;

    }

    public static enum BinaryMapIndexReaderApiName {
        ADDRESS_BY_NAME,
        POI_BY_NAME,
        LOAD_STREETS,
        LOAD_CITIES,
        LOAD_BUILDINGS,
        POI_BY_TYPE;

    }
}

