/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.Serializable;
import rtree.IllegalValueException;
import rtree.Point;

public class Rect
implements Serializable {
    private int minX = 0;
    private int minY = 0;
    private int maxX = 0;
    private int maxY = 0;
    boolean isNull = false;

    public Rect() {
        this.initNull();
    }

    public Rect(int topX, int topY, int botX, int botY) throws IllegalValueException {
        if (topX > botX || topY > botY) {
            System.out.println("\ttopX:" + topX + "\ttopY:" + topY + "\tbotX:" + botX + "\tbotY:" + botY);
            throw new IllegalValueException("rtree.Rect.Rect: wrong order of params.");
        }
        this.init(topX, topY, botX, botY);
    }

    Rect(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("rtree.Rect.Rect: Param is null.");
        }
        if (rect.isNull()) {
            this.initNull();
        } else {
            this.init(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
        }
    }

    private void initNull() {
        this.minX = 0;
        this.minY = 0;
        this.maxX = -1;
        this.maxY = -1;
        this.isNull = true;
    }

    private void init(int minX, int minY, int maxX, int maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.isNull = false;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public static int sizeInBytes() {
        return 16;
    }

    public int getArea() {
        if (this.isNull()) {
            return 0;
        }
        return (this.maxX - this.minX) * (this.maxY - this.minY);
    }

    public int getWidth() {
        if (this.isNull()) {
            return 0;
        }
        return Math.abs(this.maxX - this.minX);
    }

    public int getHeight() {
        if (this.isNull()) {
            return 0;
        }
        return Math.abs(this.maxY - this.minY);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void expandToInclude(Rect rect) {
        if (rect == null || rect.isNull()) {
            return;
        }
        if (this.isNull()) {
            this.init(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
            return;
        }
        this.minX = Math.min(rect.getMinX(), this.minX);
        this.minY = Math.min(rect.getMinY(), this.minY);
        this.maxX = Math.max(rect.getMaxX(), this.maxX);
        this.maxY = Math.max(rect.getMaxY(), this.maxY);
    }

    public Rect getResultingMBR(Rect rectangle) throws IllegalValueException {
        if (rectangle == null) {
            throw new IllegalValueException("rtree.Rect.getResultingMBR : Rect is null");
        }
        if (rectangle.isNull()) {
            if (this.isNull()) {
                return new Rect();
            }
            return new Rect(this);
        }
        if (this.isNull()) {
            return rectangle;
        }
        int topX = Math.min(rectangle.getMinX(), this.minX);
        int topY = Math.min(rectangle.getMinY(), this.minY);
        int botX = Math.max(rectangle.getMaxX(), this.maxX);
        int botY = Math.max(rectangle.getMaxY(), this.maxY);
        return new Rect(topX, topY, botX, botY);
    }

    public static Rect getResultingMBR(Rect source, Rect dest) throws IllegalValueException {
        if (dest == null || source == null) {
            throw new IllegalValueException("rtree.Rect.getResultingMBR : Rect is null");
        }
        return source.getResultingMBR(dest);
    }

    public static Rect getResultingMBR(Rect[] rects) throws IllegalValueException {
        if (rects.length <= 0) {
            throw new IllegalValueException("rtree.Rect.getResultingMBR : Array of rectangles are empty.");
        }
        Rect result = rects[0];
        for (int i = 1; i < rects.length; ++i) {
            result = Rect.getResultingMBR(rects[i], result);
        }
        return result;
    }

    public static Rect getResultingMBR(Rect[] rects, Rect rect) throws IllegalValueException {
        Rect result = Rect.getResultingMBR(rects);
        result = Rect.getResultingMBR(rect, result);
        return result;
    }

    public boolean contains(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("rtree.Rect.contains: null argument");
        }
        boolean ret = true;
        if (this.minX >= rect.getMinX() || this.maxX <= rect.getMaxX()) {
            return false;
        }
        if (this.minY >= rect.getMinY() || this.maxY <= rect.getMaxY()) {
            return false;
        }
        return ret;
    }

    public boolean encloses(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("rtree.Rect.overlaps: null argument");
        }
        boolean ret = true;
        if (this.minX > rect.getMinX() || this.maxX < rect.getMaxX()) {
            return false;
        }
        if (this.minY > rect.getMinY() || this.maxY < rect.getMaxY()) {
            return false;
        }
        return ret;
    }

    public boolean containedBy(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("rtree.Rect.containedBy:null argument");
        }
        boolean ret = true;
        if (rect.getMinX() >= this.minX || rect.getMaxX() <= this.maxX) {
            return false;
        }
        if (rect.getMinY() >= this.minY || rect.getMaxY() <= this.maxY) {
            return false;
        }
        return ret;
    }

    public boolean overlaps(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("Rect.overlaps: null argument");
        }
        int rectMinX = rect.getMinX();
        int rectMinY = rect.getMinY();
        int rectMaxX = rect.getMaxX();
        int rectMaxY = rect.getMaxY();
        boolean ret = false;
        if (this.minX == rectMinX && this.minY == rectMinY && this.maxX == rectMaxX && this.maxY == rectMaxY) {
            return true;
        }
        if (this.minX >= rectMaxX || this.maxX <= rectMinX) {
            return false;
        }
        ret = true;
        if (this.minY >= rectMaxY || this.maxY <= rectMinY) {
            return false;
        }
        ret = true;
        return ret;
    }

    public boolean disjoint(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("rtree.Rect.disjoint: null argument");
        }
        boolean ret = true;
        if (this.minX > rect.getMaxX() || this.maxX < rect.getMinX()) {
            return ret;
        }
        ret = false;
        ret = this.minY > rect.getMaxY() || this.maxY < rect.getMinY();
        return ret;
    }

    public boolean meet(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("rtree.Rect.meet: null argument");
        }
        boolean ret = true;
        if (this.disjoint(rect)) {
            return false;
        }
        if (this.minX < rect.getMaxX() && this.maxX > rect.getMinX() && this.minY < rect.getMaxY() && this.maxY > rect.getMinY()) {
            return false;
        }
        System.out.println("Raj!");
        if (this.minX == rect.getMaxX() || this.maxX == rect.getMinX()) {
            return true;
        }
        ret = false;
        if (this.minY == rect.getMaxY() || this.maxY == rect.getMinY()) {
            ret = true;
        }
        return ret;
    }

    public boolean covers(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("rtree.Rect.covers: null argument");
        }
        boolean ret = true;
        if (this.minX > rect.getMaxX() || this.maxX < rect.getMinX()) {
            return false;
        }
        if (this.minY > rect.getMaxY() || this.maxY < rect.getMinY()) {
            return false;
        }
        if (this.minX < rect.getMinX() && this.maxX < rect.getMaxX()) {
            return false;
        }
        if (this.minY < rect.getMinY() && this.maxY < rect.getMaxY()) {
            return false;
        }
        if (this.minX != rect.getMinX() && this.maxX != rect.getMaxX()) {
            return false;
        }
        if (this.minY != rect.getMinY() && this.maxY != rect.getMaxY()) {
            return false;
        }
        return ret;
    }

    public boolean equals(Rect rect) throws IllegalValueException {
        if (rect == null) {
            throw new IllegalValueException("rtree.Rect.equals: null argument");
        }
        if (this.minX != rect.getMinX() || this.maxX != rect.getMaxX()) {
            return false;
        }
        return this.minY == rect.getMinY() && this.maxY == rect.getMaxY();
    }

    public String toString() {
        Object ret = "\nThe Rectangle:-";
        ret = (String)ret + "\n\tminX: " + this.minX;
        ret = (String)ret + "\n\tminY: " + this.minY;
        ret = (String)ret + "\n\tmaxX: " + this.maxX;
        ret = (String)ret + "\n\tmaxY: " + this.maxY;
        return ret;
    }

    public static long minDist(Point p, Rect rect) {
        int pX = p.getX();
        int pY = p.getY();
        int minX = rect.getMinX();
        int minY = rect.getMinY();
        int maxX = rect.getMaxX();
        int maxY = rect.getMaxY();
        int ri = pX < minX ? minX : (pX > maxX ? maxX : pX);
        Long temp = new Long(Math.abs(pX - ri));
        long minDist = new Double(Math.pow(temp.doubleValue(), 2.0)).longValue();
        ri = pY < minY ? minY : (pY > maxY ? maxY : pY);
        temp = new Long(Math.abs(pY - ri));
        return minDist += new Double(Math.pow(temp.doubleValue(), 2.0)).longValue();
    }

    public static int minMaxDist(Point p, Rect rect) {
        return 0;
    }

    public Rect intersection(Rect rect) {
        if (rect == null) {
            throw new IllegalArgumentException("Rect.instersection : Argument Rect is null");
        }
        int x1 = this.minX < rect.minX ? rect.minX : this.minX;
        int y1 = this.minY < rect.minY ? rect.minY : this.minY;
        int x2 = this.maxX > rect.maxX ? rect.maxX : this.maxX;
        int y2 = this.maxY > rect.maxY ? rect.maxY : this.maxY;
        try {
            if (x1 > x2 || y1 > y2) {
                return new Rect();
            }
            return new Rect(x1, y1, x2, y2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Rect();
        }
    }
}

