/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.render;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.osmand.PlatformUtil;
import net.osmand.render.RenderingClass;
import net.osmand.render.RenderingRule;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRuleStorageProperties;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RenderingRulesStorage {
    private static final Log log = PlatformUtil.getLog(RenderingRulesStorage.class);
    static boolean STORE_ATTRIBUTES = false;
    public static final int MULTY_POLYGON_TYPE = 0;
    public static final int POINT_RULES = 1;
    public static final int LINE_RULES = 2;
    public static final int POLYGON_RULES = 3;
    public static final int TEXT_RULES = 4;
    public static final int ORDER_RULES = 5;
    public static final int LENGTH_RULES = 6;
    private static final int SHIFT_TAG_VAL = 16;
    private static final String SEQ_ATTR_KEY = "seq";
    private static final String SEQ_PLACEHOLDER = "#SEQ";
    List<String> dictionary = new ArrayList<String>();
    Map<String, Integer> dictionaryMap = new LinkedHashMap<String, Integer>();
    Map<String, String> classProperties = new LinkedHashMap<String, String>();
    public RenderingRuleStorageProperties PROPS = new RenderingRuleStorageProperties();
    public TIntObjectHashMap<RenderingRule>[] tagValueGlobalRules = new TIntObjectHashMap[6];
    protected Map<String, RenderingRule> renderingAttributes = new LinkedHashMap<String, RenderingRule>();
    protected Map<String, RenderingClass> renderingClasses = new LinkedHashMap<String, RenderingClass>();
    protected Map<String, String> renderingConstants = new LinkedHashMap<String, String>();
    protected String renderingName;
    protected String dependsName;
    protected String internalRenderingName;
    protected int internalVersion = 1;

    public String getDependsName() {
        return this.dependsName;
    }

    public RenderingRulesStorage(String name, Map<String, String> renderingConstants) {
        this.getDictionaryValue("");
        this.renderingName = name;
        if (renderingConstants != null) {
            this.renderingConstants.putAll(renderingConstants);
        }
    }

    public RenderingRulesStorage copy() {
        RenderingRulesStorage storage = new RenderingRulesStorage(this.renderingName, this.renderingConstants);
        storage.internalRenderingName = this.internalRenderingName;
        storage.internalVersion = this.internalVersion + 1;
        storage.dictionary = new ArrayList<String>(this.dictionary);
        storage.dictionaryMap.putAll(this.dictionaryMap);
        storage.PROPS = new RenderingRuleStorageProperties(this.PROPS);
        storage.tagValueGlobalRules = new TIntObjectHashMap[this.tagValueGlobalRules.length];
        for (int i = 0; i < this.tagValueGlobalRules.length; ++i) {
            TIntObjectHashMap<RenderingRule> rule = this.tagValueGlobalRules[i];
            if (rule == null) continue;
            TIntObjectHashMap newRule = new TIntObjectHashMap();
            newRule.putAll(rule);
            storage.tagValueGlobalRules[i] = newRule;
        }
        storage.renderingAttributes.putAll(this.renderingAttributes);
        storage.renderingClasses.putAll(this.renderingClasses);
        return storage;
    }

    public int getInternalVersion() {
        return this.internalVersion;
    }

    public int getDictionaryValue(String val) {
        if (this.dictionaryMap.containsKey(val)) {
            return this.dictionaryMap.get(val);
        }
        int nextInd = this.dictionaryMap.size();
        this.dictionaryMap.put(val, nextInd);
        this.dictionary.add(val);
        return nextInd;
    }

    public String getStringValue(int i) {
        return this.dictionary.get(i);
    }

    public String getName() {
        return this.renderingName;
    }

    public String getInternalRenderingName() {
        return this.internalRenderingName;
    }

    public void parseRulesFromXmlInputStream(InputStream is, RenderingRulesStorageResolver resolver, boolean addon) throws XmlPullParserException, IOException {
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        RenderingRulesHandler handler = new RenderingRulesHandler(parser, resolver, addon);
        handler.parse(is);
        RenderingRulesStorage depends = handler.getDependsStorage();
        if (depends != null) {
            this.dependsName = depends.getName();
            this.mergeDependsOrAddon(depends);
        }
    }

    public void mergeDependsOrAddon(RenderingRulesStorage depends) {
        if (depends == null) {
            return;
        }
        for (Map.Entry<String, RenderingRule> e : depends.renderingAttributes.entrySet()) {
            if (this.renderingAttributes.containsKey(e.getKey())) {
                RenderingRule root = this.renderingAttributes.get(e.getKey());
                List<RenderingRule> list = e.getValue().getIfElseChildren();
                for (RenderingRule every : list) {
                    root.addIfElseChildren(every);
                }
                e.getValue().addToBeginIfElseChildren(root);
                continue;
            }
            this.renderingAttributes.put(e.getKey(), e.getValue());
        }
        for (int i = 0; i < 6; ++i) {
            if (depends.tagValueGlobalRules[i] == null || depends.tagValueGlobalRules[i].isEmpty()) continue;
            if (this.tagValueGlobalRules[i] != null) {
                int[] keys = depends.tagValueGlobalRules[i].keys();
                for (int j = 0; j < keys.length; ++j) {
                    RenderingRule rule = (RenderingRule)this.tagValueGlobalRules[i].get(keys[j]);
                    RenderingRule dependsRule = (RenderingRule)depends.tagValueGlobalRules[i].get(keys[j]);
                    if (dependsRule == null) continue;
                    if (rule != null) {
                        RenderingRule toInsert = this.createTagValueRootWrapperRule(keys[j], rule);
                        toInsert.addIfElseChildren(dependsRule);
                        this.tagValueGlobalRules[i].put(keys[j], (Object)toInsert);
                        continue;
                    }
                    this.tagValueGlobalRules[i].put(keys[j], (Object)dependsRule);
                }
                continue;
            }
            this.tagValueGlobalRules[i] = depends.tagValueGlobalRules[i];
        }
        for (Map.Entry<String, RenderingClass> entry : depends.renderingClasses.entrySet()) {
            String className = entry.getKey();
            RenderingClass renderingClass = entry.getValue();
            if (this.renderingClasses.containsKey(className)) {
                RenderingClass existingClass = this.renderingClasses.get(className);
                RenderingClass mergedClass = this.mergeRenderingClasses(existingClass, renderingClass);
                this.renderingClasses.put(className, mergedClass);
                continue;
            }
            this.renderingClasses.put(className, renderingClass);
        }
    }

    private RenderingClass mergeRenderingClasses(RenderingClass existing, RenderingClass depends) {
        return new RenderingClass(existing.getTitle() != null ? existing.getTitle() : depends.getTitle(), existing.getDescription() != null ? existing.getDescription() : depends.getDescription(), existing.getCategory() != null ? existing.getCategory() : depends.getCategory(), existing.getLegendObject() != null ? existing.getLegendObject() : depends.getLegendObject(), existing.getInnerLegendObject() != null ? existing.getInnerLegendObject() : depends.getInnerLegendObject(), existing.getInnerTitle() != null ? existing.getInnerTitle() : depends.getInnerTitle(), existing.getInnerDescription() != null ? existing.getInnerDescription() : depends.getInnerDescription(), existing.getInnerCategory() != null ? existing.getInnerCategory() : depends.getInnerCategory(), existing.getInnerNames() != null ? existing.getInnerNames() : depends.getInnerNames(), existing.isEnabledByDefault() || depends.isEnabledByDefault(), existing.getName() != null ? existing.getName() : depends.getName());
    }

    public static String colorToString(int color) {
        if ((0xFF000000 & color) == -16777216) {
            return "#" + Integer.toHexString(color & 0xFFFFFF);
        }
        return "#" + Integer.toHexString(color);
    }

    private void registerGlobalRule(RenderingRule rr, int state, String tagS, String valueS, boolean addToBegin) throws XmlPullParserException {
        if (tagS == null || valueS == null) {
            throw new XmlPullParserException("Attribute tag should be specified for root filter " + rr.toString());
        }
        int key = this.getTagValueKey(tagS, valueS);
        RenderingRule insert = (RenderingRule)this.tagValueGlobalRules[state].get(key);
        if (insert != null) {
            insert = this.createTagValueRootWrapperRule(key, insert);
            if (addToBegin) {
                insert.addToBeginIfElseChildren(rr);
            } else {
                insert.addIfElseChildren(rr);
            }
        } else {
            insert = rr;
        }
        this.tagValueGlobalRules[state].put(key, (Object)insert);
    }

    private RenderingRule createTagValueRootWrapperRule(int tagValueKey, RenderingRule previous) {
        if (previous.getProperties().length > 0) {
            HashMap<String, String> m = new HashMap<String, String>();
            RenderingRule toInsert = new RenderingRule(m, true, this);
            toInsert.addIfElseChildren(previous);
            return toInsert;
        }
        return previous;
    }

    public void registerTopLevel(RenderingRule renderingRule, List<RenderingRule> applyRules, Map<String, String> attrs, int state, boolean addToBegin) throws XmlPullParserException {
        block6: {
            block5: {
                if (!renderingRule.isGroup() || renderingRule.getIntPropertyValue("tag") != -1 && renderingRule.getIntPropertyValue("value") != -1) break block5;
                List<RenderingRule> caseChildren = renderingRule.getIfElseChildren();
                for (RenderingRule ch : caseChildren) {
                    List<RenderingRule> apply = applyRules;
                    if (!renderingRule.getIfChildren().isEmpty()) {
                        apply = new ArrayList<RenderingRule>(renderingRule.getIfChildren());
                        if (applyRules != null) {
                            apply.addAll(applyRules);
                        }
                    }
                    HashMap<String, String> cattrs = new HashMap<String, String>(attrs);
                    cattrs.putAll(renderingRule.getAttributes());
                    this.registerTopLevel(ch, apply, cattrs, state, addToBegin);
                }
                break block6;
            }
            HashMap<String, String> ns = new HashMap<String, String>(attrs);
            ns.putAll(renderingRule.getAttributes());
            String tg = ns.remove("tag");
            String vl = ns.remove("value");
            renderingRule.init(ns);
            if (STORE_ATTRIBUTES) {
                renderingRule.storeAttributes(ns);
            }
            this.registerGlobalRule(renderingRule, state, tg, vl, addToBegin);
            if (applyRules == null) break block6;
            for (RenderingRule apply : applyRules) {
                renderingRule.addIfChildren(apply);
            }
        }
    }

    public int getTagValueKey(String tag, String value) {
        int itag = this.getDictionaryValue(tag);
        int ivalue = this.getDictionaryValue(value);
        return itag << 16 | ivalue;
    }

    public String getValueString(int tagValueKey) {
        return this.getStringValue(tagValueKey & 0xFFFF);
    }

    public String getTagString(int tagValueKey) {
        return this.getStringValue(tagValueKey >> 16);
    }

    protected RenderingRule getRule(int state, int itag, int ivalue) {
        if (this.tagValueGlobalRules[state] != null) {
            return (RenderingRule)this.tagValueGlobalRules[state].get(itag << 16 | ivalue);
        }
        return null;
    }

    public RenderingRule getRule(int state, int key) {
        if (this.tagValueGlobalRules[state] != null) {
            return (RenderingRule)this.tagValueGlobalRules[state].get(key);
        }
        return null;
    }

    public RenderingRule getRenderingAttributeRule(String attribute) {
        return this.renderingAttributes.get(attribute);
    }

    public String[] getRenderingAttributeNames() {
        return this.renderingAttributes.keySet().toArray(new String[0]);
    }

    public RenderingRule[] getRenderingAttributeValues() {
        return this.renderingAttributes.values().toArray(new RenderingRule[0]);
    }

    public RenderingClass getRenderingClass(String name) {
        return this.renderingClasses.get(name);
    }

    public Map<String, RenderingClass> getRenderingClasses() {
        return this.renderingClasses;
    }

    public RenderingRule[] getRules(int state) {
        if (state >= this.tagValueGlobalRules.length || this.tagValueGlobalRules[state] == null) {
            return new RenderingRule[0];
        }
        return (RenderingRule[])this.tagValueGlobalRules[state].values((Object[])new RenderingRule[this.tagValueGlobalRules[state].size()]);
    }

    public int getRuleTagValueKey(int state, int ind) {
        return this.tagValueGlobalRules[state].keys()[ind];
    }

    public void printDebug(int state, PrintStream out) {
        if (this.tagValueGlobalRules[state] != null) {
            for (int key : this.tagValueGlobalRules[state].keys()) {
                RenderingRule rr = (RenderingRule)this.tagValueGlobalRules[state].get(key);
                out.print("\n\n" + this.getTagString(key) + " : " + this.getValueString(key) + "\n ");
                RenderingRulesStorage.printRenderingRule(" ", rr, out);
            }
        }
    }

    private static void printRenderingRule(String indent, RenderingRule rr, PrintStream out) {
        out.print(rr.toString(indent, new StringBuilder()).toString());
    }

    public static void main(String[] args) throws XmlPullParserException, IOException {
        InputStream defaultIS;
        String styleName;
        File styleFile;
        STORE_ATTRIBUTES = true;
        if (args.length > 0) {
            styleFile = new File(args[0]);
            styleName = styleFile.getName().substring(0, styleFile.getName().indexOf(46));
            defaultIS = RenderingRulesStorage.class.getResourceAsStream("default.render.xml");
        } else {
            File stylesDir = new File("../../resources/rendering_styles/");
            System.out.println(stylesDir.getCanonicalFile().getAbsolutePath());
            defaultIS = new FileInputStream(new File(stylesDir, "default.render.xml"));
            styleName = "default";
            styleFile = new File(stylesDir, styleName + ".render.xml");
        }
        final Map<String, String> renderingConstants = RenderingRulesStorage.readRenderingConstantsFromInputStream(defaultIS);
        RenderingRulesStorage storage = new RenderingRulesStorage(styleName, renderingConstants);
        RenderingRulesStorageResolver resolver = new RenderingRulesStorageResolver(){

            @Override
            public RenderingRulesStorage resolve(String name, RenderingRulesStorageResolver ref) throws XmlPullParserException, IOException {
                RenderingRulesStorage depends = new RenderingRulesStorage(name, renderingConstants);
                depends.parseRulesFromXmlInputStream(new FileInputStream(new File(styleFile.getParentFile(), name + ".render.xml")), ref, false);
                return depends;
            }
        };
        defaultIS = new FileInputStream(styleFile);
        storage.parseRulesFromXmlInputStream(defaultIS, resolver, false);
        if (styleFile.getParentFile() != null) {
            for (File file : styleFile.getParentFile().listFiles()) {
                if (!file.isFile() || !file.getName().endsWith("addon.render.xml")) continue;
                FileInputStream is3 = new FileInputStream(file);
                storage.parseRulesFromXmlInputStream(is3, resolver, true);
                ((InputStream)is3).close();
            }
        }
        RenderingRulesStorage.printAllRules(storage);
    }

    protected static void testSearch(RenderingRulesStorage storage) {
        long tm = System.nanoTime();
        int count = 1000000;
        for (int i = 0; i < count; ++i) {
            RenderingRuleSearchRequest searchRequest = new RenderingRuleSearchRequest(storage);
            searchRequest.setStringFilter(storage.PROPS.R_TAG, "highway");
            searchRequest.setStringFilter(storage.PROPS.R_VALUE, "primary");
            searchRequest.setIntFilter(storage.PROPS.R_MINZOOM, 15);
            searchRequest.setIntFilter(storage.PROPS.R_MAXZOOM, 15);
            boolean bl = searchRequest.search(2);
        }
        System.out.println((float)(System.nanoTime() - tm) / 1.0E9f);
    }

    public static RenderingRulesStorage getTestStorageForStyle(String filePath) throws XmlPullParserException, IOException {
        STORE_ATTRIBUTES = true;
        FileInputStream is = new FileInputStream(filePath);
        Map<String, String> renderingConstants = RenderingRulesStorage.readRenderingConstantsFromInputStream(is);
        is = new FileInputStream(filePath);
        RenderingRulesStorage storage = new RenderingRulesStorage("default", renderingConstants);
        RenderingRulesStorageResolver resolver = new RenderingRulesStorageResolver(){

            @Override
            public RenderingRulesStorage resolve(String name, RenderingRulesStorageResolver ref) throws XmlPullParserException, IOException {
                RenderingRulesStorage depends = new RenderingRulesStorage(name, null);
                depends.parseRulesFromXmlInputStream(RenderingRulesStorage.class.getResourceAsStream(name + ".render.xml"), ref, false);
                return depends;
            }
        };
        storage.parseRulesFromXmlInputStream(is, resolver, false);
        return storage;
    }

    public static RenderingRulesStorage initWithStylesFromResources(String ... resourceFileNames) {
        try {
            RenderingRulesStorage storage = null;
            String BASE_EXT = ".render.xml";
            String ADDON_EXT = ".addon.render.xml";
            String[] defaultStyles = new String[]{"default.render.xml"};
            for (String resourceName : resourceFileNames != null ? resourceFileNames : defaultStyles) {
                boolean addon = resourceName.endsWith(".addon.render.xml");
                String styleName = resourceName.replace(".addon.render.xml", "").replace(".render.xml", "");
                Map<String, String> constants = RenderingRulesStorage.readRenderingConstantsFromInputStream(RenderingRulesStorage.class.getResourceAsStream(resourceName));
                if (storage == null) {
                    storage = new RenderingRulesStorage(styleName, constants);
                } else {
                    storage.renderingConstants.putAll(constants);
                }
                RenderingRulesStorageResolver resolver = (name, ref) -> {
                    String resource = name + (addon ? ".addon.render.xml" : ".render.xml");
                    RenderingRulesStorage depends = new RenderingRulesStorage(name, RenderingRulesStorage.readRenderingConstantsFromInputStream(RenderingRulesStorage.class.getResourceAsStream(resource)));
                    InputStream depStream = RenderingRulesStorage.class.getResourceAsStream(resource);
                    depends.parseRulesFromXmlInputStream(depStream, ref, false);
                    depStream.close();
                    return depends;
                };
                InputStream xmlStream = RenderingRulesStorage.class.getResourceAsStream(resourceName);
                storage.parseRulesFromXmlInputStream(xmlStream, resolver, addon);
                xmlStream.close();
            }
            return storage;
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> readRenderingConstantsFromInputStream(InputStream is) throws XmlPullParserException, IOException {
        LinkedHashMap<String, String> renderingConstants = new LinkedHashMap<String, String>();
        try (InputStream inputStream = is;){
            int tok;
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(is, "UTF-8");
            while ((tok = parser.next()) != 1) {
                String tagName;
                if (tok != 2 || !(tagName = parser.getName()).equals("renderingConstant") || renderingConstants.containsKey(parser.getAttributeValue("", "name"))) continue;
                renderingConstants.put(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
            }
        }
        return renderingConstants;
    }

    protected static void printAllRules(RenderingRulesStorage storage) {
        System.out.println("\n\n--------- POINTS ----- ");
        storage.printDebug(1, System.out);
        System.out.println("\n\n--------- POLYGON ----- ");
        storage.printDebug(3, System.out);
        System.out.println("\n\n--------- LINES ----- ");
        storage.printDebug(2, System.out);
        System.out.println("\n\n--------- ORDER ----- ");
        storage.printDebug(5, System.out);
        System.out.println("\n\n--------- TEXT ----- ");
        storage.printDebug(4, System.out);
    }

    private static void printResult(RenderingRuleSearchRequest searchRequest, PrintStream out) {
        if (searchRequest.isFound()) {
            out.print(" Found : ");
            for (RenderingRuleProperty rp : searchRequest.getProperties()) {
                if (!rp.isOutputProperty() || !searchRequest.isSpecified(rp)) continue;
                out.print(" " + rp.getAttrName() + "= ");
                if (rp.isString()) {
                    out.print("\"" + searchRequest.getStringPropertyValue(rp) + "\"");
                    continue;
                }
                if (rp.isFloat()) {
                    out.print(searchRequest.getFloatPropertyValue(rp));
                    continue;
                }
                if (rp.isColor()) {
                    out.print(searchRequest.getColorStringPropertyValue(rp));
                    continue;
                }
                if (!rp.isIntParse()) continue;
                out.print(searchRequest.getIntPropertyValue(rp));
            }
        } else {
            out.println("Not found");
        }
    }

    public String toString() {
        return this.getName();
    }

    private class RenderingRulesHandler {
        private final XmlPullParser parser;
        private int state;
        private Stack<RenderingRule> stack = new Stack();
        private Stack<String> nodeNamesStack = new Stack();
        private final RenderingRulesStorageResolver resolver;
        private final boolean addon;
        private RenderingRulesStorage dependsStorage;

        public RenderingRulesHandler(XmlPullParser parser, RenderingRulesStorageResolver resolver, boolean addon) {
            this.parser = parser;
            this.resolver = resolver;
            this.addon = addon;
        }

        public void parse(InputStream is) throws XmlPullParserException, IOException {
            int tok;
            XmlPullParser parser = this.parser;
            LinkedHashMap<String, String> attrsMap = new LinkedHashMap<String, String>();
            parser.setInput(is, "UTF-8");
            XmlTreeSequence currentSeqElement = null;
            while ((tok = parser.next()) != 1) {
                if (tok == 2) {
                    attrsMap.clear();
                    this.parseAttributes(parser, attrsMap);
                    String name = parser.getName();
                    if (!Algorithms.isEmpty(parser.getAttributeValue("", RenderingRulesStorage.SEQ_ATTR_KEY)) || currentSeqElement != null) {
                        XmlTreeSequence seq = new XmlTreeSequence();
                        seq.name = name;
                        seq.attrsMap = new HashMap<String, String>(attrsMap);
                        seq.parent = currentSeqElement;
                        if (currentSeqElement == null) {
                            seq.seqOrder = parser.getAttributeValue("", RenderingRulesStorage.SEQ_ATTR_KEY);
                        } else {
                            currentSeqElement.children.add(seq);
                            seq.seqOrder = currentSeqElement.seqOrder;
                        }
                        currentSeqElement = seq;
                        continue;
                    }
                    this.startElement(attrsMap, name);
                    continue;
                }
                if (tok != 3) continue;
                if (currentSeqElement == null) {
                    this.endElement(parser.getName());
                    continue;
                }
                XmlTreeSequence process = currentSeqElement;
                currentSeqElement = currentSeqElement.parent;
                if (currentSeqElement != null) continue;
                int seqEnd = Integer.parseInt(process.seqOrder.substring(process.seqOrder.indexOf(58) + 1, process.seqOrder.length()));
                for (int i = 1; i < seqEnd; ++i) {
                    process.process(this, i);
                }
            }
        }

        public RenderingRulesStorage getDependsStorage() {
            return this.dependsStorage;
        }

        private boolean isTopCase() {
            for (int i = 0; i < this.stack.size(); ++i) {
                if (((RenderingRule)this.stack.get(i)).isGroup()) continue;
                return false;
            }
            return true;
        }

        public void startElement(Map<String, String> attrsMap, String name) throws XmlPullParserException, IOException {
            boolean isCase = this.isCase(name);
            boolean isSwitch = this.isSwitch(name);
            if (isCase || isSwitch) {
                boolean top = this.stack.size() == 0 || this.isTopCase();
                RenderingRule renderingRule = new RenderingRule(attrsMap, isSwitch, RenderingRulesStorage.this);
                if (top || STORE_ATTRIBUTES) {
                    renderingRule.storeAttributes(attrsMap);
                }
                if (this.stack.size() > 0 && this.stack.peek() instanceof RenderingRule) {
                    RenderingRule parent = this.stack.peek();
                    parent.addIfElseChildren(renderingRule);
                }
                this.stack.push(renderingRule);
            } else if (this.isApply(name)) {
                RenderingRule renderingRule = new RenderingRule(attrsMap, false, RenderingRulesStorage.this);
                if (STORE_ATTRIBUTES) {
                    renderingRule.storeAttributes(attrsMap);
                }
                if (this.stack.size() <= 0 || !(this.stack.peek() instanceof RenderingRule)) {
                    throw new XmlPullParserException("Apply (groupFilter) without parent");
                }
                this.stack.peek().addIfChildren(renderingRule);
                this.stack.push(renderingRule);
            } else if ("order".equals(name)) {
                this.state = 5;
            } else if ("text".equals(name)) {
                this.state = 4;
            } else if ("point".equals(name)) {
                this.state = 1;
            } else if ("line".equals(name)) {
                this.state = 2;
            } else if ("polygon".equals(name)) {
                this.state = 3;
            } else if ("renderingAttribute".equals(name)) {
                String attr = attrsMap.get("name");
                RenderingRule root = new RenderingRule(new HashMap<String, String>(), false, RenderingRulesStorage.this);
                if (RenderingRulesStorage.this.renderingAttributes.containsKey(attr)) {
                    RenderingRulesStorage.this.renderingAttributes.get(attr).addIfElseChildren(root);
                } else {
                    RenderingRulesStorage.this.renderingAttributes.put(attr, root);
                }
                this.stack.push(root);
            } else if ("renderingProperty".equals(name)) {
                String attr = attrsMap.get("attr");
                String type = attrsMap.get("type");
                RenderingRuleProperty prop = "boolean".equalsIgnoreCase(type) ? RenderingRuleProperty.createInputBooleanProperty(attr) : ("string".equalsIgnoreCase(type) ? RenderingRuleProperty.createInputStringProperty(attr) : RenderingRuleProperty.createInputIntProperty(attr));
                prop.setDescription(attrsMap.get("description"));
                prop.setDefaultValueDescription(attrsMap.get("defaultValueDescription"));
                prop.setCategory(attrsMap.get("category"));
                prop.setName(attrsMap.get("name"));
                String possibleValues = attrsMap.get("possibleValues");
                if (possibleValues != null) {
                    String[] values = possibleValues.split(",");
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].trim();
                    }
                    prop.setPossibleValues(values);
                }
                RenderingRulesStorage.this.PROPS.registerRule(prop, !this.addon);
            } else if ("renderingConstant".equals(name)) {
                if (!RenderingRulesStorage.this.renderingConstants.containsKey(attrsMap.get("name"))) {
                    RenderingRulesStorage.this.renderingConstants.put(attrsMap.get("name"), attrsMap.get("value"));
                }
            } else if ("renderingStyle".equals(name)) {
                if (!this.addon) {
                    String depends = attrsMap.get("depends");
                    if (depends != null && depends.length() > 0) {
                        this.dependsStorage = this.resolver.resolve(depends, this.resolver);
                    }
                    if (this.dependsStorage != null) {
                        RenderingRulesStorage.this.dictionary = new ArrayList<String>(this.dependsStorage.dictionary);
                        RenderingRulesStorage.this.dictionaryMap = new LinkedHashMap<String, Integer>(this.dependsStorage.dictionaryMap);
                        RenderingRulesStorage.this.PROPS = new RenderingRuleStorageProperties(this.dependsStorage.PROPS);
                    }
                    RenderingRulesStorage.this.internalRenderingName = attrsMap.get("name");
                }
            } else {
                if ("renderer".equals(name)) {
                    throw new XmlPullParserException("Rendering style is deprecated and no longer supported.");
                }
                if ("renderingClass".equals(name)) {
                    this.parseRenderingClass(attrsMap);
                } else {
                    log.warn((Object)("Unknown tag : " + name));
                }
            }
            if (RenderingRulesStorage.this.tagValueGlobalRules[this.state] == null) {
                RenderingRulesStorage.this.tagValueGlobalRules[this.state] = new TIntObjectHashMap();
            }
        }

        private void parseRenderingClass(Map<String, String> attrsMap) {
            StringBuilder path = new StringBuilder();
            if (!this.nodeNamesStack.isEmpty()) {
                for (String nodeName : this.nodeNamesStack) {
                    path.append(nodeName);
                }
            }
            String name = attrsMap.get("name");
            String title = attrsMap.get("title");
            boolean enable = Boolean.parseBoolean(attrsMap.get("enable"));
            String description = attrsMap.get("description");
            String category = attrsMap.get("category");
            String legendObject = attrsMap.get("legend-object");
            String innerLegendObject = attrsMap.get("inner-legend-object");
            String innerTitle = attrsMap.get("inner-title");
            String innerDescription = attrsMap.get("inner-description");
            String innerCategory = attrsMap.get("inner-category");
            String innerNames = attrsMap.get("inner-names");
            path.append(name);
            RenderingClass renderingClass = new RenderingClass(title, description, category, legendObject, innerLegendObject, innerTitle, innerDescription, innerCategory, innerNames, enable, path.toString());
            this.nodeNamesStack.push(name);
            RenderingRulesStorage.this.renderingClasses.put(renderingClass.getName(), renderingClass);
            this.parseInnerRenderingClasses(renderingClass);
        }

        private void parseInnerRenderingClasses(RenderingClass parentClass) {
            String innerNames = parentClass.getInnerNames();
            if (innerNames != null && !innerNames.isEmpty()) {
                ArrayList<String> classNames = new ArrayList<String>();
                String nextPart = innerNames;
                int splitPosition = 1;
                while (splitPosition > 0) {
                    if (!nextPart.isEmpty() && !nextPart.startsWith(",")) {
                        String symbolClassName;
                        splitPosition = nextPart.indexOf(44);
                        String string = symbolClassName = splitPosition > 0 ? nextPart.substring(0, splitPosition) : nextPart;
                        if (!symbolClassName.isEmpty()) {
                            classNames.add(symbolClassName);
                        }
                    } else {
                        log.error((Object)String.format("'%s' contains an empty name for inner class definition", innerNames));
                        break;
                    }
                    if (splitPosition <= 0) continue;
                    nextPart = nextPart.substring(splitPosition + 1);
                }
                String temp = "$class";
                String path = parentClass.getName();
                boolean enabled = parentClass.isEnabledByDefault();
                String innerLegendObject = parentClass.getInnerLegendObject();
                String innerTitle = parentClass.getInnerTitle();
                String innerDescription = parentClass.getInnerDescription();
                String innerCategory = parentClass.getInnerCategory();
                for (String className : classNames) {
                    String classTitle = innerTitle != null ? innerTitle.replace(temp, className) : null;
                    String classDescription = innerDescription != null ? innerDescription.replace(temp, className) : null;
                    String classCategory = innerCategory != null ? innerCategory.replace(temp, className) : null;
                    String classLegendObject = innerLegendObject != null ? innerLegendObject.replace(temp, className) : null;
                    RenderingClass newClass = new RenderingClass(classTitle, classDescription, classCategory, classLegendObject, "", "", "", "", "", enabled, path.toString() + "." + className);
                    RenderingRulesStorage.this.renderingClasses.put(newClass.getName(), newClass);
                }
            }
        }

        protected boolean isCase(String name) {
            return "filter".equals(name) || "case".equals(name);
        }

        protected boolean isApply(String name) {
            return "groupFilter".equals(name) || "apply".equals(name) || "apply_if".equals(name);
        }

        protected boolean isSwitch(String name) {
            return "group".equals(name) || "switch".equals(name);
        }

        private Map<String, String> parseAttributes(XmlPullParser parser, Map<String, String> m) {
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String name = parser.getAttributeName(i);
                String vl = parser.getAttributeValue(i);
                if (vl != null && vl.startsWith("$")) {
                    String cv = vl.substring(1);
                    if (!(RenderingRulesStorage.this.renderingConstants.containsKey(cv) || RenderingRulesStorage.this.renderingAttributes.containsKey(cv) || RenderingRulesStorage.this.renderingClasses.containsKey(cv))) {
                        throw new IllegalStateException("Rendering constant, attribute or class '" + cv + "' was not specified.");
                    }
                    if (RenderingRulesStorage.this.renderingConstants.containsKey(cv)) {
                        vl = RenderingRulesStorage.this.renderingConstants.get(cv);
                    }
                }
                m.put(name, vl);
            }
            return m;
        }

        public void endElement(String name) throws XmlPullParserException {
            if (this.isCase(name) || this.isSwitch(name)) {
                RenderingRule renderingRule = this.stack.pop();
                if (this.stack.size() == 0) {
                    RenderingRulesStorage.this.registerTopLevel(renderingRule, null, Collections.EMPTY_MAP, this.state, false);
                }
            } else if (this.isApply(name)) {
                this.stack.pop();
            } else if ("renderingAttribute".equals(name)) {
                this.stack.pop();
            } else if ("renderingClass".equals(name)) {
                this.nodeNamesStack.pop();
            }
        }
    }

    public static interface RenderingRulesStorageResolver {
        public RenderingRulesStorage resolve(String var1, RenderingRulesStorageResolver var2) throws XmlPullParserException, IOException;
    }

    private class XmlTreeSequence {
        XmlTreeSequence parent;
        String seqOrder;
        Map<String, String> attrsMap = new LinkedHashMap<String, String>();
        String name;
        List<XmlTreeSequence> children = new ArrayList<XmlTreeSequence>();

        private XmlTreeSequence() {
        }

        private void process(RenderingRulesHandler handler, int el) throws XmlPullParserException, IOException {
            HashMap<String, String> seqAttrsMap = new HashMap<String, String>(this.attrsMap);
            if (this.attrsMap.containsKey(RenderingRulesStorage.SEQ_ATTR_KEY)) {
                this.attrsMap.remove(RenderingRulesStorage.SEQ_ATTR_KEY);
            }
            for (Map.Entry<String, String> attr : this.attrsMap.entrySet()) {
                if (attr.getValue().contains(RenderingRulesStorage.SEQ_PLACEHOLDER)) {
                    seqAttrsMap.put(attr.getKey(), attr.getValue().replace(RenderingRulesStorage.SEQ_PLACEHOLDER, "" + el));
                    continue;
                }
                seqAttrsMap.put(attr.getKey(), attr.getValue());
            }
            handler.startElement(seqAttrsMap, this.name);
            for (XmlTreeSequence s : this.children) {
                s.process(handler, el);
            }
            handler.endElement(this.name);
        }
    }
}

