/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.util.Assert;

public class MinimumBoundingCircle {
    private Geometry input;
    private Coordinate[] extremalPts = null;
    private Coordinate centre = null;
    private double radius = 0.0;

    public MinimumBoundingCircle(Geometry geom) {
        this.input = geom;
    }

    public Geometry getCircle() {
        this.compute();
        if (this.centre == null) {
            return this.input.getFactory().createPolygon(null, null);
        }
        Point centrePoint = this.input.getFactory().createPoint(this.centre);
        if (this.radius == 0.0) {
            return centrePoint;
        }
        return centrePoint.buffer(this.radius);
    }

    public Geometry getFarthestPoints() {
        this.compute();
        switch (this.extremalPts.length) {
            case 0: {
                return this.input.getFactory().createLineString((CoordinateSequence)null);
            }
            case 1: {
                return this.input.getFactory().createPoint(this.centre);
            }
        }
        Coordinate p0 = this.extremalPts[0];
        Coordinate p1 = this.extremalPts[this.extremalPts.length - 1];
        return this.input.getFactory().createLineString(new Coordinate[]{p0, p1});
    }

    public Geometry getDiameter() {
        this.compute();
        switch (this.extremalPts.length) {
            case 0: {
                return this.input.getFactory().createLineString((CoordinateSequence)null);
            }
            case 1: {
                return this.input.getFactory().createPoint(this.centre);
            }
        }
        Coordinate p0 = this.extremalPts[0];
        Coordinate p1 = this.extremalPts[1];
        return this.input.getFactory().createLineString(new Coordinate[]{p0, p1});
    }

    public Coordinate[] getExtremalPoints() {
        this.compute();
        return this.extremalPts;
    }

    public Coordinate getCentre() {
        this.compute();
        return this.centre;
    }

    public double getRadius() {
        this.compute();
        return this.radius;
    }

    private void computeCentre() {
        switch (this.extremalPts.length) {
            case 0: {
                this.centre = null;
                break;
            }
            case 1: {
                this.centre = this.extremalPts[0];
                break;
            }
            case 2: {
                this.centre = new Coordinate((this.extremalPts[0].x + this.extremalPts[1].x) / 2.0, (this.extremalPts[0].y + this.extremalPts[1].y) / 2.0);
                break;
            }
            case 3: {
                this.centre = Triangle.circumcentre(this.extremalPts[0], this.extremalPts[1], this.extremalPts[2]);
            }
        }
    }

    private void compute() {
        if (this.extremalPts != null) {
            return;
        }
        this.computeCirclePoints();
        this.computeCentre();
        if (this.centre != null) {
            this.radius = this.centre.distance(this.extremalPts[0]);
        }
    }

    private void computeCirclePoints() {
        Coordinate[] hullPts;
        if (this.input.isEmpty()) {
            this.extremalPts = new Coordinate[0];
            return;
        }
        if (this.input.getNumPoints() == 1) {
            Coordinate[] pts = this.input.getCoordinates();
            this.extremalPts = new Coordinate[]{new Coordinate(pts[0])};
            return;
        }
        Geometry convexHull = this.input.convexHull();
        Coordinate[] pts = hullPts = convexHull.getCoordinates();
        if (hullPts[0].equals2D(hullPts[hullPts.length - 1])) {
            pts = new Coordinate[hullPts.length - 1];
            CoordinateArrays.copyDeep(hullPts, 0, pts, 0, hullPts.length - 1);
        }
        if (pts.length <= 2) {
            this.extremalPts = CoordinateArrays.copyDeep(pts);
            return;
        }
        Coordinate P = MinimumBoundingCircle.lowestPoint(pts);
        Coordinate Q = MinimumBoundingCircle.pointWitMinAngleWithX(pts, P);
        int i = 0;
        while (i < pts.length) {
            Coordinate R = MinimumBoundingCircle.pointWithMinAngleWithSegment(pts, P, Q);
            if (Angle.isObtuse(P, R, Q)) {
                this.extremalPts = new Coordinate[]{new Coordinate(P), new Coordinate(Q)};
                return;
            }
            if (Angle.isObtuse(R, P, Q)) {
                P = R;
            } else if (Angle.isObtuse(R, Q, P)) {
                Q = R;
            } else {
                this.extremalPts = new Coordinate[]{new Coordinate(P), new Coordinate(Q), new Coordinate(R)};
                return;
            }
            ++i;
        }
        Assert.shouldNeverReachHere("Logic failure in Minimum Bounding Circle algorithm!");
    }

    private static Coordinate lowestPoint(Coordinate[] pts) {
        Coordinate min = pts[0];
        int i = 1;
        while (i < pts.length) {
            if (pts[i].y < min.y) {
                min = pts[i];
            }
            ++i;
        }
        return min;
    }

    private static Coordinate pointWitMinAngleWithX(Coordinate[] pts, Coordinate P) {
        double minSin = Double.MAX_VALUE;
        Coordinate minAngPt = null;
        int i = 0;
        while (i < pts.length) {
            Coordinate p = pts[i];
            if (p != P) {
                double len;
                double sin;
                double dx = p.x - P.x;
                double dy = p.y - P.y;
                if (dy < 0.0) {
                    dy = -dy;
                }
                if ((sin = dy / (len = Math.sqrt(dx * dx + dy * dy))) < minSin) {
                    minSin = sin;
                    minAngPt = p;
                }
            }
            ++i;
        }
        return minAngPt;
    }

    private static Coordinate pointWithMinAngleWithSegment(Coordinate[] pts, Coordinate P, Coordinate Q) {
        double minAng = Double.MAX_VALUE;
        Coordinate minAngPt = null;
        int i = 0;
        while (i < pts.length) {
            double ang;
            Coordinate p = pts[i];
            if (p != P && p != Q && (ang = Angle.angleBetween(P, p, Q)) < minAng) {
                minAng = ang;
                minAngPt = p;
            }
            ++i;
        }
        return minAngPt;
    }
}

