/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.organization.enums;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.data.Limits;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.enums.TracksSortScope;
import net.osmand.shared.gpx.filters.MeasureUnitType;
import net.osmand.shared.gpx.filters.TrackFilterType;
import net.osmand.shared.gpx.organization.enums.OrganizeByCategory;
import net.osmand.shared.gpx.organization.strategy.OrganizeByDateStrategy;
import net.osmand.shared.gpx.organization.strategy.OrganizeByListStrategy;
import net.osmand.shared.gpx.organization.strategy.OrganizeByRangeStrategy;
import net.osmand.shared.gpx.organization.strategy.OrganizeByStrategy;
import net.osmand.shared.units.MeasurementUnit;
import net.osmand.shared.util.Localization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001=B=\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u00101\u001a\u00020\u0003J\u0006\u00102\u001a\u00020\u0003J\u0006\u00103\u001a\u000204J\b\u00105\u001a\u0004\u0018\u000106J\n\u00107\u001a\u0006\u0012\u0002\b\u000308J\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020<R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0\u00a8\u0006>"}, d2={"Lnet/osmand/shared/gpx/organization/enums/OrganizeByType;", "", "iconResId", "", "nameResId", "filterType", "Lnet/osmand/shared/gpx/filters/TrackFilterType;", "category", "Lnet/osmand/shared/gpx/organization/enums/OrganizeByCategory;", "stepRange", "Lnet/osmand/shared/data/Limits;", "strategy", "Lnet/osmand/shared/gpx/organization/strategy/OrganizeByStrategy;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lnet/osmand/shared/gpx/filters/TrackFilterType;Lnet/osmand/shared/gpx/organization/enums/OrganizeByCategory;Lnet/osmand/shared/data/Limits;Lnet/osmand/shared/gpx/organization/strategy/OrganizeByStrategy;)V", "getIconResId", "()Ljava/lang/String;", "getNameResId", "getFilterType", "()Lnet/osmand/shared/gpx/filters/TrackFilterType;", "getCategory", "()Lnet/osmand/shared/gpx/organization/enums/OrganizeByCategory;", "getStepRange", "()Lnet/osmand/shared/data/Limits;", "getStrategy", "()Lnet/osmand/shared/gpx/organization/strategy/OrganizeByStrategy;", "ACTIVITY", "DURATION", "TIME_IN_MOTION", "LENGTH", "YEAR_OF_CREATION", "MONTH_AND_YEAR", "NEAREST_CITY", "MAX_SPEED", "AVG_SPEED", "MAX_ALTITUDE", "AVG_ALTITUDE", "UPHILL", "DOWNHILL", "SENSOR_SPEED_MAX", "SENSOR_SPEED_AVG", "HEART_RATE_MAX", "HEART_RATE_AVG", "CADENCE_MAX", "CADENCE_AVG", "POWER_MAX", "POWER_AVG", "TEMP_MAX", "TEMP_AVG", "getName", "getIconName", "getTrackSortScope", "Lnet/osmand/shared/gpx/enums/TracksSortScope;", "getGpxParameter", "Lnet/osmand/shared/gpx/GpxParameter;", "getDisplayUnits", "Lnet/osmand/shared/units/MeasurementUnit;", "getDefaultStepInBaseUnits", "", "isRangeRelated", "", "Companion", "OsmAnd-shared"})
public final class OrganizeByType
extends Enum<OrganizeByType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String iconResId;
    @NotNull
    private final String nameResId;
    @NotNull
    private final TrackFilterType filterType;
    @NotNull
    private final OrganizeByCategory category;
    @Nullable
    private final Limits stepRange;
    @NotNull
    private final OrganizeByStrategy strategy;
    public static final double DEFAULT_STEP_SIZE = 1.0;
    public static final /* enum */ OrganizeByType ACTIVITY;
    public static final /* enum */ OrganizeByType DURATION;
    public static final /* enum */ OrganizeByType TIME_IN_MOTION;
    public static final /* enum */ OrganizeByType LENGTH;
    public static final /* enum */ OrganizeByType YEAR_OF_CREATION;
    public static final /* enum */ OrganizeByType MONTH_AND_YEAR;
    public static final /* enum */ OrganizeByType NEAREST_CITY;
    public static final /* enum */ OrganizeByType MAX_SPEED;
    public static final /* enum */ OrganizeByType AVG_SPEED;
    public static final /* enum */ OrganizeByType MAX_ALTITUDE;
    public static final /* enum */ OrganizeByType AVG_ALTITUDE;
    public static final /* enum */ OrganizeByType UPHILL;
    public static final /* enum */ OrganizeByType DOWNHILL;
    public static final /* enum */ OrganizeByType SENSOR_SPEED_MAX;
    public static final /* enum */ OrganizeByType SENSOR_SPEED_AVG;
    public static final /* enum */ OrganizeByType HEART_RATE_MAX;
    public static final /* enum */ OrganizeByType HEART_RATE_AVG;
    public static final /* enum */ OrganizeByType CADENCE_MAX;
    public static final /* enum */ OrganizeByType CADENCE_AVG;
    public static final /* enum */ OrganizeByType POWER_MAX;
    public static final /* enum */ OrganizeByType POWER_AVG;
    public static final /* enum */ OrganizeByType TEMP_MAX;
    public static final /* enum */ OrganizeByType TEMP_AVG;
    private static final /* synthetic */ OrganizeByType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private OrganizeByType(String iconResId, String nameResId, TrackFilterType filterType, OrganizeByCategory category, Limits stepRange, OrganizeByStrategy strategy) {
        this.iconResId = iconResId;
        this.nameResId = nameResId;
        this.filterType = filterType;
        this.category = category;
        this.stepRange = stepRange;
        this.strategy = strategy;
    }

    /* synthetic */ OrganizeByType(String string, int n, String string2, String string3, TrackFilterType trackFilterType, OrganizeByCategory organizeByCategory, Limits limits, OrganizeByStrategy organizeByStrategy, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            limits = null;
        }
        this(string2, string3, trackFilterType, organizeByCategory, limits, organizeByStrategy);
    }

    @NotNull
    public final String getIconResId() {
        return this.iconResId;
    }

    @NotNull
    public final String getNameResId() {
        return this.nameResId;
    }

    @NotNull
    public final TrackFilterType getFilterType() {
        return this.filterType;
    }

    @NotNull
    public final OrganizeByCategory getCategory() {
        return this.category;
    }

    @Nullable
    public final Limits getStepRange() {
        return this.stepRange;
    }

    @NotNull
    public final OrganizeByStrategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    public final String getName() {
        return Localization.INSTANCE.getString(this.nameResId);
    }

    @NotNull
    public final String getIconName() {
        return this.iconResId;
    }

    @NotNull
    public final TracksSortScope getTrackSortScope() {
        return this.strategy.getTrackSortScope();
    }

    @Nullable
    public final GpxParameter getGpxParameter() {
        return this.filterType.getProperty();
    }

    @NotNull
    public final MeasurementUnit<?> getDisplayUnits() {
        return MeasureUnitType.getUnit$default(this.filterType.getMeasureUnitType(), null, null, null, 7, null);
    }

    public final double getDefaultStepInBaseUnits() {
        Limits limits = this.stepRange;
        return this.getDisplayUnits().toBase(limits != null ? limits.getMidpoint() : 1.0);
    }

    public final boolean isRangeRelated() {
        return this.stepRange != null;
    }

    public static OrganizeByType[] values() {
        return (OrganizeByType[])$VALUES.clone();
    }

    public static OrganizeByType valueOf(String value) {
        return Enum.valueOf(OrganizeByType.class, value);
    }

    @NotNull
    public static EnumEntries<OrganizeByType> getEntries() {
        return $ENTRIES;
    }

    static {
        ACTIVITY = new OrganizeByType("ACTIVITY", 0, "ic_action_activity", "shared_string_activity", TrackFilterType.ACTIVITY, OrganizeByCategory.GENERAL, null, OrganizeByListStrategy.INSTANCE, 16, null);
        DURATION = new OrganizeByType("ic_action_time_span_75", "duration", TrackFilterType.DURATION, OrganizeByCategory.GENERAL, new Limits(1, 60), OrganizeByRangeStrategy.INSTANCE);
        TIME_IN_MOTION = new OrganizeByType("ic_action_time_in_motion", "moving_time", TrackFilterType.TIME_IN_MOTION, OrganizeByCategory.GENERAL, new Limits(1, 60), OrganizeByRangeStrategy.INSTANCE);
        LENGTH = new OrganizeByType("ic_action_length", "shared_string_length", TrackFilterType.LENGTH, OrganizeByCategory.GENERAL, new Limits(1, 100), OrganizeByRangeStrategy.INSTANCE);
        YEAR_OF_CREATION = new OrganizeByType("YEAR_OF_CREATION", 4, "ic_action_calendar_month", "year_of_creation", TrackFilterType.DATE_CREATION, OrganizeByCategory.DATE_TIME, null, OrganizeByDateStrategy.INSTANCE, 16, null);
        MONTH_AND_YEAR = new OrganizeByType("MONTH_AND_YEAR", 5, "ic_action_calendar_month", "month_year_creation", TrackFilterType.DATE_CREATION, OrganizeByCategory.DATE_TIME, null, OrganizeByDateStrategy.INSTANCE, 16, null);
        NEAREST_CITY = new OrganizeByType("NEAREST_CITY", 6, "ic_action_street_name", "nearest_city", TrackFilterType.CITY, OrganizeByCategory.LOCATION, null, OrganizeByListStrategy.INSTANCE, 16, null);
        MAX_SPEED = new OrganizeByType("ic_action_speed_max", "organize_by_max_speed", TrackFilterType.MAX_SPEED, OrganizeByCategory.SPEED, new Limits(1, 50), OrganizeByRangeStrategy.INSTANCE);
        AVG_SPEED = new OrganizeByType("ic_action_speed_average", "avg_speed", TrackFilterType.AVERAGE_SPEED, OrganizeByCategory.SPEED, new Limits(1, 50), OrganizeByRangeStrategy.INSTANCE);
        MAX_ALTITUDE = new OrganizeByType("ic_action_altitude_max", "organize_by_max_altitude", TrackFilterType.MAX_ALTITUDE, OrganizeByCategory.ALTITUDE_ELEVATION, new Limits(1, 1000), OrganizeByRangeStrategy.INSTANCE);
        AVG_ALTITUDE = new OrganizeByType("ic_action_altitude_average", "shared_string_avg_altitude", TrackFilterType.AVERAGE_ALTITUDE, OrganizeByCategory.ALTITUDE_ELEVATION, new Limits(1, 1000), OrganizeByRangeStrategy.INSTANCE);
        UPHILL = new OrganizeByType("ic_action_altitude_ascent", "shared_string_uphill", TrackFilterType.UPHILL, OrganizeByCategory.ALTITUDE_ELEVATION, new Limits(1, 1000), OrganizeByRangeStrategy.INSTANCE);
        DOWNHILL = new OrganizeByType("ic_action_altitude_descent", "shared_string_downhill", TrackFilterType.DOWNHILL, OrganizeByCategory.ALTITUDE_ELEVATION, new Limits(1, 1000), OrganizeByRangeStrategy.INSTANCE);
        SENSOR_SPEED_MAX = new OrganizeByType("ic_action_sensor_speed_outlined", "max_sensor_speed", TrackFilterType.MAX_SENSOR_SPEED, OrganizeByCategory.SENSORS, new Limits(1, 50), OrganizeByRangeStrategy.INSTANCE);
        SENSOR_SPEED_AVG = new OrganizeByType("ic_action_sensor_speed_outlined", "avg_sensor_speed", TrackFilterType.AVERAGE_SENSOR_SPEED, OrganizeByCategory.SENSORS, new Limits(1, 50), OrganizeByRangeStrategy.INSTANCE);
        HEART_RATE_MAX = new OrganizeByType("ic_action_sensor_heart_rate_outlined", "max_sensor_heartrate", TrackFilterType.MAX_SENSOR_HEART_RATE, OrganizeByCategory.SENSORS, new Limits(1, 20), OrganizeByRangeStrategy.INSTANCE);
        HEART_RATE_AVG = new OrganizeByType("ic_action_sensor_heart_rate_outlined", "avg_sensor_heartrate", TrackFilterType.AVERAGE_SENSOR_HEART_RATE, OrganizeByCategory.SENSORS, new Limits(1, 20), OrganizeByRangeStrategy.INSTANCE);
        CADENCE_MAX = new OrganizeByType("ic_action_sensor_cadence_outlined", "max_sensor_cadence", TrackFilterType.MAX_SENSOR_CADENCE, OrganizeByCategory.SENSORS, new Limits(5, 25), OrganizeByRangeStrategy.INSTANCE);
        CADENCE_AVG = new OrganizeByType("ic_action_sensor_cadence_outlined", "avg_sensor_cadence", TrackFilterType.AVERAGE_SENSOR_CADENCE, OrganizeByCategory.SENSORS, new Limits(5, 25), OrganizeByRangeStrategy.INSTANCE);
        POWER_MAX = new OrganizeByType("ic_action_sensor_bicycle_power_outlined", "max_sensor_bycicle_power", TrackFilterType.MAX_SENSOR_BICYCLE_POWER, OrganizeByCategory.SENSORS, new Limits(10, 100), OrganizeByRangeStrategy.INSTANCE);
        POWER_AVG = new OrganizeByType("ic_action_sensor_bicycle_power_outlined", "avg_sensor_bycicle_power", TrackFilterType.AVERAGE_SENSOR_BICYCLE_POWER, OrganizeByCategory.SENSORS, new Limits(10, 100), OrganizeByRangeStrategy.INSTANCE);
        TEMP_MAX = new OrganizeByType("ic_action_sensor_temperature_outlined", "max_sensor_temperature", TrackFilterType.MAX_SENSOR_TEMPERATURE, OrganizeByCategory.SENSORS, new Limits(1, 10), OrganizeByRangeStrategy.INSTANCE);
        TEMP_AVG = new OrganizeByType("ic_action_sensor_temperature_outlined", "avg_sensor_temperature", TrackFilterType.AVERAGE_SENSOR_TEMPERATURE, OrganizeByCategory.SENSORS, new Limits(1, 10), OrganizeByRangeStrategy.INSTANCE);
        $VALUES = organizeByTypeArray = new OrganizeByType[]{OrganizeByType.ACTIVITY, OrganizeByType.DURATION, OrganizeByType.TIME_IN_MOTION, OrganizeByType.LENGTH, OrganizeByType.YEAR_OF_CREATION, OrganizeByType.MONTH_AND_YEAR, OrganizeByType.NEAREST_CITY, OrganizeByType.MAX_SPEED, OrganizeByType.AVG_SPEED, OrganizeByType.MAX_ALTITUDE, OrganizeByType.AVG_ALTITUDE, OrganizeByType.UPHILL, OrganizeByType.DOWNHILL, OrganizeByType.SENSOR_SPEED_MAX, OrganizeByType.SENSOR_SPEED_AVG, OrganizeByType.HEART_RATE_MAX, OrganizeByType.HEART_RATE_AVG, OrganizeByType.CADENCE_MAX, OrganizeByType.CADENCE_AVG, OrganizeByType.POWER_MAX, OrganizeByType.POWER_AVG, OrganizeByType.TEMP_MAX, OrganizeByType.TEMP_AVG};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/osmand/shared/gpx/organization/enums/OrganizeByType$Companion;", "", "<init>", "()V", "DEFAULT_STEP_SIZE", "", "valuesOf", "", "Lnet/osmand/shared/gpx/organization/enums/OrganizeByType;", "category", "Lnet/osmand/shared/gpx/organization/enums/OrganizeByCategory;", "OsmAnd-shared"})
    @SourceDebugExtension(value={"SMAP\nOrganizeByType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrganizeByType.kt\nnet/osmand/shared/gpx/organization/enums/OrganizeByType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n774#2:233\n865#2,2:234\n*S KotlinDebug\n*F\n+ 1 OrganizeByType.kt\nnet/osmand/shared/gpx/organization/enums/OrganizeByType$Companion\n*L\n230#1:233\n230#1:234,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<OrganizeByType> valuesOf(@NotNull OrganizeByCategory category) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
            Iterable $this$filter$iv = (Iterable)OrganizeByType.getEntries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OrganizeByType it = (OrganizeByType)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it.getCategory() == category)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

