/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.Arrays;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.DelayKt;
import net.osmand.shared.KAsyncTask;
import net.osmand.shared.api.SQLiteAPI;
import net.osmand.shared.data.KLatLon;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxDatabase;
import net.osmand.shared.gpx.GpxDbHelper;
import net.osmand.shared.gpx.GpxDbUtils;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.GpxReader;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.RouteActivityHelper;
import net.osmand.shared.gpx.primitives.Metadata;
import net.osmand.shared.gpx.primitives.RouteActivity;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 $2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000f\u001a\u00020\u00022\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0011\"\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u0002H\u0082@\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0002H\u0002J\b\u0010\u0016\u001a\u00020\u0002H\u0002J!\u0010\u0017\u001a\u00020\u00022\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0011\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\u0015\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020\rH\u0002J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0006\u0010\"\u001a\u00020#J\u000e\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnet/osmand/shared/gpx/GpxReader;", "Lnet/osmand/shared/KAsyncTask;", "", "Lnet/osmand/shared/gpx/GpxDataItem;", "adapter", "Lnet/osmand/shared/gpx/GpxReader$GpxReaderAdapter;", "<init>", "(Lnet/osmand/shared/gpx/GpxReader$GpxReaderAdapter;)V", "database", "Lnet/osmand/shared/gpx/GpxDatabase;", "analyser", "Lnet/osmand/shared/gpx/GpxTrackAnalysis$TrackPointsAnalyser;", "currentFile", "Lnet/osmand/shared/io/KFile;", "currentItem", "doInBackground", "params", "", "([Lkotlin/Unit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitForInitialization", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doReading", "pullNextFileItem", "onProgressUpdate", "values", "([Lnet/osmand/shared/gpx/GpxDataItem;)V", "onCancelled", "onPostExecute", "result", "(Lkotlin/Unit;)V", "updateGpxDataItem", "item", "file", "setupNearestCityName", "isReading", "", "Companion", "GpxReaderAdapter", "OsmAnd-shared"})
public final class GpxReader
extends KAsyncTask<Unit, GpxDataItem, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GpxReaderAdapter adapter;
    @NotNull
    private final GpxDatabase database;
    @Nullable
    private GpxTrackAnalysis.TrackPointsAnalyser analyser;
    @Nullable
    private KFile currentFile;
    @Nullable
    private GpxDataItem currentItem;
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("GpxReader");
    public static final float MIN_VERTICAL_EXAGGERATION = 1.0f;
    public static final float MAX_VERTICAL_EXAGGERATION = 3.0f;

    public GpxReader(@NotNull GpxReaderAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        super(true, null, null, 6, null);
        this.adapter = adapter;
        this.database = GpxDbHelper.INSTANCE.getGPXDatabase();
        this.analyser = PlatformUtil.INSTANCE.getTrackPointsAnalyser();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object doInBackground(@NotNull Unit[] var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof doInBackground.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GpxReader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.doInBackground((Unit[])null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.waitForInitialization((Continuation<? super Unit>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (GpxReader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this.doReading();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitForInitialization(Continuation<? super Unit> $completion) {
        if (!($completion instanceof waitForInitialization.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GpxReader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GpxReader.access$waitForInitialization(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 3 sources

                while (!GpxDbHelper.INSTANCE.isInitialized() && !this.isCancelled()) {
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)100L, (Continuation)$continuation);
                    if (v0 != var4_4) continue;
                    return var4_4;
                }
                break;
            }
            case 1: {
                this = (GpxReader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl12
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void doReading() {
        int filesCount = 0;
        try {
            KFile file = null;
            GpxDataItem item = null;
            this.pullNextFileItem();
            file = this.currentFile;
            item = this.currentItem;
            while (file != null && !this.isCancelled()) {
                if (GpxDbUtils.INSTANCE.isAnalyseNeeded(item)) {
                    item = this.updateGpxDataItem(item, file);
                }
                if (item != null) {
                    this.adapter.onGpxDataItemRead(item);
                    GpxDataItem[] gpxDataItemArray = new GpxDataItem[]{item};
                    this.publishProgress(gpxDataItemArray);
                }
                this.pullNextFileItem();
                file = this.currentFile;
                item = this.currentItem;
                ++filesCount;
            }
        }
        catch (Exception e) {
            Logger.error$default(log, e.getMessage(), null, 2, null);
        }
    }

    private final void pullNextFileItem() {
        this.adapter.pullNextFileItem((Function1<? super Pair<KFile, GpxDataItem>, Unit>)((Function1)arg_0 -> GpxReader.pullNextFileItem$lambda$0(this, arg_0)));
    }

    public void onProgressUpdate(GpxDataItem ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.adapter.onProgressUpdate(Arrays.copyOf(values, values.length));
    }

    @Override
    public void onCancelled() {
        this.adapter.onReadingCancelled();
    }

    @Override
    public void onPostExecute(@NotNull Unit result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.adapter.onReadingFinished(this, this.isCancelled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GpxDataItem updateGpxDataItem(GpxDataItem item, KFile file) {
        GpxDataItem updatedItem;
        GpxFile gpxFile = GpxUtilities.INSTANCE.loadGpxFile(file, null, false);
        GpxDataItem gpxDataItem = item;
        if (gpxDataItem == null) {
            gpxDataItem = updatedItem = new GpxDataItem(file);
        }
        if (gpxFile.getError() == null) {
            updatedItem.setAnalysis(gpxFile.getAnalysis(file.lastModified(), null, null, this.analyser));
            if (!updatedItem.isRegularTrack()) {
                return updatedItem;
            }
            long creationTime = ((Number)updatedItem.requireParameter(GpxParameter.FILE_CREATION_TIME)).longValue();
            if (creationTime <= 0L) {
                updatedItem.setParameter(GpxParameter.FILE_CREATION_TIME, GpxUtilities.INSTANCE.getCreationTime(gpxFile));
            }
            updatedItem.setParameter(GpxParameter.FILE_LAST_MODIFIED_TIME, file.lastModified());
            Metadata metadata = gpxFile.getMetadata();
            RouteActivity routeActivity = metadata.getRouteActivity(RouteActivityHelper.INSTANCE.getActivities());
            Object object = routeActivity;
            if (object == null || (object = ((RouteActivity)object).getId()) == null) {
                object = "";
            }
            Object routeActivityId = object;
            updatedItem.setParameter(GpxParameter.ACTIVITY_TYPE, routeActivityId);
            this.setupNearestCityName(updatedItem);
            double additionalExaggeration = ((Number)updatedItem.requireParameter(GpxParameter.ADDITIONAL_EXAGGERATION)).doubleValue();
            if (additionalExaggeration < 1.0 || additionalExaggeration > 3.0) {
                updatedItem.setParameter(GpxParameter.ADDITIONAL_EXAGGERATION, 1.0);
            }
            updatedItem.setParameter(GpxParameter.DATA_VERSION, GpxDbUtils.INSTANCE.createDataVersion(1));
            SQLiteAPI.SQLiteConnection conn = this.database.openConnection(false);
            if (conn != null) {
                try {
                    if (this.database.isDataItemExists(file, conn)) {
                        GpxDbHelper.INSTANCE.updateDataItem(updatedItem);
                    } else {
                        GpxDbHelper.INSTANCE.insertDataItem(updatedItem, conn);
                    }
                }
                catch (Exception e) {
                    Logger.error$default(log, e.getMessage(), null, 2, null);
                }
                finally {
                    conn.close();
                }
            }
        }
        return updatedItem;
    }

    private final void setupNearestCityName(GpxDataItem item) {
        KLatLon latLon;
        GpxTrackAnalysis analysis;
        GpxTrackAnalysis gpxTrackAnalysis = analysis = item.getAnalysis();
        KLatLon kLatLon = latLon = gpxTrackAnalysis != null ? gpxTrackAnalysis.getLatLonStart() : null;
        if (latLon == null) {
            item.setParameter(GpxParameter.NEAREST_CITY_NAME, "");
        } else {
            PlatformUtil.INSTANCE.getOsmAndContext().searchNearestCityName(latLon, (Function1<? super String, Unit>)((Function1)arg_0 -> GpxReader.setupNearestCityName$lambda$1(item, arg_0)));
        }
    }

    public final boolean isReading() {
        return this.isRunning();
    }

    public final boolean isReading(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)this.currentFile, (Object)file);
    }

    private static final Unit pullNextFileItem$lambda$0(GpxReader this$0, Pair it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Pair pair = it;
        this$0.currentFile = pair != null ? (KFile)pair.getFirst() : null;
        Pair pair2 = it;
        this$0.currentItem = pair2 != null ? (GpxDataItem)pair2.getSecond() : null;
        return Unit.INSTANCE;
    }

    private static final Unit setupNearestCityName$lambda$1(GpxDataItem $item, String cityName) {
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        Intrinsics.checkNotNullParameter((Object)cityName, (String)"cityName");
        $item.setParameter(GpxParameter.NEAREST_CITY_NAME, cityName);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$waitForInitialization(GpxReader $this, Continuation $completion) {
        return $this.waitForInitialization((Continuation<? super Unit>)$completion);
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/osmand/shared/gpx/GpxReader$Companion;", "", "<init>", "()V", "log", "Lnet/osmand/shared/util/Logger;", "MIN_VERTICAL_EXAGGERATION", "", "MAX_VERTICAL_EXAGGERATION", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J<\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00032$\b\u0002\u0010\u0006\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H&J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0016J!\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\r\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\bH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/gpx/GpxReader$GpxReaderAdapter;", "", "pullNextFileItem", "Lkotlin/Pair;", "Lnet/osmand/shared/io/KFile;", "Lnet/osmand/shared/gpx/GpxDataItem;", "action", "Lkotlin/Function1;", "", "onGpxDataItemRead", "item", "onProgressUpdate", "dataItems", "", "([Lnet/osmand/shared/gpx/GpxDataItem;)V", "onReadingCancelled", "onReadingFinished", "reader", "Lnet/osmand/shared/gpx/GpxReader;", "cancelled", "", "OsmAnd-shared"})
    public static interface GpxReaderAdapter {
        @Nullable
        public Pair<KFile, GpxDataItem> pullNextFileItem(@Nullable Function1<? super Pair<KFile, GpxDataItem>, Unit> var1);

        public static /* synthetic */ Pair pullNextFileItem$default(GpxReaderAdapter gpxReaderAdapter, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pullNextFileItem");
            }
            if ((n & 1) != 0) {
                function1 = null;
            }
            return gpxReaderAdapter.pullNextFileItem((Function1<? super Pair<KFile, GpxDataItem>, Unit>)function1);
        }

        default public void onGpxDataItemRead(@NotNull GpxDataItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        }

        default public void onProgressUpdate(GpxDataItem ... dataItems) {
            Intrinsics.checkNotNullParameter((Object)dataItems, (String)"dataItems");
        }

        default public void onReadingCancelled() {
        }

        default public void onReadingFinished(@NotNull GpxReader reader2, boolean cancelled) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        }
    }
}

