/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J&\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lnet/osmand/shared/util/NamingUtils;", "", "<init>", "()V", "getNextName", "", "fileName", "delimiter", "generateUniqueName", "existingNames", "", "originalName", "OsmAnd-shared"})
public final class NamingUtils {
    @NotNull
    public static final NamingUtils INSTANCE = new NamingUtils();

    private NamingUtils() {
    }

    private final String getNextName(String fileName, String delimiter) {
        Object object;
        int extensionIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        String name = null;
        String extension = null;
        if (extensionIndex != -1) {
            String string = fileName.substring(0, extensionIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            name = string;
            String string2 = fileName.substring(extensionIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            extension = string2;
        } else {
            name = fileName;
            extension = "";
        }
        Regex regex = new Regex(delimiter + "\\((\\d+)\\)$");
        MatchResult match = Regex.find$default((Regex)regex, (CharSequence)name, (int)0, (int)2, null);
        if (match != null) {
            String numberStr = (String)match.getGroupValues().get(1);
            Integer n = StringsKt.toIntOrNull((String)numberStr);
            int number = n != null ? n : 1;
            String string = name;
            IntRange intRange = match.getRange();
            CharSequence charSequence = delimiter + "(" + (number + 1) + ")";
            object = ((Object)StringsKt.replaceRange((CharSequence)string, (IntRange)intRange, (CharSequence)charSequence)).toString();
        } else {
            object = name + delimiter + "(2)";
        }
        String newBaseName = object;
        return newBaseName + extension;
    }

    @NotNull
    public final String generateUniqueName(@NotNull Set<String> existingNames, @NotNull String originalName, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter(existingNames, (String)"existingNames");
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        String candidate = originalName;
        while (existingNames.contains(candidate)) {
            candidate = this.getNextName(candidate, delimiter);
        }
        return candidate;
    }

    public static /* synthetic */ String generateUniqueName$default(NamingUtils namingUtils, Set set, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = " ";
        }
        return namingUtils.generateUniqueName(set, string, string2);
    }
}

