/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.ColorPalette;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.KMapUtils;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 ?2\u00020\u0001:\u0004<=>?BC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB+\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0013B=\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0018J\u0012\u0010\u001d\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J&\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0007J \u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0$2\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\"2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0$H\u0002J\u0010\u0010,\u001a\u00020\"2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0$2\u0006\u0010(\u001a\u00020)J<\u0010.\u001a\u00020\"2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020/0$2\u0006\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020)2\f\u00102\u001a\b\u0012\u0004\u0012\u00020/0\u001a2\u0006\u00103\u001a\u00020\u0007H\u0002J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b0$2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001b0$H\u0002J(\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u00108\u001a\u00020)2\u0006\u0010 \u001a\u00020\u0007H\u0002J\b\u00109\u001a\u00020\"H\u0002J\u0018\u00109\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010:\u001a\u00020\u00032\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006@"}, d2={"Lnet/osmand/shared/routing/RouteColorize;", "", "latitudes", "", "longitudes", "values", "minValue", "", "maxValue", "palette", "Lnet/osmand/shared/ColorPalette;", "fixedValues", "", "<init>", "([D[D[DDDLnet/osmand/shared/ColorPalette;Z)V", "gpxFile", "Lnet/osmand/shared/gpx/GpxFile;", "type", "Lnet/osmand/shared/routing/RouteColorize$ColorizationType;", "(Lnet/osmand/shared/gpx/GpxFile;Lnet/osmand/shared/routing/RouteColorize$ColorizationType;Lnet/osmand/shared/ColorPalette;Z)V", "analysis", "Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "maxProfileSpeed", "", "(Lnet/osmand/shared/gpx/GpxFile;Lnet/osmand/shared/gpx/GpxTrackAnalysis;Lnet/osmand/shared/routing/RouteColorize$ColorizationType;Lnet/osmand/shared/ColorPalette;FZ)V", "dataList", "", "Lnet/osmand/shared/routing/RouteColorize$RouteColorizationPoint;", "colorizationType", "isValidPalette", "calculateSlopesByElevations", "elevations", "slopeRange", "correctElevations", "", "result", "", "getResult", "()Ljava/util/List;", "getSimplifiedResult", "simplificationZoom", "", "setColorsToPoints", "points", "setPalette", "simplify", "simplifyDouglasPeucker", "Lnet/osmand/shared/routing/RouteColorize$Node;", "start", "end", "survivedLPoints", "epsilon", "getExtremums", "subDataList", "findDerivativeArguments", "distances", "index", "calculateMinMaxValue", "listToArray", "doubleList", "ColorizationType", "RouteColorizationPoint", "Node", "Companion", "OsmAnd-shared"})
public final class RouteColorize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double[] latitudes;
    private double[] longitudes;
    private double[] values;
    private ColorPalette palette;
    private boolean fixedValues;
    private double minValue;
    private double maxValue;
    @Nullable
    private List<RouteColorizationPoint> dataList;
    @Nullable
    private ColorizationType colorizationType;
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("RouteColorize");
    private static double MAX_CORRECT_ELEVATION_DISTANCE = 100.0;
    private static int SLOPE_RANGE = 150;
    private static final double DEFAULT_BASE = 17.2;
    private static final double MIN_DIFFERENCE_SLOPE = 0.05;

    public RouteColorize(@NotNull double[] latitudes, @NotNull double[] longitudes, @NotNull double[] values, double minValue, double maxValue, @Nullable ColorPalette palette, boolean fixedValues) {
        Intrinsics.checkNotNullParameter((Object)latitudes, (String)"latitudes");
        Intrinsics.checkNotNullParameter((Object)longitudes, (String)"longitudes");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.latitudes = latitudes;
        this.longitudes = longitudes;
        this.values = values;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.fixedValues = fixedValues;
        if (Double.isNaN(minValue) || Double.isNaN(maxValue)) {
            this.calculateMinMaxValue();
        }
        this.palette = palette == null || palette.getColors().size() < 2 ? new ColorPalette(ColorPalette.Companion.getMIN_MAX_PALETTE(), minValue, maxValue) : palette;
    }

    public RouteColorize(@NotNull GpxFile gpxFile, @NotNull ColorizationType type, @Nullable ColorPalette palette, boolean fixedValues) {
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(gpxFile, null, type, palette, 0.0f, fixedValues);
    }

    public RouteColorize(@NotNull GpxFile gpxFile, @Nullable GpxTrackAnalysis analysis, @NotNull ColorizationType type, @Nullable ColorPalette palette, float maxProfileSpeed, boolean fixedValues) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.fixedValues = fixedValues;
        GpxTrackAnalysis analysis2 = analysis;
        if (!gpxFile.hasTrkPt()) {
            LOG.warn("GPX file is not consist of track points");
            return;
        }
        List latList = new ArrayList();
        List lonList = new ArrayList();
        List valList = new ArrayList();
        int wptIdx = 0;
        if (analysis2 == null) {
            long time = KAlgorithms.INSTANCE.isEmpty(gpxFile.getPath()) ? ClockExtensionsKt.currentTimeMillis() : gpxFile.getModifiedTime();
            analysis2 = gpxFile.getAnalysis(time);
        }
        for (Track t : gpxFile.getTracks()) {
            for (TrkSegment ts : t.getSegments()) {
                if (ts.getGeneralSegment() || ts.getPoints().size() < 2) continue;
                for (WptPt p : ts.getPoints()) {
                    latList.add(p.getLat());
                    lonList.add(p.getLon());
                    boolean bl = type == ColorizationType.SPEED ? valList.add(Double.valueOf(analysis2.getPointAttributes().get(wptIdx).getSpeed())) : valList.add(Double.valueOf(analysis2.getPointAttributes().get(wptIdx).getElevation()));
                    ++wptIdx;
                }
            }
        }
        this.colorizationType = type;
        this.latitudes = this.listToArray(latList);
        this.longitudes = this.listToArray(lonList);
        if (type == ColorizationType.SLOPE) {
            double[] dArray2 = this.latitudes;
            if (this.latitudes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latitudes");
                dArray2 = null;
            }
            double[] dArray3 = this.longitudes;
            if (this.longitudes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"longitudes");
                dArray3 = null;
            }
            dArray = this.calculateSlopesByElevations(dArray2, dArray3, this.listToArray(valList), SLOPE_RANGE);
        } else {
            dArray = this.listToArray(valList);
        }
        this.values = dArray;
        this.calculateMinMaxValue(analysis2, maxProfileSpeed);
        if (fixedValues) {
            ColorPalette colorPalette;
            if (this.isValidPalette(palette)) {
                ColorPalette colorPalette2 = palette;
                colorPalette = colorPalette2;
                Intrinsics.checkNotNull((Object)colorPalette2);
            } else {
                colorPalette = Companion.getDefaultPalette(type);
            }
            this.palette = colorPalette;
        } else if (type == ColorizationType.SLOPE) {
            ColorPalette colorPalette;
            if (this.isValidPalette(palette)) {
                ColorPalette colorPalette3 = palette;
                colorPalette = colorPalette3;
                Intrinsics.checkNotNull((Object)colorPalette3);
            } else {
                colorPalette = ColorPalette.Companion.getSLOPE_PALETTE();
            }
            this.palette = colorPalette;
        } else {
            ColorPalette colorPalette;
            if (this.isValidPalette(palette)) {
                ColorPalette colorPalette4 = palette;
                colorPalette = colorPalette4;
                Intrinsics.checkNotNull((Object)colorPalette4);
            } else {
                colorPalette = ColorPalette.Companion.getMIN_MAX_PALETTE();
            }
            this.palette = new ColorPalette(colorPalette, this.minValue, this.maxValue);
        }
    }

    private final boolean isValidPalette(ColorPalette palette) {
        return palette != null && palette.getColors().size() >= 2;
    }

    @NotNull
    public final double[] calculateSlopesByElevations(@NotNull double[] latitudes, @NotNull double[] longitudes, @NotNull double[] elevations, double slopeRange) {
        int i;
        double totalDistance;
        Intrinsics.checkNotNullParameter((Object)latitudes, (String)"latitudes");
        Intrinsics.checkNotNullParameter((Object)longitudes, (String)"longitudes");
        Intrinsics.checkNotNullParameter((Object)elevations, (String)"elevations");
        double[] elevations2 = elevations;
        this.correctElevations(latitudes, longitudes, elevations2);
        double[] newElevations = elevations2;
        int i2 = 2;
        int n = elevations2.length - 2;
        while (i2 < n) {
            newElevations[i2] = elevations2[i2 - 2] + elevations2[i2 - 1] + elevations2[i2] + elevations2[i2 + 1] + elevations2[i2 + 2];
            int n2 = i2++;
            newElevations[n2] = newElevations[n2] / 5.0;
        }
        elevations2 = newElevations;
        double[] slopes = new double[elevations2.length];
        if (latitudes.length != longitudes.length || latitudes.length != elevations2.length) {
            LOG.warn("Sizes of arrays latitudes, longitudes and values are not match");
            return slopes;
        }
        double[] distances = new double[elevations2.length];
        distances[0] = totalDistance = 0.0;
        int n3 = elevations2.length - 1;
        for (i = 0; i < n3; ++i) {
            distances[i + 1] = totalDistance += KMapUtils.INSTANCE.getDistance(latitudes[i], longitudes[i], latitudes[i + 1], longitudes[i + 1]);
        }
        n3 = elevations2.length;
        for (i = 0; i < n3; ++i) {
            if (distances[i] < slopeRange / (double)2 || distances[i] > totalDistance - slopeRange / (double)2) {
                slopes[i] = Double.NaN;
                continue;
            }
            double[] arg = this.findDerivativeArguments(distances, elevations2, i, slopeRange);
            slopes[i] = (arg[1] - arg[0]) / (arg[3] - arg[2]);
        }
        return slopes;
    }

    private final void correctElevations(double[] latitudes, double[] longitudes, double[] elevations) {
        int n = elevations.length;
        block0: for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(elevations[i])) continue;
            double leftDist = MAX_CORRECT_ELEVATION_DISTANCE;
            double rightDist = MAX_CORRECT_ELEVATION_DISTANCE;
            double leftElevation = Double.NaN;
            double rightElevation = Double.NaN;
            for (int left = i - 1; left > 0 && leftDist <= MAX_CORRECT_ELEVATION_DISTANCE; --left) {
                if (Double.isNaN(elevations[left])) continue;
                double dist = KMapUtils.INSTANCE.getDistance(latitudes[left], longitudes[left], latitudes[i], longitudes[i]);
                if (!(dist < leftDist)) break;
                leftDist = dist;
                leftElevation = elevations[left];
            }
            for (int right = i + 1; right < elevations.length && rightDist <= MAX_CORRECT_ELEVATION_DISTANCE; ++right) {
                if (Double.isNaN(elevations[right])) continue;
                double dist = KMapUtils.INSTANCE.getDistance(latitudes[right], longitudes[right], latitudes[i], longitudes[i]);
                if (!(dist < rightDist)) break;
                rightElevation = elevations[right];
                rightDist = dist;
            }
            if (!Double.isNaN(leftElevation) && !Double.isNaN(rightElevation)) {
                elevations[i] = (leftElevation + rightElevation) / (double)2;
                continue;
            }
            if (Double.isNaN(leftElevation) && !Double.isNaN(rightElevation)) {
                elevations[i] = rightElevation;
                continue;
            }
            if (!Double.isNaN(leftElevation) && Double.isNaN(rightElevation)) {
                elevations[i] = leftElevation;
                continue;
            }
            int n2 = elevations.length;
            for (int right = i + 1; right < n2; ++right) {
                if (Double.isNaN(elevations[right])) continue;
                elevations[i] = elevations[right];
                continue block0;
            }
        }
    }

    @NotNull
    public final List<RouteColorizationPoint> getResult() {
        List result = new ArrayList();
        int i = 0;
        double[] dArray = this.latitudes;
        if (this.latitudes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"latitudes");
            dArray = null;
        }
        int n = dArray.length;
        while (i < n) {
            double[] dArray2 = this.latitudes;
            if (this.latitudes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latitudes");
                dArray2 = null;
            }
            double d = dArray2[i];
            double[] dArray3 = this.longitudes;
            if (this.longitudes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"longitudes");
                dArray3 = null;
            }
            double d2 = dArray3[i];
            double[] dArray4 = this.values;
            if (this.values == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"values");
                dArray4 = null;
            }
            result.add(new RouteColorizationPoint(i, d, d2, dArray4[i]));
            ++i;
        }
        this.setColorsToPoints(result);
        return result;
    }

    @NotNull
    public final List<RouteColorizationPoint> getSimplifiedResult(int simplificationZoom) {
        List<RouteColorizationPoint> simplifiedResult = this.simplify(simplificationZoom);
        this.setColorsToPoints(simplifiedResult);
        return simplifiedResult;
    }

    private final void setColorsToPoints(List<RouteColorizationPoint> points) {
        for (RouteColorizationPoint point : points) {
            ColorPalette colorPalette = this.palette;
            if (colorPalette == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"palette");
                colorPalette = null;
            }
            point.setPrimaryColor(colorPalette.getColorByValue(point.getValue()));
        }
    }

    public final void setPalette(@Nullable ColorPalette palette) {
        if (palette != null) {
            this.palette = palette;
        }
    }

    @NotNull
    public final List<RouteColorizationPoint> simplify(int simplificationZoom) {
        List dataList = this.dataList;
        if (dataList == null) {
            dataList = new ArrayList();
            int i = 0;
            double[] dArray = this.latitudes;
            if (this.latitudes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latitudes");
                dArray = null;
            }
            int n = dArray.length;
            while (i < n) {
                double[] dArray2 = this.latitudes;
                if (this.latitudes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"latitudes");
                    dArray2 = null;
                }
                double d = dArray2[i];
                double[] dArray3 = this.longitudes;
                if (this.longitudes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"longitudes");
                    dArray3 = null;
                }
                double d2 = dArray3[i];
                double[] dArray4 = this.values;
                if (this.values == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"values");
                    dArray4 = null;
                }
                dataList.add(new RouteColorizationPoint(i, d, d2, dArray4[i]));
                ++i;
            }
            this.dataList = dataList;
        }
        List points = new ArrayList();
        List result = new ArrayList();
        for (RouteColorizationPoint data : dataList) {
            points.add(new Node(data.getLat(), data.getLon(), data.getId()));
        }
        double epsilon = Math.pow(2.0, 17.2 - (double)simplificationZoom);
        result.add(points.get(0));
        this.simplifyDouglasPeucker(points, 0, points.size() - 1, result, epsilon);
        List simplified = new ArrayList();
        int n = result.size();
        for (int i = 1; i < n; ++i) {
            int prevId = ((Node)result.get(i - 1)).getId();
            int currentId = ((Node)result.get(i)).getId();
            List<RouteColorizationPoint> sublist = dataList.subList(prevId, currentId);
            simplified.addAll((Collection)this.getExtremums(sublist));
        }
        Node lastSurvivedPoint = (Node)result.get(result.size() - 1);
        simplified.add(dataList.get(lastSurvivedPoint.getId()));
        return simplified;
    }

    private final void simplifyDouglasPeucker(List<Node> points, int start, int end, List<Node> survivedLPoints, double epsilon) {
        double dmax = Double.NEGATIVE_INFINITY;
        int index = -1;
        Node startPt = points.get(start);
        Node endPt = points.get(end);
        for (int i = start + 1; i < end; ++i) {
            Node pt = points.get(i);
            double d = KMapUtils.INSTANCE.getOrthogonalDistance(pt.getLat(), pt.getLon(), startPt.getLat(), startPt.getLon(), endPt.getLat(), endPt.getLon());
            if (!(d > dmax)) continue;
            dmax = d;
            index = i;
        }
        if (dmax > epsilon) {
            this.simplifyDouglasPeucker(points, start, index, survivedLPoints, epsilon);
            this.simplifyDouglasPeucker(points, index, end, survivedLPoints, epsilon);
        } else {
            survivedLPoints.add(points.get(end));
        }
    }

    private final List<RouteColorizationPoint> getExtremums(List<RouteColorizationPoint> subDataList) {
        if (subDataList.size() <= 2) {
            return subDataList;
        }
        List result = new ArrayList();
        double min = 0.0;
        double max = 0.0;
        min = max = subDataList.get(0).getValue();
        for (RouteColorizationPoint pt : subDataList) {
            if (min > pt.getValue()) {
                min = pt.getValue();
            }
            if (!(max < pt.getValue())) continue;
            max = pt.getValue();
        }
        double diff = max - min;
        result.add(subDataList.get(0));
        int n = subDataList.size() - 1;
        for (int i = 1; i < n; ++i) {
            double prev = subDataList.get(i - 1).getValue();
            double current = subDataList.get(i).getValue();
            double next = subDataList.get(i + 1).getValue();
            RouteColorizationPoint currentData = subDataList.get(i);
            if (!(current > prev && current > next || current < prev && current < next || current < prev && current == next || current == prev && current < next || current > prev && current == next) && (!(current == prev) || !(current > next))) continue;
            RouteColorizationPoint prevInResult = null;
            if (result.size() > 0) {
                prevInResult = (RouteColorizationPoint)result.get(0);
                if (!(prevInResult.getValue() / diff > 0.05)) continue;
                result.add(currentData);
                continue;
            }
            result.add(currentData);
        }
        result.add(subDataList.get(subDataList.size() - 1));
        return result;
    }

    private final double[] findDerivativeArguments(double[] distances, double[] elevations, int index, double slopeRange) {
        double coef;
        int i;
        double[] result = new double[4];
        double minDist = distances[index] - slopeRange / (double)2;
        double maxDist = distances[index] + slopeRange / (double)2;
        result[0] = Double.NaN;
        result[1] = Double.NaN;
        result[2] = minDist;
        result[3] = maxDist;
        int closestMaxIndex = -1;
        int closestMinIndex = -1;
        int n = distances.length;
        for (i = index; i < n; ++i) {
            if (distances[i] == maxDist) {
                result[1] = elevations[i];
                break;
            }
            if (!(distances[i] > maxDist)) continue;
            closestMaxIndex = i;
            break;
        }
        for (i = index; -1 < i; --i) {
            if (distances[i] == minDist) {
                result[0] = elevations[i];
                break;
            }
            if (!(distances[i] < minDist)) continue;
            closestMinIndex = i;
            break;
        }
        if (closestMaxIndex > 0) {
            double diff = distances[closestMaxIndex] - distances[closestMaxIndex - 1];
            coef = (maxDist - distances[closestMaxIndex - 1]) / diff;
            if (coef > 1.0 || coef < 0.0) {
                LOG.warn("Coefficient fo max must be 0..1 , coef=" + coef);
            }
            result[1] = (1.0 - coef) * elevations[closestMaxIndex - 1] + coef * elevations[closestMaxIndex];
        }
        if (closestMinIndex >= 0) {
            double diff = distances[closestMinIndex + 1] - distances[closestMinIndex];
            coef = (minDist - distances[closestMinIndex]) / diff;
            if (coef > 1.0 || coef < 0.0) {
                LOG.warn("Coefficient for min must be 0..1 , coef=" + coef);
            }
            result[0] = (1.0 - coef) * elevations[closestMinIndex] + coef * elevations[closestMinIndex + 1];
        }
        if (Double.isNaN(result[0]) || Double.isNaN(result[1])) {
            LOG.warn("Elevations wasn't calculated");
        }
        return result;
    }

    private final void calculateMinMaxValue() {
        double[] dArray = this.values;
        if (this.values == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"values");
            dArray = null;
        }
        if (dArray.length == 0) {
            return;
        }
        this.minValue = this.maxValue = Double.NaN;
        double[] dArray2 = this.values;
        if (this.values == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"values");
            dArray2 = null;
        }
        for (double value : dArray2) {
            if ((Double.isNaN(this.maxValue) || Double.isNaN(this.minValue)) && !Double.isNaN(value)) {
                this.maxValue = this.minValue = value;
            }
            if (this.minValue > value) {
                this.minValue = value;
            }
            if (!(this.maxValue < value)) continue;
            this.maxValue = value;
        }
    }

    private final void calculateMinMaxValue(GpxTrackAnalysis analysis, float maxProfileSpeed) {
        this.calculateMinMaxValue();
        this.maxValue = Companion.getMaxValue(this.colorizationType, analysis, this.minValue, maxProfileSpeed);
    }

    private final double[] listToArray(List<Double> doubleList) {
        double[] result = new double[doubleList.size()];
        int n = ((Collection)doubleList).size();
        for (int i = 0; i < n; ++i) {
            result[i] = ((Number)doubleList.get(i)).doubleValue();
        }
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/osmand/shared/routing/RouteColorize$ColorizationType;", "", "<init>", "(Ljava/lang/String;I)V", "ELEVATION", "SPEED", "SLOPE", "NONE", "OsmAnd-shared"})
    public static final class ColorizationType
    extends Enum<ColorizationType> {
        public static final /* enum */ ColorizationType ELEVATION = new ColorizationType();
        public static final /* enum */ ColorizationType SPEED = new ColorizationType();
        public static final /* enum */ ColorizationType SLOPE = new ColorizationType();
        public static final /* enum */ ColorizationType NONE = new ColorizationType();
        private static final /* synthetic */ ColorizationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ColorizationType[] values() {
            return (ColorizationType[])$VALUES.clone();
        }

        public static ColorizationType valueOf(String value) {
            return Enum.valueOf(ColorizationType.class, value);
        }

        @NotNull
        public static EnumEntries<ColorizationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = colorizationTypeArray = new ColorizationType[]{ColorizationType.ELEVATION, ColorizationType.SPEED, ColorizationType.SLOPE, ColorizationType.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J(\u0010\u0019\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/osmand/shared/routing/RouteColorize$Companion;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "MAX_CORRECT_ELEVATION_DISTANCE", "", "getMAX_CORRECT_ELEVATION_DISTANCE", "()D", "setMAX_CORRECT_ELEVATION_DISTANCE", "(D)V", "SLOPE_RANGE", "", "getSLOPE_RANGE", "()I", "setSLOPE_RANGE", "(I)V", "DEFAULT_BASE", "MIN_DIFFERENCE_SLOPE", "getMinValue", "type", "Lnet/osmand/shared/routing/RouteColorize$ColorizationType;", "analysis", "Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "getMaxValue", "minValue", "maxProfileSpeed", "getDefaultPalette", "Lnet/osmand/shared/ColorPalette;", "colorizationType", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final double getMAX_CORRECT_ELEVATION_DISTANCE() {
            return MAX_CORRECT_ELEVATION_DISTANCE;
        }

        public final void setMAX_CORRECT_ELEVATION_DISTANCE(double d) {
            MAX_CORRECT_ELEVATION_DISTANCE = d;
        }

        public final int getSLOPE_RANGE() {
            return SLOPE_RANGE;
        }

        public final void setSLOPE_RANGE(int n) {
            SLOPE_RANGE = n;
        }

        public final double getMinValue(@Nullable ColorizationType type, @NotNull GpxTrackAnalysis analysis) {
            Intrinsics.checkNotNullParameter((Object)analysis, (String)"analysis");
            ColorizationType colorizationType = type;
            return switch (colorizationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[colorizationType.ordinal()]) {
                case 1 -> 0.0;
                case 2 -> analysis.getMinElevation();
                case 3 -> -1.0;
                default -> -1.0;
            };
        }

        public final double getMaxValue(@Nullable ColorizationType type, @NotNull GpxTrackAnalysis analysis, double minValue, double maxProfileSpeed) {
            Intrinsics.checkNotNullParameter((Object)analysis, (String)"analysis");
            ColorizationType colorizationType = type;
            return switch (colorizationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[colorizationType.ordinal()]) {
                case 1 -> Math.max((double)analysis.getMaxSpeed(), maxProfileSpeed);
                case 2 -> Math.max(analysis.getMaxElevation(), minValue + (double)50);
                case 3 -> 1.0;
                default -> -1.0;
            };
        }

        @NotNull
        public final ColorPalette getDefaultPalette(@NotNull ColorizationType colorizationType) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorizationType), (String)"colorizationType");
            return colorizationType == ColorizationType.SLOPE ? ColorPalette.Companion.getSLOPE_PALETTE() : ColorPalette.Companion.getMIN_MAX_PALETTE();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColorizationType.values().length];
                try {
                    nArray[ColorizationType.SPEED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorizationType.ELEVATION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColorizationType.SLOPE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lnet/osmand/shared/routing/RouteColorize$Node;", "", "lat", "", "lon", "id", "", "<init>", "(DDI)V", "getLat", "()D", "getLon", "getId", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "OsmAnd-shared"})
    private static final class Node {
        private final double lat;
        private final double lon;
        private final int id;

        public Node(double lat, double lon, int id) {
            this.lat = lat;
            this.lon = lon;
            this.id = id;
        }

        public final double getLat() {
            return this.lat;
        }

        public final double getLon() {
            return this.lon;
        }

        public final int getId() {
            return this.id;
        }

        public final double component1() {
            return this.lat;
        }

        public final double component2() {
            return this.lon;
        }

        public final int component3() {
            return this.id;
        }

        @NotNull
        public final Node copy(double lat, double lon, int id) {
            return new Node(lat, lon, id);
        }

        public static /* synthetic */ Node copy$default(Node node, double d, double d2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d = node.lat;
            }
            if ((n2 & 2) != 0) {
                d2 = node.lon;
            }
            if ((n2 & 4) != 0) {
                n = node.id;
            }
            return node.copy(d, d2, n);
        }

        @NotNull
        public String toString() {
            return "Node(lat=" + this.lat + ", lon=" + this.lon + ", id=" + this.id + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.lat);
            result = result * 31 + Double.hashCode(this.lon);
            result = result * 31 + Integer.hashCode(this.id);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (Double.compare(this.lat, node.lat) != 0) {
                return false;
            }
            if (Double.compare(this.lon, node.lon) != 0) {
                return false;
            }
            return this.id == node.id;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\r\u00a8\u0006\u001c"}, d2={"Lnet/osmand/shared/routing/RouteColorize$RouteColorizationPoint;", "", "id", "", "lat", "", "lon", "value", "<init>", "(IDDD)V", "getId", "()I", "setId", "(I)V", "getLat", "()D", "setLat", "(D)V", "getLon", "setLon", "getValue", "setValue", "primaryColor", "getPrimaryColor", "setPrimaryColor", "secondaryColor", "getSecondaryColor", "setSecondaryColor", "OsmAnd-shared"})
    public static final class RouteColorizationPoint {
        private int id;
        private double lat;
        private double lon;
        private double value;
        private int primaryColor;
        private int secondaryColor;

        public RouteColorizationPoint(int id, double lat, double lon, double value) {
            this.id = id;
            this.lat = lat;
            this.lon = lon;
            this.value = value;
        }

        public final int getId() {
            return this.id;
        }

        public final void setId(int n) {
            this.id = n;
        }

        public final double getLat() {
            return this.lat;
        }

        public final void setLat(double d) {
            this.lat = d;
        }

        public final double getLon() {
            return this.lon;
        }

        public final void setLon(double d) {
            this.lon = d;
        }

        public final double getValue() {
            return this.value;
        }

        public final void setValue(double d) {
            this.value = d;
        }

        public final int getPrimaryColor() {
            return this.primaryColor;
        }

        public final void setPrimaryColor(int n) {
            this.primaryColor = n;
        }

        public final int getSecondaryColor() {
            return this.secondaryColor;
        }

        public final void setSecondaryColor(int n) {
            this.secondaryColor = n;
        }
    }
}

