/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.palette.data.gradient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import net.osmand.shared.api.SettingsAPI;
import net.osmand.shared.palette.data.gradient.GradientSettingsItem;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/osmand/shared/palette/data/gradient/GradientSettingsHelper;", "", "settingsAPI", "Lnet/osmand/shared/api/SettingsAPI;", "<init>", "(Lnet/osmand/shared/api/SettingsAPI;)V", "json", "Lkotlinx/serialization/json/Json;", "getItems", "", "Lnet/osmand/shared/palette/data/gradient/GradientSettingsItem;", "categoryKey", "", "saveItems", "", "items", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGradientSettingsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradientSettingsHelper.kt\nnet/osmand/shared/palette/data/gradient/GradientSettingsHelper\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,94:1\n222#2:95\n211#2:96\n113#3:97\n*S KotlinDebug\n*F\n+ 1 GradientSettingsHelper.kt\nnet/osmand/shared/palette/data/gradient/GradientSettingsHelper\n*L\n56#1:95\n85#1:96\n88#1:97\n*E\n"})
public final class GradientSettingsHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsAPI settingsAPI;
    @NotNull
    private final Json json;
    @NotNull
    private static final String GRADIENT_COLOR_PALETTES_PREF = "gradient_color_palettes";
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("GradientSettingsHelper");

    public GradientSettingsHelper(@NotNull SettingsAPI settingsAPI) {
        Intrinsics.checkNotNullParameter((Object)settingsAPI, (String)"settingsAPI");
        this.settingsAPI = settingsAPI;
        this.json = JsonKt.Json$default(null, GradientSettingsHelper::json$lambda$0, (int)1, null);
        this.settingsAPI.registerPreference(GRADIENT_COLOR_PALETTES_PREF, "", true, true);
    }

    public /* synthetic */ GradientSettingsHelper(SettingsAPI settingsAPI, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            settingsAPI = PlatformUtil.INSTANCE.getOsmAndContext().getSettings();
        }
        this(settingsAPI);
    }

    @NotNull
    public final List<GradientSettingsItem> getItems(@NotNull String categoryKey) {
        Intrinsics.checkNotNullParameter((Object)categoryKey, (String)"categoryKey");
        String jsonString = this.settingsAPI.getStringPreference(GRADIENT_COLOR_PALETTES_PREF);
        CharSequence charSequence = jsonString;
        if (charSequence == null || charSequence.length() == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<GradientSettingsItem> result = new ArrayList<GradientSettingsItem>();
        try {
            JsonElement rootElement = this.json.parseToJsonElement(jsonString);
            JsonObject rootObject = JsonElementKt.getJsonObject((JsonElement)rootElement);
            JsonElement jsonElement = (JsonElement)rootObject.get((Object)categoryKey);
            if (jsonElement == null || (jsonElement = JsonElementKt.getJsonArray((JsonElement)jsonElement)) == null) {
                return CollectionsKt.emptyList();
            }
            JsonElement categoryArray = jsonElement;
            for (JsonElement element : categoryArray) {
                try {
                    Json $this$decodeFromJsonElement$iv = this.json;
                    boolean $i$f$decodeFromJsonElement = false;
                    $this$decodeFromJsonElement$iv.getSerializersModule();
                    GradientSettingsItem item = (GradientSettingsItem)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)GradientSettingsItem.Companion.serializer(), element);
                    result.add(item);
                }
                catch (Exception e) {
                    LOG.debug("Error while reading a single gradient color info from JSON " + e);
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Error parsing global gradient settings JSON " + e);
        }
        return result;
    }

    public final void saveItems(@NotNull String categoryKey, @NotNull List<GradientSettingsItem> items) {
        Intrinsics.checkNotNullParameter((Object)categoryKey, (String)"categoryKey");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        String currentJsonString = this.settingsAPI.getStringPreference(GRADIENT_COLOR_PALETTES_PREF);
        HashMap rootMap = new HashMap();
        CharSequence charSequence = currentJsonString;
        if (!(charSequence == null || charSequence.length() == 0)) {
            try {
                JsonObject rootElement = JsonElementKt.getJsonObject((JsonElement)this.json.parseToJsonElement(currentJsonString));
                rootMap.putAll((Map)rootElement);
            }
            catch (Exception e) {
                LOG.debug("Error parsing global settings JSON " + e);
            }
        }
        try {
            Json $this$encodeToJsonElement$iv = this.json;
            boolean $i$f$encodeToJsonElement = false;
            $this$encodeToJsonElement$iv.getSerializersModule();
            JsonElement newCategoryElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)new ArrayListSerializer(GradientSettingsItem.Companion.serializer()), items);
            ((Map)rootMap).put(categoryKey, newCategoryElement);
            StringFormat $this$encodeToString$iv = (StringFormat)this.json;
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            String newJsonString = $this$encodeToString$iv.encodeToString((SerializationStrategy)new HashMapSerializer((KSerializer)StringSerializer.INSTANCE, JsonElement.Companion.serializer()), rootMap);
            this.settingsAPI.setStringPreference(GRADIENT_COLOR_PALETTES_PREF, newJsonString);
        }
        catch (Exception e) {
            LOG.debug("Error saving gradient settings " + e);
        }
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setLenient(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(true);
        return Unit.INSTANCE;
    }

    public GradientSettingsHelper() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/osmand/shared/palette/data/gradient/GradientSettingsHelper$Companion;", "", "<init>", "()V", "GRADIENT_COLOR_PALETTES_PREF", "", "LOG", "Lnet/osmand/shared/util/Logger;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

