/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.palette.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import net.osmand.shared.ColorPalette;
import net.osmand.shared.palette.domain.GradientPoint;
import net.osmand.shared.palette.domain.GradientProperties;
import net.osmand.shared.palette.domain.Palette;
import net.osmand.shared.palette.domain.PaletteItem;
import net.osmand.shared.palette.domain.PaletteItemSource;
import net.osmand.shared.palette.domain.filetype.GradientFileType;
import net.osmand.shared.palette.domain.filetype.PaletteFileType;
import net.osmand.shared.palette.domain.filetype.PaletteFileTypeRegistry;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.NamingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0014\u0010\u0016\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0005J3\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\b\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0005J\"\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001d\u001a\u00020*2\u0006\u0010'\u001a\u00020\u00052\b\b\u0002\u0010+\u001a\u00020\u0011J\u001e\u0010,\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020*2\u0006\u0010-\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lnet/osmand/shared/palette/data/PaletteUtils;", "", "<init>", "()V", "TXT_EXT", "", "CUSTOM_NAME", "buildFileName", "paletteName", "fileType", "Lnet/osmand/shared/palette/domain/filetype/PaletteFileType;", "buildDisplayName", "getPaletteNameFromDisplayName", "displayName", "extractPaletteName", "fileName", "isDefaultPalette", "", "generateUniquePaletteName", "existingIds", "", "baseId", "generateSolidUniqueId", "isPaletteFileExt", "renameGradientPalette", "Lnet/osmand/shared/palette/domain/PaletteItem$Gradient;", "item", "newName", "createGradientColor", "palette", "Lnet/osmand/shared/palette/domain/Palette$GradientCollection;", "Lnet/osmand/shared/palette/domain/filetype/GradientFileType;", "points", "", "Lnet/osmand/shared/palette/domain/GradientPoint;", "noDataColor", "", "(Lnet/osmand/shared/palette/domain/Palette$GradientCollection;Lnet/osmand/shared/palette/domain/filetype/GradientFileType;Ljava/util/List;Ljava/lang/Integer;)Lnet/osmand/shared/palette/domain/PaletteItem$Gradient;", "createGradientDuplicate", "originalItemId", "createSolidDuplicate", "Lnet/osmand/shared/palette/domain/PaletteItem$Solid;", "Lnet/osmand/shared/palette/domain/Palette$SolidCollection;", "markAsUsed", "createSolidColor", "colorInt", "updateSolidColor", "originalItem", "newColorInt", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nPaletteUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaletteUtils.kt\nnet/osmand/shared/palette/data/PaletteUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1557#2:181\n1628#2,3:182\n360#2,7:185\n1557#2:192\n1628#2,3:193\n360#2,7:196\n1557#2:203\n1628#2,3:204\n1557#2:207\n1628#2,3:208\n1#3:211\n*S KotlinDebug\n*F\n+ 1 PaletteUtils.kt\nnet/osmand/shared/palette/data/PaletteUtils\n*L\n79#1:181\n79#1:182,3\n105#1:185,7\n113#1:192\n113#1:193,3\n133#1:196,7\n138#1:203\n138#1:204,3\n155#1:207\n155#1:208,3\n*E\n"})
public final class PaletteUtils {
    @NotNull
    public static final PaletteUtils INSTANCE = new PaletteUtils();
    @NotNull
    private static final String TXT_EXT = ".txt";
    @NotNull
    private static final String CUSTOM_NAME = "custom";

    private PaletteUtils() {
    }

    @NotNull
    public final String buildFileName(@NotNull String paletteName, @NotNull PaletteFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)paletteName, (String)"paletteName");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return fileType.getFilePrefix() + paletteName + TXT_EXT;
    }

    @NotNull
    public final String buildDisplayName(@NotNull String paletteName) {
        Intrinsics.checkNotNullParameter((Object)paletteName, (String)"paletteName");
        String string = KAlgorithms.INSTANCE.capitalizeFirstLetter(StringsKt.replace$default((String)paletteName, (String)"_", (String)" ", (boolean)false, (int)4, null));
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String getPaletteNameFromDisplayName(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return StringsKt.replace$default((String)displayName, (String)" ", (String)"_", (boolean)false, (int)4, null);
    }

    @Nullable
    public final String extractPaletteName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        PaletteFileType paletteFileType = PaletteFileTypeRegistry.INSTANCE.fromFileName(fileName);
        if (paletteFileType == null) {
            return null;
        }
        PaletteFileType fileType = paletteFileType;
        return StringsKt.replace$default((String)StringsKt.replace$default((String)fileName, (String)fileType.getFilePrefix(), (String)"", (boolean)false, (int)4, null), (String)TXT_EXT, (String)"", (boolean)false, (int)4, null);
    }

    public final boolean isDefaultPalette(@NotNull String paletteName) {
        Intrinsics.checkNotNullParameter((Object)paletteName, (String)"paletteName");
        Object[] objectArray = new String[]{"altitude_default", "default"};
        return SetsKt.setOf((Object[])objectArray).contains(paletteName);
    }

    private final String generateUniquePaletteName(Set<String> existingIds, String baseId) {
        return NamingUtils.INSTANCE.generateUniqueName(existingIds, baseId, "_");
    }

    @NotNull
    public final String generateSolidUniqueId(@NotNull Set<String> existingIds) {
        Intrinsics.checkNotNullParameter(existingIds, (String)"existingIds");
        int newId = 0;
        while (existingIds.contains(String.valueOf(newId = Random.Default.nextInt(100000, Integer.MAX_VALUE)))) {
        }
        return String.valueOf(newId);
    }

    public final boolean isPaletteFileExt(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return StringsKt.endsWith$default((String)fileName, (String)TXT_EXT, (boolean)false, (int)2, null);
    }

    @NotNull
    public final PaletteItem.Gradient renameGradientPalette(@NotNull PaletteItem.Gradient item, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        GradientFileType fileType = item.getProperties().getFileType();
        String paletteName = this.getPaletteNameFromDisplayName(newName);
        return PaletteItem.Gradient.copy$default(item, paletteName, newName, PaletteItemSource.GradientFile.copy$default(item.getSource(), null, this.buildFileName(paletteName, fileType), 1, null), false, false, 0, 0L, null, null, null, 1016, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PaletteItem.Gradient createGradientColor(@NotNull Palette.GradientCollection palette, @NotNull GradientFileType fileType, @NotNull List<GradientPoint> points, @Nullable Integer noDataColor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Iterable $this$map$iv = palette.getItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PaletteItem.Gradient gradient = (PaletteItem.Gradient)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set existingIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        String paletteName = this.generateUniquePaletteName(existingIds, CUSTOM_NAME);
        String displayName = this.buildDisplayName(paletteName);
        String newFileName = this.buildFileName(paletteName, fileType);
        return new PaletteItem.Gradient(paletteName, displayName, new PaletteItemSource.GradientFile(palette.getId(), newFileName), false, true, 0, 0L, points, noDataColor, new GradientProperties(fileType, fileType.getRangeType(), null, null, null, 28, null));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PaletteItem.Gradient createGradientDuplicate(@NotNull Palette.GradientCollection palette, @NotNull String originalItemId) {
        void $this$mapTo$iv$iv;
        int index;
        Object it;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter((Object)originalItemId, (String)"originalItemId");
            List<PaletteItem.Gradient> $this$indexOfFirst$iv = palette.getItems();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (PaletteItem.Gradient item$iv : $this$indexOfFirst$iv) {
                it = item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)((PaletteItem.Gradient)it).getId(), (Object)originalItemId)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            return null;
        }
        PaletteItem.Gradient originalItem = palette.getItems().get(index);
        GradientFileType fileType = originalItem.getProperties().getFileType();
        Iterable $this$map$iv = palette.getItems();
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            PaletteItem.Gradient gradient = (PaletteItem.Gradient)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        Set existingIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        String paletteName = this.generateUniquePaletteName(existingIds, originalItem.getId());
        String newFileName = this.buildFileName(paletteName, fileType);
        String displayName = this.buildDisplayName(paletteName);
        return PaletteItem.Gradient.copy$default(originalItem, paletteName, displayName, new PaletteItemSource.GradientFile(palette.getId(), newFileName), false, true, 0, 0L, null, null, null, 992, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PaletteItem.Solid createSolidDuplicate(@NotNull Palette.SolidCollection palette, @NotNull String originalItemId, boolean markAsUsed) {
        int index;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter((Object)originalItemId, (String)"originalItemId");
            List<PaletteItem.Solid> $this$indexOfFirst$iv = palette.getItems();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PaletteItem.Solid> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PaletteItem.Solid solid;
                PaletteItem.Solid it = solid = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)originalItemId)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            return null;
        }
        PaletteItem.Solid originalItem = palette.getItems().get(index);
        Iterable $this$map$iv = palette.getItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            PaletteItem.Solid solid = (PaletteItem.Solid)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set existingIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        String newId = this.generateSolidUniqueId(existingIds);
        long lastUsedTime = markAsUsed ? Clock.System.INSTANCE.now().toEpochMilliseconds() : originalItem.getLastUsedTime();
        return PaletteItem.Solid.copy$default(originalItem, newId, null, new PaletteItemSource.CollectionRecord(palette.getId()), false, 0, lastUsedTime, 0, 90, null);
    }

    public static /* synthetic */ PaletteItem.Solid createSolidDuplicate$default(PaletteUtils paletteUtils, Palette.SolidCollection solidCollection, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return paletteUtils.createSolidDuplicate(solidCollection, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PaletteItem.Solid createSolidColor(@NotNull Palette.SolidCollection palette, int colorInt, boolean markAsUsed) {
        Object object;
        PaletteItem.Solid it;
        Object object2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Iterable $this$map$iv = palette.getItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object2 = (PaletteItem.Solid)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set existingIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        String newId = this.generateSolidUniqueId(existingIds);
        long lastUsedTime = markAsUsed ? Clock.System.INSTANCE.now().toEpochMilliseconds() : 0L;
        Iterator iterator = ((Iterable)palette.getItems()).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            it = (PaletteItem.Solid)iterator.next();
            boolean bl = false;
            object2 = it.getHistoryIndex();
            while (iterator.hasNext()) {
                PaletteItem.Solid it2 = (PaletteItem.Solid)iterator.next();
                $i$a$-maxOfOrNull-PaletteUtils$createSolidColor$maxHistoryIndex$1 = false;
                Comparable comparable = Integer.valueOf(it2.getHistoryIndex());
                if (object2.compareTo(comparable) >= 0) continue;
                object2 = comparable;
            }
            object = object2;
        }
        Integer n = (Integer)object;
        int maxHistoryIndex = n != null ? n : 0;
        String string = ColorPalette.Companion.colorToHex(colorInt);
        PaletteItemSource.CollectionRecord collectionRecord = new PaletteItemSource.CollectionRecord(palette.getId());
        int n2 = maxHistoryIndex + 1;
        return new PaletteItem.Solid(newId, string, collectionRecord, false, n2, lastUsedTime, colorInt, 8, null);
    }

    @NotNull
    public final PaletteItem.Solid updateSolidColor(@NotNull PaletteItem.Solid originalItem, int newColorInt) {
        Intrinsics.checkNotNullParameter((Object)originalItem, (String)"originalItem");
        String string = ColorPalette.Companion.colorToHex(newColorInt);
        return PaletteItem.Solid.copy$default(originalItem, null, string, null, false, 0, 0L, newColorInt, 61, null);
    }
}

