/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import co.touchlab.stately.collections.ConcurrentMutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import net.osmand.shared.api.SQLiteAPI;
import net.osmand.shared.data.StringIntPair;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxDatabase;
import net.osmand.shared.gpx.GpxDbHelper;
import net.osmand.shared.gpx.GpxDbUtils;
import net.osmand.shared.gpx.GpxDirItem;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.GpxReader;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002tuB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020$H\u0082@\u00a2\u0006\u0002\u0010&J2\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\"0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130+2\b\b\u0002\u0010,\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020$H\u0002J\u0006\u0010/\u001a\u00020\"J\u0006\u00100\u001a\u00020\u001cJ\u0010\u00101\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020\u0010H\u0002J\u001c\u00106\u001a\u00020$2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130)H\u0002J\u0016\u00108\u001a\u00020$2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00100:H\u0002J\u0016\u0010;\u001a\u00020\"2\u0006\u0010<\u001a\u00020\u00102\u0006\u0010=\u001a\u00020\u0010J\u000e\u0010>\u001a\u00020\"2\u0006\u00102\u001a\u000203J\u0016\u0010?\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u0010@\u001a\u00020AJ \u0010B\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010 J\u000e\u0010F\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0010J\u0014\u0010F\u001a\u00020\"2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00100HJ\u000e\u0010F\u001a\u00020\"2\u0006\u00102\u001a\u000203J\u000e\u0010I\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0013J\u000e\u0010I\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0011J\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00130+J\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00110+J\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00130+H\u0082@\u00a2\u0006\u0002\u0010&J\u000e\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110+H\u0002J,\u0010N\u001a\b\u0012\u0004\u0012\u00020O0+2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\"2\u0006\u0010S\u001a\u00020\"2\u0006\u0010T\u001a\u00020\"J\u0006\u0010U\u001a\u00020VJ\u000e\u0010W\u001a\u00020Q2\u0006\u0010C\u001a\u00020DJ\u0010\u0010X\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u00020\u0010J\u0018\u0010X\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u00020\u00102\u0006\u0010Y\u001a\u00020\"J\u0010\u0010Z\u001a\u0004\u0018\u00010\u00112\u0006\u00102\u001a\u00020\u0013J\u000e\u0010Z\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u0010J\u001a\u0010X\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u00020\u00102\b\u0010[\u001a\u0004\u0018\u00010\u001aJ\"\u0010X\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u00020\u00102\b\u0010[\u001a\u0004\u0018\u00010\u001a2\u0006\u0010Y\u001a\u00020\"J\u000e\u0010\\\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0010J\u000e\u0010]\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0010J\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00130+J\u0014\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00130+H\u0086@\u00a2\u0006\u0002\u0010&J\u0018\u0010`\u001a\u00020$2\u0006\u00102\u001a\u00020\u00132\u0006\u0010a\u001a\u00020\"H\u0002J\u0006\u0010b\u001a\u00020\"J\u000e\u0010b\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0010J$\u0010c\u001a\u00020$2\u0006\u00105\u001a\u00020\u00102\b\u00102\u001a\u0004\u0018\u00010\u00132\b\u0010[\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010d\u001a\u00020$H\u0002J\b\u0010e\u001a\u00020$H\u0002J\u0006\u0010f\u001a\u00020\tJ:\u0010g\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010h2\"\u0010i\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0018\u00010h\u0012\u0004\u0012\u00020$\u0018\u00010jH\u0016J\u0010\u0010k\u001a\u00020$2\u0006\u00102\u001a\u00020\u0013H\u0016J\u0010\u0010l\u001a\u00020$2\u0006\u00102\u001a\u00020\u0013H\u0002J!\u0010m\u001a\u00020$2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130n\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010oJ\b\u0010p\u001a\u00020$H\u0016J\u0018\u0010q\u001a\u00020$2\u0006\u0010r\u001a\u00020\u001e2\u0006\u0010s\u001a\u00020\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lnet/osmand/shared/gpx/GpxDbHelper;", "Lnet/osmand/shared/gpx/GpxReader$GpxReaderAdapter;", "<init>", "()V", "log", "Lnet/osmand/shared/util/Logger;", "getLog", "()Lnet/osmand/shared/util/Logger;", "database", "Lnet/osmand/shared/gpx/GpxDatabase;", "getDatabase", "()Lnet/osmand/shared/gpx/GpxDatabase;", "database$delegate", "Lkotlin/Lazy;", "dirItems", "Lco/touchlab/stately/collections/ConcurrentMutableMap;", "Lnet/osmand/shared/io/KFile;", "Lnet/osmand/shared/gpx/GpxDirItem;", "dataItems", "Lnet/osmand/shared/gpx/GpxDataItem;", "itemsVersion", "Ljava/util/concurrent/atomic/AtomicInteger;", "readingItemsMap", "", "readingItemsCallbacks", "", "Lnet/osmand/shared/gpx/GpxDbHelper$GpxDataItemCallback;", "READER_TASKS_LIMIT", "", "readers", "Lnet/osmand/shared/gpx/GpxReader;", "readerSync", "", "initialized", "", "loadItemsBlocking", "", "loadItems", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadGpxItems", "getFileExistenceMap", "", "items", "", "batchSize", "(Ljava/util/List;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadGpxDirItems", "isInitialized", "getItemsVersion", "putToCache", "item", "Lnet/osmand/shared/gpx/DataItem;", "removeFromCache", "file", "putToCacheBulk", "itemsToCache", "removeFromCacheBulk", "filesToRemove", "", "rename", "currentFile", "newFile", "updateDataItem", "insertDataItem", "conn", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteConnection;", "updateDataItemParameter", "parameter", "Lnet/osmand/shared/gpx/GpxParameter;", "value", "remove", "files", "", "add", "getItems", "getDirItems", "readItems", "readDirItems", "getStringIntItemsCollection", "Lnet/osmand/shared/data/StringIntPair;", "columnName", "", "includeEmptyValues", "sortByName", "sortDescending", "getTracksMinCreateDate", "", "getMaxParameterValue", "getItem", "readIfNeeded", "getGpxDirItem", "callback", "hasGpxDataItem", "hasGpxDirItem", "getSplitItemsBlocking", "getSplitItems", "updateDefaultAppearance", "updateExistingValues", "isReading", "readGpxItem", "startReading", "stopReading", "getGPXDatabase", "pullNextFileItem", "Lkotlin/Pair;", "action", "Lkotlin/Function1;", "onGpxDataItemRead", "putGpxDataItemToSmartFolder", "onProgressUpdate", "", "([Lnet/osmand/shared/gpx/GpxDataItem;)V", "onReadingCancelled", "onReadingFinished", "reader", "cancelled", "GpxDataItemCallback", "GpxDataItemCallbackEx", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGpxDbHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpxDbHelper.kt\nnet/osmand/shared/gpx/GpxDbHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 GpxDataItem.kt\nnet/osmand/shared/gpx/GpxDataItem\n+ 5 Synchronizable.kt\nco/touchlab/stately/concurrency/SynchronizableKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,393:1\n1863#2,2:394\n1863#2,2:396\n774#2:399\n865#2:400\n866#2:424\n1755#2,3:434\n1863#2,2:444\n1863#2,2:447\n1#3:398\n171#4:401\n187#4,3:402\n203#4:405\n191#4,13:406\n172#4,4:419\n203#4:423\n5#5:425\n5#5:426\n5#5:427\n5#5:428\n5#5:429\n5#5:430\n5#5:431\n5#5:432\n5#5:433\n381#6,7:437\n13346#7:446\n13347#7:449\n*S KotlinDebug\n*F\n+ 1 GpxDbHelper.kt\nnet/osmand/shared/gpx/GpxDbHelper\n*L\n65#1:394,2\n93#1:396,2\n290#1:399\n290#1:400\n290#1:424\n314#1:434,3\n338#1:444,2\n365#1:447,2\n291#1:401\n291#1:402,3\n291#1:405\n291#1:406,13\n291#1:419,4\n291#1:423\n311#1:425\n314#1:426\n317#1:427\n331#1:428\n337#1:429\n346#1:430\n362#1:431\n379#1:432\n386#1:433\n319#1:437,7\n363#1:446\n363#1:449\n*E\n"})
public final class GpxDbHelper
implements GpxReader.GpxReaderAdapter {
    @NotNull
    public static final GpxDbHelper INSTANCE = new GpxDbHelper();
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("GpxDbHelper");
    @NotNull
    private static final Lazy database$delegate = LazyKt.lazy(GpxDbHelper::database_delegate$lambda$0);
    @NotNull
    private static final ConcurrentMutableMap<KFile, GpxDirItem> dirItems = new ConcurrentMutableMap();
    @NotNull
    private static final ConcurrentMutableMap<KFile, GpxDataItem> dataItems = new ConcurrentMutableMap();
    @NotNull
    private static AtomicInteger itemsVersion = new AtomicInteger(0);
    @NotNull
    private static final Map<KFile, GpxDataItem> readingItemsMap = new LinkedHashMap();
    @NotNull
    private static final Map<KFile, List<GpxDataItemCallback>> readingItemsCallbacks = new LinkedHashMap();
    private static final int READER_TASKS_LIMIT = 4;
    @NotNull
    private static List<GpxReader> readers = new ArrayList();
    @NotNull
    private static Object readerSync = new Object();
    private static boolean initialized;

    private GpxDbHelper() {
    }

    @NotNull
    public final Logger getLog() {
        return log;
    }

    private final GpxDatabase getDatabase() {
        Lazy lazy = database$delegate;
        return (GpxDatabase)lazy.getValue();
    }

    public final void loadItemsBlocking() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = GpxDbHelper.INSTANCE.loadItems((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object loadItems(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof loadItems.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GpxDbHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadItems((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.loadGpxItems((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (GpxDbHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this.loadGpxDirItems();
                GpxDbHelper.initialized = true;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadGpxItems(Continuation<? super Unit> $completion) {
        if (!($completion instanceof loadGpxItems.1)) ** GOTO lbl-1000
        var18_2 = $completion;
        if ((var18_2.label & -2147483648) != 0) {
            var18_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ GpxDbHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GpxDbHelper.access$loadGpxItems(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                start = ClockExtensionsKt.currentTimeMillis();
                $continuation.L$0 = this;
                $continuation.J$0 = start;
                $continuation.label = 1;
                v0 = this.readItems((Continuation<? super List<GpxDataItem>>)$continuation);
                if (v0 == var19_4) {
                    return var19_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                start = $continuation.J$0;
                this = (GpxDbHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                items = (List)v0;
                startEx = ClockExtensionsKt.currentTimeMillis();
                $continuation.L$0 = this;
                $continuation.L$1 = items;
                $continuation.J$0 = start;
                $continuation.J$1 = startEx;
                $continuation.label = 2;
                v1 = GpxDbHelper.getFileExistenceMap$default(this, items, 0, (Continuation)$continuation, 2, null);
                if (v1 == var19_4) {
                    return var19_4;
                }
                ** GOTO lbl43
            }
            case 2: {
                startEx = $continuation.J$1;
                start = $continuation.J$0;
                items = (List)$continuation.L$1;
                this = (GpxDbHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                fileExistenceMap = (Map)v1;
                GpxDbHelper.log.info("Time to getFileExistenceMap " + (ClockExtensionsKt.currentTimeMillis() - startEx) + " ms, " + items.size() + " items");
                itemsToCache = new LinkedHashMap<K, V>();
                itemsToRemove = new LinkedHashSet<E>();
                $this$forEach$iv = items;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    item = (GpxDataItem)element$iv;
                    $i$a$-forEach-GpxDbHelper$loadGpxItems$2 = false;
                    file = item.getFile();
                    if (Intrinsics.areEqual(fileExistenceMap.get(file), (Object)Boxing.boxBoolean((boolean)true))) {
                        itemsToCache.put(file, item);
                        continue;
                    }
                    Boxing.boxBoolean((boolean)itemsToRemove.add(file));
                }
                this.putToCacheBulk(itemsToCache);
                this.removeFromCacheBulk(itemsToRemove);
                this.getDatabase().remove(itemsToRemove);
                GpxDbHelper.log.info("Time to loadGpxItems " + (ClockExtensionsKt.currentTimeMillis() - start) + " ms, " + items.size() + " items");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object getFileExistenceMap(List<GpxDataItem> items, int batchSize, Continuation<? super Map<KFile, Boolean>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<KFile, Boolean>>, Object>(items, batchSize, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<GpxDataItem> $items;
            final /* synthetic */ int $batchSize;
            {
                this.$items = $items;
                this.$batchSize = $batchSize;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        gpxPath = PlatformUtil.INSTANCE.getOsmAndContext().getGpxDir().path();
                        $this$map$iv = CollectionsKt.chunked((Iterable)this.$items, (int)this.$batchSize);
                        $i$f$map = false;
                        var6_8 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Map item$iv$iv : $this$mapTo$iv$iv) {
                            var11_15 = (List)item$iv$iv /* !! */ ;
                            var16_17 = destination$iv$iv;
                            $i$a$-map-GpxDbHelper$getFileExistenceMap$2$1 = false;
                            var16_17.add(BuildersKt.async$default((CoroutineScope)$this$coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<KFile, ? extends Boolean>>, Object>((List<GpxDataItem>)batch, gpxPath, null){
                                int label;
                                final /* synthetic */ List<GpxDataItem> $batch;
                                final /* synthetic */ String $gpxPath;
                                {
                                    this.$batch = $batch;
                                    this.$gpxPath = $gpxPath;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void $this$associateTo$iv$iv;
                                            void $this$associate$iv;
                                            ResultKt.throwOnFailure((Object)object);
                                            Iterable iterable = this.$batch;
                                            String string = this.$gpxPath;
                                            boolean $i$f$associate = false;
                                            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                                            void var6_6 = $this$associate$iv;
                                            Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                                            boolean $i$f$associateTo = false;
                                            for (T element$iv$iv : $this$associateTo$iv$iv) {
                                                Map map = destination$iv$iv;
                                                GpxDataItem it = (GpxDataItem)element$iv$iv;
                                                boolean bl = false;
                                                Pair pair = TuplesKt.to((Object)it.getFile(), (Object)Boxing.boxBoolean((it.getFile().exists() && StringsKt.startsWith$default((String)it.getFile().path(), (String)string, (boolean)false, (int)2, null) ? 1 : 0) != 0));
                                                map.put(pair.getFirst(), pair.getSecond());
                                            }
                                            return destination$iv$iv;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Map<KFile, Boolean>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null));
                        }
                        this.label = 1;
                        v0 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                        if (v0 == var17_2) {
                            return var17_2;
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 2 sources

                        $this$map$iv = (Iterable)v0;
                        initial$iv = new LinkedHashMap<K, V>();
                        $i$f$fold = false;
                        accumulator$iv = initial$iv;
                        for (T element$iv : $this$fold$iv) {
                            item$iv$iv /* !! */  = (Map)element$iv;
                            acc = accumulator$iv;
                            $i$a$-fold-GpxDbHelper$getFileExistenceMap$2$2 = false;
                            $this$invokeSuspend_u24lambda_u242_u24lambda_u241 = var13_18 = acc;
                            $i$a$-apply-GpxDbHelper$getFileExistenceMap$2$2$1 = false;
                            $this$invokeSuspend_u24lambda_u242_u24lambda_u241.putAll(map);
                            accumulator$iv = var13_18;
                        }
                        return accumulator$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<KFile, Boolean>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    static /* synthetic */ Object getFileExistenceMap$default(GpxDbHelper gpxDbHelper, List list, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        return gpxDbHelper.getFileExistenceMap(list, n, (Continuation<? super Map<KFile, Boolean>>)continuation);
    }

    private final void loadGpxDirItems() {
        long start = ClockExtensionsKt.currentTimeMillis();
        List<GpxDirItem> items = this.readDirItems();
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GpxDirItem item = (GpxDirItem)element$iv;
            boolean bl = false;
            KFile file = item.getFile();
            if (file.exists()) {
                INSTANCE.putToCache(item);
                continue;
            }
            INSTANCE.remove(file);
        }
        log.info("Time to loadGpxDirItems " + (ClockExtensionsKt.currentTimeMillis() - start) + " ms, items count " + dirItems.size());
    }

    public final boolean isInitialized() {
        return initialized;
    }

    public final int getItemsVersion() {
        return itemsVersion.get();
    }

    private final void putToCache(DataItem item) {
        KFile file = item.getFile();
        DataItem dataItem = item;
        if (dataItem instanceof GpxDataItem) {
            ((Map)dataItems).put(file, item);
        } else if (dataItem instanceof GpxDirItem) {
            ((Map)dirItems).put(file, item);
        }
        itemsVersion.incrementAndGet();
    }

    private final void removeFromCache(KFile file) {
        DataItem dataItem = GpxDbUtils.INSTANCE.isGpxFile(file) ? (DataItem)dataItems.remove((Object)file) : (DataItem)dirItems.remove((Object)file);
        itemsVersion.incrementAndGet();
    }

    private final void putToCacheBulk(Map<KFile, GpxDataItem> itemsToCache) {
        dataItems.putAll(itemsToCache);
        itemsVersion.incrementAndGet();
    }

    private final void removeFromCacheBulk(Set<KFile> filesToRemove) {
        dataItems.keySet().removeAll((Collection)filesToRemove);
        itemsVersion.incrementAndGet();
    }

    public final boolean rename(@NotNull KFile currentFile, @NotNull KFile newFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        boolean success = this.getDatabase().rename(currentFile, newFile);
        if (success) {
            GpxDataItem newItem = new GpxDataItem(newFile);
            GpxDataItem oldItem = (GpxDataItem)dataItems.get((Object)currentFile);
            if (oldItem != null) {
                newItem.copyData(oldItem);
            }
            this.putToCache(newItem);
            this.removeFromCache(currentFile);
            this.updateDefaultAppearance(newItem, false);
        }
        return success;
    }

    public final boolean updateDataItem(@NotNull DataItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean res = this.getDatabase().updateDataItem(item);
        this.putToCache(item);
        return res;
    }

    public final void insertDataItem(@NotNull DataItem item, @NotNull SQLiteAPI.SQLiteConnection conn) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        this.getDatabase().insertItem(item, conn);
        this.putToCache(item);
    }

    public final boolean updateDataItemParameter(@NotNull DataItem item, @NotNull GpxParameter parameter, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        item.setParameter(parameter, value);
        boolean res = this.getDatabase().updateDataItemParameter(item, parameter, value);
        if (res && parameter.isAnalysisRecalculationNeeded()) {
            item.setParameter(GpxParameter.DATA_VERSION, 0);
            item.increaseAnalysisParametersVersion();
            this.getDatabase().updateDataItemParameter(item, GpxParameter.DATA_VERSION, 0);
        }
        this.putToCache(item);
        return res;
    }

    public final boolean remove(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean res = this.getDatabase().remove(file);
        this.removeFromCache(file);
        return res;
    }

    public final boolean remove(@NotNull Collection<KFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        boolean res = this.getDatabase().remove(files);
        this.removeFromCacheBulk(CollectionsKt.toSet((Iterable)files));
        return res;
    }

    public final boolean remove(@NotNull DataItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        KFile file = item.getFile();
        boolean res = this.getDatabase().remove(file);
        this.removeFromCache(file);
        return res;
    }

    public final boolean add(@NotNull GpxDataItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean res = this.getDatabase().add(item);
        this.putToCache(item);
        this.updateDefaultAppearance(item, true);
        return res;
    }

    public final boolean add(@NotNull GpxDirItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean res = this.getDatabase().add(item);
        this.putToCache(item);
        return res;
    }

    @NotNull
    public final List<GpxDataItem> getItems() {
        return CollectionsKt.toList((Iterable)dataItems.values());
    }

    @NotNull
    public final List<GpxDirItem> getDirItems() {
        return CollectionsKt.toList((Iterable)dirItems.values());
    }

    private final Object readItems(Continuation<? super List<GpxDataItem>> $completion) {
        return this.getDatabase().getGpxDataItems($completion);
    }

    private final List<GpxDirItem> readDirItems() {
        return this.getDatabase().getGpxDirItems();
    }

    @NotNull
    public final List<StringIntPair> getStringIntItemsCollection(@NotNull String columnName, boolean includeEmptyValues, boolean sortByName, boolean sortDescending) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return this.getDatabase().getStringIntItemsCollection(columnName, includeEmptyValues, sortByName, sortDescending);
    }

    public final long getTracksMinCreateDate() {
        return this.getDatabase().getTracksMinCreateDate();
    }

    @NotNull
    public final String getMaxParameterValue(@NotNull GpxParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        return this.getDatabase().getColumnMaxValue(parameter);
    }

    @Nullable
    public final GpxDataItem getItem(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getItem(file, null);
    }

    @Nullable
    public final GpxDataItem getItem(@NotNull KFile file, boolean readIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getItem(file, null, readIfNeeded);
    }

    @Nullable
    public final GpxDirItem getGpxDirItem(@NotNull GpxDataItem item) {
        GpxDirItem gpxDirItem;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        KFile kFile = item.getFile().getParentFile();
        if (kFile != null) {
            KFile it = kFile;
            boolean bl = false;
            gpxDirItem = INSTANCE.getGpxDirItem(it);
        } else {
            gpxDirItem = null;
        }
        return gpxDirItem;
    }

    @NotNull
    public final GpxDirItem getGpxDirItem(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GpxDirItem item = (GpxDirItem)dirItems.get((Object)file);
        if (item == null && (item = this.getDatabase().getGpxDirItem(file)) != null) {
            this.putToCache(item);
        }
        if (item == null) {
            item = new GpxDirItem(file);
            this.add(item);
        }
        return item;
    }

    @Nullable
    public final GpxDataItem getItem(@NotNull KFile file, @Nullable GpxDataItemCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getItem(file, callback2, true);
    }

    @Nullable
    public final GpxDataItem getItem(@NotNull KFile file, @Nullable GpxDataItemCallback callback2, boolean readIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isPathEmpty()) {
            return null;
        }
        GpxDataItem item = (GpxDataItem)dataItems.get((Object)file);
        if (readIfNeeded && GpxDbUtils.INSTANCE.isAnalyseNeeded(item) && GpxDataItem.Companion.isRegularTrack(file)) {
            this.readGpxItem(file, item, callback2);
        }
        return item;
    }

    public final boolean hasGpxDataItem(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return dataItems.containsKey((Object)file);
    }

    public final boolean hasGpxDirItem(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return dirItems.containsKey((Object)file);
    }

    @NotNull
    public final List<GpxDataItem> getSplitItemsBlocking() {
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends GpxDataItem>>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = GpxDbHelper.INSTANCE.getSplitItems((Continuation<? super List<GpxDataItem>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<GpxDataItem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getSplitItems(@NotNull Continuation<? super List<GpxDataItem>> $completion) {
        if (!($completion instanceof getSplitItems.1)) ** GOTO lbl-1000
        var22_2 = $completion;
        if ((var22_2.label & -2147483648) != 0) {
            var22_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ GpxDbHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getSplitItems((Continuation<? super List<GpxDataItem>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.readItems((Continuation<? super List<GpxDataItem>>)$continuation);
                if (v0 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $this$filter$iv = (Iterable)v0;
                $i$f$filter = false;
                var4_7 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (GpxDataItem)element$iv$iv;
                    $i$a$-filter-GpxDbHelper$getSplitItems$2 = false;
                    var11_14 = it;
                    parameter$iv = GpxParameter.SPLIT_TYPE;
                    $i$f$getAppearanceParameter = false;
                    this_$iv$iv = this_$iv;
                    $i$f$getAppearanceParameter = false;
                    value$iv$iv = this_$iv.getParameter(parameter$iv);
                    if (value$iv$iv != null) {
                        $i$f$castGpxParameter = false;
                        v1 = parameter$iv.getTypeClass().isInstance(value$iv$iv) ? (Object)value$iv$iv : null;
                    } else {
                        dir$iv$iv = this_$iv.getFile().getParentFile();
                        if (dir$iv$iv != null && (value$iv$iv = (dirItem$iv$iv = GpxDbHelper.INSTANCE.getGpxDirItem(dir$iv$iv)).getParameter(parameter$iv)) != null) {
                            $i$f$castGpxParameter = false;
                            v1 = parameter$iv.getTypeClass().isInstance(value$iv$iv) ? value$iv$iv : null;
                        } else {
                            v1 = value$iv = null;
                        }
                    }
                    if (value$iv == null) {
                        value$iv = parameter$iv.getDefaultValue();
                    }
                    $i$f$castGpxParameter = false;
                    if (parameter$iv.getTypeClass().isInstance(value$iv)) {
                        v2 = value$iv;
                        if (!(v2 instanceof Integer)) {
                            v2 = null;
                        }
                        v3 = (Integer)v2;
                    } else {
                        v3 = null;
                    }
                    if (!(v3 == null || v3 != 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateDefaultAppearance(GpxDataItem item, boolean updateExistingValues) {
        KFile file = item.getFile();
        KFile dir = file.getParentFile();
        if (dir != null) {
            GpxDirItem dirItem = this.getGpxDirItem(dir);
            for (GpxParameter parameter : GpxParameter.Companion.getAppearanceParameters()) {
                Object value = item.getParameter(parameter);
                Object defaultValue = dirItem.getParameter(parameter);
                if (defaultValue == null || !updateExistingValues && value != null) continue;
                item.setParameter(parameter, defaultValue);
            }
            this.updateDataItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean isReading() {
        Object object;
        void $this$synchronize$iv;
        Object object2 = readerSync;
        Function0 block$iv = GpxDbHelper::isReading$lambda$5;
        boolean $i$f$synchronize = false;
        void var4_4 = $this$synchronize$iv;
        synchronized (var4_4) {
            object = block$iv.invoke();
        }
        return (Boolean)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean isReading(@NotNull KFile file) {
        Object object;
        void $this$synchronize$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object2 = readerSync;
        Function0 block$iv = () -> GpxDbHelper.isReading$lambda$7(file);
        boolean $i$f$synchronize = false;
        void var5_5 = $this$synchronize$iv;
        synchronized (var5_5) {
            object = block$iv.invoke();
        }
        return (Boolean)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void readGpxItem(KFile file, GpxDataItem item, GpxDataItemCallback callback2) {
        void $this$synchronize$iv;
        Object object = readerSync;
        Function0 block$iv = () -> GpxDbHelper.readGpxItem$lambda$10(callback2, file, item);
        boolean $i$f$synchronize = false;
        void var7_7 = $this$synchronize$iv;
        synchronized (var7_7) {
            Object object2 = block$iv.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void startReading() {
        void $this$synchronize$iv;
        Object object = readerSync;
        Function0 block$iv = GpxDbHelper::startReading$lambda$12;
        boolean $i$f$synchronize = false;
        void var4_4 = $this$synchronize$iv;
        synchronized (var4_4) {
            Object object2 = block$iv.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void stopReading() {
        void $this$synchronize$iv;
        Object object = readerSync;
        Function0 block$iv = GpxDbHelper::stopReading$lambda$14;
        boolean $i$f$synchronize = false;
        void var4_4 = $this$synchronize$iv;
        synchronized (var4_4) {
            Object object2 = block$iv.invoke();
        }
    }

    @NotNull
    public final GpxDatabase getGPXDatabase() {
        return this.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Pair<KFile, GpxDataItem> pullNextFileItem(@Nullable Function1<? super Pair<KFile, GpxDataItem>, Unit> action) {
        Object object;
        void $this$synchronize$iv;
        Object object2 = readerSync;
        Function0 block$iv = () -> GpxDbHelper.pullNextFileItem$lambda$16(action);
        boolean $i$f$synchronize = false;
        void var5_5 = $this$synchronize$iv;
        synchronized (var5_5) {
            object = block$iv.invoke();
        }
        return (Pair)object;
    }

    @Override
    public void onGpxDataItemRead(@NotNull GpxDataItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.putGpxDataItemToSmartFolder(item);
    }

    private final void putGpxDataItemToSmartFolder(GpxDataItem item) {
        TrackItem trackItem;
        TrackItem $this$putGpxDataItemToSmartFolder_u24lambda_u2417 = trackItem = new TrackItem(item.getFile());
        boolean bl = false;
        $this$putGpxDataItemToSmartFolder_u24lambda_u2417.setDataItem(item);
        TrackItem trackItem2 = trackItem;
        PlatformUtil.INSTANCE.getOsmAndContext().getSmartFolderHelper().addTrackItemToSmartFolder(trackItem2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onProgressUpdate(GpxDataItem ... dataItems) {
        void $this$synchronize$iv;
        Intrinsics.checkNotNullParameter((Object)dataItems, (String)"dataItems");
        Object object = readerSync;
        Function0 block$iv = () -> GpxDbHelper.onProgressUpdate$lambda$20(dataItems);
        boolean $i$f$synchronize = false;
        void var5_5 = $this$synchronize$iv;
        synchronized (var5_5) {
            Object object2 = block$iv.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onReadingCancelled() {
        void $this$synchronize$iv;
        Object object = readerSync;
        Function0 block$iv = GpxDbHelper::onReadingCancelled$lambda$21;
        boolean $i$f$synchronize = false;
        void var4_4 = $this$synchronize$iv;
        synchronized (var4_4) {
            Object object2 = block$iv.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onReadingFinished(@NotNull GpxReader reader2, boolean cancelled) {
        void $this$synchronize$iv;
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Object object = readerSync;
        Function0 block$iv = () -> GpxDbHelper.onReadingFinished$lambda$22(cancelled, reader2);
        boolean $i$f$synchronize = false;
        void var6_6 = $this$synchronize$iv;
        synchronized (var6_6) {
            Object object2 = block$iv.invoke();
        }
    }

    private static final GpxDatabase database_delegate$lambda$0() {
        return new GpxDatabase();
    }

    private static final boolean isReading$lambda$5() {
        return !((Collection)readers).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isReading$lambda$7(KFile $file) {
        GpxReader it;
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        if (readingItemsMap.containsKey($file)) return true;
        Iterable $this$any$iv = readers;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (GpxReader)element$iv;
            boolean bl = false;
        } while (!it.isReading($file));
        return true;
    }

    private static final Unit readGpxItem$lambda$10(GpxDataItemCallback $callback, KFile $file, GpxDataItem $item) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        if ($callback != null) {
            List list;
            List list2;
            Map<KFile, List<GpxDataItemCallback>> $this$getOrPut$iv = readingItemsCallbacks;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get($file);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put($file, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            List $this$readGpxItem_u24lambda_u2410_u24lambda_u249 = list = list2;
            boolean bl = false;
            $this$readGpxItem_u24lambda_u2410_u24lambda_u249.add((GpxDataItemCallback)$callback);
        }
        if (!INSTANCE.isReading($file)) {
            GpxDataItem gpxDataItem = $item;
            if (gpxDataItem == null) {
                gpxDataItem = new GpxDataItem($file);
            }
            readingItemsMap.put($file, gpxDataItem);
            if (readers.size() < 4) {
                INSTANCE.startReading();
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean startReading$lambda$12() {
        GpxReader gpxReader;
        GpxReader $this$startReading_u24lambda_u2412_u24lambda_u2411 = gpxReader = new GpxReader(INSTANCE);
        List<GpxReader> list = readers;
        boolean bl = false;
        $this$startReading_u24lambda_u2412_u24lambda_u2411.execute(new Unit[0]);
        return list.add(gpxReader);
    }

    private static final Unit stopReading$lambda$14() {
        Iterable $this$forEach$iv = readers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GpxReader it = (GpxReader)element$iv;
            boolean bl = false;
            it.cancel();
        }
        readers.clear();
        return Unit.INSTANCE;
    }

    private static final Pair pullNextFileItem$lambda$16(Function1 $action) {
        Map.Entry result;
        block2: {
            Map.Entry entry;
            Map.Entry entry2 = (Map.Entry)CollectionsKt.firstOrNull((Iterable)readingItemsMap.entrySet());
            if (entry2 != null) {
                Map.Entry entry3 = entry2;
                Map.Entry $this$pullNextFileItem_u24lambda_u2416_u24lambda_u2415 = entry3 = new Pair(entry3.getKey(), entry3.getValue());
                boolean bl = false;
                readingItemsMap.remove($this$pullNextFileItem_u24lambda_u2416_u24lambda_u2415.getFirst());
                entry = entry3;
            } else {
                entry = null;
            }
            result = entry;
            Function1 function1 = $action;
            if (function1 == null) break block2;
            function1.invoke(result);
        }
        return result;
    }

    private static final Unit onProgressUpdate$lambda$20(GpxDataItem[] $dataItems) {
        Intrinsics.checkNotNullParameter((Object)$dataItems, (String)"$dataItems");
        GpxDataItem[] $this$forEach$iv = $dataItems;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            List<GpxDataItemCallback> callbacks;
            GpxDataItem element$iv;
            GpxDataItem item = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            List<GpxDataItemCallback> list = callbacks = readingItemsCallbacks.remove(item.getFile());
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GpxDataItemCallback callback2 = (GpxDataItemCallback)element$iv2;
                boolean bl2 = false;
                if (callback2.isCancelled()) {
                    INSTANCE.stopReading();
                    continue;
                }
                callback2.onGpxDataItemReady(item);
                if (!(callback2 instanceof GpxDataItemCallbackEx)) continue;
                ((GpxDataItemCallbackEx)callback2).onGpxDataItemReady(item, readingItemsCallbacks.isEmpty());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit onReadingCancelled$lambda$21() {
        readingItemsMap.clear();
        readingItemsCallbacks.clear();
        return Unit.INSTANCE;
    }

    private static final boolean onReadingFinished$lambda$22(boolean $cancelled, GpxReader $reader) {
        Intrinsics.checkNotNullParameter((Object)$reader, (String)"$reader");
        if (!readingItemsMap.isEmpty() && readers.size() < 4 && !$cancelled) {
            INSTANCE.startReading();
        }
        return readers.remove($reader);
    }

    public static final /* synthetic */ Object access$loadGpxItems(GpxDbHelper $this, Continuation $completion) {
        return $this.loadGpxItems((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$getFileExistenceMap(GpxDbHelper $this, List items, int batchSize, Continuation $completion) {
        return $this.getFileExistenceMap(items, batchSize, (Continuation<? super Map<KFile, Boolean>>)$completion);
    }

    public static final /* synthetic */ Object access$readItems(GpxDbHelper $this, Continuation $completion) {
        return $this.readItems((Continuation<? super List<GpxDataItem>>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/gpx/GpxDbHelper$GpxDataItemCallback;", "", "isCancelled", "", "onGpxDataItemReady", "", "item", "Lnet/osmand/shared/gpx/GpxDataItem;", "OsmAnd-shared"})
    public static interface GpxDataItemCallback {
        default public boolean isCancelled() {
            return false;
        }

        public void onGpxDataItemReady(@NotNull GpxDataItem var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/gpx/GpxDbHelper$GpxDataItemCallbackEx;", "Lnet/osmand/shared/gpx/GpxDbHelper$GpxDataItemCallback;", "onGpxDataItemReady", "", "item", "Lnet/osmand/shared/gpx/GpxDataItem;", "lastItem", "", "OsmAnd-shared"})
    public static interface GpxDataItemCallbackEx
    extends GpxDataItemCallback {
        public void onGpxDataItemReady(@NotNull GpxDataItem var1, boolean var2);
    }
}

