/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.palette.domain;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.ColorPalette;
import net.osmand.shared.palette.domain.GradientPoint;
import net.osmand.shared.palette.domain.GradientProperties;
import net.osmand.shared.palette.domain.GradientRangeType;
import net.osmand.shared.palette.domain.PaletteItemSource;
import net.osmand.shared.palette.domain.category.GradientPaletteCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0017\u0018R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0001\u0002\u0019\u001a\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/palette/domain/PaletteItem;", "", "id", "", "getId", "()Ljava/lang/String;", "displayName", "getDisplayName", "source", "Lnet/osmand/shared/palette/domain/PaletteItemSource;", "getSource", "()Lnet/osmand/shared/palette/domain/PaletteItemSource;", "isEditable", "", "()Z", "historyIndex", "", "getHistoryIndex", "()I", "lastUsedTime", "", "getLastUsedTime", "()J", "Solid", "Gradient", "Lnet/osmand/shared/palette/domain/PaletteItem$Gradient;", "Lnet/osmand/shared/palette/domain/PaletteItem$Solid;", "OsmAnd-shared"})
public interface PaletteItem {
    @NotNull
    public String getId();

    @NotNull
    public String getDisplayName();

    @NotNull
    public PaletteItemSource getSource();

    public boolean isEditable();

    public int getHistoryIndex();

    public long getLastUsedTime();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\bJ\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0006H\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\t\u00100\u001a\u00020\bH\u00c6\u0003J\t\u00101\u001a\u00020\u000bH\u00c6\u0003J\t\u00102\u001a\u00020\rH\u00c6\u0003J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\u0010\u00104\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010#J\t\u00105\u001a\u00020\u0013H\u00c6\u0003Jz\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001\u00a2\u0006\u0002\u00107J\u0013\u00108\u001a\u00020\b2\b\u00109\u001a\u0004\u0018\u00010:H\u00d6\u0003J\t\u0010;\u001a\u00020\u000bH\u00d6\u0001J\t\u0010<\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u001bR\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u001bR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006="}, d2={"Lnet/osmand/shared/palette/domain/PaletteItem$Gradient;", "Lnet/osmand/shared/palette/domain/PaletteItem;", "id", "", "displayName", "source", "Lnet/osmand/shared/palette/domain/PaletteItemSource$GradientFile;", "isDefault", "", "isEditable", "historyIndex", "", "lastUsedTime", "", "points", "", "Lnet/osmand/shared/palette/domain/GradientPoint;", "noDataColor", "properties", "Lnet/osmand/shared/palette/domain/GradientProperties;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lnet/osmand/shared/palette/domain/PaletteItemSource$GradientFile;ZZIJLjava/util/List;Ljava/lang/Integer;Lnet/osmand/shared/palette/domain/GradientProperties;)V", "getId", "()Ljava/lang/String;", "getDisplayName", "getSource", "()Lnet/osmand/shared/palette/domain/PaletteItemSource$GradientFile;", "()Z", "getHistoryIndex", "()I", "getLastUsedTime", "()J", "getPoints", "()Ljava/util/List;", "getNoDataColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getProperties", "()Lnet/osmand/shared/palette/domain/GradientProperties;", "getPaletteCategory", "Lnet/osmand/shared/palette/domain/category/GradientPaletteCategory;", "getColorPalette", "Lnet/osmand/shared/ColorPalette;", "isFixed", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "(Ljava/lang/String;Ljava/lang/String;Lnet/osmand/shared/palette/domain/PaletteItemSource$GradientFile;ZZIJLjava/util/List;Ljava/lang/Integer;Lnet/osmand/shared/palette/domain/GradientProperties;)Lnet/osmand/shared/palette/domain/PaletteItem$Gradient;", "equals", "other", "", "hashCode", "toString", "OsmAnd-shared"})
    @SourceDebugExtension(value={"SMAP\nPaletteItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaletteItem.kt\nnet/osmand/shared/palette/domain/PaletteItem$Gradient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1863#2,2:79\n*S KotlinDebug\n*F\n+ 1 PaletteItem.kt\nnet/osmand/shared/palette/domain/PaletteItem$Gradient\n*L\n71#1:79,2\n*E\n"})
    public static final class Gradient
    implements PaletteItem {
        @NotNull
        private final String id;
        @NotNull
        private final String displayName;
        @NotNull
        private final PaletteItemSource.GradientFile source;
        private final boolean isDefault;
        private final boolean isEditable;
        private final int historyIndex;
        private final long lastUsedTime;
        @NotNull
        private final List<GradientPoint> points;
        @Nullable
        private final Integer noDataColor;
        @NotNull
        private final GradientProperties properties;

        public Gradient(@NotNull String id, @NotNull String displayName, @NotNull PaletteItemSource.GradientFile source, boolean isDefault, boolean isEditable, int historyIndex, long lastUsedTime, @NotNull List<GradientPoint> points, @Nullable Integer noDataColor, @NotNull GradientProperties properties) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            this.id = id;
            this.displayName = displayName;
            this.source = source;
            this.isDefault = isDefault;
            this.isEditable = isEditable;
            this.historyIndex = historyIndex;
            this.lastUsedTime = lastUsedTime;
            this.points = points;
            this.noDataColor = noDataColor;
            this.properties = properties;
        }

        public /* synthetic */ Gradient(String string, String string2, PaletteItemSource.GradientFile gradientFile, boolean bl, boolean bl2, int n, long l, List list, Integer n2, GradientProperties gradientProperties, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                boolean bl3 = bl2 = !bl;
            }
            if ((n3 & 0x40) != 0) {
                l = 0L;
            }
            this(string, string2, gradientFile, bl, bl2, n, l, list, n2, gradientProperties);
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public PaletteItemSource.GradientFile getSource() {
            return this.source;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        @Override
        public boolean isEditable() {
            return this.isEditable;
        }

        @Override
        public int getHistoryIndex() {
            return this.historyIndex;
        }

        @Override
        public long getLastUsedTime() {
            return this.lastUsedTime;
        }

        @NotNull
        public final List<GradientPoint> getPoints() {
            return this.points;
        }

        @Nullable
        public final Integer getNoDataColor() {
            return this.noDataColor;
        }

        @NotNull
        public final GradientProperties getProperties() {
            return this.properties;
        }

        @NotNull
        public final GradientPaletteCategory getPaletteCategory() {
            return this.properties.getFileType().getCategory();
        }

        @NotNull
        public final ColorPalette getColorPalette() {
            ColorPalette palette = new ColorPalette();
            Iterable $this$forEach$iv = this.points;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GradientPoint it = (GradientPoint)element$iv;
                boolean bl = false;
                palette.getColors().add(it.toColorValue());
            }
            palette.setNoDataColor(this.noDataColor);
            return palette;
        }

        public final boolean isFixed() {
            return this.properties.getFileType().getRangeType() == GradientRangeType.FIXED_VALUES;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.displayName;
        }

        @NotNull
        public final PaletteItemSource.GradientFile component3() {
            return this.source;
        }

        public final boolean component4() {
            return this.isDefault;
        }

        public final boolean component5() {
            return this.isEditable;
        }

        public final int component6() {
            return this.historyIndex;
        }

        public final long component7() {
            return this.lastUsedTime;
        }

        @NotNull
        public final List<GradientPoint> component8() {
            return this.points;
        }

        @Nullable
        public final Integer component9() {
            return this.noDataColor;
        }

        @NotNull
        public final GradientProperties component10() {
            return this.properties;
        }

        @NotNull
        public final Gradient copy(@NotNull String id, @NotNull String displayName, @NotNull PaletteItemSource.GradientFile source, boolean isDefault, boolean isEditable, int historyIndex, long lastUsedTime, @NotNull List<GradientPoint> points, @Nullable Integer noDataColor, @NotNull GradientProperties properties) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            return new Gradient(id, displayName, source, isDefault, isEditable, historyIndex, lastUsedTime, points, noDataColor, properties);
        }

        public static /* synthetic */ Gradient copy$default(Gradient gradient, String string, String string2, PaletteItemSource.GradientFile gradientFile, boolean bl, boolean bl2, int n, long l, List list, Integer n2, GradientProperties gradientProperties, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = gradient.id;
            }
            if ((n3 & 2) != 0) {
                string2 = gradient.displayName;
            }
            if ((n3 & 4) != 0) {
                gradientFile = gradient.source;
            }
            if ((n3 & 8) != 0) {
                bl = gradient.isDefault;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = gradient.isEditable;
            }
            if ((n3 & 0x20) != 0) {
                n = gradient.historyIndex;
            }
            if ((n3 & 0x40) != 0) {
                l = gradient.lastUsedTime;
            }
            if ((n3 & 0x80) != 0) {
                list = gradient.points;
            }
            if ((n3 & 0x100) != 0) {
                n2 = gradient.noDataColor;
            }
            if ((n3 & 0x200) != 0) {
                gradientProperties = gradient.properties;
            }
            return gradient.copy(string, string2, gradientFile, bl, bl2, n, l, list, n2, gradientProperties);
        }

        @NotNull
        public String toString() {
            return "Gradient(id=" + this.id + ", displayName=" + this.displayName + ", source=" + this.source + ", isDefault=" + this.isDefault + ", isEditable=" + this.isEditable + ", historyIndex=" + this.historyIndex + ", lastUsedTime=" + this.lastUsedTime + ", points=" + this.points + ", noDataColor=" + this.noDataColor + ", properties=" + this.properties + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.displayName.hashCode();
            result = result * 31 + this.source.hashCode();
            result = result * 31 + Boolean.hashCode(this.isDefault);
            result = result * 31 + Boolean.hashCode(this.isEditable);
            result = result * 31 + Integer.hashCode(this.historyIndex);
            result = result * 31 + Long.hashCode(this.lastUsedTime);
            result = result * 31 + ((Object)this.points).hashCode();
            result = result * 31 + (this.noDataColor == null ? 0 : ((Object)this.noDataColor).hashCode());
            result = result * 31 + this.properties.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Gradient)) {
                return false;
            }
            Gradient gradient = (Gradient)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)gradient.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)gradient.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.source, (Object)gradient.source)) {
                return false;
            }
            if (this.isDefault != gradient.isDefault) {
                return false;
            }
            if (this.isEditable != gradient.isEditable) {
                return false;
            }
            if (this.historyIndex != gradient.historyIndex) {
                return false;
            }
            if (this.lastUsedTime != gradient.lastUsedTime) {
                return false;
            }
            if (!Intrinsics.areEqual(this.points, gradient.points)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.noDataColor, (Object)gradient.noDataColor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.properties, (Object)gradient.properties);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003JO\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\nH\u00c6\u0001J\u0013\u0010%\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020\nH\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006*"}, d2={"Lnet/osmand/shared/palette/domain/PaletteItem$Solid;", "Lnet/osmand/shared/palette/domain/PaletteItem;", "id", "", "displayName", "source", "Lnet/osmand/shared/palette/domain/PaletteItemSource$CollectionRecord;", "isEditable", "", "historyIndex", "", "lastUsedTime", "", "colorInt", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lnet/osmand/shared/palette/domain/PaletteItemSource$CollectionRecord;ZIJI)V", "getId", "()Ljava/lang/String;", "getDisplayName", "getSource", "()Lnet/osmand/shared/palette/domain/PaletteItemSource$CollectionRecord;", "()Z", "getHistoryIndex", "()I", "getLastUsedTime", "()J", "getColorInt", "getColorValue", "Lnet/osmand/shared/ColorPalette$ColorValue;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "toString", "OsmAnd-shared"})
    public static final class Solid
    implements PaletteItem {
        @NotNull
        private final String id;
        @NotNull
        private final String displayName;
        @NotNull
        private final PaletteItemSource.CollectionRecord source;
        private final boolean isEditable;
        private final int historyIndex;
        private final long lastUsedTime;
        private final int colorInt;

        public Solid(@NotNull String id, @NotNull String displayName, @NotNull PaletteItemSource.CollectionRecord source, boolean isEditable, int historyIndex, long lastUsedTime, int colorInt) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.id = id;
            this.displayName = displayName;
            this.source = source;
            this.isEditable = isEditable;
            this.historyIndex = historyIndex;
            this.lastUsedTime = lastUsedTime;
            this.colorInt = colorInt;
        }

        public /* synthetic */ Solid(String string, String string2, PaletteItemSource.CollectionRecord collectionRecord, boolean bl, int n, long l, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                bl = true;
            }
            if ((n3 & 0x20) != 0) {
                l = 0L;
            }
            this(string, string2, collectionRecord, bl, n, l, n2);
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public PaletteItemSource.CollectionRecord getSource() {
            return this.source;
        }

        @Override
        public boolean isEditable() {
            return this.isEditable;
        }

        @Override
        public int getHistoryIndex() {
            return this.historyIndex;
        }

        @Override
        public long getLastUsedTime() {
            return this.lastUsedTime;
        }

        public final int getColorInt() {
            return this.colorInt;
        }

        @NotNull
        public final ColorPalette.ColorValue getColorValue() {
            return new ColorPalette.ColorValue(this.getHistoryIndex(), this.colorInt);
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.displayName;
        }

        @NotNull
        public final PaletteItemSource.CollectionRecord component3() {
            return this.source;
        }

        public final boolean component4() {
            return this.isEditable;
        }

        public final int component5() {
            return this.historyIndex;
        }

        public final long component6() {
            return this.lastUsedTime;
        }

        public final int component7() {
            return this.colorInt;
        }

        @NotNull
        public final Solid copy(@NotNull String id, @NotNull String displayName, @NotNull PaletteItemSource.CollectionRecord source, boolean isEditable, int historyIndex, long lastUsedTime, int colorInt) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Solid(id, displayName, source, isEditable, historyIndex, lastUsedTime, colorInt);
        }

        public static /* synthetic */ Solid copy$default(Solid solid, String string, String string2, PaletteItemSource.CollectionRecord collectionRecord, boolean bl, int n, long l, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = solid.id;
            }
            if ((n3 & 2) != 0) {
                string2 = solid.displayName;
            }
            if ((n3 & 4) != 0) {
                collectionRecord = solid.source;
            }
            if ((n3 & 8) != 0) {
                bl = solid.isEditable;
            }
            if ((n3 & 0x10) != 0) {
                n = solid.historyIndex;
            }
            if ((n3 & 0x20) != 0) {
                l = solid.lastUsedTime;
            }
            if ((n3 & 0x40) != 0) {
                n2 = solid.colorInt;
            }
            return solid.copy(string, string2, collectionRecord, bl, n, l, n2);
        }

        @NotNull
        public String toString() {
            return "Solid(id=" + this.id + ", displayName=" + this.displayName + ", source=" + this.source + ", isEditable=" + this.isEditable + ", historyIndex=" + this.historyIndex + ", lastUsedTime=" + this.lastUsedTime + ", colorInt=" + this.colorInt + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.displayName.hashCode();
            result = result * 31 + this.source.hashCode();
            result = result * 31 + Boolean.hashCode(this.isEditable);
            result = result * 31 + Integer.hashCode(this.historyIndex);
            result = result * 31 + Long.hashCode(this.lastUsedTime);
            result = result * 31 + Integer.hashCode(this.colorInt);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Solid)) {
                return false;
            }
            Solid solid = (Solid)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)solid.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)solid.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.source, (Object)solid.source)) {
                return false;
            }
            if (this.isEditable != solid.isEditable) {
                return false;
            }
            if (this.historyIndex != solid.historyIndex) {
                return false;
            }
            if (this.lastUsedTime != solid.lastUsedTime) {
                return false;
            }
            return this.colorInt == solid.colorInt;
        }
    }
}

