/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.palette.data;

import co.touchlab.stately.collections.ConcurrentMutableList;
import co.touchlab.stately.collections.ConcurrentMutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.palette.data.PaletteChangeEvent;
import net.osmand.shared.palette.data.PaletteIO;
import net.osmand.shared.palette.data.PaletteModifier;
import net.osmand.shared.palette.data.PaletteRepositoryListener;
import net.osmand.shared.palette.data.PaletteSortMode;
import net.osmand.shared.palette.data.gradient.GradientPaletteIO;
import net.osmand.shared.palette.data.gradient.GradientPaletteModifier;
import net.osmand.shared.palette.data.solid.SolidPaletteIO;
import net.osmand.shared.palette.data.solid.SolidPaletteModifier;
import net.osmand.shared.palette.domain.Palette;
import net.osmand.shared.palette.domain.PaletteItem;
import net.osmand.shared.palette.domain.category.GradientPaletteCategory;
import net.osmand.shared.palette.domain.filetype.GradientFileType;
import net.osmand.shared.palette.domain.filetype.PaletteFileType;
import net.osmand.shared.palette.domain.filetype.PaletteFileTypeRegistry;
import net.osmand.shared.palette.domain.filetype.SolidFileType;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nJ\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006J\u0010\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\u0006J \u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0$2\u0006\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010%\u001a\u00020&H\u0007J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u001eJ\u0016\u0010)\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u001eJ\u001e\u0010+\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u001eJ\u001e\u0010-\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u001eJ\u0016\u0010/\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006J\u0016\u00100\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006J'\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00072\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001c05H\u0082\bJ\u001a\u00106\u001a\u00020\u00172\b\u00107\u001a\u0004\u0018\u00010\u00072\u0006\u00108\u001a\u00020\u0007H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u001a\u0010:\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00122\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f*\u00020\u00078BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012*\u00020\u00078BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006<"}, d2={"Lnet/osmand/shared/palette/data/PaletteRepository;", "", "<init>", "()V", "cachedPalettesForId", "Lco/touchlab/stately/collections/ConcurrentMutableMap;", "", "Lnet/osmand/shared/palette/domain/Palette;", "listeners", "Lco/touchlab/stately/collections/ConcurrentMutableList;", "Lnet/osmand/shared/palette/data/PaletteRepositoryListener;", "modifier", "Lnet/osmand/shared/palette/data/PaletteModifier;", "getModifier$annotations", "(Lnet/osmand/shared/palette/domain/Palette;)V", "getModifier", "(Lnet/osmand/shared/palette/domain/Palette;)Lnet/osmand/shared/palette/data/PaletteModifier;", "io", "Lnet/osmand/shared/palette/data/PaletteIO;", "getIo$annotations", "getIo", "(Lnet/osmand/shared/palette/domain/Palette;)Lnet/osmand/shared/palette/data/PaletteIO;", "addListener", "", "listener", "removeListener", "notifyListeners", "event", "Lnet/osmand/shared/palette/data/PaletteChangeEvent;", "findPaletteItem", "Lnet/osmand/shared/palette/domain/PaletteItem;", "paletteId", "itemId", "getPalette", "id", "getPaletteItems", "", "sortMode", "Lnet/osmand/shared/palette/data/PaletteSortMode;", "updatePaletteItem", "item", "addPaletteItem", "newItem", "replacePaletteItem", "oldItemId", "insertPaletteItemAfter", "anchorId", "removePaletteItem", "markPaletteItemAsUsed", "applyChange", "oldPalette", "newPalette", "createEvent", "Lkotlin/Function0;", "savePalette", "old", "new", "readPalette", "findPaletteIO", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nPaletteRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaletteRepository.kt\nnet/osmand/shared/palette/data/PaletteRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n160#1,5:213\n160#1,5:218\n160#1,5:223\n160#1,5:228\n160#1,5:233\n160#1,5:238\n1863#2,2:206\n295#2,2:208\n1062#2:211\n1053#2:212\n1#3:210\n*S KotlinDebug\n*F\n+ 1 PaletteRepository.kt\nnet/osmand/shared/palette/data/PaletteRepository\n*L\n89#1:213,5\n98#1:218,5\n107#1:223,5\n116#1:228,5\n125#1:233,5\n134#1:238,5\n49#1:206,2\n56#1:208,2\n76#1:211\n77#1:212\n*E\n"})
public final class PaletteRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMutableMap<String, Palette> cachedPalettesForId = new ConcurrentMutableMap();
    @NotNull
    private final ConcurrentMutableList<PaletteRepositoryListener> listeners = new ConcurrentMutableList();
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("PaletteRepository");

    private final PaletteModifier<Palette> getModifier(Palette $this$modifier) {
        PaletteModifier paletteModifier;
        Palette palette = $this$modifier;
        if (palette instanceof Palette.SolidCollection) {
            SolidPaletteModifier solidPaletteModifier = SolidPaletteModifier.INSTANCE;
            Intrinsics.checkNotNull((Object)solidPaletteModifier, (String)"null cannot be cast to non-null type net.osmand.shared.palette.data.PaletteModifier<net.osmand.shared.palette.domain.Palette>");
            paletteModifier = solidPaletteModifier;
        } else if (palette instanceof Palette.GradientCollection) {
            GradientPaletteModifier gradientPaletteModifier = GradientPaletteModifier.INSTANCE;
            Intrinsics.checkNotNull((Object)gradientPaletteModifier, (String)"null cannot be cast to non-null type net.osmand.shared.palette.data.PaletteModifier<net.osmand.shared.palette.domain.Palette>");
            paletteModifier = gradientPaletteModifier;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return paletteModifier;
    }

    private static /* synthetic */ void getModifier$annotations(Palette palette) {
    }

    private final PaletteIO<Palette> getIo(Palette $this$io) {
        PaletteIO paletteIO;
        Palette palette = $this$io;
        if (palette instanceof Palette.SolidCollection) {
            SolidPaletteIO solidPaletteIO = SolidPaletteIO.INSTANCE;
            Intrinsics.checkNotNull((Object)solidPaletteIO, (String)"null cannot be cast to non-null type net.osmand.shared.palette.data.PaletteIO<net.osmand.shared.palette.domain.Palette>");
            paletteIO = solidPaletteIO;
        } else if (palette instanceof Palette.GradientCollection) {
            GradientPaletteIO gradientPaletteIO = GradientPaletteIO.INSTANCE;
            Intrinsics.checkNotNull((Object)gradientPaletteIO, (String)"null cannot be cast to non-null type net.osmand.shared.palette.data.PaletteIO<net.osmand.shared.palette.domain.Palette>");
            paletteIO = gradientPaletteIO;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return paletteIO;
    }

    private static /* synthetic */ void getIo$annotations(Palette palette) {
    }

    public final void addListener(@NotNull PaletteRepositoryListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add((Object)listener);
    }

    public final void removeListener(@NotNull PaletteRepositoryListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove((Object)listener);
    }

    private final void notifyListeners(PaletteChangeEvent event) {
        Iterable $this$forEach$iv = (Iterable)this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PaletteRepositoryListener it = (PaletteRepositoryListener)element$iv;
            boolean bl = false;
            it.onPaletteChanged(event);
        }
    }

    @Nullable
    public final PaletteItem findPaletteItem(@NotNull String paletteId, @NotNull String itemId) {
        PaletteItem paletteItem;
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Palette palette = this.getPalette(paletteId);
        Object object = palette;
        if (object != null && (object = ((Palette)object).getItems()) != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaletteItem it = (PaletteItem)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)itemId)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            paletteItem = v1;
        } else {
            paletteItem = null;
        }
        return paletteItem;
    }

    @Nullable
    public final Palette getPalette(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Palette palette = (Palette)this.cachedPalettesForId.get((Object)id);
        if (palette != null) {
            Palette it = palette;
            boolean bl = false;
            return it;
        }
        Palette loadedPalette = this.readPalette(id);
        if (loadedPalette != null) {
            ((Map)this.cachedPalettesForId).put(id, loadedPalette);
        }
        return loadedPalette;
    }

    @JvmOverloads
    @NotNull
    public final List<PaletteItem> getPaletteItems(@NotNull String paletteId, @NotNull PaletteSortMode sortMode) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortMode), (String)"sortMode");
        Palette palette = this.getPalette(paletteId);
        if (palette != null) {
            Palette palette2 = palette;
            boolean bl = false;
            return switch (WhenMappings.$EnumSwitchMapping$0[sortMode.ordinal()]) {
                case 1 -> {
                    Iterable $this$sortedByDescending$iv = palette2.getItems();
                    boolean $i$f$sortedByDescending = false;
                    yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            PaletteItem it = (PaletteItem)b;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(it.getLastUsedTime());
                            it = (PaletteItem)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastUsedTime()));
                        }
                    });
                }
                case 2 -> {
                    Iterable $this$sortedBy$iv = palette2.getItems();
                    boolean $i$f$sortedBy = false;
                    yield CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            PaletteItem it = (PaletteItem)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.getHistoryIndex());
                            it = (PaletteItem)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHistoryIndex()));
                        }
                    });
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List getPaletteItems$default(PaletteRepository paletteRepository, String string, PaletteSortMode paletteSortMode, int n, Object object) {
        if ((n & 2) != 0) {
            paletteSortMode = PaletteSortMode.ORIGINAL_ORDER;
        }
        return paletteRepository.getPaletteItems(string, paletteSortMode);
    }

    public final void updatePaletteItem(@NotNull PaletteItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Palette palette = this.getPalette(item.getSource().getPaletteId());
        if (palette == null) {
            return;
        }
        Palette currentPalette = palette;
        Palette updatedPalette = this.getModifier(currentPalette).update(currentPalette, item);
        PaletteRepository this_$iv = this;
        boolean $i$f$applyChange = false;
        if (currentPalette != updatedPalette) {
            this_$iv.savePalette(currentPalette, updatedPalette);
            PaletteRepository paletteRepository = this_$iv;
            boolean bl = false;
            paletteRepository.notifyListeners(new PaletteChangeEvent.Updated(item));
        }
    }

    public final void addPaletteItem(@NotNull String paletteId, @NotNull PaletteItem newItem) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        Palette palette = this.getPalette(paletteId);
        if (palette == null) {
            return;
        }
        Palette currentPalette = palette;
        Palette updatedPalette = this.getModifier(currentPalette).add(currentPalette, newItem);
        PaletteRepository this_$iv = this;
        boolean $i$f$applyChange = false;
        if (currentPalette != updatedPalette) {
            this_$iv.savePalette(currentPalette, updatedPalette);
            PaletteRepository paletteRepository = this_$iv;
            boolean bl = false;
            paletteRepository.notifyListeners(new PaletteChangeEvent.Added(newItem));
        }
    }

    public final void replacePaletteItem(@NotNull String paletteId, @NotNull String oldItemId, @NotNull PaletteItem newItem) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        Intrinsics.checkNotNullParameter((Object)oldItemId, (String)"oldItemId");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        Palette palette = this.getPalette(paletteId);
        if (palette == null) {
            return;
        }
        Palette currentPalette = palette;
        Palette updatedPalette = this.getModifier(currentPalette).replace(currentPalette, oldItemId, newItem);
        PaletteRepository this_$iv = this;
        boolean $i$f$applyChange = false;
        if (currentPalette != updatedPalette) {
            this_$iv.savePalette(currentPalette, updatedPalette);
            PaletteRepository paletteRepository = this_$iv;
            boolean bl = false;
            paletteRepository.notifyListeners(new PaletteChangeEvent.Replaced(oldItemId, newItem));
        }
    }

    public final void insertPaletteItemAfter(@NotNull String paletteId, @NotNull String anchorId, @NotNull PaletteItem newItem) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        Palette palette = this.getPalette(paletteId);
        if (palette == null) {
            return;
        }
        Palette currentPalette = palette;
        Palette updatedPalette = this.getModifier(currentPalette).insertAfter(currentPalette, anchorId, newItem);
        PaletteRepository this_$iv = this;
        boolean $i$f$applyChange = false;
        if (currentPalette != updatedPalette) {
            this_$iv.savePalette(currentPalette, updatedPalette);
            PaletteRepository paletteRepository = this_$iv;
            boolean bl = false;
            paletteRepository.notifyListeners(new PaletteChangeEvent.Added(newItem));
        }
    }

    public final void removePaletteItem(@NotNull String paletteId, @NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Palette palette = this.getPalette(paletteId);
        if (palette == null) {
            return;
        }
        Palette currentPalette = palette;
        Palette updatedPalette = this.getModifier(currentPalette).remove(currentPalette, itemId);
        PaletteRepository this_$iv = this;
        boolean $i$f$applyChange = false;
        if (currentPalette != updatedPalette) {
            this_$iv.savePalette(currentPalette, updatedPalette);
            PaletteRepository paletteRepository = this_$iv;
            boolean bl = false;
            paletteRepository.notifyListeners(new PaletteChangeEvent.Removed(itemId, paletteId));
        }
    }

    public final void markPaletteItemAsUsed(@NotNull String paletteId, @NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Palette palette = this.getPalette(paletteId);
        if (palette == null) {
            return;
        }
        Palette currentPalette = palette;
        Palette updatedPalette = this.getModifier(currentPalette).markAsUsed(currentPalette, itemId);
        PaletteRepository this_$iv = this;
        boolean $i$f$applyChange = false;
        if (currentPalette != updatedPalette) {
            Object v1;
            PaletteRepository paletteRepository;
            block3: {
                this_$iv.savePalette(currentPalette, updatedPalette);
                paletteRepository = this_$iv;
                boolean bl = false;
                Iterable iterable = updatedPalette.getItems();
                for (Object t : iterable) {
                    PaletteItem it = (PaletteItem)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)itemId)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            PaletteItem updatedItem = v1;
            paletteRepository.notifyListeners(updatedItem != null ? (PaletteChangeEvent)new PaletteChangeEvent.Updated(updatedItem) : (PaletteChangeEvent)new PaletteChangeEvent.Updated((PaletteItem)CollectionsKt.first(currentPalette.getItems())));
        }
    }

    private final void applyChange(Palette oldPalette, Palette newPalette, Function0<? extends PaletteChangeEvent> createEvent) {
        boolean $i$f$applyChange = false;
        if (oldPalette != newPalette) {
            this.savePalette(oldPalette, newPalette);
            this.notifyListeners((PaletteChangeEvent)createEvent.invoke());
        }
    }

    private final void savePalette(Palette old, Palette palette) {
        ((Map)this.cachedPalettesForId).put(palette.getId(), palette);
        try {
            this.getIo(palette).sync(old, palette);
        }
        catch (Exception e) {
            LOG.error("Failed to save palette " + palette.getId(), e);
        }
    }

    private final Palette readPalette(String id) {
        PaletteIO<? extends Palette> paletteIO = this.findPaletteIO(id);
        if (paletteIO == null) {
            return null;
        }
        PaletteIO<? extends Palette> io = paletteIO;
        Palette palette = io.read(id);
        if (palette == null && (palette = io.createDefault(id)) != null) {
            this.savePalette(null, palette);
        }
        return palette;
    }

    private final PaletteIO<? extends Palette> findPaletteIO(String paletteId) {
        PaletteFileType fileType = PaletteFileTypeRegistry.INSTANCE.fromFileName(paletteId);
        if (fileType instanceof SolidFileType) {
            return SolidPaletteIO.INSTANCE;
        }
        if (GradientPaletteCategory.Companion.fromKey(paletteId) != null || fileType instanceof GradientFileType) {
            return GradientPaletteIO.INSTANCE;
        }
        return null;
    }

    @JvmOverloads
    @NotNull
    public final List<PaletteItem> getPaletteItems(@NotNull String paletteId) {
        Intrinsics.checkNotNullParameter((Object)paletteId, (String)"paletteId");
        return PaletteRepository.getPaletteItems$default(this, paletteId, null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/osmand/shared/palette/data/PaletteRepository$Companion;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaletteSortMode.values().length];
            try {
                nArray[PaletteSortMode.LAST_USED_TIME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaletteSortMode.ORIGINAL_ORDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

