/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.filters;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.filters.BaseTrackFilter;
import net.osmand.shared.gpx.filters.DateTrackFilter;
import net.osmand.shared.gpx.filters.FilterChangedListener;
import net.osmand.shared.gpx.filters.FilterType;
import net.osmand.shared.gpx.filters.FolderTrackFilter;
import net.osmand.shared.gpx.filters.ListTrackFilter;
import net.osmand.shared.gpx.filters.OtherTrackFilter;
import net.osmand.shared.gpx.filters.RangeTrackFilter;
import net.osmand.shared.gpx.filters.TextTrackFilter;
import net.osmand.shared.gpx.filters.TrackFilterType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\"\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\tJ\u0016\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00162\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\u001a"}, d2={"Lnet/osmand/shared/gpx/filters/TrackFiltersHelper;", "", "<init>", "()V", "createTextFilter", "Lnet/osmand/shared/gpx/filters/BaseTrackFilter;", "filterType", "Lnet/osmand/shared/gpx/filters/TrackFilterType;", "listener", "Lnet/osmand/shared/gpx/filters/FilterChangedListener;", "createDateFilter", "trackFilterType", "minDate", "", "createOtherFilter", "createSingleListFilter", "createRangeFilter", "isGpxParameterClass", "", "parameter", "Lnet/osmand/shared/gpx/GpxParameter;", "javaClass", "Lkotlin/reflect/KClass;", "createFilter", "filterChangedListener", "getFilterClass", "OsmAnd-shared"})
public final class TrackFiltersHelper {
    @NotNull
    public static final TrackFiltersHelper INSTANCE = new TrackFiltersHelper();

    private TrackFiltersHelper() {
    }

    private final BaseTrackFilter createTextFilter(TrackFilterType filterType, FilterChangedListener listener) {
        return new TextTrackFilter(filterType, listener);
    }

    private final BaseTrackFilter createDateFilter(TrackFilterType trackFilterType, long minDate, FilterChangedListener listener) {
        return new DateTrackFilter(trackFilterType, minDate, listener);
    }

    private final BaseTrackFilter createOtherFilter(TrackFilterType trackFilterType, FilterChangedListener listener) {
        return new OtherTrackFilter(trackFilterType, listener);
    }

    private final BaseTrackFilter createSingleListFilter(TrackFilterType trackFilterType, FilterChangedListener listener) {
        return trackFilterType == TrackFilterType.FOLDER ? (BaseTrackFilter)new FolderTrackFilter(listener) : (BaseTrackFilter)new ListTrackFilter(trackFilterType, listener);
    }

    private final BaseTrackFilter createRangeFilter(TrackFilterType trackFilterType, FilterChangedListener listener) {
        if (trackFilterType.getDefaultParams() == null || trackFilterType.getDefaultParams().size() < 2) {
            throw new IllegalArgumentException("RangeTrackFilter needs 2 default params: minValue, maxValue");
        }
        Object minValue = trackFilterType.getDefaultParams().get(0);
        Object maxValue = trackFilterType.getDefaultParams().get(1);
        if (minValue.getClass() != maxValue.getClass()) {
            throw new IllegalArgumentException("RangeTrackFilter's 2 default params (minValue, maxValue) must be the same type");
        }
        GpxParameter parameter = trackFilterType.getProperty();
        if (this.isGpxParameterClass(parameter, Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Intrinsics.checkNotNull((Object)minValue, (String)"null cannot be cast to non-null type kotlin.Double");
            Comparable comparable = (Double)minValue;
            Intrinsics.checkNotNull((Object)maxValue, (String)"null cannot be cast to non-null type kotlin.Double");
            return new RangeTrackFilter<Comparable>(comparable, (Double)maxValue, trackFilterType, listener);
        }
        if (this.isGpxParameterClass(parameter, Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Intrinsics.checkNotNull((Object)minValue, (String)"null cannot be cast to non-null type kotlin.Float");
            Comparable comparable = (Float)minValue;
            Intrinsics.checkNotNull((Object)maxValue, (String)"null cannot be cast to non-null type kotlin.Float");
            return new RangeTrackFilter<Comparable>(comparable, (Float)maxValue, trackFilterType, listener);
        }
        if (this.isGpxParameterClass(parameter, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Intrinsics.checkNotNull((Object)minValue, (String)"null cannot be cast to non-null type kotlin.Int");
            Comparable comparable = (Integer)minValue;
            Intrinsics.checkNotNull((Object)maxValue, (String)"null cannot be cast to non-null type kotlin.Int");
            return new RangeTrackFilter<Comparable>(comparable, (Integer)maxValue, trackFilterType, listener);
        }
        if (this.isGpxParameterClass(parameter, Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Intrinsics.checkNotNull((Object)minValue, (String)"null cannot be cast to non-null type kotlin.Long");
            Comparable comparable = (Long)minValue;
            Intrinsics.checkNotNull((Object)maxValue, (String)"null cannot be cast to non-null type kotlin.Long");
            return new RangeTrackFilter<Comparable>(comparable, (Long)maxValue, trackFilterType, listener);
        }
        GpxParameter gpxParameter = parameter;
        throw new IllegalArgumentException("Unsupported gpxParameter type class " + (gpxParameter != null ? gpxParameter.getTypeClass() : null));
    }

    private final boolean isGpxParameterClass(GpxParameter parameter, KClass<?> javaClass) {
        GpxParameter gpxParameter = parameter;
        return Intrinsics.areEqual(gpxParameter != null ? gpxParameter.getTypeClass() : null, javaClass);
    }

    @NotNull
    public final BaseTrackFilter createFilter(@NotNull TrackFilterType trackFilterType, @Nullable FilterChangedListener filterChangedListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)trackFilterType), (String)"trackFilterType");
        BaseTrackFilter newFilter = switch (WhenMappings.$EnumSwitchMapping$0[trackFilterType.getFilterType().ordinal()]) {
            case 1 -> this.createTextFilter(trackFilterType, filterChangedListener);
            case 2 -> this.createRangeFilter(trackFilterType, filterChangedListener);
            case 3 -> this.createDateFilter(trackFilterType, ClockExtensionsKt.currentTimeMillis(), filterChangedListener);
            case 4 -> this.createOtherFilter(trackFilterType, filterChangedListener);
            case 5 -> this.createSingleListFilter(trackFilterType, filterChangedListener);
            default -> throw new IllegalArgumentException("Unknown filterType " + trackFilterType);
        };
        return newFilter;
    }

    @NotNull
    public final KClass<? extends BaseTrackFilter> getFilterClass(@NotNull TrackFilterType trackFilterType) {
        Intrinsics.checkNotNullParameter((Object)((Object)trackFilterType), (String)"trackFilterType");
        KClass filterClass = switch (WhenMappings.$EnumSwitchMapping$0[trackFilterType.getFilterType().ordinal()]) {
            case 1 -> Reflection.getOrCreateKotlinClass(TextTrackFilter.class);
            case 2 -> Reflection.getOrCreateKotlinClass(RangeTrackFilter.class);
            case 3 -> Reflection.getOrCreateKotlinClass(DateTrackFilter.class);
            case 4 -> Reflection.getOrCreateKotlinClass(OtherTrackFilter.class);
            case 5 -> Reflection.getOrCreateKotlinClass(ListTrackFilter.class);
            default -> throw new IllegalArgumentException("Unknown filterType " + trackFilterType);
        };
        return filterClass;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterType.values().length];
            try {
                nArray[FilterType.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.RANGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.DATE_RANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.OTHER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.SINGLE_FIELD_LIST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

