/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.engine.lua;

import info.bliki.extensions.scribunto.ScribuntoException;
import info.bliki.extensions.scribunto.engine.ScribuntoModule;
import info.bliki.extensions.scribunto.engine.lua.ScribuntoLuaEngine;
import info.bliki.extensions.scribunto.template.Frame;
import info.bliki.wiki.filter.ParsedPageName;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScribuntoLuaModule
implements ScribuntoModule {
    private static final int SLOW_MODULE_THRESHOLD = 500;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScribuntoLuaEngine engine;
    private Prototype prototype;
    private final ParsedPageName pageName;

    public ScribuntoLuaModule(ScribuntoLuaEngine engine, Prototype prototype, ParsedPageName pageName) {
        if (engine == null) {
            throw new IllegalArgumentException("engine is null");
        }
        if (prototype == null) {
            throw new IllegalArgumentException("prototype is null");
        }
        this.engine = engine;
        this.prototype = prototype;
        this.pageName = pageName;
    }

    @Override
    public String invoke(String functionName, Frame frame) throws ScribuntoException {
        LuaValue function = this.getEngine().loadFunction(functionName, this.prototype, frame);
        long execStart = System.currentTimeMillis();
        String result = this.getEngine().executeFunctionChunk(function, frame);
        long execDuration = System.currentTimeMillis() - execStart;
        this.logExecution(functionName, execDuration);
        return result;
    }

    public String toString() {
        return "ScribuntoLuaModule{" + this.pageName() + '}';
    }

    protected ScribuntoLuaEngine getEngine() {
        return this.engine;
    }

    @Override
    public ParsedPageName pageName() {
        return this.pageName;
    }

    private void logExecution(String functionName, long execDuration) {
        boolean slowExecution;
        boolean bl = slowExecution = execDuration > 500L;
        if (slowExecution || this.logger.isDebugEnabled()) {
            String message = String.format("execDuration(%s %s):%d ms", this.toString(), functionName, execDuration);
            if (slowExecution) {
                this.logger.warn(message);
            } else {
                this.logger.debug(message);
            }
        }
    }
}

