/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;
import net.osmand.router.MissingMapsCalculationResult;
import net.osmand.router.RoutingContext;
import net.osmand.util.Algorithms;
import net.osmand.util.CollectionUtils;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class MissingMapsCalculator {
    protected static final Log LOG = PlatformUtil.getLog(MissingMapsCalculator.class);
    public static final double DISTANCE_SPLIT = 15000.0;
    public static final double DISTANCE_SKIP = 10000.0;
    private OsmandRegions or;
    private BinaryMapIndexReader reader;
    private List<String> lastKeyNames;

    public MissingMapsCalculator() throws IOException {
        this.or = new OsmandRegions();
        this.reader = this.or.prepareFile();
    }

    public MissingMapsCalculator(OsmandRegions osmandRegions) {
        this.or = osmandRegions;
    }

    public boolean checkIfThereAreMissingMaps(RoutingContext ctx, LatLon start, List<LatLon> targets, boolean checkHHEditions) throws IOException {
        long tm = System.nanoTime();
        this.lastKeyNames = new ArrayList<String>();
        ArrayList<Point> pointsToCheck = new ArrayList<Point>();
        String profile = ctx.getRouter().getProfile().getBaseProfile();
        TreeMap<String, RegisteredMap> knownMaps = new TreeMap<String, RegisteredMap>();
        for (BinaryMapIndexReader r : ctx.map.keySet()) {
            RegisteredMap rmap = new RegisteredMap();
            rmap.downloadName = Algorithms.getRegionName(r.getFile().getName());
            rmap.reader = r;
            boolean bl = rmap.standard = this.or.getRegionDataByDownloadName(rmap.downloadName) != null;
            if (rmap.downloadName.toLowerCase().startsWith("world_")) continue;
            knownMaps.put(rmap.downloadName, rmap);
            for (BinaryHHRouteReaderAdapter.HHRouteRegion rt : r.getHHRoutingIndexes()) {
                if (!rt.profile.equals(profile)) continue;
                rmap.edition = rt.edition;
            }
        }
        LatLon end = null;
        LatLon prev = start;
        for (int i = 0; i < targets.size(); ++i) {
            end = targets.get(i);
            if (i > 0 && MapUtils.getDistance(prev, end) < 10000.0) continue;
            this.split(ctx, knownMaps, pointsToCheck, prev, end);
            prev = end;
        }
        if (end != null) {
            this.addPoint(ctx, knownMaps, pointsToCheck, end);
        }
        List<LatLon> points = CollectionUtils.asOneList(Collections.singletonList(start), targets);
        MissingMapsCalculationResult result = new MissingMapsCalculationResult(ctx, points);
        TreeSet<Long> presentTimestamps = null;
        block3: for (Point p : pointsToCheck) {
            if (p.hhEditions == null) {
                for (String reg : p.regions) {
                    if (this.isRoadOnlyMap(reg)) continue;
                    result.addMissingMaps(reg);
                    continue block3;
                }
                continue;
            }
            if (checkHHEditions) {
                if (presentTimestamps == null) {
                    presentTimestamps = new TreeSet<Long>((SortedSet<Long>)p.editionsUnique);
                    continue;
                }
                if (presentTimestamps.isEmpty()) continue;
                presentTimestamps.retainAll(p.editionsUnique);
                continue;
            }
            if (p.regions.size() <= 0) continue;
            result.addUsedMaps(p.regions.get(0));
        }
        if (presentTimestamps != null && presentTimestamps.isEmpty()) {
            long max = 0L;
            for (Point p : pointsToCheck) {
                if (p.editionsUnique == null) continue;
                max = Math.max(p.editionsUnique.last(), max);
            }
            for (Point p : pointsToCheck) {
                String region = null;
                boolean fresh = false;
                for (int i = 0; p.hhEditions != null && i < p.hhEditions.length; ++i) {
                    if (p.hhEditions[i] <= 0L) continue;
                    region = p.regions.get(i);
                    boolean bl = fresh = p.hhEditions[i] == max;
                    if (fresh) break;
                }
                if (region == null) continue;
                if (!fresh) {
                    result.addMapToUpdate(region);
                    continue;
                }
                result.addUsedMaps(region);
            }
        } else if (presentTimestamps != null) {
            long selectedEdition = (Long)presentTimestamps.iterator().next();
            block8: for (Point p : pointsToCheck) {
                for (int i = 0; p.hhEditions != null && i < p.hhEditions.length; ++i) {
                    if (p.hhEditions[i] != selectedEdition) continue;
                    result.addUsedMaps(p.regions.get(i));
                    continue block8;
                }
            }
        }
        if (!result.hasMissingMaps()) {
            return false;
        }
        ctx.calculationProgress.missingMapsCalculationResult = result.prepare(this.or);
        LOG.info((Object)String.format("Check missing maps %d points %.2f sec", pointsToCheck.size(), (double)(System.nanoTime() - tm) / 1.0E9));
        return true;
    }

    protected LatLon testLatLons(List<LatLon> targets) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(MissingMapsCalculator.class.getResourceAsStream("/latlons.test.txt")));
        targets.clear();
        String s = null;
        while ((s = r.readLine()) != null) {
            String[] ls = s.split(",");
            targets.add(new LatLon(Double.parseDouble(ls[1].trim()), Double.parseDouble(ls[0].trim())));
        }
        return targets.get(0);
    }

    private void addPoint(RoutingContext ctx, Map<String, RegisteredMap> knownMaps, List<Point> pointsToCheck, LatLon loc) throws IOException {
        List<BinaryMapDataObject> resList = this.or.getRegionsToDownload(loc.getLatitude(), loc.getLongitude());
        boolean onlyJointMap = true;
        ArrayList<String> regions = new ArrayList<String>();
        for (BinaryMapDataObject o : resList) {
            boolean hasRoadsJoinType;
            String downloadName = this.or.getDownloadName(o);
            WorldRegion region = this.or.getRegionDataByDownloadName(downloadName);
            boolean hasMapType = region != null && region.isRegionMapDownload();
            boolean hasRoadsType = region != null && region.isRegionRoadsDownload();
            boolean hasMapJoinType = region != null && region.isRegionJoinMapDownload();
            boolean bl = hasRoadsJoinType = region != null && region.isRegionJoinRoadsDownload();
            if (!hasMapType && !hasRoadsType && !hasMapJoinType && !hasRoadsJoinType) continue;
            regions.add(downloadName);
            if (hasMapJoinType || hasRoadsJoinType) continue;
            onlyJointMap = false;
        }
        Collections.sort(regions, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -Integer.compare(o1.length(), o2.length());
            }
        });
        if (!(pointsToCheck.size() != 0 && regions.equals(this.lastKeyNames) || onlyJointMap)) {
            Point pnt = new Point();
            this.lastKeyNames = regions;
            pnt.regions = new ArrayList<String>(regions);
            boolean hasHHEdition = this.addMapEditions(knownMaps, pnt);
            if (!hasHHEdition) {
                pnt.hhEditions = null;
                int x31 = MapUtils.get31TileNumberX(loc.getLongitude());
                int y31 = MapUtils.get31TileNumberY(loc.getLatitude());
                for (RegisteredMap r : knownMaps.values()) {
                    if (r.standard || !r.reader.containsRouteData() || !r.reader.containsActualRouteData(x31, y31, null)) continue;
                    pnt.regions.add(0, r.downloadName);
                }
                this.addMapEditions(knownMaps, pnt);
            }
            pointsToCheck.add(pnt);
        }
    }

    private boolean addMapEditions(Map<String, RegisteredMap> knownMaps, Point pnt) {
        boolean hhEditionPresent = false;
        for (int i = 0; i < pnt.regions.size(); ++i) {
            String regionName = pnt.regions.get(i);
            if (!knownMaps.containsKey(regionName)) continue;
            if (pnt.hhEditions == null) {
                pnt.hhEditions = new long[pnt.regions.size()];
                pnt.editionsUnique = new TreeSet();
            }
            pnt.hhEditions[i] = knownMaps.get((Object)regionName).edition;
            hhEditionPresent |= pnt.hhEditions[i] > 0L;
            pnt.editionsUnique.add(pnt.hhEditions[i]);
        }
        return hhEditionPresent;
    }

    private void split(RoutingContext ctx, Map<String, RegisteredMap> knownMaps, List<Point> pointsToCheck, LatLon pnt, LatLon next) throws IOException {
        double dist = MapUtils.getDistance(pnt, next);
        if (dist < 15000.0) {
            this.addPoint(ctx, knownMaps, pointsToCheck, pnt);
        } else {
            LatLon mid = MapUtils.calculateMidPoint(pnt, next);
            this.split(ctx, knownMaps, pointsToCheck, pnt, mid);
            this.split(ctx, knownMaps, pointsToCheck, mid, next);
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private boolean isRoadOnlyMap(String regionName) {
        WorldRegion wr;
        if (this.or != null && (wr = this.or.getRegionDataByDownloadName(regionName)) != null) {
            return !wr.isRegionMapDownload() && wr.isRegionRoadsDownload();
        }
        return false;
    }

    private static class RegisteredMap {
        BinaryMapIndexReader reader;
        boolean standard;
        long edition;
        String downloadName;

        private RegisteredMap() {
        }
    }

    private static class Point {
        List<String> regions;
        long[] hhEditions;
        TreeSet<Long> editionsUnique;

        private Point() {
        }
    }
}

