/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.osm.edit.Entity;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.HHRoutingPreparationDB;
import net.osmand.router.HHRoutingPrepareContext;
import net.osmand.router.HHRoutingUtilities;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RoutingContext;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class HHRoutingSubGraphCreator {
    static final Log LOG = PlatformUtil.getLog(HHRoutingSubGraphCreator.class);
    static int DEBUG_STORE_ALL_ROADS = 0;
    static int DEBUG_LIMIT_START_OFFSET = 0;
    static int DEBUG_LIMIT_PROCESS = -1;
    static int DEBUG_VERBOSE_LEVEL = 0;
    static final double OVERLAP_FOR_VISITED = 0.2;
    static final double OVERLAP_FOR_ROUTING = 2.0;
    static final int LONG_DISTANCE_SEGMENTS_SPLIT = 100000;
    protected static LatLon EX1 = new LatLon(52.3201813, 4.7644685);
    protected static LatLon EX2 = new LatLon(52.33265, 4.77738);
    protected static LatLon EX3 = new LatLon(52.2728791, 4.8064803);
    protected static LatLon EX4 = new LatLon(52.27757, 4.85731);
    protected static LatLon EX5 = new LatLon(42.78725, 18.95036);
    protected static LatLon EX6 = new LatLon(42.42385, 19.261171);
    protected static LatLon EX7 = new LatLon(42.527111, 19.43255);
    protected static LatLon EX8 = new LatLon(42.105892, 19.089802);
    protected static LatLon EX9 = new LatLon(42.306454, 18.804703);
    protected static LatLon EX10 = new LatLon(42.10768, 19.103357);
    protected static LatLon EX11 = new LatLon(42.31288, 19.275553);
    protected static LatLon EX12 = new LatLon(32.919117, -96.96761);
    protected static LatLon[] EX = new LatLon[0];
    static int TOTAL_MAX_POINTS = 50000;
    static int TOTAL_MIN_POINTS = 1000;
    static boolean ALG_BY_DEPTH_REACH_POINTS = true;
    static int ALG_BY_DEPTH_MINMAX_DIFF = 10;
    static boolean CLEAN = false;
    static String ROUTING_PROFILE = "car";
    static String ROUTING_PARAMS = "allow_private";

    private static File testData() {
        DEBUG_VERBOSE_LEVEL = 1;
        DEBUG_STORE_ALL_ROADS = 1;
        CLEAN = false;
        String name = "Montenegro_europe_2.road.obf";
        return new File(System.getProperty("maps.dir"), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CLEAN = false;
        boolean onlymerge = false;
        File obfFile = args.length == 0 ? HHRoutingSubGraphCreator.testData() : new File(args[0]);
        for (String a : args) {
            if (a.startsWith("--routing_profile=")) {
                ROUTING_PROFILE = a.substring("--routing_profile=".length());
                continue;
            }
            if (a.startsWith("--routing_params=")) {
                ROUTING_PARAMS = a.substring("--routing_params=".length());
                continue;
            }
            if (a.equals("--network_by_depth")) {
                ALG_BY_DEPTH_REACH_POINTS = true;
                continue;
            }
            if (a.equals("--network_by_limits")) {
                ALG_BY_DEPTH_REACH_POINTS = false;
                continue;
            }
            if (a.equals("--clean")) {
                CLEAN = true;
                continue;
            }
            if (a.equals("--merge")) {
                onlymerge = true;
                continue;
            }
            if (a.equals("--debug")) {
                DEBUG_VERBOSE_LEVEL = 1;
                DEBUG_STORE_ALL_ROADS = 1;
                continue;
            }
            if (a.equals("--debug2")) {
                DEBUG_VERBOSE_LEVEL = 2;
                DEBUG_STORE_ALL_ROADS = 2;
                continue;
            }
            if (!a.equals("--debug3")) continue;
            DEBUG_VERBOSE_LEVEL = 3;
            DEBUG_STORE_ALL_ROADS = 3;
        }
        Object name = new File(".").getCanonicalFile().getName();
        if (args.length == 0) {
            File dir = HHRoutingSubGraphCreator.testData();
            if (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
            name = dir.getAbsolutePath() + "/" + HHRoutingSubGraphCreator.testData().getCanonicalFile().getName();
        }
        name = (String)name + "_" + ROUTING_PROFILE;
        File dbFile = new File((String)name + ".hhdb");
        if (CLEAN && dbFile.exists()) {
            dbFile.delete();
        }
        HHRoutingSubGraphCreator proc = new HHRoutingSubGraphCreator();
        HHRoutingPreparationDB networkDB = new HHRoutingPreparationDB(dbFile);
        HHRoutingPrepareContext prepareContext = new HHRoutingPrepareContext(obfFile, ROUTING_PROFILE, ROUTING_PARAMS);
        NetworkCollectPointCtx ctx = new NetworkCollectPointCtx(prepareContext, networkDB);
        try {
            ctx.networkDB.loadNetworkPoints(ctx.networkPointToDbInd);
            ctx.longRoads = ctx.networkDB.loadNetworkLongRoads();
            if (onlymerge) {
                proc.mergeConnectedPoints(ctx);
            } else {
                proc.collectNetworkPoints(ctx);
            }
            TLongObjectHashMap totalPnts = networkDB.loadNetworkPoints((short)0, HHRouteDataStructure.NetworkDBPoint.class);
            HHRoutingSubGraphCreator.createOSMNetworkPoints(new File((String)name + "-pnts.osm"), (TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint>)totalPnts);
            System.out.printf("Profile has %,d points\n", totalPnts.size());
        }
        finally {
            if (ctx.visualClusters.size() > 0) {
                HHRoutingUtilities.saveOsmFile(HHRoutingUtilities.visualizeClusters(ctx.visualClusters), new File((String)name + ".osm"));
            }
            networkDB.close();
        }
    }

    public static void createOSMNetworkPoints(File osm, TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint> pnts) throws XMLStreamException, IOException {
        TLongObjectHashMap osmObjects = new TLongObjectHashMap();
        for (HHRouteDataStructure.NetworkDBPoint p : pnts.valueCollection()) {
            HHRoutingUtilities.addNode((TLongObjectHashMap<Entity>)osmObjects, p, null, "highway", "stop");
        }
        HHRoutingUtilities.saveOsmFile(osmObjects.valueCollection(), osm);
    }

    private int compareRect(QuadRect q1, QuadRect q2) {
        int x1 = (int)MapUtils.getTileNumberX((float)6.0f, (double)q1.left);
        int y1 = (int)MapUtils.getTileNumberY((float)6.0f, (double)q1.top);
        int x2 = (int)MapUtils.getTileNumberX((float)6.0f, (double)q2.left);
        int y2 = (int)MapUtils.getTileNumberY((float)6.0f, (double)q2.top);
        if (Integer.compare(x1, x2) != 0) {
            return Integer.compare(x1, x2);
        }
        if (Integer.compare(y1, y2) != 0) {
            return Integer.compare(y1, y2);
        }
        return 0;
    }

    private NetworkCollectPointCtx collectNetworkPoints(NetworkCollectPointCtx ctx) throws IOException, SQLException {
        if (EX != null && EX.length > 0) {
            DEBUG_STORE_ALL_ROADS = 3;
            RoutePlannerFrontEnd router = new RoutePlannerFrontEnd();
            for (LatLon l : EX) {
                BinaryRoutePlanner.RouteSegmentPoint pnt = router.findRouteSegment(l.getLatitude(), l.getLongitude(), ctx.rctx, null);
                NetworkIsland cluster = this.buildRoadNetworkIsland(ctx, pnt);
                ctx.addCluster(cluster);
            }
            return ctx;
        }
        TreeSet<String> routeRegionNames = new TreeSet<String>();
        for (BinaryMapRouteReaderAdapter.RouteRegion r : ctx.rctx.reverseMap.keySet()) {
            if (routeRegionNames.add(r.getName())) {
                HHRoutingPreparationDB.NetworkRouteRegion reg = new HHRoutingPreparationDB.NetworkRouteRegion(r, ((BinaryMapIndexReader)ctx.rctx.reverseMap.get(r)).getFile(), null);
                ctx.routeRegions.add(reg);
                continue;
            }
            HHRoutingUtilities.logf("Ignore route region %s as duplicate", r.getName());
        }
        Collections.sort(ctx.routeRegions, new Comparator<HHRoutingPreparationDB.NetworkRouteRegion>(){

            @Override
            public int compare(HHRoutingPreparationDB.NetworkRouteRegion o1, HHRoutingPreparationDB.NetworkRouteRegion o2) {
                int c = HHRoutingSubGraphCreator.this.compareRect(o1.rect, o2.rect);
                if (c != 0) {
                    return c;
                }
                return Long.compare(o1.region.getLength(), o2.region.getLength());
            }
        });
        ctx.networkDB.insertRegions(ctx.routeRegions);
        int procInd = 0;
        for (HHRoutingPreparationDB.NetworkRouteRegion nrouteRegion : ctx.routeRegions) {
            System.out.println("------------------------");
            HHRoutingUtilities.logf("Region bbox %s %d of %d (l,t - r,b): %.5f, %.5f x %.5f, %.5f", nrouteRegion.region.getName(), ++procInd, ctx.routeRegions.size(), nrouteRegion.rect.left, nrouteRegion.rect.top, nrouteRegion.rect.right, nrouteRegion.rect.bottom);
            if (ctx.networkDB.hasVisitedPoints(nrouteRegion)) {
                System.out.println("Already processed");
                continue;
            }
            if (nrouteRegion.region.getLeftLongitude() > nrouteRegion.region.getRightLongitude()) {
                if (nrouteRegion.region.getLength() < 1000L) {
                    System.out.printf("Skip region  %s - %d bytes\n", nrouteRegion.region.getName(), nrouteRegion.region.getLength());
                    continue;
                }
                throw new IllegalStateException();
            }
            double overlapBbox = 2.0;
            boolean notProcessed = true;
            while (notProcessed) {
                ctx.startRegionProcess(nrouteRegion, overlapBbox);
                BinaryMapRouteReaderAdapter.RouteRegion routeRegion = null;
                for (BinaryMapRouteReaderAdapter.RouteRegion rr : ctx.rctx.reverseMap.keySet()) {
                    if (rr.getFilePointer() != nrouteRegion.region.getFilePointer() || !nrouteRegion.region.getName().equals(rr.getName())) continue;
                    routeRegion = rr;
                    break;
                }
                BinaryMapIndexReader reader = (BinaryMapIndexReader)ctx.rctx.reverseMap.get(routeRegion);
                HHRoutingUtilities.logf("Region %s %d of %d %s", nrouteRegion.region.getName(), procInd, ctx.routeRegions.size(), new Date().toString());
                List regions = reader.searchRouteIndexTree(BinaryMapIndexReader.buildSearchRequest((int)MapUtils.get31TileNumberX((double)nrouteRegion.region.getLeftLongitude()), (int)MapUtils.get31TileNumberX((double)nrouteRegion.region.getRightLongitude()), (int)MapUtils.get31TileNumberY((double)nrouteRegion.region.getTopLatitude()), (int)MapUtils.get31TileNumberY((double)nrouteRegion.region.getBottomLatitude()), (int)16, null), routeRegion.getSubregions());
                long estimatedRoads = 1L + routeRegion.getLength() / 150L;
                RouteDataObjectProcessor proc = new RouteDataObjectProcessor(ctx, estimatedRoads);
                reader.loadRouteIndexData(regions, (ResultMatcher)proc);
                boolean ok = ctx.finishRegionProcess(overlapBbox);
                if (!ok) {
                    overlapBbox *= 2.0;
                    ctx.networkDB.cleanupRegionForReprocessing(nrouteRegion, ctx.networkPointToDbInd, ctx.longRoads);
                } else {
                    notProcessed = false;
                }
                ctx.printStatsNetworks();
            }
        }
        if (ctx.longRoads.size() > 0) {
            this.processLongRoads(ctx);
        }
        this.mergeConnectedPoints(ctx);
        return ctx;
    }

    private void processLongRoads(NetworkCollectPointCtx ctx) throws IOException, SQLException {
        int size = ctx.longRoads.size();
        if (size == 0) {
            return;
        }
        ctx.checkLongRoads = false;
        for (HHRoutingPreparationDB.NetworkLongRoad l : ctx.longRoads) {
            l.addConnected(ctx.longRoads);
        }
        ArrayList<LongRoadGroup> connectedGroups = new ArrayList<LongRoadGroup>();
        while (!ctx.longRoads.isEmpty()) {
            LongRoadGroup group = new LongRoadGroup();
            HHRoutingPreparationDB.NetworkLongRoad r = ctx.longRoads.get(0);
            LinkedList<HHRoutingPreparationDB.NetworkLongRoad> queue = new LinkedList<HHRoutingPreparationDB.NetworkLongRoad>();
            queue.add(r);
            while (!queue.isEmpty()) {
                HHRoutingPreparationDB.NetworkLongRoad l = (HHRoutingPreparationDB.NetworkLongRoad)queue.poll();
                boolean add = group.set.add(l);
                if (!add) continue;
                queue.addAll(l.connected);
            }
            Iterator<HHRoutingPreparationDB.NetworkLongRoad> it = ctx.longRoads.iterator();
            while (it.hasNext()) {
                if (!group.set.contains(it.next())) continue;
                it.remove();
            }
            for (HHRoutingPreparationDB.NetworkLongRoad o : group.set) {
                QuadRect t = o.getQuadRect();
                group.r = HHRoutingUtilities.expandLatLonRect(group.r, t.left, t.top, t.right, t.bottom);
            }
            connectedGroups.add(group);
        }
        Collections.sort(connectedGroups, new Comparator<LongRoadGroup>(){

            @Override
            public int compare(LongRoadGroup o1, LongRoadGroup o2) {
                int c = HHRoutingSubGraphCreator.this.compareRect(o1.r, o2.r);
                if (c != 0) {
                    return c;
                }
                return Integer.compare(o1.set.size(), o2.set.size());
            }
        });
        HHRoutingUtilities.logf("Process long roads %d and %d connected groups...", size, connectedGroups.size());
        int id = -2;
        for (LongRoadGroup group : connectedGroups) {
            HHRoutingPreparationDB.NetworkRouteRegion reg = new HHRoutingPreparationDB.NetworkRouteRegion(null, null, group.r);
            reg.id = id--;
            if (ctx.networkDB.hasVisitedPoints(reg)) continue;
            HHRoutingUtilities.logf("Group %d [%s] - %s ", reg.id, group.r, group);
            ctx.startRegionProcess(reg, 2.0);
            RouteDataObjectProcessor proc = new RouteDataObjectProcessor(ctx, ctx.longRoads.size());
            for (HHRoutingPreparationDB.NetworkLongRoad o : group.set) {
                RouteDataObject obj = null;
                for (BinaryRoutePlanner.RouteSegment s = ctx.rctx.loadRouteSegment(o.pointsX[o.startIndex], o.pointsY[o.startIndex], 0L); s != null; s = s.getNext()) {
                    if (s.getRoad().getId() != o.roadId) continue;
                    obj = s.getRoad();
                    break;
                }
                if (obj == null) {
                    throw new IllegalStateException(String.format("Not found long road %d (osm %d)", o.roadId, o.roadId / 64L));
                }
                proc.publish(obj);
            }
            ctx.finishRegionProcess(2.0);
        }
        ctx.printStatsNetworks();
    }

    private boolean checkLongRoads(NetworkIsland c, RouteSegmentVertex seg) {
        return c.ctx.checkLongRoads && MapUtils.squareRootDist31((int)seg.getStartPointX(), (int)seg.getStartPointY(), (int)seg.getEndPointX(), (int)seg.getEndPointY()) > 100000.0;
    }

    private NetworkIsland buildRoadNetworkIsland(NetworkCollectPointCtx ctx, BinaryRoutePlanner.RouteSegmentPoint pnt) {
        NetworkIsland c = new NetworkIsland(ctx, (BinaryRoutePlanner.RouteSegment)pnt);
        TLongObjectHashMap existNetworkPoints = new TLongObjectHashMap();
        TIntIntHashMap depthDistr = new TIntIntHashMap();
        int minDepth = 0;
        int maxDepth = ALG_BY_DEPTH_MINMAX_DIFF + 2;
        if (DEBUG_VERBOSE_LEVEL >= 1) {
            HHRoutingUtilities.logf("Cluster %d. %s", ctx.lastClusterInd + 1, pnt);
        }
        c.addSegmentToQueue(c.getVertex((BinaryRoutePlanner.RouteSegment)pnt));
        int maxPoints = 0;
        if (ALG_BY_DEPTH_REACH_POINTS) {
            while (HHRoutingUtilities.distrSum(depthDistr, maxDepth) < TOTAL_MAX_POINTS && c.toVisitVertices.size() > 0) {
                ++maxDepth;
                c.queue.clear();
                for (BinaryRoutePlanner.RouteSegment r : c.toVisitVertices.valueCollection()) {
                    c.queue.add((RouteSegmentVertex)r);
                }
                maxPoints = this.reachAllPoints(c, (TLongObjectHashMap<RouteSegmentVertex>)existNetworkPoints, depthDistr, maxDepth, maxPoints);
            }
            while (minDepth < maxDepth - ALG_BY_DEPTH_MINMAX_DIFF && HHRoutingUtilities.distrSum(depthDistr, minDepth) < TOTAL_MIN_POINTS) {
                ++minDepth;
            }
        } else {
            maxPoints = this.reachAllPoints(c, (TLongObjectHashMap<RouteSegmentVertex>)existNetworkPoints, depthDistr, maxDepth, maxPoints);
        }
        for (RouteSegmentVertex seg : c.toVisitVertices.valueCollection()) {
            if (existNetworkPoints.contains(seg.getId())) {
                throw new IllegalStateException();
            }
            c.loadVertexConnections(seg);
        }
        TLongObjectHashMap edges = new TLongObjectHashMap();
        List<MaxFlowVertex> vertices = this.constructMaxFlowGraph(c.visitedVertices, (TLongObjectHashMap<RouteSegmentVertex>)existNetworkPoints, (TLongObjectHashMap<MaxFlowEdge>)edges);
        List<MaxFlowVertex> sources = this.constructMaxFlowGraph(c.toVisitVertices, (TLongObjectHashMap<RouteSegmentVertex>)existNetworkPoints, (TLongObjectHashMap<MaxFlowEdge>)edges);
        TLongObjectHashMap<RouteSegmentBorderPoint> mincuts = this.findMincutUsingMaxFlow(c, minDepth, sources, vertices, pnt.toString());
        c.clearVisitedPoints((TLongObjectHashMap<RouteSegmentVertex>)existNetworkPoints);
        c.borderVertices = this.recalculateClusterPointsUsingMincut(c, pnt, mincuts);
        for (RouteSegmentVertex v : c.visitedVertices.valueCollection()) {
            c.edgeDistr.adjustOrPutValue(v.connections.size(), 1, 1);
            c.edges += v.connections.size();
        }
        if (DEBUG_VERBOSE_LEVEL >= 1) {
            HHRoutingUtilities.logf("   Borders %d (%,d size ~ %d depth). Flow %d: depth min %d (%,d) <- max %d (%,d).", c.toVisitVertices.size(), c.visitedVertices.size(), HHRoutingUtilities.distrCumKey(depthDistr, c.visitedVertices.size()), mincuts.size(), minDepth, HHRoutingUtilities.distrSum(depthDistr, minDepth), maxDepth, HHRoutingUtilities.distrSum(depthDistr, maxDepth));
        }
        c.clearVisitedPoints((TLongObjectHashMap<RouteSegmentVertex>)existNetworkPoints);
        return c;
    }

    private int reachAllPoints(NetworkIsland c, TLongObjectHashMap<RouteSegmentVertex> existNetworkPoints, TIntIntHashMap depthDistr, int maxDepth, int order) {
        while (!c.queue.isEmpty()) {
            RouteSegmentVertex seg = c.queue.poll();
            seg.order = order++;
            depthDistr.adjustOrPutValue(seg.getDepth(), 1, 1);
            if (c.ctx.testIfNetworkPoint(seg.getId()) || this.checkLongRoads(c, seg)) {
                c.toVisitVertices.remove(seg.getId());
                existNetworkPoints.put(seg.getId(), (Object)seg);
                continue;
            }
            if (ALG_BY_DEPTH_REACH_POINTS ? seg.getDepth() > maxDepth : order > TOTAL_MAX_POINTS) continue;
            this.proceed(c, seg, existNetworkPoints, c.queue);
        }
        return order;
    }

    private List<RouteSegmentBorderPoint> recalculateClusterPointsUsingMincut(NetworkIsland c, BinaryRoutePlanner.RouteSegmentPoint pnt, TLongObjectHashMap<RouteSegmentBorderPoint> mincuts) {
        c.clearQueues();
        c.queue.add(c.getVertex((BinaryRoutePlanner.RouteSegment)pnt));
        ArrayList<RouteSegmentBorderPoint> borderPoints = new ArrayList<RouteSegmentBorderPoint>();
        ArrayList<RouteSegmentBorderPoint> exPoints = new ArrayList<RouteSegmentBorderPoint>();
        int longPoints = 0;
        while (!c.queue.isEmpty()) {
            RouteSegmentVertex ls = c.queue.poll();
            if (mincuts.containsKey(ls.getId())) {
                borderPoints.add((RouteSegmentBorderPoint)mincuts.get(ls.getId()));
                continue;
            }
            if (c.ctx.testIfNetworkPoint(ls.getId())) {
                exPoints.add(RouteSegmentBorderPoint.fromParent(ls));
                continue;
            }
            if (this.checkLongRoads(c, ls)) {
                ++longPoints;
                System.out.println(" Add long point segment " + String.valueOf((Object)ls));
                borderPoints.add(RouteSegmentBorderPoint.fromParent(ls));
                continue;
            }
            this.proceed(c, ls, null, c.queue);
        }
        if (borderPoints.size() + exPoints.size() != c.toVisitVertices.size() || mincuts.size() + longPoints != borderPoints.size()) {
            ArrayList<RouteSegmentBorderPoint> toVisit = new ArrayList<RouteSegmentBorderPoint>();
            for (RouteSegmentVertex b : c.toVisitVertices.valueCollection()) {
                toVisit.add(RouteSegmentBorderPoint.fromParent(b));
            }
            this.print(this.sortPoints(exPoints), "Existing");
            this.print(this.sortPoints(borderPoints), "Mincut reached");
            this.print(this.sortPoints(new ArrayList<RouteSegmentBorderPoint>(mincuts.valueCollection())), "Mincut");
            this.print(this.sortPoints(toVisit), "To Visit");
            String msg = String.format("BUG !! mincut border %d  ( = %d mincut + %d long ) + %d existing pnts != %d graph reached size: %s", borderPoints.size(), mincuts.size(), longPoints, exPoints.size(), c.toVisitVertices.size(), c.startToString);
            if (mincuts.size() + longPoints != borderPoints.size()) {
                System.err.println(msg);
                throw new IllegalStateException(msg);
            }
            throw new IllegalStateException(msg);
        }
        borderPoints.addAll(exPoints);
        return borderPoints;
    }

    private void print(List<RouteSegmentBorderPoint> borderPoints, String prefix) {
        int ind = 0;
        for (RouteSegmentBorderPoint p : borderPoints) {
            System.out.println(prefix + " " + ind++ + " " + String.valueOf(p));
        }
    }

    private List<RouteSegmentBorderPoint> sortPoints(List<RouteSegmentBorderPoint> borderPoints) {
        borderPoints.sort(new Comparator<RouteSegmentBorderPoint>(){

            @Override
            public int compare(RouteSegmentBorderPoint o1, RouteSegmentBorderPoint o2) {
                return Long.compare(o1.roadId, o2.roadId);
            }
        });
        return borderPoints;
    }

    private boolean proceed(NetworkIsland c, RouteSegmentVertex vertex, TLongObjectHashMap<RouteSegmentVertex> existNetworkPoints, PriorityQueue<RouteSegmentVertex> queue) {
        c.toVisitVertices.remove(vertex.getId());
        if (c.testIfVisited(vertex.getId())) {
            throw new IllegalStateException(String.format("%d %s was already locally visited", vertex.getId(), vertex.toString()));
        }
        if (c.ctx.testGlobalVisited(vertex.getId())) {
            throw new IllegalStateException(String.format("%d %s was already globally visited: %s", vertex.getId(), vertex.toString(), c.ctx.globalVisitedMessage(vertex.getId())));
        }
        c.visitedVertices.put(vertex.getId(), (Object)vertex);
        c.loadVertexConnections(vertex);
        float distFromStart = vertex.distanceFromStart + vertex.distSegment() / 2.0f;
        for (RouteSegmentEdge e : vertex.connections) {
            long id = e.t.getId();
            if (c.testIfVisited(id) || c.toVisitVertices.containsKey(id)) continue;
            if (existNetworkPoints != null && !existNetworkPoints.contains(id) && e.t.parentRoute != null) {
                throw new IllegalArgumentException(String.valueOf((Object)e.t) + " parent " + String.valueOf(e.t.parentRoute));
            }
            e.t.parentRoute = vertex;
            e.t.distanceFromStart = distFromStart + e.t.distSegment() / 2.0f;
            c.addSegmentToQueue(e.t);
        }
        return true;
    }

    private TLongObjectHashMap<RouteSegmentBorderPoint> findMincutUsingMaxFlow(NetworkIsland c, int minDepth, List<MaxFlowVertex> sources, List<MaxFlowVertex> vertices, String errorDebug) {
        MaxFlowVertex source = new MaxFlowVertex(null, false);
        for (MaxFlowVertex s : sources) {
            Object edge = new MaxFlowEdge(null);
            ((MaxFlowEdge)edge).s = source;
            ((MaxFlowEdge)edge).t = s;
            source.connections.add((MaxFlowEdge)edge);
            edge = new MaxFlowEdge(null);
            ((MaxFlowEdge)edge).s = s;
            ((MaxFlowEdge)edge).t = source;
            s.connections.add((MaxFlowEdge)edge);
            vertices.add(s);
        }
        vertices.add(source);
        ArrayList<MaxFlowVertex> sinks = new ArrayList<MaxFlowVertex>();
        MaxFlowVertex sink = null;
        block1: do {
            for (MaxFlowVertex rs : vertices) {
                rs.flowParentTemp = null;
            }
            sink = null;
            LinkedList<MaxFlowVertex> queue = new LinkedList<MaxFlowVertex>();
            queue.add(source);
            block3: while (!queue.isEmpty() && sink == null) {
                MaxFlowVertex vert = (MaxFlowVertex)queue.poll();
                for (MaxFlowEdge conn : vert.connections) {
                    boolean isSink;
                    int maxFlow;
                    int n = maxFlow = conn.vertex == null ? Integer.MAX_VALUE : 1;
                    if (conn.t.flowParentTemp != null || conn.flow >= maxFlow) continue;
                    conn.t.flowParentTemp = conn;
                    if (ALG_BY_DEPTH_REACH_POINTS) {
                        isSink = conn.vertex != null && conn.vertex.getDepth() < minDepth;
                    } else {
                        boolean bl = isSink = conn.vertex != null && conn.vertex.order <= TOTAL_MIN_POINTS && conn.vertex.order > 0;
                    }
                    if (isSink) {
                        sink = conn.t;
                        continue block3;
                    }
                    queue.add(conn.t);
                }
            }
            if (sink == null) continue;
            sinks.add(sink);
            MaxFlowVertex p = sink;
            while (true) {
                ++p.flowParentTemp.flow;
                if (p.flowParentTemp.s == source) continue block1;
                --p.flowParentTemp.reverseConnect().flow;
                p = p.flowParentTemp.s;
            }
        } while (sink != null);
        TLongObjectHashMap<RouteSegmentBorderPoint> mincuts = this.calculateMincut(vertices, source, sinks, c.visitedVertices);
        if (sinks.size() != mincuts.size()) {
            String msg = String.format("BUG maxflow %d != %d mincut: %s ", sinks.size(), mincuts.size(), errorDebug);
            System.err.println(msg);
            throw new IllegalStateException(msg);
        }
        return mincuts;
    }

    private List<MaxFlowVertex> constructMaxFlowGraph(TLongObjectHashMap<RouteSegmentVertex> values, TLongObjectHashMap<RouteSegmentVertex> existingVertices, TLongObjectHashMap<MaxFlowEdge> edges) {
        ArrayList<MaxFlowVertex> vertices = new ArrayList<MaxFlowVertex>();
        for (RouteSegmentVertex r : values.valueCollection()) {
            MaxFlowVertex s = null;
            MaxFlowVertex t = null;
            for (RouteSegmentEdge e : r.connections) {
                MaxFlowVertex conn;
                MaxFlowEdge ex = (MaxFlowEdge)edges.get(e.t.cId);
                if (existingVertices.contains(e.t.getId()) || existingVertices.contains(e.s.getId()) || ex == null) continue;
                MaxFlowVertex maxFlowVertex = conn = e.tEnd ? ex.t : ex.s;
                if (e.sEnd) {
                    if (t != null && t != conn) {
                        throw new IllegalStateException(String.valueOf(t) + " != " + String.valueOf(conn));
                    }
                    t = conn;
                    continue;
                }
                if (s != null && s != conn) {
                    throw new IllegalStateException(String.valueOf(s) + " != " + String.valueOf(conn));
                }
                s = conn;
            }
            if (s == null) {
                s = new MaxFlowVertex(r, false);
                vertices.add(s);
            }
            if (t == null) {
                t = new MaxFlowVertex(r, true);
                vertices.add(t);
            }
            MaxFlowEdge newEdge = new MaxFlowEdge(r);
            newEdge.s = s;
            newEdge.t = t;
            s.connections.add(newEdge);
            edges.put(r.cId, (Object)newEdge);
            newEdge = new MaxFlowEdge(r);
            newEdge.s = t;
            newEdge.t = s;
            t.connections.add(newEdge);
        }
        return vertices;
    }

    private TLongObjectHashMap<RouteSegmentBorderPoint> calculateMincut(List<MaxFlowVertex> vertices, MaxFlowVertex source, Collection<MaxFlowVertex> sinks, TLongObjectHashMap<RouteSegmentVertex> visitedVertices) {
        MaxFlowVertex ps;
        for (MaxFlowVertex rs : vertices) {
            rs.flowParentTemp = null;
        }
        TLongObjectHashMap mincuts = new TLongObjectHashMap();
        LinkedList<MaxFlowVertex> queue = new LinkedList<MaxFlowVertex>();
        HashSet<MaxFlowVertex> reachableSource = new HashSet<MaxFlowVertex>();
        queue.add(source);
        if (DEBUG_VERBOSE_LEVEL > 1) {
            for (MaxFlowEdge t : source.connections) {
                MaxFlowVertex sourceL = t.t;
                int flow = 0;
                for (MaxFlowEdge tc : sourceL.connections) {
                    flow += tc.flow;
                }
                if (flow <= 0) continue;
                System.out.printf("-> Source: %s depth %d, flow %d\n", sourceL, sourceL.segment.getDepth(), flow);
            }
            for (MaxFlowVertex s : sinks) {
                System.out.printf("<- Sink: %s depth %d\n", s, s.segment.getDepth());
            }
        }
        reachableSource.add(source);
        while (!queue.isEmpty()) {
            ps = (MaxFlowVertex)queue.poll();
            for (MaxFlowEdge conn : ps.connections) {
                int maxFlow;
                int n = maxFlow = conn.vertex == null ? Integer.MAX_VALUE : 1;
                if (conn.t.flowParentTemp != null || conn.flow >= maxFlow) continue;
                conn.t.flowParentTemp = conn;
                queue.add(conn.t);
                reachableSource.add(conn.t);
            }
        }
        queue = new LinkedList();
        queue.addAll(sinks);
        while (!queue.isEmpty()) {
            ps = (MaxFlowVertex)queue.poll();
            for (MaxFlowEdge conn : ps.connections) {
                if (reachableSource.contains(conn.t)) {
                    MaxFlowEdge c = conn;
                    boolean posDir = c.vertex.getStartPointX() == (c.s.end ? c.s.segment.getEndPointX() : c.s.segment.getStartPointX()) && c.vertex.getStartPointY() == (c.s.end ? c.s.segment.getEndPointY() : c.s.segment.getStartPointY());
                    RouteSegmentBorderPoint borderPnt = new RouteSegmentBorderPoint(c.vertex, posDir);
                    mincuts.put(HHRoutePlanner.calcUniDirRoutePointInternalId((BinaryRoutePlanner.RouteSegment)c.vertex), (Object)borderPnt);
                    if (DEBUG_VERBOSE_LEVEL > 1) {
                        System.out.println("? Mincut " + String.valueOf(c.s) + " -> " + String.valueOf(borderPnt));
                    }
                }
                if (conn.t.flowParentTemp != null) continue;
                conn.t.flowParentTemp = conn;
                queue.add(conn.t);
            }
        }
        return mincuts;
    }

    public void mergeConnectedPoints(NetworkCollectPointCtx ctx) {
        TLongObjectHashMap mp = new TLongObjectHashMap();
        ArrayList lst = new ArrayList(ctx.networkPointToDbInd.valueCollection());
        for (HHRoutingPreparationDB.NetworkBorderPoint p : lst) {
            if (p.positiveObj != null && p.negativeObj == null) {
                this.add(p.positiveObj, (TLongObjectHashMap<List<RouteSegmentBorderPoint>>)mp);
            }
            if (p.negativeObj == null || p.positiveObj != null) continue;
            this.add(p.negativeObj, (TLongObjectHashMap<List<RouteSegmentBorderPoint>>)mp);
        }
        System.out.printf("Check to merge %d points... ", mp.size());
        for (List lstMerge : mp.valueCollection()) {
            if (lstMerge.size() <= 1) continue;
            RouteSegmentBorderPoint f = (RouteSegmentBorderPoint)lstMerge.get(0);
            RouteSegmentBorderPoint s = (RouteSegmentBorderPoint)lstMerge.get(1);
            if (lstMerge.size() == 2) {
                this.simpleMerge(ctx, f, s.clusterDbId, s);
                continue;
            }
            TIntIntHashMap clusters = new TIntIntHashMap();
            for (RouteSegmentBorderPoint p : lstMerge) {
                clusters.adjustOrPutValue(p.clusterDbId, 1, 1);
            }
            ArrayList<RouteSegmentBorderPoint> pointsOfSingleMultiCluster = new ArrayList<RouteSegmentBorderPoint>();
            int multiClusterId = -1;
            for (RouteSegmentBorderPoint p : lstMerge) {
                if (clusters.get(p.clusterDbId) <= 1) continue;
                pointsOfSingleMultiCluster.add(p);
                if (multiClusterId == -1) {
                    multiClusterId = p.clusterDbId;
                    continue;
                }
                if (multiClusterId == p.clusterDbId) continue;
                multiClusterId = -1;
                break;
            }
            if (multiClusterId == -1 && pointsOfSingleMultiCluster.size() == 0) {
                RouteSegmentBorderPoint pnt = (RouteSegmentBorderPoint)lstMerge.get(0);
                pointsOfSingleMultiCluster.add(pnt);
                multiClusterId = pnt.clusterDbId;
            }
            if (multiClusterId != -1) {
                lstMerge.removeAll(pointsOfSingleMultiCluster);
                Object[] pointsOfMultiCluster = pointsOfSingleMultiCluster.toArray(new RouteSegmentBorderPoint[pointsOfSingleMultiCluster.size()]);
                int ind = 0;
                for (RouteSegmentBorderPoint singlePointCluster : lstMerge) {
                    System.out.printf("Complex scenario with [%d] clusters (%s): main point (%d of %d) (%s) merging with lstMerge [%d] (%s)\n", clusters.size(), clusters, ++ind, lstMerge.size(), singlePointCluster, pointsOfMultiCluster.length, Arrays.toString(pointsOfMultiCluster));
                    this.simpleMerge(ctx, singlePointCluster, multiClusterId, (RouteSegmentBorderPoint[])pointsOfMultiCluster);
                }
                continue;
            }
            String msg = String.format("Can't merge points %s", lstMerge);
            throw new IllegalArgumentException(msg);
        }
    }

    private void add(RouteSegmentBorderPoint po, TLongObjectHashMap<List<RouteSegmentBorderPoint>> mp) {
        long epnt = Algorithms.combine2Points((int)po.ex, (int)po.ey);
        if (!mp.containsKey(epnt)) {
            mp.put(epnt, new ArrayList());
        }
        ((List)mp.get(epnt)).add(po);
    }

    private void simpleMerge(NetworkCollectPointCtx ctx, RouteSegmentBorderPoint main, int clusterOppId, RouteSegmentBorderPoint ... toMerges) {
        HHRoutingUtilities.logf("MERGE route road %s with %s", main, Arrays.toString(toMerges));
        RouteSegmentBorderPoint newOpp = new RouteSegmentBorderPoint(main.roadId, main.segmentEnd, main.segmentStart, main.ex, main.ey, main.sx, main.sy, main.tagValues);
        if (main.isPositive()) {
            ((HHRoutingPreparationDB.NetworkBorderPoint)ctx.networkPointToDbInd.get((long)main.unidirId)).negativeObj = newOpp;
        } else {
            ((HHRoutingPreparationDB.NetworkBorderPoint)ctx.networkPointToDbInd.get((long)main.unidirId)).positiveObj = newOpp;
        }
        newOpp.clusterDbId = clusterOppId;
        newOpp.inserted = main.inserted;
        newOpp.fileDbId = main.fileDbId;
        ctx.networkDB.mergePoints(main, newOpp);
        for (RouteSegmentBorderPoint toMerge : toMerges) {
            ctx.networkDB.deleteMergePoints(toMerge);
            if (ctx.currentProcessingRegion != null) {
                ctx.currentProcessingRegion.visitedVertices.put(toMerge.unidirId, toMerge.clusterDbId);
            }
            ctx.networkPointToDbInd.remove(toMerge.unidirId);
        }
    }

    private static class NetworkCollectPointCtx {
        HHRoutingPrepareContext prepareContext;
        HHRoutingPreparationDB networkDB;
        NetworkCollectStats stats = new NetworkCollectStats();
        int lastClusterInd = -1;
        RoutingContext rctx;
        List<HHRoutingPreparationDB.NetworkRouteRegion> routeRegions = new ArrayList<HHRoutingPreparationDB.NetworkRouteRegion>();
        List<NetworkIsland> visualClusters = new ArrayList<NetworkIsland>();
        HHRoutingPreparationDB.NetworkRouteRegion currentProcessingRegion;
        TLongObjectHashMap<RouteSegmentVertex> allVerticesCache = new TLongObjectHashMap();
        boolean checkLongRoads = true;
        List<HHRoutingPreparationDB.NetworkLongRoad> longRoads = new ArrayList<HHRoutingPreparationDB.NetworkLongRoad>();
        TLongObjectHashMap<HHRoutingPreparationDB.NetworkBorderPoint> networkPointToDbInd = new TLongObjectHashMap();
        List<HHRoutingPreparationDB.NetworkRouteRegion> validateIntersectionRegions = new ArrayList<HHRoutingPreparationDB.NetworkRouteRegion>();

        public NetworkCollectPointCtx(HHRoutingPrepareContext prepareContext, HHRoutingPreparationDB networkDB) throws IOException {
            this.prepareContext = prepareContext;
            this.rctx = prepareContext.prepareContext(null, null);
            this.networkDB = networkDB;
        }

        public long getTotalPoints() {
            long totalPoints = 0L;
            for (HHRoutingPreparationDB.NetworkRouteRegion r : this.routeRegions) {
                totalPoints += (long)r.getPoints();
            }
            return totalPoints;
        }

        public int borderPointsSize() {
            return this.networkPointToDbInd.size();
        }

        public String globalVisitedMessage(long k) {
            HHRoutingPreparationDB.NetworkRouteRegion r = null;
            if (this.currentProcessingRegion != null && this.currentProcessingRegion.visitedVertices.containsKey(k)) {
                r = this.currentProcessingRegion;
            } else {
                for (HHRoutingPreparationDB.NetworkRouteRegion n : this.validateIntersectionRegions) {
                    if (!n.visitedVertices.containsKey(k)) continue;
                    r = n;
                    break;
                }
            }
            if (r != null) {
                return String.format("%s region %d cluster", r.getName(), r.visitedVertices.get(k));
            }
            return "";
        }

        public boolean testGlobalVisited(long k) {
            if (this.currentProcessingRegion != null && this.currentProcessingRegion.visitedVertices.containsKey(k)) {
                return true;
            }
            for (HHRoutingPreparationDB.NetworkRouteRegion n : this.validateIntersectionRegions) {
                if (!n.visitedVertices.containsKey(k)) continue;
                return true;
            }
            return false;
        }

        public void startRegionProcess(HHRoutingPreparationDB.NetworkRouteRegion nrouteRegion, double overlapBbox) throws IOException, SQLException {
            this.currentProcessingRegion = nrouteRegion;
            this.currentProcessingRegion.visitedVertices = new TLongIntHashMap();
            this.currentProcessingRegion.calcRect = null;
            this.currentProcessingRegion.points = -1;
            this.validateIntersectionRegions = new ArrayList<HHRoutingPreparationDB.NetworkRouteRegion>();
            this.allVerticesCache = new TLongObjectHashMap();
            ArrayList<HHRoutingPreparationDB.NetworkRouteRegion> regionsForRouting = new ArrayList<HHRoutingPreparationDB.NetworkRouteRegion>();
            for (HHRoutingPreparationDB.NetworkRouteRegion nr : this.routeRegions) {
                if (nr == nrouteRegion) continue;
                if (nr.intersects(nrouteRegion, 0.2)) {
                    HHRoutingUtilities.logf("Intersects with %s %s.", nr.getName(), nr.rect.toString());
                    nr.loadVisitedVertices(this.networkDB);
                    this.validateIntersectionRegions.add(nr);
                    regionsForRouting.add(nr);
                    continue;
                }
                if (nr.intersects(nrouteRegion, overlapBbox)) {
                    regionsForRouting.add(nr);
                    continue;
                }
                nr.unload();
            }
            if (nrouteRegion.file != null) {
                regionsForRouting.add(nrouteRegion);
            }
            this.rctx = this.prepareContext.gcMemoryLimitToUnloadAll(this.rctx, regionsForRouting, true);
        }

        public void addCluster(NetworkIsland cluster) {
            this.lastClusterInd = cluster.dbIndex = this.networkDB.prepareBorderPointsToInsert(this.currentProcessingRegion == null ? 0 : this.currentProcessingRegion.id, cluster.borderVertices, this.networkPointToDbInd);
            this.stats.addCluster(cluster);
            if ((double)cluster.visitedVertices.size() > (double)TOTAL_MAX_POINTS * 1.5) {
                throw new IllegalStateException("Cluster " + cluster.dbIndex + " has too many points: " + cluster.visitedVertices.size());
            }
            for (RouteSegmentVertex routeSegmentVertex : cluster.visitedVertices.valueCollection()) {
                if (this.testGlobalVisited(routeSegmentVertex.getId())) {
                    throw new IllegalStateException(String.format("Point was already visited %s: %s", new Object[]{routeSegmentVertex, this.globalVisitedMessage(routeSegmentVertex.getId())}));
                }
                if (this.currentProcessingRegion == null) continue;
                this.currentProcessingRegion.visitedVertices.put(routeSegmentVertex.getId(), cluster.dbIndex);
                this.currentProcessingRegion.updateBbox(routeSegmentVertex.getEndPointX() / 2 + routeSegmentVertex.getStartPointX() / 2, routeSegmentVertex.getEndPointY() / 2 + routeSegmentVertex.getStartPointY() / 2);
            }
            if (DEBUG_STORE_ALL_ROADS > 0) {
                this.visualClusters.add(cluster);
                if (DEBUG_STORE_ALL_ROADS <= 2) {
                    long[] keys;
                    for (long k : keys = cluster.visitedVertices.keys()) {
                        cluster.visitedVertices.put(k, null);
                    }
                }
                if (DEBUG_STORE_ALL_ROADS > 1) {
                    cluster.visualBorders = new TLongObjectHashMap();
                    for (RouteSegmentVertex routeSegmentVertex : cluster.toVisitVertices.valueCollection()) {
                        ArrayList<LatLon> l = new ArrayList<LatLon>();
                        RouteSegmentVertex par = routeSegmentVertex;
                        while (par != null) {
                            l.add(HHRoutingUtilities.getPoint(par));
                            par = par.parentRoute;
                        }
                        cluster.visualBorders.put(routeSegmentVertex.cId, l);
                    }
                }
                cluster.toVisitVertices = null;
                cluster.queue = null;
            }
        }

        public boolean finishRegionProcess(double overlapBbox) throws SQLException {
            HHRoutingUtilities.logf("Tiles " + String.valueOf(this.rctx.calculationProgress.getInfo(null).get("tiles")), new Object[0]);
            QuadRect c = this.currentProcessingRegion.getCalcBbox();
            QuadRect r = this.currentProcessingRegion.rect;
            if (c.left < r.left || c.top > r.top || c.bottom < r.bottom || c.right > r.right) {
                QuadRect n = new QuadRect(Math.min(c.left, r.left), Math.max(c.top, r.top), Math.max(c.right, r.right), Math.min(c.bottom, r.bottom));
                System.out.printf("Updating bbox (L T R B) for %s from [%.3f, %.3f] x [%.3f, %.3f] add   [%.3f, %.3f] x [%.3f, %.3f] to [%.3f, %.3f] x [%.3f, %.3f]\n", this.currentProcessingRegion.getName(), r.left, r.top, r.right, r.bottom, c.left, c.top, c.right, c.bottom, n.left, n.top, n.right, n.bottom);
                if (Math.abs(n.left - r.left) > overlapBbox || Math.abs(n.right - r.right) > overlapBbox || Math.abs(n.top - r.top) > overlapBbox || Math.abs(n.bottom - r.bottom) > overlapBbox) {
                    System.err.println("BBOX is out of range for routing");
                    return false;
                }
                this.currentProcessingRegion.rect = n;
            }
            int ins = 0;
            int tl = 0;
            for (HHRoutingPreparationDB.NetworkBorderPoint npnt : this.networkPointToDbInd.valueCollection()) {
                if (npnt.positiveObj != null) {
                    if (!npnt.positiveObj.inserted) {
                        ++ins;
                    }
                    ++tl;
                }
                if (npnt.negativeObj == null) continue;
                if (!npnt.negativeObj.inserted) {
                    ++ins;
                }
                ++tl;
            }
            HHRoutingUtilities.logf("Saving visited %,d points (%,d border points) from %s to db...", this.currentProcessingRegion.getPoints(), ins, this.currentProcessingRegion.getName());
            this.networkDB.insertProcessedRegion(this.currentProcessingRegion, this.networkPointToDbInd, this.longRoads);
            HHRoutingUtilities.logf("     saved - total %,d points (%,d border points), ", this.getTotalPoints(), tl);
            this.currentProcessingRegion.unload();
            this.currentProcessingRegion = null;
            return true;
        }

        public boolean testIfNetworkPoint(long pntId) {
            return this.networkPointToDbInd.contains(pntId);
        }

        public void printStatsNetworks() {
            this.stats.printStatsNetworks(this.getTotalPoints(), this.lastClusterInd);
        }
    }

    class NetworkIsland {
        final LatLon startLatLon;
        final String startToString;
        final NetworkCollectPointCtx ctx;
        int dbIndex;
        int edges = 0;
        TIntIntHashMap edgeDistr = new TIntIntHashMap();
        PriorityQueue<RouteSegmentVertex> queue;
        TLongObjectHashMap<RouteSegmentVertex> visitedVertices = new TLongObjectHashMap();
        TLongObjectHashMap<RouteSegmentVertex> toVisitVertices = new TLongObjectHashMap();
        List<RouteSegmentBorderPoint> borderVertices;
        TLongObjectHashMap<List<LatLon>> visualBorders = null;

        NetworkIsland(NetworkCollectPointCtx ctx, BinaryRoutePlanner.RouteSegment start) {
            this.ctx = ctx;
            this.startLatLon = HHRoutingUtilities.getPoint(start);
            this.startToString = start.getRoad().getId() / 64L + " " + start.getSegmentStart() + " " + start.getSegmentEnd();
            this.queue = new PriorityQueue<BinaryRoutePlanner.RouteSegment>(new Comparator<BinaryRoutePlanner.RouteSegment>(){

                @Override
                public int compare(BinaryRoutePlanner.RouteSegment o1, BinaryRoutePlanner.RouteSegment o2) {
                    return Double.compare(o1.distanceFromStart, o2.distanceFromStart);
                }
            });
        }

        public RouteSegmentVertex getVertex(BinaryRoutePlanner.RouteSegment s) {
            if (s == null) {
                return null;
            }
            long p = HHRoutePlanner.calcUniDirRoutePointInternalId((BinaryRoutePlanner.RouteSegment)s);
            RouteSegmentVertex routeSegment = (RouteSegmentVertex)((Object)this.ctx.allVerticesCache.get(p));
            if (routeSegment == null) {
                routeSegment = new RouteSegmentVertex(HHRoutingUtilities.makePositiveDir(s));
                this.ctx.allVerticesCache.put(p, (Object)routeSegment);
            }
            return routeSegment;
        }

        public void loadVertexConnections(RouteSegmentVertex segment) {
            if (!segment.connections.isEmpty()) {
                return;
            }
            this.loadVertexConnections(segment, true);
            this.loadVertexConnections(segment, false);
        }

        void loadVertexConnections(RouteSegmentVertex segment, boolean end) {
            short segmentInd = end ? segment.getSegmentEnd() : segment.getSegmentStart();
            int x = segment.getRoad().getPoint31XTile((int)segmentInd);
            int y = segment.getRoad().getPoint31YTile((int)segmentInd);
            for (BinaryRoutePlanner.RouteSegment next = this.ctx.rctx.loadRouteSegment(x, y, 0L); next != null; next = next.getNext()) {
                segment.addConnection(end, this.getVertex(next));
                segment.addConnection(end, this.getVertex(next.initRouteSegment(!next.isPositive())));
            }
        }

        private NetworkIsland addSegmentToQueue(RouteSegmentVertex s) {
            this.queue.add(s);
            this.toVisitVertices.put(s.getId(), (Object)s);
            return this;
        }

        public boolean testIfVisited(long pntId) {
            return this.visitedVertices.containsKey(pntId);
        }

        public void clearVisitedPoints(TLongObjectHashMap<RouteSegmentVertex> existNetworkPoints) {
            for (RouteSegmentVertex v : this.visitedVertices.valueCollection()) {
                v.clearPoint();
            }
            for (RouteSegmentVertex v : this.toVisitVertices.valueCollection()) {
                v.clearPoint();
            }
            for (RouteSegmentVertex v : existNetworkPoints.valueCollection()) {
                v.clearPoint();
            }
        }

        public void clearQueues() {
            this.visitedVertices.clear();
            this.toVisitVertices.clear();
            this.queue.clear();
        }
    }

    private class RouteDataObjectProcessor
    implements ResultMatcher<RouteDataObject> {
        int indProc = 0;
        int prevPrintInd = 0;
        private float estimatedRoads;
        private NetworkCollectPointCtx ctx;

        public RouteDataObjectProcessor(NetworkCollectPointCtx ctx, float estimatedRoads) {
            this.estimatedRoads = estimatedRoads;
            this.ctx = ctx;
        }

        public boolean publish(RouteDataObject object) {
            if (!this.ctx.rctx.getRouter().acceptLine(object)) {
                return false;
            }
            ++this.indProc;
            if (this.indProc < DEBUG_LIMIT_START_OFFSET || this.isCancelled()) {
                System.out.println("SKIP PROCESS " + this.indProc);
            } else {
                int pos;
                for (pos = 0; pos < object.getPointsLength() - 1 && this.ctx.checkLongRoads; ++pos) {
                    double dst = this.segmentDist(object, pos, pos + 1);
                    if (!(dst > 100000.0)) continue;
                    String msg = String.format("Skip long road to process later %s (length %d) %d <-> %d - %.1f", object, object.getPointsLength(), pos, pos + 1, dst / 1000.0);
                    System.out.println(msg);
                    this.ctx.longRoads.add(new HHRoutingPreparationDB.NetworkLongRoad(object.getId(), pos, object.pointsX, object.pointsY));
                    return false;
                }
                for (pos = 0; pos < object.getPointsLength() - 1; ++pos) {
                    BinaryRoutePlanner.RouteSegmentPoint pntAround = new BinaryRoutePlanner.RouteSegmentPoint(object, pos, 0.0);
                    long mainPoint = HHRoutePlanner.calcUniDirRoutePointInternalId((BinaryRoutePlanner.RouteSegment)pntAround);
                    if (this.ctx.testGlobalVisited(mainPoint) || this.ctx.networkPointToDbInd.containsKey(mainPoint)) continue;
                    NetworkIsland cluster = HHRoutingSubGraphCreator.this.buildRoadNetworkIsland(this.ctx, pntAround);
                    this.ctx.addCluster(cluster);
                    if (DEBUG_VERBOSE_LEVEL < 1 && this.indProc - this.prevPrintInd <= 1000) continue;
                    this.prevPrintInd = this.indProc;
                    int borderPointsSize = this.ctx.borderPointsSize();
                    HHRoutingUtilities.logf("Progress %.2f%%: all %,d points -> %,d border points, %,d clusters", Float.valueOf((float)this.indProc * 100.0f / this.estimatedRoads), this.ctx.getTotalPoints() + (long)borderPointsSize, borderPointsSize, this.ctx.lastClusterInd);
                }
            }
            return false;
        }

        private double segmentDist(RouteDataObject object, int pos, int next) {
            return MapUtils.squareRootDist31((int)object.getPoint31XTile(pos), (int)object.getPoint31YTile(pos), (int)object.getPoint31XTile(next), (int)object.getPoint31YTile(next));
        }

        public boolean isCancelled() {
            return DEBUG_LIMIT_PROCESS != -1 && this.indProc >= DEBUG_LIMIT_PROCESS;
        }
    }

    class LongRoadGroup {
        QuadRect r;
        Set<HHRoutingPreparationDB.NetworkLongRoad> set = new LinkedHashSet<HHRoutingPreparationDB.NetworkLongRoad>();

        LongRoadGroup() {
        }

        public String toString() {
            return this.set.toString();
        }
    }

    class RouteSegmentVertex
    extends BinaryRoutePlanner.RouteSegment {
        public List<RouteSegmentEdge> connections;
        public int cDepth;
        public final long cId;
        public int order;

        public RouteSegmentVertex(BinaryRoutePlanner.RouteSegment s) {
            super(s.getRoad(), (int)s.getSegmentStart(), (int)s.getSegmentEnd());
            this.connections = new ArrayList<RouteSegmentEdge>();
            this.order = 0;
            this.cId = HHRoutePlanner.calcUniDirRoutePointInternalId((BinaryRoutePlanner.RouteSegment)this);
        }

        public RouteSegmentVertex() {
            super(null, 0, 0);
            this.connections = new ArrayList<RouteSegmentEdge>();
            this.order = 0;
            this.cId = 0L;
        }

        public long getId() {
            return this.cId;
        }

        public void removeConnection(RouteSegmentVertex pos) {
            Iterator<RouteSegmentEdge> it = this.connections.iterator();
            while (it.hasNext()) {
                RouteSegmentEdge e = it.next();
                if (e.t != pos) continue;
                it.remove();
                break;
            }
        }

        public void addConnection(boolean sEnd, RouteSegmentVertex t) {
            if (t != this && t != null) {
                boolean tEnd = t.getEndPointX() == (sEnd ? this.getEndPointX() : this.getStartPointX()) && t.getEndPointY() == (sEnd ? this.getEndPointY() : this.getStartPointY());
                this.connections.add(new RouteSegmentEdge(this, sEnd, t, tEnd));
            }
        }

        public int getDepth() {
            if (this.cDepth == 0) {
                this.cDepth = super.getDepth();
            }
            return this.cDepth;
        }

        public float distSegment() {
            RouteSegmentVertex segment = this;
            int prevX = segment.getRoad().getPoint31XTile((int)segment.getSegmentStart());
            int prevY = segment.getRoad().getPoint31YTile((int)segment.getSegmentStart());
            int x = segment.getRoad().getPoint31XTile((int)segment.getSegmentEnd());
            int y = segment.getRoad().getPoint31YTile((int)segment.getSegmentEnd());
            return (float)MapUtils.squareRootDist31((int)x, (int)y, (int)prevX, (int)prevY);
        }

        public RouteSegmentEdge getConnection(RouteSegmentVertex t) {
            for (RouteSegmentEdge c : this.connections) {
                if (c.t != t) continue;
                return c;
            }
            return null;
        }

        public void clearPoint() {
            this.distanceFromStart = 0.0f;
            this.cDepth = 0;
            this.parentRoute = null;
        }
    }

    static class RouteSegmentBorderPoint {
        public final long unidirId;
        public final long uniqueId;
        public final int segmentStart;
        public final int segmentEnd;
        public final long roadId;
        public final int sx;
        public final int sy;
        public final int ex;
        public final int ey;
        public int pointDbId;
        public int clusterDbId;
        public int fileDbId;
        public boolean inserted;
        public String[] tagValues;

        public RouteSegmentBorderPoint(BinaryRoutePlanner.RouteSegment s, boolean dir) {
            this.segmentStart = dir ? s.getSegmentStart() : s.getSegmentEnd();
            this.segmentEnd = dir ? s.getSegmentEnd() : s.getSegmentStart();
            this.roadId = s.getRoad().getId();
            this.sx = dir ? s.getStartPointX() : s.getEndPointX();
            this.sy = dir ? s.getStartPointY() : s.getEndPointY();
            this.ex = !dir ? s.getStartPointX() : s.getEndPointX();
            this.ey = !dir ? s.getStartPointY() : s.getEndPointY();
            this.unidirId = this.uniId();
            this.uniqueId = this.uniqueId();
            int[] tps = s.getRoad().getTypes();
            if (tps != null) {
                this.tagValues = new String[tps.length * 2];
                for (int i = 0; i < tps.length; ++i) {
                    BinaryMapRouteReaderAdapter.RouteTypeRule rtr = s.getRoad().region.quickGetEncodingRule(tps[i]);
                    this.tagValues[2 * i] = rtr.getTag();
                    this.tagValues[2 * i + 1] = rtr.getValue();
                }
            }
        }

        public RouteSegmentBorderPoint(long roadId, int st, int end, int sx, int sy, int ex, int ey, String[] tagValues) {
            this.roadId = roadId;
            this.segmentStart = st;
            this.segmentEnd = end;
            this.sx = sx;
            this.sy = sy;
            this.ex = ex;
            this.ey = ey;
            this.unidirId = this.uniId();
            this.uniqueId = this.uniqueId();
            this.tagValues = tagValues;
            this.inserted = true;
        }

        private long uniqueId() {
            return HHRoutePlanner.calculateRoutePointInternalId((long)this.roadId, (int)this.segmentStart, (int)this.segmentEnd);
        }

        private long uniId() {
            return HHRoutePlanner.calculateRoutePointInternalId((long)this.roadId, (int)Math.min(this.segmentStart, this.segmentEnd), (int)Math.max(this.segmentStart, this.segmentEnd));
        }

        public static RouteSegmentBorderPoint fromParent(BinaryRoutePlanner.RouteSegment ls) {
            boolean pos = ls.parentRoute.getEndPointX() == ls.getStartPointX() && ls.parentRoute.getEndPointY() == ls.getStartPointY() || ls.parentRoute.getStartPointX() == ls.getStartPointX() && ls.parentRoute.getStartPointY() == ls.getStartPointY();
            return new RouteSegmentBorderPoint(ls, pos);
        }

        public boolean isPositive() {
            return this.segmentStart < this.segmentEnd;
        }

        public String toString() {
            return String.format("Border point db %d (cluster %d), road %d [%d - %d]", this.pointDbId, this.clusterDbId, this.roadId / 64L, this.segmentStart, this.segmentEnd);
        }
    }

    class RouteSegmentEdge {
        RouteSegmentVertex s;
        boolean sEnd;
        RouteSegmentVertex t;
        boolean tEnd;

        RouteSegmentEdge(RouteSegmentVertex s, boolean sEnd, RouteSegmentVertex t, boolean tEnd) {
            this.s = s;
            this.sEnd = sEnd;
            this.t = t;
            this.tEnd = tEnd;
        }

        public String toString() {
            return String.format("%s (%s) -> %s (%s)", new Object[]{this.s, this.sEnd, this.t, this.tEnd});
        }
    }

    private class MaxFlowVertex {
        List<MaxFlowEdge> connections = new ArrayList<MaxFlowEdge>();
        RouteSegmentVertex segment;
        boolean end;
        MaxFlowEdge flowParentTemp;

        public MaxFlowVertex(RouteSegmentVertex e, boolean end) {
            this.segment = e;
            this.end = end;
        }

        public String toString() {
            if (this.segment == null) {
                return "Null vertex";
            }
            return String.valueOf(this.segment.getRoad()) + " [" + (this.end ? this.segment.getSegmentEnd() : this.segment.getSegmentStart()) + "]";
        }
    }

    private class MaxFlowEdge {
        RouteSegmentVertex vertex;
        MaxFlowVertex s;
        MaxFlowVertex t;
        int flow;

        MaxFlowEdge(RouteSegmentVertex v) {
            this.vertex = v;
        }

        public String toString() {
            return String.valueOf(this.s) + " -> " + String.valueOf(this.t);
        }

        public MaxFlowEdge reverseConnect() {
            for (MaxFlowEdge r : this.t.connections) {
                if (r.t != this.s) continue;
                return r;
            }
            throw new IllegalArgumentException("No reverse connection: " + String.valueOf(this));
        }
    }

    private static class NetworkCollectStats {
        int totalBorderPoints = 0;
        TIntIntHashMap borderPntsDistr = new TIntIntHashMap();
        TLongIntHashMap borderPntsCluster = new TLongIntHashMap();
        TIntIntHashMap pntsDistr = new TIntIntHashMap();
        TIntIntHashMap edgesDistr = new TIntIntHashMap();
        long edges;
        int isolatedIslands = 0;
        int toMergeIslands = 0;
        int shortcuts = 0;

        private NetworkCollectStats() {
        }

        public void printStatsNetworks(long totalPoints, int clusterSize) {
            int borderPointsSize = this.borderPntsCluster.size();
            TIntIntHashMap borderClusterDistr = new TIntIntHashMap();
            for (int a : this.borderPntsCluster.values()) {
                borderClusterDistr.adjustOrPutValue(a, 1, 1);
            }
            HHRoutingUtilities.logf("RESULT %,d points (%,d edges) -> %,d border points, %,d clusters + %,d isolated + %d to merge, %,d est shortcuts (%s edges distr) \n", totalPoints + (long)borderPointsSize, this.edges / 2L, borderPointsSize, clusterSize - this.isolatedIslands - this.toMergeIslands, this.isolatedIslands, this.toMergeIslands, this.shortcuts, HHRoutingUtilities.distrString(this.edgesDistr, ""));
            System.out.printf("       %.1f avg (%s) border points per cluster \n       %s - shared border points between clusters \n       %.1f avg (%s) points in cluster \n", (double)this.totalBorderPoints * 1.0 / (double)clusterSize, HHRoutingUtilities.distrString(this.borderPntsDistr, ""), HHRoutingUtilities.distrString(borderClusterDistr, ""), (double)totalPoints * 1.0 / (double)clusterSize, HHRoutingUtilities.distrString(this.pntsDistr, "K"));
        }

        public void addCluster(NetworkIsland cluster) {
            for (long k : cluster.toVisitVertices.keys()) {
                this.borderPntsCluster.adjustOrPutValue(k, 1, 1);
            }
            int borderPoints = cluster.toVisitVertices.size();
            if (borderPoints == 0) {
                ++this.isolatedIslands;
            } else if (borderPoints <= 2) {
                ++this.toMergeIslands;
            } else {
                this.borderPntsDistr.adjustOrPutValue(borderPoints, 1, 1);
                this.shortcuts += borderPoints * (borderPoints - 1);
                this.pntsDistr.adjustOrPutValue((cluster.visitedVertices.size() + 500) / 1000, 1, 1);
            }
            this.edges += (long)cluster.edges;
            TIntIntIterator it = cluster.edgeDistr.iterator();
            while (it.hasNext()) {
                it.advance();
                this.edgesDistr.adjustOrPutValue(it.key(), it.value(), it.value());
            }
            this.totalBorderPoints += borderPoints;
        }
    }
}

