/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.palette.data.solid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import net.osmand.shared.palette.data.PaletteModifier;
import net.osmand.shared.palette.domain.Palette;
import net.osmand.shared.palette.domain.PaletteItem;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/osmand/shared/palette/data/solid/SolidPaletteModifier;", "Lnet/osmand/shared/palette/data/PaletteModifier;", "Lnet/osmand/shared/palette/domain/Palette$SolidCollection;", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "update", "palette", "item", "Lnet/osmand/shared/palette/domain/PaletteItem;", "add", "insertAfter", "anchorId", "", "replace", "oldItemId", "newItem", "remove", "itemId", "markAsUsed", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nSolidPaletteModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolidPaletteModifier.kt\nnet/osmand/shared/palette/data/solid/SolidPaletteModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n360#2,7:128\n1755#2,3:135\n1755#2,3:138\n360#2,7:141\n1557#2:148\n1628#2,3:149\n774#2:152\n865#2,2:153\n360#2,7:155\n*S KotlinDebug\n*F\n+ 1 SolidPaletteModifier.kt\nnet/osmand/shared/palette/data/solid/SolidPaletteModifier\n*L\n23#1:128,7\n45#1:135,3\n63#1:138,3\n68#1:141,7\n91#1:148\n91#1:149,3\n102#1:152\n102#1:153,2\n115#1:155,7\n*E\n"})
public final class SolidPaletteModifier
implements PaletteModifier<Palette.SolidCollection> {
    @NotNull
    public static final SolidPaletteModifier INSTANCE = new SolidPaletteModifier();
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("SolidPaletteModifier");

    private SolidPaletteModifier() {
    }

    @Override
    @NotNull
    public Palette.SolidCollection update(@NotNull Palette.SolidCollection palette, @NotNull PaletteItem item) {
        int index;
        List<PaletteItem.Solid> currentItems;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (!(item instanceof PaletteItem.Solid)) {
                Logger.error$default(LOG, "Wrong item type for SolidCollection: " + Reflection.getOrCreateKotlinClass(item.getClass()).getSimpleName(), null, 2, null);
                return palette;
            }
            List<PaletteItem.Solid> $this$indexOfFirst$iv = currentItems = palette.getItems();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PaletteItem.Solid> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PaletteItem.Solid item$iv;
                PaletteItem.Solid it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)((PaletteItem.Solid)item).getId())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            return palette;
        }
        List newItems = CollectionsKt.toMutableList((Collection)currentItems);
        newItems.set(index, item);
        return Palette.SolidCollection.copy$default(palette, null, null, newItems, false, null, 27, null);
    }

    @Override
    @NotNull
    public Palette.SolidCollection add(@NotNull Palette.SolidCollection palette, @NotNull PaletteItem item) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (!(item instanceof PaletteItem.Solid)) {
                return palette;
            }
            Iterable $this$any$iv = palette.getItems();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PaletteItem.Solid it = (PaletteItem.Solid)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)((PaletteItem.Solid)item).getId())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return palette;
        }
        return Palette.SolidCollection.copy$default(palette, null, null, CollectionsKt.plus((Collection)palette.getItems(), (Object)item), false, null, 27, null);
    }

    @Override
    @NotNull
    public Palette.SolidCollection insertAfter(@NotNull Palette.SolidCollection palette, @NotNull String anchorId, @NotNull PaletteItem item) {
        int anchorIndex;
        List items;
        block10: {
            int n;
            boolean bl;
            block9: {
                Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
                Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                if (!(item instanceof PaletteItem.Solid)) {
                    return palette;
                }
                Iterable $this$any$iv = palette.getItems();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PaletteItem.Solid it = (PaletteItem.Solid)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)((PaletteItem.Solid)item).getId())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return palette;
            }
            List $this$indexOfFirst$iv = items = CollectionsKt.toMutableList((Collection)palette.getItems());
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                PaletteItem.Solid it = (PaletteItem.Solid)item$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)anchorId)) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = anchorIndex = -1;
        }
        if (anchorIndex != -1) {
            items.add(anchorIndex + 1, item);
        } else {
            items.add(item);
        }
        return Palette.SolidCollection.copy$default(palette, null, null, items, false, null, 27, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Palette.SolidCollection replace(@NotNull Palette.SolidCollection palette, @NotNull String oldItemId, @NotNull PaletteItem newItem) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Intrinsics.checkNotNullParameter((Object)oldItemId, (String)"oldItemId");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        if (!(newItem instanceof PaletteItem.Solid)) {
            return palette;
        }
        Iterable $this$map$iv = palette.getItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            PaletteItem.Solid solid = (PaletteItem.Solid)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.areEqual((Object)item.getId(), (Object)oldItemId) ? (PaletteItem.Solid)newItem : item);
        }
        List newItems = (List)destination$iv$iv;
        return Palette.SolidCollection.copy$default(palette, null, null, newItems, false, null, 27, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Palette.SolidCollection remove(@NotNull Palette.SolidCollection palette, @NotNull String itemId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Iterable $this$filter$iv = palette.getItems();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PaletteItem.Solid it = (PaletteItem.Solid)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getId(), (Object)itemId))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newItems = (List)destination$iv$iv;
        if (newItems.size() == palette.getItems().size()) {
            return palette;
        }
        return Palette.SolidCollection.copy$default(palette, null, null, newItems, false, null, 27, null);
    }

    @Override
    @NotNull
    public Palette.SolidCollection markAsUsed(@NotNull Palette.SolidCollection palette, @NotNull String itemId) {
        int index;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            List<PaletteItem.Solid> $this$indexOfFirst$iv = palette.getItems();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PaletteItem.Solid> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PaletteItem.Solid item$iv;
                PaletteItem.Solid it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)itemId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            return palette;
        }
        PaletteItem.Solid updatedItem = PaletteItem.Solid.copy$default(palette.getItems().get(index), null, null, null, false, 0, Clock.System.INSTANCE.now().toEpochMilliseconds(), 0, 95, null);
        List newItems = CollectionsKt.toMutableList((Collection)palette.getItems());
        newItems.set(index, updatedItem);
        return Palette.SolidCollection.copy$default(palette, null, null, newItems, false, null, 27, null);
    }
}

