/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.palette.data.gradient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import net.osmand.shared.palette.data.PaletteModifier;
import net.osmand.shared.palette.domain.Palette;
import net.osmand.shared.palette.domain.PaletteItem;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/osmand/shared/palette/data/gradient/GradientPaletteModifier;", "Lnet/osmand/shared/palette/data/PaletteModifier;", "Lnet/osmand/shared/palette/domain/Palette$GradientCollection;", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "update", "palette", "item", "Lnet/osmand/shared/palette/domain/PaletteItem;", "add", "insertAfter", "anchorId", "", "replace", "oldItemId", "newItem", "remove", "itemId", "markAsUsed", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGradientPaletteModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradientPaletteModifier.kt\nnet/osmand/shared/palette/data/gradient/GradientPaletteModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n360#2,7:135\n1755#2,3:142\n1755#2,3:145\n360#2,7:148\n1557#2:155\n1628#2,3:156\n774#2:159\n865#2,2:160\n360#2,7:162\n*S KotlinDebug\n*F\n+ 1 GradientPaletteModifier.kt\nnet/osmand/shared/palette/data/gradient/GradientPaletteModifier\n*L\n27#1:135,7\n47#1:142,3\n65#1:145,3\n70#1:148,7\n94#1:155\n94#1:156,3\n108#1:159\n108#1:160,2\n122#1:162,7\n*E\n"})
public final class GradientPaletteModifier
implements PaletteModifier<Palette.GradientCollection> {
    @NotNull
    public static final GradientPaletteModifier INSTANCE = new GradientPaletteModifier();
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("GradientPaletteModifier");

    private GradientPaletteModifier() {
    }

    @Override
    @NotNull
    public Palette.GradientCollection update(@NotNull Palette.GradientCollection palette, @NotNull PaletteItem item) {
        int index;
        List<PaletteItem.Gradient> currentItems;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (!(item instanceof PaletteItem.Gradient)) {
                Logger.error$default(LOG, "Wrong item type for GradientCollection: " + Reflection.getOrCreateKotlinClass(item.getClass()).getSimpleName(), null, 2, null);
                return palette;
            }
            List<PaletteItem.Gradient> $this$indexOfFirst$iv = currentItems = palette.getItems();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PaletteItem.Gradient> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PaletteItem.Gradient item$iv;
                PaletteItem.Gradient it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)((PaletteItem.Gradient)item).getId())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            return palette;
        }
        List newItems = CollectionsKt.toMutableList((Collection)currentItems);
        newItems.set(index, item);
        return Palette.GradientCollection.copy$default(palette, null, null, null, newItems, false, 23, null);
    }

    @Override
    @NotNull
    public Palette.GradientCollection add(@NotNull Palette.GradientCollection palette, @NotNull PaletteItem item) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (!(item instanceof PaletteItem.Gradient)) {
                return palette;
            }
            Iterable $this$any$iv = palette.getItems();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PaletteItem.Gradient it = (PaletteItem.Gradient)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)((PaletteItem.Gradient)item).getId())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return palette;
        }
        return Palette.GradientCollection.copy$default(palette, null, null, null, CollectionsKt.plus((Collection)palette.getItems(), (Object)item), false, 23, null);
    }

    @Override
    @NotNull
    public Palette.GradientCollection insertAfter(@NotNull Palette.GradientCollection palette, @NotNull String anchorId, @NotNull PaletteItem item) {
        int anchorIndex;
        List items;
        block10: {
            int n;
            boolean bl;
            block9: {
                Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
                Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                if (!(item instanceof PaletteItem.Gradient)) {
                    return palette;
                }
                Iterable $this$any$iv = palette.getItems();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PaletteItem.Gradient it = (PaletteItem.Gradient)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)((PaletteItem.Gradient)item).getId())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return palette;
            }
            List $this$indexOfFirst$iv = items = CollectionsKt.toMutableList((Collection)palette.getItems());
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                PaletteItem.Gradient it = (PaletteItem.Gradient)item$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)anchorId)) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = anchorIndex = -1;
        }
        if (anchorIndex != -1) {
            items.add(anchorIndex + 1, item);
        } else {
            items.add(item);
        }
        return Palette.GradientCollection.copy$default(palette, null, null, null, items, false, 23, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Palette.GradientCollection replace(@NotNull Palette.GradientCollection palette, @NotNull String oldItemId, @NotNull PaletteItem newItem) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Intrinsics.checkNotNullParameter((Object)oldItemId, (String)"oldItemId");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        if (!(newItem instanceof PaletteItem.Gradient)) {
            return palette;
        }
        Iterable $this$map$iv = palette.getItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            PaletteItem.Gradient gradient = (PaletteItem.Gradient)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.areEqual((Object)item.getId(), (Object)oldItemId) ? (PaletteItem.Gradient)newItem : item);
        }
        List newItems = (List)destination$iv$iv;
        return Palette.GradientCollection.copy$default(palette, null, null, null, newItems, false, 23, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Palette.GradientCollection remove(@NotNull Palette.GradientCollection palette, @NotNull String itemId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Iterable $this$filter$iv = palette.getItems();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PaletteItem.Gradient it = (PaletteItem.Gradient)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getId(), (Object)itemId))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newItems = (List)destination$iv$iv;
        if (newItems.size() == palette.getItems().size()) {
            return palette;
        }
        return Palette.GradientCollection.copy$default(palette, null, null, null, newItems, false, 23, null);
    }

    @Override
    @NotNull
    public Palette.GradientCollection markAsUsed(@NotNull Palette.GradientCollection palette, @NotNull String itemId) {
        int index;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            List<PaletteItem.Gradient> $this$indexOfFirst$iv = palette.getItems();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PaletteItem.Gradient> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PaletteItem.Gradient item$iv;
                PaletteItem.Gradient it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)itemId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            return palette;
        }
        PaletteItem.Gradient updatedItem = PaletteItem.Gradient.copy$default(palette.getItems().get(index), null, null, null, false, false, 0, Clock.System.INSTANCE.now().toEpochMilliseconds(), null, null, null, 959, null);
        List newItems = CollectionsKt.toMutableList((Collection)palette.getItems());
        newItems.set(index, updatedItem);
        return Palette.GradientCollection.copy$default(palette, null, null, null, newItems, false, 23, null);
    }
}

