/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.PolymorphicModuleBuilder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuilder;
import net.osmand.shared.KAsyncTask;
import net.osmand.shared.api.KStateChangedListener;
import net.osmand.shared.api.SettingsAPI;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.SmartFolderHelper;
import net.osmand.shared.gpx.SmartFolderUpdateListener;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.data.SmartFolder;
import net.osmand.shared.gpx.filters.BaseTrackFilter;
import net.osmand.shared.gpx.filters.FolderTrackFilter;
import net.osmand.shared.gpx.filters.TrackFilterList;
import net.osmand.shared.gpx.filters.TrackFiltersHelper;
import net.osmand.shared.gpx.organization.OrganizeByParams;
import net.osmand.shared.gpx.organization.OrganizeByRangeParams;
import net.osmand.shared.gpx.organization.OrganizeTracksResourceMapper;
import net.osmand.shared.io.KFile;
import net.osmand.shared.settings.enums.AltitudeMetrics;
import net.osmand.shared.settings.enums.MetricsConstants;
import net.osmand.shared.settings.enums.SpeedConstants;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.KCollectionUtils;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0004\u0016\u0019\u001c\u001f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020(J\b\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020(H\u0002J\u0006\u0010,\u001a\u00020(J-\u0010-\u001a\u0012\u0012\u0004\u0012\u00020/00j\b\u0012\u0004\u0012\u00020/`.2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020/\u0018\u000102H\u0002\u00a2\u0006\u0002\u00103J\u001e\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u000b2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020/\u0018\u000102J\u001e\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u00052\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020/\u0018\u000102J\u0006\u00108\u001a\u00020(J\u0010\u00109\u001a\u00020(2\u0006\u00105\u001a\u00020\u000bH\u0002J\u0010\u0010:\u001a\u00020(2\u0006\u00105\u001a\u00020\u000bH\u0002J\u0010\u0010;\u001a\u00020(2\u0006\u00105\u001a\u00020\u000bH\u0002J\u0010\u0010<\u001a\u00020(2\u0006\u00105\u001a\u00020\u000bH\u0002J\u000e\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020\u0010J\u000e\u0010?\u001a\u00020(2\u0006\u0010>\u001a\u00020\u0010J\b\u0010@\u001a\u00020(H\u0002J\u000e\u0010A\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u0005J\u0012\u0010B\u001a\u0004\u0018\u00010\u000b2\u0006\u00107\u001a\u00020\u0005H\u0002J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000b02J\u0016\u0010D\u001a\u00020(2\u0006\u00105\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020\u0005J\u000e\u0010F\u001a\u00020(2\u0006\u00105\u001a\u00020\u000bJ\u000e\u0010G\u001a\u00020(2\u0006\u0010H\u001a\u00020\u000eJ\u0014\u0010I\u001a\u00020(2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000e0\nJ$\u0010K\u001a\u00020(2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010M\u001a\u00020(2\u0006\u0010N\u001a\u00020OJ\u0016\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020O2\u0006\u0010R\u001a\u00020OJ\u0010\u0010S\u001a\u00020(2\u0006\u00105\u001a\u00020\u000bH\u0002J\u0010\u0010T\u001a\u0004\u0018\u00010\u000b2\u0006\u00107\u001a\u00020\u0005J\u0010\u0010U\u001a\u0004\u0018\u00010\u000b2\u0006\u0010V\u001a\u00020\u0005J\u000e\u0010W\u001a\u00020(2\u0006\u00105\u001a\u00020\u000bJ\u001b\u0010X\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`Y\u00a2\u0006\u0002\u0010ZJ\b\u0010[\u001a\u00020(H\u0002J\u0018\u0010\\\u001a\u00020(2\u0006\u0010]\u001a\u00020\u00052\b\u0010^\u001a\u0004\u0018\u00010_J\u0010\u0010`\u001a\u0004\u0018\u00010_2\u0006\u0010]\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006b"}, d2={"Lnet/osmand/shared/gpx/SmartFolderHelper;", "", "<init>", "()V", "TRACK_FILTERS_SETTINGS_PREF", "", "METRIC_SYSTEM_PREF", "ALTITUDE_SYSTEM_PREF", "SPEED_SYSTEM_PREF", "smartFolderCollection", "", "Lnet/osmand/shared/gpx/data/SmartFolder;", "allAvailableTrackItems", "Ljava/util/HashSet;", "Lnet/osmand/shared/gpx/TrackItem;", "updateListeners", "Lnet/osmand/shared/gpx/SmartFolderUpdateListener;", "isWritingSettings", "", "osmAndSettings", "Lnet/osmand/shared/api/SettingsAPI;", "settingsChangedListener", "net/osmand/shared/gpx/SmartFolderHelper$settingsChangedListener$1", "Lnet/osmand/shared/gpx/SmartFolderHelper$settingsChangedListener$1;", "metricSystemListener", "net/osmand/shared/gpx/SmartFolderHelper$metricSystemListener$1", "Lnet/osmand/shared/gpx/SmartFolderHelper$metricSystemListener$1;", "altitudeSystemListener", "net/osmand/shared/gpx/SmartFolderHelper$altitudeSystemListener$1", "Lnet/osmand/shared/gpx/SmartFolderHelper$altitudeSystemListener$1;", "speedSystemListener", "net/osmand/shared/gpx/SmartFolderHelper$speedSystemListener$1", "Lnet/osmand/shared/gpx/SmartFolderHelper$speedSystemListener$1;", "trackFilterSerializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "onSettingsChanged", "", "onUnitsSettingsChanged", "readSettings", "updateSmartFolderSettings", "resetSmartFoldersItems", "getEnabledFilters", "Lkotlin/collections/ArrayList;", "Lnet/osmand/shared/gpx/filters/BaseTrackFilter;", "Ljava/util/ArrayList;", "filters", "", "(Ljava/util/List;)Ljava/util/ArrayList;", "saveSmartFolder", "smartFolder", "saveNewSmartFolder", "name", "notifyUpdateListeners", "notifyFolderCreatedListeners", "notifyFolderUpdatedListeners", "notifyFolderSavedListeners", "notifyFolderRenamedListeners", "addUpdateListener", "listener", "removeUpdateListener", "writeSettings", "isSmartFolderPresent", "getSmartFolderByName", "getSmartFolders", "renameSmartFolder", "newName", "deleteSmartFolder", "addTrackItemToSmartFolder", "item", "addTrackItemsToSmartFolder", "items", "addTracksToSmartFolders", "smartFolders", "onGpxFileDeleted", "gpxFile", "Lnet/osmand/shared/io/KFile;", "onTrackRenamed", "srcTrackFile", "destTrackFile", "updateSmartFolderItems", "getSmartFolder", "getSmartFolderById", "id", "refreshSmartFolder", "getAllAvailableTrackItems", "Lkotlin/collections/HashSet;", "()Ljava/util/HashSet;", "updateAllSmartFoldersItems", "setOrganizeByParams", "folderId", "params", "Lnet/osmand/shared/gpx/organization/OrganizeByParams;", "getOrganizeByParams", "SmartFoldersUpdateTask", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nSmartFolderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartFolderHelper.kt\nnet/osmand/shared/gpx/SmartFolderHelper\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 SerializersModuleBuilders.kt\nkotlinx/serialization/modules/SerializersModuleBuildersKt\n+ 4 PolymorphicModuleBuilder.kt\nkotlinx/serialization/modules/PolymorphicModuleBuilderKt\n*L\n1#1,375:1\n113#2:376\n31#3,2:377\n254#3,7:379\n261#3,2:387\n254#3,7:389\n261#3,2:397\n33#3:399\n118#4:386\n118#4:396\n*S KotlinDebug\n*F\n+ 1 SmartFolderHelper.kt\nnet/osmand/shared/gpx/SmartFolderHelper\n*L\n214#1:376\n62#1:377,2\n63#1:379,7\n63#1:387,2\n66#1:389,7\n66#1:397,2\n62#1:399\n64#1:386\n67#1:396\n*E\n"})
public final class SmartFolderHelper {
    @NotNull
    public static final SmartFolderHelper INSTANCE;
    @NotNull
    private static final String TRACK_FILTERS_SETTINGS_PREF = "track_filters_settings_pref";
    @NotNull
    private static final String METRIC_SYSTEM_PREF = "default_metric_system";
    @NotNull
    private static final String ALTITUDE_SYSTEM_PREF = "altitude_metrics";
    @NotNull
    private static final String SPEED_SYSTEM_PREF = "default_speed_system";
    @NotNull
    private static List<SmartFolder> smartFolderCollection;
    @NotNull
    private static HashSet<TrackItem> allAvailableTrackItems;
    @NotNull
    private static List<? extends SmartFolderUpdateListener> updateListeners;
    private static boolean isWritingSettings;
    @NotNull
    private static final SettingsAPI osmAndSettings;
    @NotNull
    private static final settingsChangedListener.1 settingsChangedListener;
    @NotNull
    private static final metricSystemListener.1 metricSystemListener;
    @NotNull
    private static final altitudeSystemListener.1 altitudeSystemListener;
    @NotNull
    private static final speedSystemListener.1 speedSystemListener;
    @NotNull
    private static final SerializersModule trackFilterSerializersModule;
    @NotNull
    private static final Json json;

    private SmartFolderHelper() {
    }

    @NotNull
    public final Json getJson() {
        return json;
    }

    private final void onSettingsChanged() {
        if (!isWritingSettings) {
            this.updateSmartFolderSettings();
        }
    }

    public final void onUnitsSettingsChanged() {
        OrganizeTracksResourceMapper.INSTANCE.clearCache();
        for (SmartFolder smartFolder : smartFolderCollection) {
            smartFolder.invalidateCache();
        }
        this.notifyUpdateListeners();
    }

    private final void readSettings() {
        ArrayList newCollection = new ArrayList();
        String settingsJson = osmAndSettings.getStringPreference(TRACK_FILTERS_SETTINGS_PREF);
        if (!KAlgorithms.INSTANCE.isEmpty(settingsJson)) {
            String string = settingsJson;
            Intrinsics.checkNotNull((Object)string);
            List<SmartFolder> list = TrackFilterList.INSTANCE.parseFilters(string);
            if (list != null) {
                List<SmartFolder> savedFilters = list;
                boolean bl = false;
                for (SmartFolder smartFolder : savedFilters) {
                    if (smartFolder.getFilters() != null) {
                        List<BaseTrackFilter> it;
                        boolean bl2 = false;
                        List newFilters = new ArrayList();
                        for (BaseTrackFilter filter : it) {
                            BaseTrackFilter newFilter = TrackFiltersHelper.INSTANCE.createFilter(filter.getTrackFilterType(), null);
                            newFilter.initWithValue(filter);
                            newFilters.add(newFilter);
                        }
                        smartFolder.setFilters(newFilters);
                    }
                    smartFolder.initTracksOrganizer();
                }
                newCollection.addAll(savedFilters);
            }
        }
        smartFolderCollection = newCollection;
    }

    private final void updateSmartFolderSettings() {
        new SmartFoldersUpdateTask().execute(new Unit[0]);
    }

    public final void resetSmartFoldersItems() {
        ArrayList collection = new ArrayList(smartFolderCollection);
        Iterator iterator = collection.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            SmartFolder smartFolder = (SmartFolder)iterator2.next();
            smartFolder.resetItems();
        }
    }

    private final ArrayList<BaseTrackFilter> getEnabledFilters(List<BaseTrackFilter> filters) {
        ArrayList<BaseTrackFilter> enabledFilters;
        block1: {
            enabledFilters = new ArrayList<BaseTrackFilter>();
            List<BaseTrackFilter> list = filters;
            if (list == null) break block1;
            List<BaseTrackFilter> it = list;
            boolean bl = false;
            for (BaseTrackFilter filter : filters) {
                if (!filter.isEnabled()) continue;
                enabledFilters.add(filter);
            }
        }
        return enabledFilters;
    }

    public final void saveSmartFolder(@NotNull SmartFolder smartFolder, @Nullable List<BaseTrackFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)smartFolder, (String)"smartFolder");
        ArrayList<BaseTrackFilter> enabledFilters = this.getEnabledFilters(filters);
        smartFolder.setFilters((List<? extends BaseTrackFilter>)enabledFilters);
        this.writeSettings();
        this.updateSmartFolderItems(smartFolder);
        this.notifyFolderSavedListeners(smartFolder);
    }

    public final void saveNewSmartFolder(@NotNull String name, @Nullable List<BaseTrackFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ArrayList<BaseTrackFilter> enabledFilters = this.getEnabledFilters(filters);
        SmartFolder newFolder = new SmartFolder(name);
        newFolder.setCreationTime(ClockExtensionsKt.currentTimeMillis());
        newFolder.setFilters((List<? extends BaseTrackFilter>)enabledFilters);
        smartFolderCollection = KCollectionUtils.INSTANCE.addToList((Collection)smartFolderCollection, newFolder);
        this.updateSmartFolderItems(newFolder);
        this.writeSettings();
        this.notifyFolderCreatedListeners(newFolder);
    }

    public final void notifyUpdateListeners() {
        for (SmartFolderUpdateListener smartFolderUpdateListener : updateListeners) {
            smartFolderUpdateListener.onSmartFoldersUpdated();
        }
    }

    private final void notifyFolderCreatedListeners(SmartFolder smartFolder) {
        for (SmartFolderUpdateListener smartFolderUpdateListener : updateListeners) {
            smartFolderUpdateListener.onSmartFolderCreated(smartFolder);
        }
    }

    private final void notifyFolderUpdatedListeners(SmartFolder smartFolder) {
        for (SmartFolderUpdateListener smartFolderUpdateListener : updateListeners) {
            smartFolderUpdateListener.onSmartFolderUpdated(smartFolder);
        }
    }

    private final void notifyFolderSavedListeners(SmartFolder smartFolder) {
        for (SmartFolderUpdateListener smartFolderUpdateListener : updateListeners) {
            smartFolderUpdateListener.onSmartFolderSaved(smartFolder);
        }
    }

    private final void notifyFolderRenamedListeners(SmartFolder smartFolder) {
        for (SmartFolderUpdateListener smartFolderUpdateListener : updateListeners) {
            smartFolderUpdateListener.onSmartFolderRenamed(smartFolder);
        }
    }

    public final void addUpdateListener(@NotNull SmartFolderUpdateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!updateListeners.contains(listener)) {
            updateListeners = KCollectionUtils.INSTANCE.addToList((Collection)updateListeners, listener);
        }
    }

    public final void removeUpdateListener(@NotNull SmartFolderUpdateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (updateListeners.contains(listener)) {
            updateListeners = KCollectionUtils.INSTANCE.removeFromList((Collection)updateListeners, listener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeSettings() {
        void $this$encodeToString$iv;
        isWritingSettings = true;
        StringFormat stringFormat = (StringFormat)json;
        List<SmartFolder> value$iv = smartFolderCollection;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json = $this$encodeToString$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(SmartFolder.Companion.serializer()), value$iv);
        osmAndSettings.setStringPreference(TRACK_FILTERS_SETTINGS_PREF, json);
        isWritingSettings = false;
    }

    public final boolean isSmartFolderPresent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getSmartFolderByName(name) != null;
    }

    private final SmartFolder getSmartFolderByName(String name) {
        for (SmartFolder folder : smartFolderCollection) {
            if (!KAlgorithms.INSTANCE.stringsEqual(folder.getFolderName(), name)) continue;
            return folder;
        }
        return null;
    }

    @NotNull
    public final List<SmartFolder> getSmartFolders() {
        return new ArrayList(smartFolderCollection);
    }

    public final void renameSmartFolder(@NotNull SmartFolder smartFolder, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)smartFolder, (String)"smartFolder");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        smartFolder.setFolderName(newName);
        this.writeSettings();
        this.notifyFolderRenamedListeners(smartFolder);
    }

    public final void deleteSmartFolder(@NotNull SmartFolder smartFolder) {
        Intrinsics.checkNotNullParameter((Object)smartFolder, (String)"smartFolder");
        smartFolderCollection = KCollectionUtils.INSTANCE.removeFromList((Collection)smartFolderCollection, smartFolder);
        this.writeSettings();
        this.notifyUpdateListeners();
    }

    public final void addTrackItemToSmartFolder(@NotNull TrackItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        HashSet<TrackItem> newSet = allAvailableTrackItems;
        newSet.add(item);
        allAvailableTrackItems = newSet;
        Object[] objectArray = new TrackItem[]{item};
        this.addTracksToSmartFolders(CollectionsKt.arrayListOf((Object[])objectArray), smartFolderCollection);
    }

    public final void addTrackItemsToSmartFolder(@NotNull List<TrackItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (smartFolderCollection.isEmpty()) {
            return;
        }
        HashSet<TrackItem> newSet = allAvailableTrackItems;
        newSet.addAll((Collection<TrackItem>)items);
        allAvailableTrackItems = newSet;
        this.addTracksToSmartFolders(items, smartFolderCollection);
    }

    private final void addTracksToSmartFolders(List<TrackItem> items, List<SmartFolder> smartFolders) {
        for (TrackItem item : items) {
            for (SmartFolder smartFolder : smartFolders) {
                boolean trackAccepted = false;
                trackAccepted = true;
                if (smartFolder.getFilters() != null) {
                    List<BaseTrackFilter> smartFolderFilters;
                    boolean bl = false;
                    for (BaseTrackFilter filter : smartFolderFilters) {
                        if (filter.isTrackAccepted(item)) continue;
                        trackAccepted = false;
                        break;
                    }
                }
                if (trackAccepted) {
                    smartFolder.addTrackItem(item, true);
                    continue;
                }
                SmartFolder.removeTrackItem$default(smartFolder, item, false, 2, null);
            }
        }
    }

    public final void onGpxFileDeleted(@NotNull KFile gpxFile) {
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        HashSet newAllTracks = new HashSet(allAvailableTrackItems);
        Iterator iterator = newAllTracks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TrackItem trackItem = (TrackItem)e;
            if (!Intrinsics.areEqual((Object)trackItem.getPath(), (Object)gpxFile.absolutePath())) continue;
            newAllTracks.remove(trackItem);
            allAvailableTrackItems = newAllTracks;
            break;
        }
        this.updateAllSmartFoldersItems();
    }

    public final void onTrackRenamed(@NotNull KFile srcTrackFile, @NotNull KFile destTrackFile) {
        Intrinsics.checkNotNullParameter((Object)srcTrackFile, (String)"srcTrackFile");
        Intrinsics.checkNotNullParameter((Object)destTrackFile, (String)"destTrackFile");
        HashSet<TrackItem> newAllTracks = new HashSet<TrackItem>((Collection)allAvailableTrackItems);
        Iterator iterator = newAllTracks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TrackItem trackItem = (TrackItem)e;
            if (!Intrinsics.areEqual((Object)trackItem.getPath(), (Object)srcTrackFile.absolutePath())) continue;
            newAllTracks.remove(trackItem);
            newAllTracks.add(new TrackItem(destTrackFile));
            allAvailableTrackItems = newAllTracks;
            break;
        }
        this.updateAllSmartFoldersItems();
        this.notifyUpdateListeners();
    }

    private final void updateSmartFolderItems(SmartFolder smartFolder) {
        smartFolder.resetItems();
        Object[] objectArray = new SmartFolder[]{smartFolder};
        this.addTracksToSmartFolders(new ArrayList(allAvailableTrackItems), CollectionsKt.arrayListOf((Object[])objectArray));
        this.notifyFolderUpdatedListeners(smartFolder);
    }

    @Nullable
    public final SmartFolder getSmartFolder(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (SmartFolder folder : smartFolderCollection) {
            if (!KAlgorithms.INSTANCE.stringsEqual(folder.getFolderName(), name)) continue;
            return folder;
        }
        return null;
    }

    @Nullable
    public final SmartFolder getSmartFolderById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        for (SmartFolder folder : smartFolderCollection) {
            if (!KAlgorithms.INSTANCE.stringsEqual(folder.getId(), id)) continue;
            return folder;
        }
        return null;
    }

    public final void refreshSmartFolder(@NotNull SmartFolder smartFolder) {
        Intrinsics.checkNotNullParameter((Object)smartFolder, (String)"smartFolder");
        this.updateSmartFolderItems(smartFolder);
    }

    @NotNull
    public final HashSet<TrackItem> getAllAvailableTrackItems() {
        return allAvailableTrackItems;
    }

    private final void updateAllSmartFoldersItems() {
        for (SmartFolder smartFolder : smartFolderCollection) {
            this.updateSmartFolderItems(smartFolder);
        }
    }

    public final void setOrganizeByParams(@NotNull String folderId, @Nullable OrganizeByParams params) {
        SmartFolder folder;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        SmartFolder smartFolder = folder = this.getSmartFolderById(folderId);
        if (smartFolder != null) {
            smartFolder.setOrganizeByParams(params);
        }
        this.writeSettings();
        SmartFolder smartFolder2 = folder;
        if (smartFolder2 == null) {
            return;
        }
        this.notifyFolderUpdatedListeners(smartFolder2);
    }

    @Nullable
    public final OrganizeByParams getOrganizeByParams(@NotNull String folderId) {
        SmartFolder folder;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        SmartFolder smartFolder = folder = this.getSmartFolderById(folderId);
        return smartFolder != null ? smartFolder.getOrganizeByParams() : null;
    }

    private static final Unit json$lambda$3(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setLenient(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setUseArrayPolymorphism(false);
        $this$Json.setEncodeDefaults(true);
        $this$Json.setClassDiscriminator("className");
        $this$Json.setClassDiscriminatorMode(ClassDiscriminatorMode.NONE);
        $this$Json.setSerializersModule(trackFilterSerializersModule);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$onSettingsChanged(SmartFolderHelper $this) {
        $this.onSettingsChanged();
    }

    static {
        SerializersModuleBuilder $this$polymorphic_u24default$iv;
        PolymorphicModuleBuilder $this$subclass$iv;
        PolymorphicModuleBuilder builder$iv;
        SerializersModuleBuilder builder$iv2;
        INSTANCE = new SmartFolderHelper();
        smartFolderCollection = CollectionsKt.emptyList();
        allAvailableTrackItems = new HashSet();
        updateListeners = CollectionsKt.emptyList();
        osmAndSettings = PlatformUtil.INSTANCE.getOsmAndContext().getSettings();
        settingsChangedListener = new KStateChangedListener<String>(){

            public void stateChanged(String change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                SmartFolderHelper.access$onSettingsChanged(SmartFolderHelper.INSTANCE);
            }
        };
        metricSystemListener = new KStateChangedListener<MetricsConstants>(){

            public void stateChanged(MetricsConstants change) {
                Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
                SmartFolderHelper.INSTANCE.onUnitsSettingsChanged();
            }
        };
        altitudeSystemListener = new KStateChangedListener<AltitudeMetrics>(){

            public void stateChanged(AltitudeMetrics change) {
                Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
                SmartFolderHelper.INSTANCE.onUnitsSettingsChanged();
            }
        };
        speedSystemListener = new KStateChangedListener<SpeedConstants>(){

            public void stateChanged(SpeedConstants change) {
                Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
                SmartFolderHelper.INSTANCE.onUnitsSettingsChanged();
            }
        };
        boolean $i$f$SerializersModule = false;
        SerializersModuleBuilder $this$trackFilterSerializersModule_u24lambda_u242 = builder$iv2 = new SerializersModuleBuilder();
        boolean bl = false;
        SerializersModuleBuilder serializersModuleBuilder = $this$trackFilterSerializersModule_u24lambda_u242;
        KClass baseClass$iv = Reflection.getOrCreateKotlinClass(BaseTrackFilter.class);
        KSerializer baseSerializer$iv = null;
        boolean $i$f$polymorphic = false;
        PolymorphicModuleBuilder $this$trackFilterSerializersModule_u24lambda_u242_u24lambda_u240 = builder$iv = new PolymorphicModuleBuilder(baseClass$iv, baseSerializer$iv);
        boolean bl2 = false;
        PolymorphicModuleBuilder polymorphicModuleBuilder = $this$trackFilterSerializersModule_u24lambda_u242_u24lambda_u240;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(FolderTrackFilter.class);
        boolean $i$f$subclass = false;
        $this$subclass$iv.subclass(clazz$iv, FolderTrackFilter.Companion.serializer());
        builder$iv.buildTo($this$polymorphic_u24default$iv);
        $this$polymorphic_u24default$iv = $this$trackFilterSerializersModule_u24lambda_u242;
        baseClass$iv = Reflection.getOrCreateKotlinClass(OrganizeByParams.class);
        baseSerializer$iv = null;
        $i$f$polymorphic = false;
        PolymorphicModuleBuilder $this$trackFilterSerializersModule_u24lambda_u242_u24lambda_u241 = builder$iv = new PolymorphicModuleBuilder(baseClass$iv, baseSerializer$iv);
        boolean bl3 = false;
        $this$subclass$iv = $this$trackFilterSerializersModule_u24lambda_u242_u24lambda_u241;
        clazz$iv = Reflection.getOrCreateKotlinClass(OrganizeByRangeParams.class);
        $i$f$subclass = false;
        $this$subclass$iv.subclass(clazz$iv, OrganizeByRangeParams.Companion.serializer());
        builder$iv.buildTo($this$polymorphic_u24default$iv);
        trackFilterSerializersModule = builder$iv2.build();
        json = JsonKt.Json$default(null, SmartFolderHelper::json$lambda$3, (int)1, null);
        osmAndSettings.registerPreference(TRACK_FILTERS_SETTINGS_PREF, "", true, true);
        osmAndSettings.addStringPreferenceListener(TRACK_FILTERS_SETTINGS_PREF, settingsChangedListener);
        osmAndSettings.addEnumPreferenceListener(METRIC_SYSTEM_PREF, metricSystemListener);
        osmAndSettings.addEnumPreferenceListener(ALTITUDE_SYSTEM_PREF, altitudeSystemListener);
        osmAndSettings.addEnumPreferenceListener(SPEED_SYSTEM_PREF, speedSystemListener);
        INSTANCE.readSettings();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00022\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0007\"\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/osmand/shared/gpx/SmartFolderHelper$SmartFoldersUpdateTask;", "Lnet/osmand/shared/KAsyncTask;", "", "<init>", "()V", "doInBackground", "params", "", "([Lkotlin/Unit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onPostExecute", "result", "(Lkotlin/Unit;)V", "OsmAnd-shared"})
    private static final class SmartFoldersUpdateTask
    extends KAsyncTask<Unit, Unit, Unit> {
        public SmartFoldersUpdateTask() {
            super(false, null, null, 7, null);
        }

        @Nullable
        public Object doInBackground(@NotNull Unit[] params, @NotNull Continuation<? super Unit> $completion) {
            INSTANCE.readSettings();
            INSTANCE.updateAllSmartFoldersItems();
            return Unit.INSTANCE;
        }

        @Override
        public void onPostExecute(@NotNull Unit result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            INSTANCE.notifyUpdateListeners();
        }
    }
}

