/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Way;
import net.osmand.util.MapAlgorithms;

public class Ring
implements Comparable<Ring> {
    private static final int INDEX_RING_NODES_FAST_CHECK = 100;
    private static final int INDEX_SIZE = 100;
    private double[] indexedRingIntervals = null;
    private List<Node>[] indexedRingNodes = null;
    private Way border;
    private double area = -1.0;

    Ring(Way w) {
        this.border = w;
        this.indexForFastCheck();
    }

    private void indexForFastCheck() {
        if (this.border.getNodes().size() > 100) {
            double maxLat = Double.MIN_VALUE;
            double minLat = Double.MAX_VALUE;
            Node lastNode = null;
            for (Node n : this.border.getNodes()) {
                if (n == null) continue;
                lastNode = n;
                if (n.getLatitude() > maxLat) {
                    maxLat = n.getLatitude();
                    continue;
                }
                if (!(n.getLatitude() < minLat)) continue;
                minLat = n.getLatitude();
            }
            double interval = ((maxLat += 1.0E-4) - (minLat -= 1.0E-4)) / 99.0;
            this.indexedRingIntervals = new double[100];
            this.indexedRingNodes = new List[100];
            for (int i = 0; i < 100; ++i) {
                this.indexedRingIntervals[i] = minLat + (double)i * interval;
                this.indexedRingNodes[i] = new ArrayList<Node>();
            }
            Node prev = lastNode;
            for (int i = 0; i < this.border.getNodes().size(); ++i) {
                int max;
                int i2;
                Node current = this.border.getNodes().get(i);
                if (current == null) continue;
                int i1 = this.getIndexedLessOrEq(current.getLatitude());
                if (i1 > (i2 = this.getIndexedLessOrEq(prev.getLatitude()))) {
                    min = i2;
                    max = i1;
                } else {
                    min = i1;
                    max = i2;
                }
                for (int j = min; j <= max; ++j) {
                    this.indexedRingNodes[j].add(prev);
                    this.indexedRingNodes[j].add(current);
                }
                prev = current;
            }
        }
    }

    private int getIndexedLessOrEq(double latitude) {
        int ind1 = Arrays.binarySearch(this.indexedRingIntervals, latitude);
        if (ind1 < 0) {
            ind1 = -(ind1 + 1);
        }
        return ind1;
    }

    public boolean isClosed() {
        return this.border.getFirstNodeId() == this.border.getLastNodeId();
    }

    public List<Node> getBorder() {
        return this.border.getNodes();
    }

    public Way getBorderWay() {
        return this.border;
    }

    public boolean containsNode(Node n) {
        return this.containsPoint(n.getLatitude(), n.getLongitude());
    }

    public boolean containsPoint(double latitude, double longitude) {
        if (this.indexedRingIntervals != null) {
            int intersections = 0;
            int indx = this.getIndexedLessOrEq(latitude);
            if (indx == 0 || indx >= this.indexedRingNodes.length) {
                return false;
            }
            List<Node> lst = this.indexedRingNodes[indx];
            for (int k = 0; k < lst.size(); k += 2) {
                Node last;
                Node first = lst.get(k);
                if (OsmMapUtils.ray_intersect_lon(first, last = lst.get(k + 1), latitude, longitude) == -360.0) continue;
                ++intersections;
            }
            return intersections % 2 == 1;
        }
        return MapAlgorithms.containsPoint(this.getBorder(), latitude, longitude);
    }

    public boolean speedIsIn(Ring r) {
        List<Node> points = this.getBorder();
        if (points.size() < 2) {
            return false;
        }
        double minlat = points.get(0).getLatitude();
        double maxlat = points.get(0).getLatitude();
        double minlon = points.get(0).getLongitude();
        double maxlon = points.get(0).getLongitude();
        for (Node n : points) {
            minlat = Math.min(n.getLatitude(), minlat);
            maxlat = Math.max(n.getLatitude(), maxlat);
            minlon = Math.min(n.getLongitude(), minlon);
            maxlon = Math.max(n.getLongitude(), maxlon);
        }
        if (!r.containsPoint(minlat, minlon)) {
            return false;
        }
        if (!r.containsPoint(maxlat, minlon)) {
            return false;
        }
        if (!r.containsPoint(minlat, maxlon)) {
            return false;
        }
        if (!r.containsPoint(maxlat, maxlon)) {
            return false;
        }
        for (Node n : r.getBorder()) {
            if (!(n.getLatitude() > minlat) || !(n.getLatitude() < maxlat) || !(n.getLongitude() > minlon) || !(n.getLongitude() < maxlon)) continue;
            return false;
        }
        return true;
    }

    public boolean isIn(Ring r) {
        if (this.speedIsIn(r)) {
            return true;
        }
        List<Node> points = this.getBorder();
        for (Node n : points) {
            if (r.containsNode(n)) continue;
            return false;
        }
        points = r.getBorder();
        for (Node n : points) {
            if (!this.containsNode(n)) continue;
            return false;
        }
        return true;
    }

    public void closeWithOtherRing(Ring other) {
        List<Node> thisBorder = this.getBorder();
        ArrayList<Integer> thisSwitchPoints = new ArrayList<Integer>();
        boolean insideOther = other.containsNode(thisBorder.get(0));
        for (int i = 0; i < thisBorder.size(); ++i) {
            Node n = thisBorder.get(i);
            if (other.containsNode(n) == insideOther) continue;
            insideOther = !insideOther;
            thisSwitchPoints.add(i);
        }
        ArrayList<Integer> otherSwitchPoints = new ArrayList<Integer>();
        Iterator iterator = thisSwitchPoints.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            LatLon a = thisBorder.get(i - 1).getLatLon();
            LatLon b = thisBorder.get(i).getLatLon();
            otherSwitchPoints.add(this.getTheSegmentRingIntersectsSegment(a, b));
        }
    }

    private int getTheSegmentRingIntersectsSegment(LatLon a, LatLon b) {
        List<Node> border = this.getBorder();
        for (int i = 1; i < border.size(); ++i) {
            LatLon c = border.get(i - 1).getLatLon();
            LatLon d = border.get(i).getLatLon();
            if (!MapAlgorithms.linesIntersect(a.getLatitude(), a.getLongitude(), b.getLatitude(), b.getLongitude(), c.getLatitude(), c.getLongitude(), d.getLatitude(), d.getLongitude())) continue;
            return i;
        }
        return 0;
    }

    public double getArea() {
        if (this.area == -1.0) {
            this.area = OsmMapUtils.getArea(this.getBorder());
        }
        return this.area;
    }

    public LinearRing toLinearRing() {
        GeometryFactory geometryFactory = new GeometryFactory();
        CoordinateList coordinates = new CoordinateList();
        for (Node node : this.border.getNodes()) {
            coordinates.add(new Coordinate(node.getLatitude(), node.getLongitude()), true);
        }
        coordinates.closeRing();
        return geometryFactory.createLinearRing(coordinates.toCoordinateArray());
    }

    @Override
    public int compareTo(Ring r) {
        return Double.compare(this.getArea(), r.getArea());
    }
}

