/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.units;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.units.MeasurementSystem;
import net.osmand.shared.util.Localization;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u001d\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0019\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/units/MeasurementUnit;", "T", "", "nameKey", "", "getNameKey", "()Ljava/lang/String;", "symbolKey", "getSymbolKey", "conversionCoefficient", "", "getConversionCoefficient", "()D", "system", "Lnet/osmand/shared/units/MeasurementSystem;", "getSystem", "()Lnet/osmand/shared/units/MeasurementSystem;", "getName", "getSymbol", "toBase", "value", "fromBase", "from", "sourceUnit", "(DLnet/osmand/shared/units/MeasurementUnit;)D", "OsmAnd-shared"})
public interface MeasurementUnit<T extends MeasurementUnit<T>> {
    @NotNull
    public String getNameKey();

    @NotNull
    public String getSymbolKey();

    public double getConversionCoefficient();

    @NotNull
    public MeasurementSystem getSystem();

    @NotNull
    default public String getName() {
        return Localization.INSTANCE.getString(this.getNameKey());
    }

    @NotNull
    default public String getSymbol() {
        return Localization.INSTANCE.getString(this.getSymbolKey());
    }

    default public double toBase(double value) {
        return value / this.getConversionCoefficient();
    }

    default public double fromBase(double value) {
        return value * this.getConversionCoefficient();
    }

    default public double from(double value, @NotNull T sourceUnit) {
        Intrinsics.checkNotNullParameter(sourceUnit, (String)"sourceUnit");
        return Intrinsics.areEqual((Object)this, sourceUnit) ? value : this.fromBase(sourceUnit.toBase(value));
    }
}

