/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.organization.strategy;

import java.time.Month;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.data.OrganizedTracksGroup;
import net.osmand.shared.gpx.data.TracksGroup;
import net.osmand.shared.gpx.enums.TracksSortScope;
import net.osmand.shared.gpx.organization.OrganizeByParams;
import net.osmand.shared.gpx.organization.enums.OrganizeByType;
import net.osmand.shared.gpx.organization.strategy.OrganizeByStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J!\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0011j\u0002`\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lnet/osmand/shared/gpx/organization/strategy/OrganizeByDateStrategy;", "Lnet/osmand/shared/gpx/organization/strategy/OrganizeByStrategy;", "<init>", "()V", "apply", "", "Lnet/osmand/shared/gpx/data/OrganizedTracksGroup;", "originalGroup", "Lnet/osmand/shared/gpx/data/TracksGroup;", "params", "Lnet/osmand/shared/gpx/organization/OrganizeByParams;", "getStartOfMonthMillis", "", "year", "", "month", "Lkotlinx/datetime/Month;", "Ljava/time/Month;", "(ILjava/time/Month;)J", "getStartOfYearMillis", "getTrackSortScope", "Lnet/osmand/shared/gpx/enums/TracksSortScope;", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nOrganizeByDateStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrganizeByDateStrategy.kt\nnet/osmand/shared/gpx/organization/strategy/OrganizeByDateStrategy\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,73:1\n381#2,7:74\n*S KotlinDebug\n*F\n+ 1 OrganizeByDateStrategy.kt\nnet/osmand/shared/gpx/organization/strategy/OrganizeByDateStrategy\n*L\n37#1:74,7\n*E\n"})
public final class OrganizeByDateStrategy
implements OrganizeByStrategy {
    @NotNull
    public static final OrganizeByDateStrategy INSTANCE = new OrganizeByDateStrategy();

    private OrganizeByDateStrategy() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<OrganizedTracksGroup> apply(@NotNull TracksGroup originalGroup, @NotNull OrganizeByParams params) {
        Intrinsics.checkNotNullParameter((Object)originalGroup, (String)"originalGroup");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        OrganizeByType type = params.getType();
        HashMap groupedTracks = new HashMap();
        List<TrackItem> trackItems = originalGroup.getTrackItems();
        boolean bl = false;
        for (TrackItem trackItem : trackItems) {
            Object object;
            void $this$getOrPut$iv;
            Object object2 = trackItem.getDataItem();
            long date = object2 != null && (object2 = (Long)((DataItem)object2).getParameter(GpxParameter.FILE_CREATION_TIME)) != null ? (Long)object2 : 0L;
            LocalDateTime time = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(date), (TimeZone)TimeZone.Companion.currentSystemDefault());
            long key = type == OrganizeByType.YEAR_OF_CREATION ? INSTANCE.getStartOfYearMillis(time.getYear()) : INSTANCE.getStartOfMonthMillis(time.getYear(), time.getMonth());
            Map map = groupedTracks;
            Long key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(trackItem);
        }
        List result = new ArrayList();
        Iterator iterator = groupedTracks.entrySet().iterator();
        while (iterator.hasNext()) {
            String valueIdPart;
            Map.Entry entry;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            long value = ((Number)k).longValue();
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            List trackItems2 = (List)v;
            Intrinsics.checkNotNullExpressionValue((Object)String.valueOf(value).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            String id = OrganizedTracksGroup.Companion.createId(originalGroup, type, valueIdPart);
            result.add(new OrganizedTracksGroup(id, this.getName(type, value), this.getIconName(type, value), type, value, trackItems2, originalGroup));
        }
        return result;
    }

    private final long getStartOfMonthMillis(int year, Month month) {
        LocalDate date = new LocalDate(year, month, 1);
        Instant instant = TimeZoneKt.atStartOfDayIn((LocalDate)date, (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        return instant.toEpochMilliseconds();
    }

    private final long getStartOfYearMillis(int year) {
        LocalDate date = new LocalDate(year, Month.JANUARY, 1);
        Instant instant = TimeZoneKt.atStartOfDayIn((LocalDate)date, (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        return instant.toEpochMilliseconds();
    }

    @Override
    @NotNull
    public TracksSortScope getTrackSortScope() {
        return TracksSortScope.ORGANIZED_BY_VALUE;
    }
}

