/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.filters;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDateTime;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.filters.BaseTrackFilter;
import net.osmand.shared.gpx.filters.DateTrackFilter$;
import net.osmand.shared.gpx.filters.FilterChangedListener;
import net.osmand.shared.gpx.filters.TrackFilterType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 D2\u00020\u0001:\u0002CDB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB5\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\b\u0010\u0010J\b\u0010%\u001a\u00020&H\u0002J\b\u0010.\u001a\u00020/H\u0016J\u001c\u00100\u001a\u00020/2\b\u00101\u001a\u0004\u0018\u00010\u001d2\b\u00102\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u00103\u001a\u00020/2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0001H\u0016J\b\u00107\u001a\u00020&H\u0016J\u0013\u00108\u001a\u00020/2\b\u00109\u001a\u0004\u0018\u00010:H\u0096\u0002J\b\u0010;\u001a\u00020\u000bH\u0016J%\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0001\u00a2\u0006\u0002\bBR$\u0010\u0011\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001e\u0010\u0013R\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b \u0010\u0013R\u001a\u0010!\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010\u0013R\u001a\u0010#\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b$\u0010\u0013R,\u0010\f\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010\u0013\u001a\u0004\b)\u0010\u0015\"\u0004\b*\u0010\u0017R,\u0010\r\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010\u0013\u001a\u0004\b,\u0010\u0015\"\u0004\b-\u0010\u0017\u00a8\u0006E"}, d2={"Lnet/osmand/shared/gpx/filters/DateTrackFilter;", "Lnet/osmand/shared/gpx/filters/BaseTrackFilter;", "trackFilterType", "Lnet/osmand/shared/gpx/filters/TrackFilterType;", "dateFrom", "", "filterChangedListener", "Lnet/osmand/shared/gpx/filters/FilterChangedListener;", "<init>", "(Lnet/osmand/shared/gpx/filters/TrackFilterType;JLnet/osmand/shared/gpx/filters/FilterChangedListener;)V", "seen0", "", "valueFrom", "valueTo", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/osmand/shared/gpx/filters/TrackFilterType;JJLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "initialValueFrom", "getInitialValueFrom$annotations", "()V", "getInitialValueFrom", "()J", "setInitialValueFrom", "(J)V", "initialValueTo", "getInitialValueTo$annotations", "getInitialValueTo", "setInitialValueTo", "initialValueFromDateTime", "Lkotlinx/datetime/LocalDateTime;", "getInitialValueFromDateTime$annotations", "initialValueToDateTime", "getInitialValueToDateTime$annotations", "valueFromDateTime", "getValueFromDateTime$annotations", "valueToDateTime", "getValueToDateTime$annotations", "updateDateTime", "", "value", "getValueFrom$annotations", "getValueFrom", "setValueFrom", "getValueTo$annotations", "getValueTo", "setValueTo", "isEnabled", "", "isDatesEquals", "date1", "date2", "isTrackAccepted", "trackItem", "Lnet/osmand/shared/gpx/TrackItem;", "initWithValue", "initFilter", "equals", "other", "", "hashCode", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
public final class DateTrackFilter
extends BaseTrackFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long initialValueFrom;
    private long initialValueTo;
    @Nullable
    private LocalDateTime initialValueFromDateTime;
    @Nullable
    private LocalDateTime initialValueToDateTime;
    @Nullable
    private LocalDateTime valueFromDateTime;
    @Nullable
    private LocalDateTime valueToDateTime;
    private long valueFrom;
    private long valueTo;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public DateTrackFilter(@NotNull TrackFilterType trackFilterType, long dateFrom, @Nullable FilterChangedListener filterChangedListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)trackFilterType), (String)"trackFilterType");
        super(trackFilterType, filterChangedListener, null);
        this.initialValueFrom = dateFrom;
        this.initialValueTo = ClockExtensionsKt.currentTimeMillis();
        this.setValueFrom(this.initialValueFrom);
        this.setValueTo(this.initialValueTo);
        this.updateDateTime();
    }

    public final long getInitialValueFrom() {
        return this.initialValueFrom;
    }

    public final void setInitialValueFrom(long l) {
        this.initialValueFrom = l;
    }

    @Transient
    public static /* synthetic */ void getInitialValueFrom$annotations() {
    }

    public final long getInitialValueTo() {
        return this.initialValueTo;
    }

    public final void setInitialValueTo(long l) {
        this.initialValueTo = l;
    }

    @Transient
    public static /* synthetic */ void getInitialValueTo$annotations() {
    }

    @Transient
    private static /* synthetic */ void getInitialValueFromDateTime$annotations() {
    }

    @Transient
    private static /* synthetic */ void getInitialValueToDateTime$annotations() {
    }

    @Transient
    private static /* synthetic */ void getValueFromDateTime$annotations() {
    }

    @Transient
    private static /* synthetic */ void getValueToDateTime$annotations() {
    }

    private final void updateDateTime() {
        this.initialValueFromDateTime = ClockExtensionsKt.millisToLocalDateTime(this.initialValueFrom);
        this.initialValueToDateTime = ClockExtensionsKt.millisToLocalDateTime(this.initialValueTo);
        this.valueFromDateTime = ClockExtensionsKt.millisToLocalDateTime(this.valueFrom);
        this.valueToDateTime = ClockExtensionsKt.millisToLocalDateTime(this.valueTo);
    }

    public final long getValueFrom() {
        return this.valueFrom;
    }

    public final void setValueFrom(long value) {
        block0: {
            this.valueFrom = value;
            this.updateDateTime();
            FilterChangedListener filterChangedListener = this.getFilterChangedListener();
            if (filterChangedListener == null) break block0;
            filterChangedListener.onFilterChanged();
        }
    }

    @Serializable
    public static /* synthetic */ void getValueFrom$annotations() {
    }

    public final long getValueTo() {
        return this.valueTo;
    }

    public final void setValueTo(long value) {
        block0: {
            this.valueTo = value;
            this.updateDateTime();
            FilterChangedListener filterChangedListener = this.getFilterChangedListener();
            if (filterChangedListener == null) break block0;
            filterChangedListener.onFilterChanged();
        }
    }

    @Serializable
    public static /* synthetic */ void getValueTo$annotations() {
    }

    @Override
    public boolean isEnabled() {
        return !this.isDatesEquals(this.initialValueFromDateTime, this.valueFromDateTime) || !this.isDatesEquals(this.initialValueToDateTime, this.valueToDateTime);
    }

    private final boolean isDatesEquals(LocalDateTime date1, LocalDateTime date2) {
        LocalDateTime localDateTime = date1;
        LocalDateTime localDateTime2 = date2;
        return Intrinsics.areEqual((Object)(localDateTime != null ? localDateTime.getDate() : null), (Object)(localDateTime2 != null ? localDateTime2.getDate() : null));
    }

    @Override
    public boolean isTrackAccepted(@NotNull TrackItem trackItem) {
        Intrinsics.checkNotNullParameter((Object)trackItem, (String)"trackItem");
        GpxDataItem gpxDataItem = trackItem.getDataItem();
        if (gpxDataItem != null) {
            GpxDataItem it = gpxDataItem;
            boolean bl = false;
            Long l = (Long)it.getParameter(GpxParameter.FILE_CREATION_TIME);
            if (l != null) {
                long creationTime = ((Number)l).longValue();
                boolean bl2 = false;
                long l2 = this.valueFrom;
                return creationTime <= this.valueTo ? l2 <= creationTime : false;
            }
        }
        return false;
    }

    @Override
    public void initWithValue(@NotNull BaseTrackFilter value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof DateTrackFilter) {
            this.setValueTo(((DateTrackFilter)value).valueTo);
            this.setValueFrom(((DateTrackFilter)value).valueFrom);
            if (this.initialValueTo < this.valueTo) {
                this.initialValueTo = this.valueTo;
            }
            if (this.initialValueFrom > this.valueFrom) {
                this.initialValueFrom = this.valueFrom;
            }
            this.updateDateTime();
            super.initWithValue(value);
        }
    }

    @Override
    public void initFilter() {
        super.initFilter();
        this.updateDateTime();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return super.equals(other) && other instanceof DateTrackFilter && this.isDatesEquals(this.valueFromDateTime, ((DateTrackFilter)other).valueFromDateTime) && this.isDatesEquals(this.valueToDateTime, ((DateTrackFilter)other).valueToDateTime);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.valueFrom) + Long.hashCode(this.valueTo);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$OsmAnd_shared(DateTrackFilter self, CompositeEncoder output, SerialDescriptor serialDesc) {
        BaseTrackFilter.write$Self(self, output, serialDesc);
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.valueFrom != 0L) {
            output.encodeLongElement(serialDesc, 1, self.valueFrom);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.valueTo != 0L) {
            output.encodeLongElement(serialDesc, 2, self.valueTo);
        }
    }

    public /* synthetic */ DateTrackFilter(int seen0, TrackFilterType trackFilterType, long valueFrom, long valueTo, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, trackFilterType, serializationConstructorMarker);
        this.initialValueFrom = 0L;
        this.initialValueTo = 0L;
        this.initialValueFromDateTime = null;
        this.initialValueToDateTime = null;
        this.valueFromDateTime = null;
        this.valueToDateTime = null;
        this.valueFrom = (seen0 & 2) == 0 ? 0L : valueFrom;
        this.valueTo = (seen0 & 4) == 0 ? 0L : valueTo;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{TrackFilterType.Companion.serializer(), null, null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/gpx/filters/DateTrackFilter$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/gpx/filters/DateTrackFilter;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<DateTrackFilter> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

