/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.exploreplaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.osmand.shared.api.SQLiteAPI;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import net.osmand.shared.wiki.WikiCoreHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J8\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0019J2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\tJ,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\tJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000eH\u0002J@\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0%0$2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnet/osmand/shared/exploreplaces/PlacesDatabaseHelper;", "", "<init>", "()V", "json", "Lkotlinx/serialization/json/Json;", "getJson$annotations", "serializer", "Lkotlinx/serialization/KSerializer;", "", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandApiFeatureData;", "onCreate", "", "db", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteConnection;", "onDowngrade", "onUpgrade", "oldVersion", "", "newVersion", "insertPlaces", "zoom", "tileX", "tileY", "placesByLang", "", "", "getPlaces", "languages", "isDataExpired", "", "openConnection", "readOnly", "updateDatabaseVersion", "conn", "getSelectionWithArgs", "Lkotlin/Pair;", "", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nPlacesDatabaseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlacesDatabaseHelper.kt\nnet/osmand/shared/exploreplaces/PlacesDatabaseHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KLock.kt\nnet/osmand/shared/util/KLockKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,267:1\n1#2:268\n1#2:270\n6#3:269\n37#4,2:271\n*S KotlinDebug\n*F\n+ 1 PlacesDatabaseHelper.kt\nnet/osmand/shared/exploreplaces/PlacesDatabaseHelper\n*L\n200#1:270\n200#1:269\n265#1:271,2\n*E\n"})
public final class PlacesDatabaseHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Json json = JsonKt.Json$default(null, PlacesDatabaseHelper::json$lambda$0, (int)1, null);
    @NotNull
    private final KSerializer<List<WikiCoreHelper.OsmandApiFeatureData>> serializer = BuiltinSerializersKt.ListSerializer(WikiCoreHelper.OsmandApiFeatureData.Companion.serializer());
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("PlacesDatabaseHelper");
    @NotNull
    private static final Object DB_LOCK = new Object();
    @NotNull
    private static final String DATABASE_NAME = "places.db";
    private static final int DATABASE_VERSION = 2;
    private static final long DATA_EXPIRATION_TIME = 2592000000L;
    private static final long EMPTY_DATA_EXPIRATION_TIME = 604800000L;
    @NotNull
    private static final String TABLE_PLACES = "places";
    @NotNull
    private static final String COLUMN_ZOOM = "zoom";
    @NotNull
    private static final String COLUMN_TILE_X = "tileX";
    @NotNull
    private static final String COLUMN_TILE_Y = "tileY";
    @NotNull
    private static final String COLUMN_LANG = "lang";
    @NotNull
    private static final String COLUMN_DATA = "data";
    @NotNull
    private static final String COLUMN_TIMESTAMP = "timestamp";
    @NotNull
    private static final String CREATE_TABLE_PLACES = "CREATE TABLE IF NOT EXISTS places (zoom INTEGER,tileX INTEGER,tileY INTEGER,lang TEXT,data TEXT,timestamp INTEGER,PRIMARY KEY (zoom, tileX, tileY, lang))";
    @NotNull
    private static final String INSERT_OR_REPLACE = "INSERT OR REPLACE INTO places (zoom, tileX, tileY, lang, data, timestamp) VALUES (?, ?, ?, ?, ?, ?)";

    private static /* synthetic */ void getJson$annotations() {
    }

    private final void onCreate(SQLiteAPI.SQLiteConnection db) {
        db.execSQL(CREATE_TABLE_PLACES);
    }

    private final void onDowngrade(SQLiteAPI.SQLiteConnection db) {
        db.execSQL("DROP TABLE IF EXISTS places");
        this.onCreate(db);
    }

    private final void onUpgrade(SQLiteAPI.SQLiteConnection db, int oldVersion, int newVersion) {
        if (oldVersion < 2) {
            db.execSQL("DROP TABLE IF EXISTS places");
            this.onCreate(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void insertPlaces(int zoom, int tileX, int tileY, @NotNull Map<String, ? extends List<WikiCoreHelper.OsmandApiFeatureData>> placesByLang) {
        block25: {
            Object $this$insertPlaces_u24lambda_u241;
            SQLiteAPI.SQLiteConnection sQLiteConnection;
            SQLiteAPI.SQLiteConnection db;
            block23: {
                Intrinsics.checkNotNullParameter(placesByLang, (String)"placesByLang");
                db = null;
                if (this.openConnection(false) != null) break block23;
                PlacesDatabaseHelper placesDatabaseHelper = this;
                try {
                    Object $this$insertPlaces_u24lambda_u2412 = placesDatabaseHelper;
                    boolean bl = false;
                    $this$insertPlaces_u24lambda_u2412 = Result.constructor-impl(null);
                }
                catch (Throwable bl) {
                    Object $this$insertPlaces_u24lambda_u2412 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                return;
            }
            db = sQLiteConnection;
            db.beginTransaction();
            try {
                for (Map.Entry<String, ? extends List<WikiCoreHelper.OsmandApiFeatureData>> entry : placesByLang.entrySet()) {
                    Object[] objectArray;
                    String lang = entry.getKey();
                    List<WikiCoreHelper.OsmandApiFeatureData> places = entry.getValue();
                    try {
                        objectArray = this.json.encodeToString((SerializationStrategy)this.serializer, places);
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to serialize places for insert", e);
                        continue;
                    }
                    Object[] dataJson = objectArray;
                    objectArray = new Object[]{zoom, tileX, tileY, lang, dataJson, ClockExtensionsKt.currentTimeMillis()};
                    db.execSQL(INSERT_OR_REPLACE, objectArray);
                }
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            PlacesDatabaseHelper placesDatabaseHelper = this;
            try {
                $this$insertPlaces_u24lambda_u241 = placesDatabaseHelper;
                boolean bl = false;
                db.close();
                $this$insertPlaces_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$insertPlaces_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            break block25;
            catch (Throwable e) {
                PlacesDatabaseHelper placesDatabaseHelper2;
                try {
                    LOG.error("Failed insert places", e);
                    placesDatabaseHelper2 = this;
                }
                catch (Throwable throwable) {
                    PlacesDatabaseHelper placesDatabaseHelper3 = this;
                    try {
                        Unit unit;
                        PlacesDatabaseHelper $this$insertPlaces_u24lambda_u2413 = placesDatabaseHelper3;
                        boolean bl = false;
                        SQLiteAPI.SQLiteConnection sQLiteConnection2 = db;
                        if (sQLiteConnection2 != null) {
                            sQLiteConnection2.close();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Object object = Result.constructor-impl((Object)unit);
                    }
                    catch (Throwable throwable2) {
                        Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    throw throwable;
                }
                try {
                    Unit unit;
                    PlacesDatabaseHelper $this$insertPlaces_u24lambda_u2414 = placesDatabaseHelper2;
                    boolean bl = false;
                    SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
                    if (sQLiteConnection3 != null) {
                        sQLiteConnection3.close();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Object object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable bl) {
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public final List<WikiCoreHelper.OsmandApiFeatureData> getPlaces(int zoom, int tileX, int tileY, @NotNull List<String> languages) {
        List places;
        block36: {
            Object $this$getPlaces_u24lambda_u243;
            Object $this$getPlaces_u24lambda_u242;
            SQLiteAPI.SQLiteConnection sQLiteConnection;
            SQLiteAPI.SQLiteCursor cursor;
            SQLiteAPI.SQLiteConnection db;
            block35: {
                Object $this$getPlaces_u24lambda_u2432;
                Object $this$getPlaces_u24lambda_u2422;
                Intrinsics.checkNotNullParameter(languages, (String)"languages");
                db = null;
                cursor = null;
                places = new ArrayList();
                if (this.openConnection(true) != null) break block35;
                List list = places;
                PlacesDatabaseHelper placesDatabaseHelper = this;
                try {
                    $this$getPlaces_u24lambda_u2422 = placesDatabaseHelper;
                    boolean bl2 = false;
                    $this$getPlaces_u24lambda_u2422 = Result.constructor-impl(null);
                }
                catch (Throwable bl2) {
                    $this$getPlaces_u24lambda_u2422 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                placesDatabaseHelper = this;
                try {
                    $this$getPlaces_u24lambda_u2432 = placesDatabaseHelper;
                    boolean bl3 = false;
                    $this$getPlaces_u24lambda_u2432 = Result.constructor-impl(null);
                }
                catch (Throwable bl3) {
                    $this$getPlaces_u24lambda_u2432 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                }
                return list;
            }
            db = sQLiteConnection;
            Object object = this.getSelectionWithArgs(zoom, tileX, tileY, languages);
            String selection = (String)object.component1();
            String[] args = (String[])object.component2();
            String sql = "SELECT data, timestamp FROM places WHERE " + selection;
            cursor = db.rawQuery(sql, args);
            if (cursor != null && cursor.moveToFirst()) {
                int dataIndex = cursor.getColumnIndex(COLUMN_DATA);
                do {
                    String jsonStr;
                    if (!(((CharSequence)(jsonStr = cursor.getString(dataIndex))).length() > 0)) continue;
                    try {
                        places.addAll((Collection)this.json.decodeFromString((DeserializationStrategy)this.serializer, jsonStr));
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to parse places JSON", e);
                    }
                } while (cursor.moveToNext());
            }
            object = this;
            try {
                Unit unit;
                $this$getPlaces_u24lambda_u242 = (PlacesDatabaseHelper)object;
                boolean bl = false;
                SQLiteAPI.SQLiteCursor sQLiteCursor = cursor;
                if (sQLiteCursor != null) {
                    sQLiteCursor.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                $this$getPlaces_u24lambda_u242 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                $this$getPlaces_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = this;
            try {
                $this$getPlaces_u24lambda_u243 = (PlacesDatabaseHelper)object;
                boolean bl = false;
                db.close();
                $this$getPlaces_u24lambda_u243 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$getPlaces_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            break block36;
            catch (Throwable e) {
                Object object2;
                Object $this$getPlaces_u24lambda_u2423;
                PlacesDatabaseHelper placesDatabaseHelper;
                try {
                    LOG.error("Failed get places", e);
                    placesDatabaseHelper = this;
                }
                catch (Throwable throwable) {
                    Object object3;
                    Object $this$getPlaces_u24lambda_u2424;
                    PlacesDatabaseHelper placesDatabaseHelper2 = this;
                    try {
                        Unit unit;
                        $this$getPlaces_u24lambda_u2424 = placesDatabaseHelper2;
                        boolean bl = false;
                        SQLiteAPI.SQLiteCursor sQLiteCursor = cursor;
                        if (sQLiteCursor != null) {
                            sQLiteCursor.close();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        $this$getPlaces_u24lambda_u2424 = Result.constructor-impl((Object)unit);
                    }
                    catch (Throwable bl) {
                        $this$getPlaces_u24lambda_u2424 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    placesDatabaseHelper2 = this;
                    try {
                        Unit unit;
                        PlacesDatabaseHelper $this$getPlaces_u24lambda_u2433 = placesDatabaseHelper2;
                        boolean bl = false;
                        SQLiteAPI.SQLiteConnection sQLiteConnection2 = db;
                        if (sQLiteConnection2 != null) {
                            sQLiteConnection2.close();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        object3 = Result.constructor-impl((Object)unit);
                    }
                    catch (Throwable throwable2) {
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    throw throwable;
                }
                try {
                    Unit unit;
                    $this$getPlaces_u24lambda_u2423 = placesDatabaseHelper;
                    boolean bl = false;
                    SQLiteAPI.SQLiteCursor sQLiteCursor = cursor;
                    if (sQLiteCursor != null) {
                        sQLiteCursor.close();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    $this$getPlaces_u24lambda_u2423 = Result.constructor-impl((Object)unit);
                }
                catch (Throwable bl) {
                    $this$getPlaces_u24lambda_u2423 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                placesDatabaseHelper = this;
                try {
                    Unit unit;
                    PlacesDatabaseHelper $this$getPlaces_u24lambda_u2434 = placesDatabaseHelper;
                    boolean bl = false;
                    SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
                    if (sQLiteConnection3 != null) {
                        sQLiteConnection3.close();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    object2 = Result.constructor-impl((Object)unit);
                }
                catch (Throwable bl) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
            }
        }
        return places;
    }

    /*
     * Exception decompiling
     */
    public final boolean isDataExpired(int zoom, int tileX, int tileY, @NotNull List<String> languages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 31[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLiteAPI.SQLiteConnection openConnection(boolean readOnly) {
        SQLiteAPI.SQLiteConnection sQLiteConnection;
        Object lock$iv = DB_LOCK;
        boolean $i$f$synchronized = false;
        Object object = lock$iv;
        synchronized (object) {
            SQLiteAPI.SQLiteConnection sQLiteConnection2;
            boolean bl = false;
            boolean bl2 = false;
            KFile cacheDir = PlatformUtil.INSTANCE.getOsmAndContext().getCacheDir();
            String path = new KFile(cacheDir, DATABASE_NAME).absolutePath();
            SQLiteAPI api = PlatformUtil.INSTANCE.getSQLiteAPI();
            SQLiteAPI.SQLiteConnection conn = null;
            SQLiteAPI.SQLiteConnection sQLiteConnection3 = api.openByAbsolutePath(path, readOnly);
            if (sQLiteConnection3 == null) {
                sQLiteConnection3 = readOnly ? api.openByAbsolutePath(path, false) : null;
            }
            if ((conn = sQLiteConnection3) == null) {
                sQLiteConnection2 = null;
            } else if (conn.getVersion() == 2) {
                sQLiteConnection2 = conn;
            } else {
                if (conn.isReadOnly()) {
                    PlacesDatabaseHelper placesDatabaseHelper = this;
                    try {
                        PlacesDatabaseHelper $this$openConnection_u24lambda_u247_u24lambda_u246 = placesDatabaseHelper;
                        boolean bl3 = false;
                        conn.close();
                        Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    conn = api.openByAbsolutePath(path, false);
                }
                sQLiteConnection2 = conn != null && this.updateDatabaseVersion(conn) ? conn : null;
            }
            sQLiteConnection = sQLiteConnection2;
        }
        return sQLiteConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean updateDatabaseVersion(SQLiteAPI.SQLiteConnection conn) {
        boolean bl;
        try {
            conn.beginTransaction();
            try {
                int v = conn.getVersion();
                if (v == 0) {
                    this.onCreate(conn);
                } else if (v > 2) {
                    this.onDowngrade(conn);
                } else {
                    this.onUpgrade(conn, v, 2);
                }
                conn.setVersion(2);
                conn.setTransactionSuccessful();
            }
            finally {
                conn.endTransaction();
            }
            bl = true;
        }
        catch (Throwable t) {
            LOG.error("Failed to init/upgrade/downgrade database", t);
            PlacesDatabaseHelper placesDatabaseHelper = this;
            try {
                PlacesDatabaseHelper $this$updateDatabaseVersion_u24lambda_u248 = placesDatabaseHelper;
                boolean bl2 = false;
                conn.close();
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            bl = false;
        }
        return bl;
    }

    private final Pair<String, String[]> getSelectionWithArgs(int zoom, int tileX, int tileY, List<String> languages) {
        ArrayList<String> args = new ArrayList<String>(3 + languages.size());
        args.add(String.valueOf(zoom));
        args.add(String.valueOf(tileX));
        args.add(String.valueOf(tileY));
        StringBuilder builder = new StringBuilder("zoom=? AND tileX=? AND tileY=?");
        if (!KAlgorithms.INSTANCE.isEmpty((Collection)languages)) {
            builder.append(" AND lang IN (");
            int n = ((Collection)languages).size();
            for (int i = 0; i < n; ++i) {
                builder.append("?");
                if (i < languages.size() - 1) {
                    builder.append(",");
                }
                args.add(languages.get(i));
            }
            builder.append(")");
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new Pair((Object)builder.toString(), (Object)thisCollection$iv.toArray(new String[0]));
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setExplicitNulls(false);
        $this$Json.setCoerceInputValues(true);
        $this$Json.setEncodeDefaults(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00060\u0001j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/osmand/shared/exploreplaces/PlacesDatabaseHelper$Companion;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "DB_LOCK", "Lnet/osmand/shared/util/KLock;", "Ljava/lang/Object;", "DATABASE_NAME", "", "DATABASE_VERSION", "", "DATA_EXPIRATION_TIME", "", "EMPTY_DATA_EXPIRATION_TIME", "TABLE_PLACES", "COLUMN_ZOOM", "COLUMN_TILE_X", "COLUMN_TILE_Y", "COLUMN_LANG", "COLUMN_DATA", "COLUMN_TIMESTAMP", "CREATE_TABLE_PLACES", "INSERT_OR_REPLACE", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

