/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.exploreplaces;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.KAsyncTask;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.wiki.WikiCoreHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u0000 \u001e2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0002\u001e\u001fB-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0002H\u0016J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lnet/osmand/shared/exploreplaces/GetExplorePlacesImagesTask;", "Lnet/osmand/shared/KAsyncTask;", "", "", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandApiFeatureData;", "mapRect", "Lnet/osmand/shared/data/KQuadRect;", "zoom", "", "languages", "", "listener", "Lnet/osmand/shared/exploreplaces/GetExplorePlacesImagesTask$GetImageCardsListener;", "<init>", "(Lnet/osmand/shared/data/KQuadRect;ILjava/util/List;Lnet/osmand/shared/exploreplaces/GetExplorePlacesImagesTask$GetImageCardsListener;)V", "getMapRect", "()Lnet/osmand/shared/data/KQuadRect;", "getZoom", "()I", "getLanguages", "()Ljava/util/List;", "getListener", "()Lnet/osmand/shared/exploreplaces/GetExplorePlacesImagesTask$GetImageCardsListener;", "onPreExecute", "doInBackground", "params", "", "([Lkotlin/Unit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onPostExecute", "result", "Companion", "GetImageCardsListener", "OsmAnd-shared"})
public final class GetExplorePlacesImagesTask
extends KAsyncTask<Unit, Unit, List<? extends WikiCoreHelper.OsmandApiFeatureData>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KQuadRect mapRect;
    private final int zoom;
    @NotNull
    private final List<String> languages;
    @NotNull
    private final GetImageCardsListener listener;
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("GetExplorePlacesImagesTask");

    public GetExplorePlacesImagesTask(@NotNull KQuadRect mapRect, int zoom, @NotNull List<String> languages, @NotNull GetImageCardsListener listener) {
        Intrinsics.checkNotNullParameter((Object)mapRect, (String)"mapRect");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super(true, null, null, 6, null);
        this.mapRect = mapRect;
        this.zoom = zoom;
        this.languages = languages;
        this.listener = listener;
    }

    @NotNull
    public final KQuadRect getMapRect() {
        return this.mapRect;
    }

    public final int getZoom() {
        return this.zoom;
    }

    @NotNull
    public final List<String> getLanguages() {
        return this.languages;
    }

    @NotNull
    public final GetImageCardsListener getListener() {
        return this.listener;
    }

    @Override
    public void onPreExecute() {
        super.onPreExecute();
        this.listener.onTaskStarted();
    }

    @Nullable
    public Object doInBackground(@NotNull Unit[] params, @NotNull Continuation<? super List<WikiCoreHelper.OsmandApiFeatureData>> $completion) {
        List<WikiCoreHelper.OsmandApiFeatureData> list = CollectionsKt.emptyList();
        LOG.debug("Start loading nearby places");
        try {
            String langs = CollectionsKt.joinToString$default((Iterable)this.languages, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            list = WikiCoreHelper.INSTANCE.getExploreImageList(this.mapRect, this.zoom, langs);
        }
        catch (Exception error) {
            LOG.debug("Load nearby images error " + error);
        }
        LOG.debug("Finish loading nearby places. Found " + list.size() + " items");
        return list;
    }

    @Override
    public void onPostExecute(@NotNull List<WikiCoreHelper.OsmandApiFeatureData> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        super.onPostExecute(result);
        this.listener.onFinish(result);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/osmand/shared/exploreplaces/GetExplorePlacesImagesTask$Companion;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0016\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/exploreplaces/GetExplorePlacesImagesTask$GetImageCardsListener;", "", "onTaskStarted", "", "onFinish", "result", "", "Lnet/osmand/shared/wiki/WikiCoreHelper$OsmandApiFeatureData;", "OsmAnd-shared"})
    public static interface GetImageCardsListener {
        public void onTaskStarted();

        public void onFinish(@NotNull List<WikiCoreHelper.OsmandApiFeatureData> var1);
    }
}

