/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapIndexTestReader;
import net.osmand.obf.BinaryMerger;
import net.osmand.util.Algorithms;

public class OBFDataCreator
extends BinaryMerger {
    protected static final Map<String, Integer> COMBINE_ARGS = new HashMap<String, Integer>();

    public File create(String obfFilePath, String[] jsonFilePaths) throws IOException, SQLException {
        HashSet<Integer> combineParts = new HashSet<Integer>(COMBINE_ARGS.values());
        return this.create(obfFilePath, jsonFilePaths, combineParts);
    }

    public File create(String obfFilePath, String[] jsonFilePaths, Set<Integer> combineParts) throws IOException, SQLException {
        File outputFile = new File(obfFilePath);
        ArrayList<BinaryMapIndexReader> readers = new ArrayList<BinaryMapIndexReader>();
        for (String jsonFilePath : jsonFilePaths) {
            File jsonFile = new File(jsonFilePath);
            if (!jsonFile.exists() || !jsonFile.getName().endsWith(".json")) continue;
            BinaryMapIndexReader reader = BinaryMapIndexTestReader.buildTestReader(jsonFile);
            readers.add(reader);
        }
        if (readers.isEmpty()) {
            throw new IOException("No data for merge");
        }
        if (outputFile.exists() && !outputFile.delete()) {
            throw new IOException("Cannot delete file " + String.valueOf(outputFile));
        }
        HashSet<Integer> cp = combineParts == null || combineParts.isEmpty() ? new HashSet<Integer>(COMBINE_ARGS.values()) : new HashSet<Integer>(combineParts);
        this.combineParts(outputFile, null, readers, cp);
        File outFile = new File(obfFilePath + ".gz");
        try (FileInputStream inputStream = new FileInputStream(outputFile);
             FileOutputStream fileOutputStream = new FileOutputStream(outFile);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);){
            Algorithms.streamCopy((InputStream)inputStream, (OutputStream)gzipOutputStream);
        }
        return outFile;
    }

    static {
        COMBINE_ARGS.put("--address", 7);
        COMBINE_ARGS.put("--poi", 8);
    }
}

