/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.VoidConfigurationSource;

public abstract class AbstractConfigurationSourceProvider
implements Provider<ConfigurationSource> {
    @Inject
    private ComponentManager componentManager;

    protected ConfigurationSource get(String hint) {
        ConfigurationSource configurationSource;
        try {
            configurationSource = hint == null ? (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class) : (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class, hint);
        }
        catch (ComponentLookupException e) {
            try {
                configurationSource = (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class, "memory");
            }
            catch (ComponentLookupException e1) {
                configurationSource = this.getVoidConfigurationSource();
            }
        }
        return configurationSource;
    }

    private ConfigurationSource getVoidConfigurationSource() {
        ConfigurationSource configurationSource;
        try {
            configurationSource = (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class, "void");
        }
        catch (ComponentLookupException e) {
            configurationSource = new VoidConfigurationSource();
        }
        return configurationSource;
    }
}

