/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.Utils;
import java.io.IOException;

public class Encoder {
    static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2D", "%2E", "%2F", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4A", "%4B", "%4C", "%4D", "%4E", "%4F", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5A", "%5B", "%5C", "%5D", "%5E", "%5F", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6A", "%6B", "%6C", "%6D", "%6E", "%6F", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7A", "%7B", "%7C", "%7D", "%7E", "%7F", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8A", "%8B", "%8C", "%8D", "%8E", "%8F", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9A", "%9B", "%9C", "%9D", "%9E", "%9F", "%A0", "%A1", "%A2", "%A3", "%A4", "%A5", "%A6", "%A7", "%A8", "%A9", "%AA", "%AB", "%AC", "%AD", "%AE", "%AF", "%B0", "%B1", "%B2", "%B3", "%B4", "%B5", "%B6", "%B7", "%B8", "%B9", "%BA", "%BB", "%BC", "%BD", "%BE", "%BF", "%C0", "%C1", "%C2", "%C3", "%C4", "%C5", "%C6", "%C7", "%C8", "%C9", "%CA", "%CB", "%CC", "%CD", "%CE", "%CF", "%D0", "%D1", "%D2", "%D3", "%D4", "%D5", "%D6", "%D7", "%D8", "%D9", "%DA", "%DB", "%DC", "%DD", "%DE", "%DF", "%E0", "%E1", "%E2", "%E3", "%E4", "%E5", "%E6", "%E7", "%E8", "%E9", "%EA", "%EB", "%EC", "%ED", "%EE", "%EF", "%F0", "%F1", "%F2", "%F3", "%F4", "%F5", "%F6", "%F7", "%F8", "%F9", "%FA", "%FB", "%FC", "%FD", "%FE", "%FF"};
    static final String[] hex1 = new String[]{".00", ".01", ".02", ".03", ".04", ".05", ".06", ".07", ".08", ".09", ".0A", ".0B", ".0C", ".0D", ".0E", ".0F", ".10", ".11", ".12", ".13", ".14", ".15", ".16", ".17", ".18", ".19", ".1A", ".1B", ".1C", ".1D", ".1E", ".1F", ".20", ".21", ".22", ".23", ".24", ".25", ".26", ".27", ".28", ".29", ".2A", ".2B", ".2C", ".2D", ".2E", ".2F", ".30", ".31", ".32", ".33", ".34", ".35", ".36", ".37", ".38", ".39", ".3A", ".3B", ".3C", ".3D", ".3E", ".3F", ".40", ".41", ".42", ".43", ".44", ".45", ".46", ".47", ".48", ".49", ".4A", ".4B", ".4C", ".4D", ".4E", ".4F", ".50", ".51", ".52", ".53", ".54", ".55", ".56", ".57", ".58", ".59", ".5A", ".5B", ".5C", ".5D", ".5E", ".5F", ".60", ".61", ".62", ".63", ".64", ".65", ".66", ".67", ".68", ".69", ".6A", ".6B", ".6C", ".6D", ".6E", ".6F", ".70", ".71", ".72", ".73", ".74", ".75", ".76", ".77", ".78", ".79", ".7A", ".7B", ".7C", ".7D", ".7E", ".7F", ".80", ".81", ".82", ".83", ".84", ".85", ".86", ".87", ".88", ".89", ".8A", ".8B", ".8C", ".8D", ".8E", ".8F", ".90", ".91", ".92", ".93", ".94", ".95", ".96", ".97", ".98", ".99", ".9A", ".9B", ".9C", ".9D", ".9E", ".9F", ".A0", ".A1", ".A2", ".A3", ".A4", ".A5", ".A6", ".A7", ".A8", ".A9", ".AA", ".AB", ".AC", ".AD", ".AE", ".AF", ".B0", ".B1", ".B2", ".B3", ".B4", ".B5", ".B6", ".B7", ".B8", ".B9", ".BA", ".BB", ".BC", ".BD", ".BE", ".BF", ".C0", ".C1", ".C2", ".C3", ".C4", ".C5", ".C6", ".C7", ".C8", ".C9", ".CA", ".CB", ".CC", ".CD", ".CE", ".CF", ".D0", ".D1", ".D2", ".D3", ".D4", ".D5", ".D6", ".D7", ".D8", ".D9", ".DA", ".DB", ".DC", ".DD", ".DE", ".DF", ".E0", ".E1", ".E2", ".E3", ".E4", ".E5", ".E6", ".E7", ".E8", ".E9", ".EA", ".EB", ".EC", ".ED", ".EE", ".EF", ".F0", ".F1", ".F2", ".F3", ".F4", ".F5", ".F6", ".F7", ".F8", ".F9", ".FA", ".FB", ".FC", ".FD", ".FE", ".FF"};
    static final String[] hex2 = new String[]{"'00", "'01", "'02", "'03", "'04", "'05", "'06", "'07", "'08", "'09", "'0A", "'0B", "'0C", "'0D", "'0E", "'0F", "'10", "'11", "'12", "'13", "'14", "'15", "'16", "'17", "'18", "'19", "'1A", "'1B", "'1C", "'1D", "'1E", "'1F", "'20", "'21", "'22", "'23", "'24", "'25", "'26", "'27", "'28", "'29", "'2A", "'2B", "'2C", "'2D", "'2E", "'2F", "'30", "'31", "'32", "'33", "'34", "'35", "'36", "'37", "'38", "'39", "'3A", "'3B", "'3C", "'3D", "'3E", "'3F", "'40", "'41", "'42", "'43", "'44", "'45", "'46", "'47", "'48", "'49", "'4A", "'4B", "'4C", "'4D", "'4E", "'4F", "'50", "'51", "'52", "'53", "'54", "'55", "'56", "'57", "'58", "'59", "'5A", "'5B", "'5C", "'5D", "'5E", "'5F", "'60", "'61", "'62", "'63", "'64", "'65", "'66", "'67", "'68", "'69", "'6A", "'6B", "'6C", "'6D", "'6E", "'6F", "'70", "'71", "'72", "'73", "'74", "'75", "'76", "'77", "'78", "'79", "'7A", "'7B", "'7C", "'7D", "'7E", "'7F", "'80", "'81", "'82", "'83", "'84", "'85", "'86", "'87", "'88", "'89", "'8A", "'8B", "'8C", "'8D", "'8E", "'8F", "'90", "'91", "'92", "'93", "'94", "'95", "'96", "'97", "'98", "'99", "'9A", "'9B", "'9C", "'9D", "'9E", "'9F", "'A0", "'A1", "'A2", "'A3", "'A4", "'A5", "'A6", "'A7", "'A8", "'A9", "'AA", "'AB", "'AC", "'AD", "'AE", "'AF", "'B0", "'B1", "'B2", "'B3", "'B4", "'B5", "'B6", "'B7", "'B8", "'B9", "'BA", "'BB", "'BC", "'BD", "'BE", "'BF", "'C0", "'C1", "'C2", "'C3", "'C4", "'C5", "'C6", "'C7", "'C8", "'C9", "'CA", "'CB", "'CC", "'CD", "'CE", "'CF", "'D0", "'D1", "'D2", "'D3", "'D4", "'D5", "'D6", "'D7", "'D8", "'D9", "'DA", "'DB", "'DC", "'DD", "'DE", "'DF", "'E0", "'E1", "'E2", "'E3", "'E4", "'E5", "'E6", "'E7", "'E8", "'E9", "'EA", "'EB", "'EC", "'ED", "'EE", "'EF", "'F0", "'F1", "'F2", "'F3", "'F4", "'F5", "'F6", "'F7", "'F8", "'F9", "'FA", "'FB", "'FC", "'FD", "'FE", "'FF"};

    public static String encodeUrl(String s) {
        int len = s.length();
        if (len == 0) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder(len + len / 10);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            Encoder.encodeUrl(sbuf, ch);
        }
        return sbuf.toString();
    }

    private static void encodeUrl(StringBuilder sbuf, int ch) {
        if (65 <= ch && ch <= 90) {
            sbuf.append((char)ch);
        } else if (97 <= ch && ch <= 122) {
            sbuf.append((char)ch);
        } else if (48 <= ch && ch <= 57) {
            sbuf.append((char)ch);
        } else if (ch == 32) {
            sbuf.append('_');
        } else if (ch == 35) {
            sbuf.append('#');
        } else if (ch == 45 || ch == 95 || ch == 47 || ch == 46 || ch == 58 || ch == 33 || ch == 126 || ch == 39 || ch == 40 || ch == 41) {
            sbuf.append((char)ch);
        } else if (ch <= 127) {
            sbuf.append(hex[ch]);
        } else if (ch <= 2047) {
            sbuf.append(hex[0xC0 | ch >> 6]);
            sbuf.append(hex[0x80 | ch & 0x3F]);
        } else {
            sbuf.append(hex[0xE0 | ch >> 12]);
            sbuf.append(hex[0x80 | ch >> 6 & 0x3F]);
            sbuf.append(hex[0x80 | ch & 0x3F]);
        }
    }

    public static String encodeDotUrl(String s) {
        int len = s.length();
        if (len == 0) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder(len + len / 10);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            Encoder.encodeDotUrl(sbuf, ch);
        }
        return sbuf.toString();
    }

    private static void encodeDotUrl(StringBuilder sbuf, int ch) {
        if (65 <= ch && ch <= 90) {
            sbuf.append((char)ch);
        } else if (97 <= ch && ch <= 122) {
            sbuf.append((char)ch);
        } else if (48 <= ch && ch <= 57) {
            sbuf.append((char)ch);
        } else if (ch == 32) {
            sbuf.append('_');
        } else if (ch == 45 || ch == 95 || ch == 46 || ch == 58) {
            sbuf.append((char)ch);
        } else if (ch <= 127) {
            sbuf.append(hex1[ch]);
        } else if (ch <= 2047) {
            sbuf.append(hex1[0xC0 | ch >> 6]);
            sbuf.append(hex1[0x80 | ch & 0x3F]);
        } else {
            sbuf.append(hex1[0xE0 | ch >> 12]);
            sbuf.append(hex1[0x80 | ch >> 6 & 0x3F]);
            sbuf.append(hex1[0x80 | ch & 0x3F]);
        }
    }

    private static void encodeLocalUrl(StringBuilder sbuf, int ch) {
        if (65 <= ch && ch <= 90) {
            sbuf.append((char)ch);
        } else if (97 <= ch && ch <= 122) {
            sbuf.append((char)ch);
        } else if (48 <= ch && ch <= 57) {
            sbuf.append((char)ch);
        } else if (ch == 32) {
            sbuf.append('_');
        } else if (ch == 46 || ch == 45 || ch == 95 || ch == 47 || ch == 33 || ch == 126 || ch == 40 || ch == 41) {
            sbuf.append((char)ch);
        } else if (ch <= 127) {
            sbuf.append(hex2[ch]);
        } else if (ch <= 2047) {
            sbuf.append(hex2[0xC0 | ch >> 6]);
            sbuf.append(hex2[0x80 | ch & 0x3F]);
        } else {
            sbuf.append(hex2[0xE0 | ch >> 12]);
            sbuf.append(hex2[0x80 | ch >> 6 & 0x3F]);
            sbuf.append(hex2[0x80 | ch & 0x3F]);
        }
    }

    public static String encodeTitleToUrl(String wikiTitle, boolean firstCharacterAsUpperCase) {
        return Encoder.normaliseTitle(wikiTitle, true, ' ', firstCharacterAsUpperCase, true);
    }

    public static String encodeTitleDotUrl(String wikiTitle, boolean firstCharacterAsUpperCase) {
        int len = wikiTitle.length();
        if (len == 0) {
            return "";
        }
        for (int j = len - 1; j > 0; --j) {
            if (Character.isWhitespace(wikiTitle.charAt(j))) continue;
            len = j + 1;
            break;
        }
        boolean whiteSpace = true;
        StringBuilder buffer = new StringBuilder(len + len / 10);
        for (int i = 0; i < len; ++i) {
            char ch = wikiTitle.charAt(i);
            if (whiteSpace && Character.isWhitespace(ch)) continue;
            if (whiteSpace) {
                whiteSpace = false;
                if (firstCharacterAsUpperCase) {
                    Encoder.encodeDotUrl(buffer, Character.toUpperCase(ch));
                    continue;
                }
            }
            Encoder.encodeDotUrl(buffer, ch);
        }
        return buffer.toString();
    }

    public static String encodeTitleLocalUrl(String title) {
        String wikiTitle = title;
        int slashIndex = title.lastIndexOf(47);
        int len = wikiTitle.length();
        if (len == 0) {
            return "";
        }
        for (int j = len - 1; j > 0; --j) {
            if (Character.isWhitespace(wikiTitle.charAt(j))) continue;
            len = j + 1;
            break;
        }
        boolean colon = false;
        boolean whiteSpace = true;
        StringBuilder buffer = new StringBuilder(len + len / 10);
        for (int i = 0; i < len; ++i) {
            char ch = wikiTitle.charAt(i);
            if (whiteSpace && Character.isWhitespace(ch)) continue;
            if (whiteSpace) {
                whiteSpace = false;
                Encoder.encodeLocalUrl(buffer, Character.toUpperCase(ch));
                continue;
            }
            if (ch == '.' && slashIndex > i) {
                buffer.append(hex2[ch]);
                continue;
            }
            if (colon) {
                colon = false;
                Encoder.encodeLocalUrl(buffer, Character.toUpperCase(ch));
                continue;
            }
            Encoder.encodeLocalUrl(buffer, ch);
        }
        return buffer.toString();
    }

    public static String normaliseTitle(String value, boolean underScoreIsWhitespace, char whiteSpaceChar, boolean firstCharacterAsUpperCase) {
        return Encoder.normaliseTitle(value, underScoreIsWhitespace, whiteSpaceChar, firstCharacterAsUpperCase, false);
    }

    public static String normaliseTitle(String value, boolean underScoreIsWhitespace, char whiteSpaceChar, boolean firstCharacterAsUpperCase, boolean encodeUrl) {
        int len = value.length();
        StringBuilder sb = encodeUrl ? new StringBuilder(len + len / 10) : new StringBuilder(len);
        boolean whiteSpace = true;
        boolean first = firstCharacterAsUpperCase;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (Character.isWhitespace(c) || underScoreIsWhitespace && c == '_') {
                if (whiteSpace) continue;
                whiteSpace = true;
                if (encodeUrl) {
                    Encoder.encodeUrl(sb, whiteSpaceChar);
                    continue;
                }
                sb.append(whiteSpaceChar);
                continue;
            }
            char ch = c;
            if (first) {
                ch = Character.toUpperCase(c);
                first = false;
            }
            if (encodeUrl) {
                Encoder.encodeUrl(sb, ch);
            } else {
                sb.append(ch);
            }
            whiteSpace = false;
        }
        return sb.toString().trim();
    }

    public static void encodeHtml(String text, StringBuilder buffer) {
        if (text.length() == 0) {
            return;
        }
        try {
            Utils.escapeXmlToBuffer(text, buffer, true, true, true);
        }
        catch (IOException e) {
            buffer.append("Error in encodeHtml: IOException");
        }
    }

    public static String encodeHtml(String text) {
        int len = text.length();
        if (len == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + len / 10);
        Encoder.encodeHtml(text, buffer);
        return buffer.toString();
    }

    public static boolean isUrlIdentifierPart(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        String test = "-_.!~*;/?:@#&=+$,%\\";
        return "-_.!~*;/?:@#&=+$,%\\".indexOf(ch) != -1;
    }
}

