/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import org.xwiki.rendering.wikimodel.util.ISectionListener;
import org.xwiki.rendering.wikimodel.util.TreeBuilder;

public class SectionBuilder<T> {
    Deque<TreeBuilder<TocEntry>> fBuilder = new ArrayDeque<TreeBuilder<TocEntry>>();
    private Deque<TocEntry> fDocEntries = new ArrayDeque<TocEntry>();
    ISectionListener<T> fListener;

    public SectionBuilder(ISectionListener<T> listener) {
        this.fListener = listener;
    }

    private void pushBuilder() {
        this.fBuilder.push(new TreeBuilder<TocEntry>(new TreeBuilder.ITreeListener<TocEntry>(){

            @Override
            public void onBeginRow(TocEntry n) {
                if (!n.fDoc) {
                    SectionBuilder.this.fListener.beginSection(n);
                    if (n.fHeader) {
                        SectionBuilder.this.fListener.beginSectionHeader(n);
                    } else {
                        SectionBuilder.this.fListener.beginSectionContent(n);
                    }
                }
            }

            @Override
            public void onBeginTree(TocEntry n) {
                if (n.fDoc) {
                    SectionBuilder.this.fListener.beginDocument(n);
                }
            }

            @Override
            public void onEndRow(TocEntry n) {
                if (!n.fDoc) {
                    SectionBuilder.this.fListener.endSectionContent(n);
                    SectionBuilder.this.fListener.endSection(n);
                }
            }

            @Override
            public void onEndTree(TocEntry n) {
                if (n.fDoc) {
                    SectionBuilder.this.fListener.endDocument(n);
                }
            }
        }));
    }

    private TreeBuilder<TocEntry> popBuilder() {
        return this.fBuilder.pop();
    }

    private TocEntry align(int docLevel, int level, T data, boolean doc) {
        TocEntry entry = null;
        ArrayList<TocEntry> entries = new ArrayList<TocEntry>();
        for (int i = 0; i <= level; ++i) {
            entry = new TocEntry(docLevel, i, data, doc, i == level);
            entries.add(entry);
        }
        this.fBuilder.peek().align((TocEntry)((Object)entries));
        return entry;
    }

    public void beginDocument(T data) {
        this.pushBuilder();
        TocEntry entry = this.align(this.getDocLevel() + 1, 0, data, true);
        this.fDocEntries.push(entry);
    }

    public void beginHeader(int level, T data) {
        int docLevel = this.getDocLevel();
        this.align(docLevel, level, data, false);
    }

    public void endDocument() {
        this.fDocEntries.pop();
        this.popBuilder().align((TocEntry)((Object)Collections.emptyList()));
    }

    public void endHeader() {
        TocEntry entry = this.fBuilder.peek().getPeek();
        this.fListener.endSectionHeader(entry);
        this.fListener.beginSectionContent(entry);
    }

    private int getDocLevel() {
        return this.fDocEntries.size();
    }

    protected class TocEntry
    implements TreeBuilder.IPos<TocEntry>,
    ISectionListener.IPos<T> {
        T fData;
        protected boolean fDoc;
        protected boolean fHeader;
        int fDocLevel;
        int fLevel;

        public TocEntry(int docLevel, int level, T data, boolean doc, boolean header) {
            this.fDocLevel = docLevel;
            this.fLevel = level;
            this.fData = data;
            this.fDoc = doc;
            this.fHeader = header;
        }

        @Override
        public boolean equalsData(TocEntry pos) {
            return true;
        }

        @Override
        public T getData() {
            return this.fData;
        }

        @Override
        public int getDocumentLevel() {
            return this.fDocLevel;
        }

        @Override
        public int getHeaderLevel() {
            return this.fLevel;
        }

        @Override
        public int getPos() {
            return this.fDocLevel * 10 + this.fLevel + 1;
        }
    }
}

