/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block.match;

import java.util.ArrayList;
import java.util.List;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.match.BlockMatcher;

public class CompositeBlockMatcher
implements BlockMatcher {
    private List<BlockMatcher> matchers = new ArrayList<BlockMatcher>();

    public CompositeBlockMatcher(List<BlockMatcher> matchers) {
        this.matchers.addAll(matchers);
    }

    public CompositeBlockMatcher(BlockMatcher ... matchers) {
        for (BlockMatcher matcher : matchers) {
            this.matchers.add(matcher);
        }
    }

    @Override
    public boolean match(Block block) {
        for (BlockMatcher matcher : this.matchers) {
            if (matcher.match(block)) continue;
            return false;
        }
        return true;
    }
}

