/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

@Component
@Named(value="body")
@Singleton
public class BodyFilter
extends AbstractHTMLFilter {
    private static final List<String> ALLOWED_BODY_TAGS = Arrays.asList("address", "blockquote", "del", "div", "fieldset", "form", "hr", "ins", "noscript", "p", "pre", "script", "table", "h1", "h2", "h3", "h4", "h5", "h6", "dl", "ol", "ul");

    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        Node body = document.getElementsByTagName("body").item(0);
        Node markerNode = null;
        boolean containsOnlySpaces = true;
        for (Node currentNode = body.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (currentNode.getNodeType() == 8) continue;
            if (!ALLOWED_BODY_TAGS.contains(currentNode.getNodeName())) {
                containsOnlySpaces = this.containsOnlySpaces(currentNode);
                if (markerNode != null) continue;
                markerNode = currentNode;
                continue;
            }
            if (markerNode == null) continue;
            if (!containsOnlySpaces) {
                this.surroundWithParagraph(document, body, markerNode, currentNode);
            }
            markerNode = null;
        }
        if (markerNode != null && !containsOnlySpaces) {
            this.surroundWithParagraph(document, body, markerNode, null);
        }
    }

    private boolean containsOnlySpaces(Node currentNode) {
        boolean result = true;
        if (currentNode.getNodeType() == 3) {
            Text textNode = (Text)currentNode;
            if (textNode.getNodeValue().trim().length() > 0) {
                result = false;
            }
        } else if (currentNode.getNodeType() != 8) {
            result = false;
        }
        return result;
    }

    private void surroundWithParagraph(Document document, Node body, Node beginNode, Node endNode) {
        Element paragraph = document.createElement("p");
        body.insertBefore(paragraph, beginNode);
        Node child = beginNode;
        while (child != endNode) {
            Node nextChild = child.getNextSibling();
            paragraph.appendChild(body.removeChild(child));
            child = nextChild;
        }
    }
}

