/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.api;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.osmand.shared.api.NetworkAPI;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/osmand/shared/api/NetworkAPIImpl;", "Lnet/osmand/shared/api/NetworkAPI;", "<init>", "()V", "proxy", "Ljava/net/Proxy;", "hasProxy", "", "setProxy", "", "host", "", "port", "", "getHttpURLConnection", "Ljava/net/HttpURLConnection;", "urlString", "sendGetRequest", "Lnet/osmand/shared/api/NetworkAPI$NetworkResponse;", "url", "auth", "useGzip", "userAgent", "Companion", "OsmAnd-shared"})
public final class NetworkAPIImpl
implements NetworkAPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Proxy proxy;
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("NetworkAPIImpl");

    @Override
    public boolean hasProxy() {
        return this.proxy != null;
    }

    @Override
    public void setProxy(@Nullable String host, int port) {
        CharSequence charSequence = host;
        if (!(charSequence == null || charSequence.length() == 0) && port > 0) {
            InetSocketAddress isa = new InetSocketAddress(host, port);
            this.proxy = new Proxy(Proxy.Type.HTTP, isa);
        } else {
            this.proxy = null;
        }
    }

    @NotNull
    public final HttpURLConnection getHttpURLConnection(@NotNull String urlString) throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        URL url = new URL(urlString);
        if (this.proxy != null) {
            URLConnection uRLConnection = url.openConnection(this.proxy);
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        } else {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        return httpURLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public NetworkAPI.NetworkResponse sendGetRequest(@NotNull String url, @Nullable String auth, boolean useGzip, @NotNull String userAgent) {
        NetworkAPI.NetworkResponse networkResponse;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        try {
            Object object;
            LOG.info("GET : " + url);
            HttpURLConnection conn = this.getHttpURLConnection(url);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", userAgent);
            if (auth != null) {
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray = auth.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                String encodedAuth = encoder.encodeToString(byArray);
                conn.setRequestProperty("Authorization", "Basic " + encodedAuth);
            }
            if (useGzip) {
                conn.setRequestProperty("Accept-Encoding", "gzip");
            }
            LOG.info("Response code and message : " + conn.getResponseCode() + " " + conn.getResponseMessage());
            if (conn.getResponseCode() != 200) {
                Object object2 = conn.getResponseMessage();
                if (object2 == null) {
                    object2 = "HTTP Error " + conn.getResponseCode();
                }
                String error = object2;
                return new NetworkAPI.NetworkResponse(null, error);
            }
            String contentEncoding = conn.getHeaderField("Content-Encoding");
            InputStream inputStream = useGzip && StringsKt.equals((String)"gzip", (String)contentEncoding, (boolean)true) ? (InputStream)new GZIPInputStream(conn.getInputStream()) : conn.getInputStream();
            Intrinsics.checkNotNull((Object)inputStream);
            Object object3 = new InputStreamReader(inputStream, Charsets.UTF_8);
            int n = 8192;
            Closeable closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            Throwable throwable = null;
            try {
                BufferedReader reader2 = (BufferedReader)closeable;
                boolean bl = false;
                StringBuilder sb = new StringBuilder();
                String line = reader2.readLine();
                boolean first = true;
                while (line != null) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append("\n");
                    }
                    sb.append(line);
                    line = reader2.readLine();
                }
                object3 = sb.toString();
                object = object3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"use(...)");
            Object responseBody = object;
            networkResponse = new NetworkAPI.NetworkResponse((String)responseBody, null);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            networkResponse = new NetworkAPI.NetworkResponse(null, string);
        }
        return networkResponse;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/osmand/shared/api/NetworkAPIImpl$Companion;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

