/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.AreaI;
import net.osmand.core.jni.FColorARGB;
import net.osmand.core.jni.FColorRGB;
import net.osmand.core.jni.MapStubStyle;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.SWIGTYPE_p_std__bitsetT_8psizeoffintF_t;
import net.osmand.core.jni.ZoomLevel;

public class MapState {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MapState(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(MapState mapState) {
        return mapState == null ? 0L : mapState.swigCPtr;
    }

    protected static long swigRelease(MapState mapState) {
        long l = 0L;
        if (mapState != null) {
            if (!mapState.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = mapState.swigCPtr;
            mapState.swigCMemOwn = false;
            mapState.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_MapState(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MapState() {
        this(OsmAndCoreJNI.new_MapState(), true);
    }

    public void setWindowSize(PointI pointI) {
        OsmAndCoreJNI.MapState_windowSize_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getWindowSize() {
        long l = OsmAndCoreJNI.MapState_windowSize_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setViewport(AreaI areaI) {
        OsmAndCoreJNI.MapState_viewport_set(this.swigCPtr, this, AreaI.getCPtr(areaI), areaI);
    }

    public AreaI getViewport() {
        long l = OsmAndCoreJNI.MapState_viewport_get(this.swigCPtr, this);
        return l == 0L ? null : new AreaI(l, false);
    }

    public void setFlip(boolean bl) {
        OsmAndCoreJNI.MapState_flip_set(this.swigCPtr, this, bl);
    }

    public boolean getFlip() {
        return OsmAndCoreJNI.MapState_flip_get(this.swigCPtr, this);
    }

    public void setFlatEarth(boolean bl) {
        OsmAndCoreJNI.MapState_flatEarth_set(this.swigCPtr, this, bl);
    }

    public boolean getFlatEarth() {
        return OsmAndCoreJNI.MapState_flatEarth_get(this.swigCPtr, this);
    }

    public void setFieldOfView(float f) {
        OsmAndCoreJNI.MapState_fieldOfView_set(this.swigCPtr, this, f);
    }

    public float getFieldOfView() {
        return OsmAndCoreJNI.MapState_fieldOfView_get(this.swigCPtr, this);
    }

    public void setVisibleDistance(float f) {
        OsmAndCoreJNI.MapState_visibleDistance_set(this.swigCPtr, this, f);
    }

    public float getVisibleDistance() {
        return OsmAndCoreJNI.MapState_visibleDistance_get(this.swigCPtr, this);
    }

    public void setDetailedDistance(float f) {
        OsmAndCoreJNI.MapState_detailedDistance_set(this.swigCPtr, this, f);
    }

    public float getDetailedDistance() {
        return OsmAndCoreJNI.MapState_detailedDistance_get(this.swigCPtr, this);
    }

    public void setSkyColor(FColorRGB fColorRGB) {
        OsmAndCoreJNI.MapState_skyColor_set(this.swigCPtr, this, FColorRGB.getCPtr(fColorRGB), fColorRGB);
    }

    public FColorRGB getSkyColor() {
        long l = OsmAndCoreJNI.MapState_skyColor_get(this.swigCPtr, this);
        return l == 0L ? null : new FColorRGB(l, false);
    }

    public void setAzimuth(float f) {
        OsmAndCoreJNI.MapState_azimuth_set(this.swigCPtr, this, f);
    }

    public float getAzimuth() {
        return OsmAndCoreJNI.MapState_azimuth_get(this.swigCPtr, this);
    }

    public void setElevationAngle(float f) {
        OsmAndCoreJNI.MapState_elevationAngle_set(this.swigCPtr, this, f);
    }

    public float getElevationAngle() {
        return OsmAndCoreJNI.MapState_elevationAngle_get(this.swigCPtr, this);
    }

    public void setTarget31(PointI pointI) {
        OsmAndCoreJNI.MapState_target31_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getTarget31() {
        long l = OsmAndCoreJNI.MapState_target31_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setFixedPixel(PointI pointI) {
        OsmAndCoreJNI.MapState_fixedPixel_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getFixedPixel() {
        long l = OsmAndCoreJNI.MapState_fixedPixel_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setFixedLocation31(PointI pointI) {
        OsmAndCoreJNI.MapState_fixedLocation31_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getFixedLocation31() {
        long l = OsmAndCoreJNI.MapState_fixedLocation31_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setFixedHeight(float f) {
        OsmAndCoreJNI.MapState_fixedHeight_set(this.swigCPtr, this, f);
    }

    public float getFixedHeight() {
        return OsmAndCoreJNI.MapState_fixedHeight_get(this.swigCPtr, this);
    }

    public void setFixedZoomLevel(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.MapState_fixedZoomLevel_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getFixedZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.MapState_fixedZoomLevel_get(this.swigCPtr, this));
    }

    public void setAimPixel(PointI pointI) {
        OsmAndCoreJNI.MapState_aimPixel_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getAimPixel() {
        long l = OsmAndCoreJNI.MapState_aimPixel_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setAimLocation31(PointI pointI) {
        OsmAndCoreJNI.MapState_aimLocation31_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getAimLocation31() {
        long l = OsmAndCoreJNI.MapState_aimLocation31_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setAimHeight(float f) {
        OsmAndCoreJNI.MapState_aimHeight_set(this.swigCPtr, this, f);
    }

    public float getAimHeight() {
        return OsmAndCoreJNI.MapState_aimHeight_get(this.swigCPtr, this);
    }

    public void setAimZoomLevel(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.MapState_aimZoomLevel_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getAimZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.MapState_aimZoomLevel_get(this.swigCPtr, this));
    }

    public void setAimingActions(SWIGTYPE_p_std__bitsetT_8psizeoffintF_t sWIGTYPE_p_std__bitsetT_8psizeoffintF_t) {
        OsmAndCoreJNI.MapState_aimingActions_set(this.swigCPtr, this, SWIGTYPE_p_std__bitsetT_8psizeoffintF_t.getCPtr(sWIGTYPE_p_std__bitsetT_8psizeoffintF_t));
    }

    public SWIGTYPE_p_std__bitsetT_8psizeoffintF_t getAimingActions() {
        return new SWIGTYPE_p_std__bitsetT_8psizeoffintF_t(OsmAndCoreJNI.MapState_aimingActions_get(this.swigCPtr, this), true);
    }

    public void setZoomLevel(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.MapState_zoomLevel_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.MapState_zoomLevel_get(this.swigCPtr, this));
    }

    public void setVisualZoom(float f) {
        OsmAndCoreJNI.MapState_visualZoom_set(this.swigCPtr, this, f);
    }

    public float getVisualZoom() {
        return OsmAndCoreJNI.MapState_visualZoom_get(this.swigCPtr, this);
    }

    public void setSurfaceZoomLevel(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.MapState_surfaceZoomLevel_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getSurfaceZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.MapState_surfaceZoomLevel_get(this.swigCPtr, this));
    }

    public void setSurfaceVisualZoom(float f) {
        OsmAndCoreJNI.MapState_surfaceVisualZoom_set(this.swigCPtr, this, f);
    }

    public float getSurfaceVisualZoom() {
        return OsmAndCoreJNI.MapState_surfaceVisualZoom_get(this.swigCPtr, this);
    }

    public void setVisualZoomShift(float f) {
        OsmAndCoreJNI.MapState_visualZoomShift_set(this.swigCPtr, this, f);
    }

    public float getVisualZoomShift() {
        return OsmAndCoreJNI.MapState_visualZoomShift_get(this.swigCPtr, this);
    }

    public void setMinZoomLimit(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.MapState_minZoomLimit_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getMinZoomLimit() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.MapState_minZoomLimit_get(this.swigCPtr, this));
    }

    public void setMaxZoomLimit(ZoomLevel zoomLevel) {
        OsmAndCoreJNI.MapState_maxZoomLimit_set(this.swigCPtr, this, zoomLevel.swigValue());
    }

    public ZoomLevel getMaxZoomLimit() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.MapState_maxZoomLimit_get(this.swigCPtr, this));
    }

    public void setStubsStyle(MapStubStyle mapStubStyle) {
        OsmAndCoreJNI.MapState_stubsStyle_set(this.swigCPtr, this, mapStubStyle.swigValue());
    }

    public MapStubStyle getStubsStyle() {
        return MapStubStyle.swigToEnum(OsmAndCoreJNI.MapState_stubsStyle_get(this.swigCPtr, this));
    }

    public void setBackgroundColor(FColorRGB fColorRGB) {
        OsmAndCoreJNI.MapState_backgroundColor_set(this.swigCPtr, this, FColorRGB.getCPtr(fColorRGB), fColorRGB);
    }

    public FColorRGB getBackgroundColor() {
        long l = OsmAndCoreJNI.MapState_backgroundColor_get(this.swigCPtr, this);
        return l == 0L ? null : new FColorRGB(l, false);
    }

    public void setFogColor(FColorRGB fColorRGB) {
        OsmAndCoreJNI.MapState_fogColor_set(this.swigCPtr, this, FColorRGB.getCPtr(fColorRGB), fColorRGB);
    }

    public FColorRGB getFogColor() {
        long l = OsmAndCoreJNI.MapState_fogColor_get(this.swigCPtr, this);
        return l == 0L ? null : new FColorRGB(l, false);
    }

    public void setMyLocationColor(FColorARGB fColorARGB) {
        OsmAndCoreJNI.MapState_myLocationColor_set(this.swigCPtr, this, FColorARGB.getCPtr(fColorARGB), fColorARGB);
    }

    public FColorARGB getMyLocationColor() {
        long l = OsmAndCoreJNI.MapState_myLocationColor_get(this.swigCPtr, this);
        return l == 0L ? null : new FColorARGB(l, false);
    }

    public void setMyLocation31(PointI pointI) {
        OsmAndCoreJNI.MapState_myLocation31_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getMyLocation31() {
        long l = OsmAndCoreJNI.MapState_myLocation31_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setMyLocationRadiusInMeters(float f) {
        OsmAndCoreJNI.MapState_myLocationRadiusInMeters_set(this.swigCPtr, this, f);
    }

    public float getMyLocationRadiusInMeters() {
        return OsmAndCoreJNI.MapState_myLocationRadiusInMeters_get(this.swigCPtr, this);
    }

    public void setMyDirection(float f) {
        OsmAndCoreJNI.MapState_myDirection_set(this.swigCPtr, this, f);
    }

    public float getMyDirection() {
        return OsmAndCoreJNI.MapState_myDirection_get(this.swigCPtr, this);
    }

    public void setMyDirectionRadius(float f) {
        OsmAndCoreJNI.MapState_myDirectionRadius_set(this.swigCPtr, this, f);
    }

    public float getMyDirectionRadius() {
        return OsmAndCoreJNI.MapState_myDirectionRadius_get(this.swigCPtr, this);
    }

    public void setSymbolsOpacity(float f) {
        OsmAndCoreJNI.MapState_symbolsOpacity_set(this.swigCPtr, this, f);
    }

    public float getSymbolsOpacity() {
        return OsmAndCoreJNI.MapState_symbolsOpacity_get(this.swigCPtr, this);
    }

    public void setDateTime(long l) {
        OsmAndCoreJNI.MapState_dateTime_set(this.swigCPtr, this, l);
    }

    public long getDateTime() {
        return OsmAndCoreJNI.MapState_dateTime_get(this.swigCPtr, this);
    }

    public void setMetersPerPixel(double d) {
        OsmAndCoreJNI.MapState_metersPerPixel_set(this.swigCPtr, this, d);
    }

    public double getMetersPerPixel() {
        return OsmAndCoreJNI.MapState_metersPerPixel_get(this.swigCPtr, this);
    }

    public void setVisibleBBox31(AreaI areaI) {
        OsmAndCoreJNI.MapState_visibleBBox31_set(this.swigCPtr, this, AreaI.getCPtr(areaI), areaI);
    }

    public AreaI getVisibleBBox31() {
        long l = OsmAndCoreJNI.MapState_visibleBBox31_get(this.swigCPtr, this);
        return l == 0L ? null : new AreaI(l, false);
    }

    public void setVisibleBBoxShifted(AreaI areaI) {
        OsmAndCoreJNI.MapState_visibleBBoxShifted_set(this.swigCPtr, this, AreaI.getCPtr(areaI), areaI);
    }

    public AreaI getVisibleBBoxShifted() {
        long l = OsmAndCoreJNI.MapState_visibleBBoxShifted_get(this.swigCPtr, this);
        return l == 0L ? null : new AreaI(l, false);
    }

    public void setHasElevationDataProvider(boolean bl) {
        OsmAndCoreJNI.MapState_hasElevationDataProvider_set(this.swigCPtr, this, bl);
    }

    public boolean getHasElevationDataProvider() {
        return OsmAndCoreJNI.MapState_hasElevationDataProvider_get(this.swigCPtr, this);
    }

    public void setHasElevationDataResources(boolean bl) {
        OsmAndCoreJNI.MapState_hasElevationDataResources_set(this.swigCPtr, this, bl);
    }

    public boolean getHasElevationDataResources() {
        return OsmAndCoreJNI.MapState_hasElevationDataResources_get(this.swigCPtr, this);
    }
}

