/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import gnu.trove.TLongCollection;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLStreamException;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.map.OsmandRegions;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.RelationTagsPropagation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.EntityInfo;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.IOsmStorageFilter;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;

public class FixBasemapRoads {
    private static final Log LOG = PlatformUtil.getLog(FixBasemapRoads.class);
    private static int PREFERRED_DISTANCE = 50000;
    private static int MINIMAL_DISTANCE = 1500;
    private static final double MINIMUM_DISTANCE_LINK = 150.0;
    private static final double DIST_DIRECTION = 150.0;
    private static final double ANGLE_TO_ALLOW_DIRECTION = 2.0943951023931953;
    private static final double METRIC_SHORT_LENGTH_THRESHOLD = 100.0;
    private static final double METRIC_SHORT_LENGTH_PENALTY = 100.0;
    private static final double METRIC_LONG_LENGTH_THRESHOLD = 5000.0;
    private static final double METRIC_LONG_LENGTH_BONUS = -100.0;
    private static final double METRIC_ANGLE_THRESHOLD = 0.5235987755982988;
    private static final double METRIC_ANGLE_PENALTY = 50.0;
    private static final int APPROXIMATE_POINT_ZOOM = 31;
    private static final int ADMIN_LEVEL_ZOOM_SPLIT = 4;
    private static final int RAILWAY_ZOOM_SPLIT = 4;
    private static final int REF_EMPTY_ZOOM_SPLIT = 6;
    private static boolean FILTER_BBOX = false;
    private static double LEFT_LON = 0.0;
    private static double RIGHT_LON = 12.25;
    private static double TOP_LAT = 57.25;
    private static double BOTTOM_LAT = 45.0;
    private Map<String, RoadInfo> roadInfoMap = new LinkedHashMap<String, RoadInfo>();
    private TLongObjectHashMap<TLongHashSet> roundabouts = new TLongObjectHashMap();
    private static final int CONNECT_NOT_ALLOWED = 0;
    private static final int CONNECT_S1 = 1;
    private static final int CONNECT_S2 = 2;
    private static final int CONNECT_S3 = 3;
    private static final int CONNECT_S4 = 4;

    public static void main(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        if (args.length == 1 && args[0].equals("test")) {
            args = new String[]{"/Users/macmini/Downloads/basemap/result_out8.osm", "--route-relations", "/Users/macmini/Downloads/basemap/route_road.osm", "--pref-dist", "20000", "--min-dist", "5000", "/Users/macmini/Downloads/basemap/line_all_roads_2_1_3.osm"};
        }
        String fileToWrite = args[0];
        ArrayList<File> relationFiles = new ArrayList<File>();
        ArrayList<File> filesToRead = new ArrayList<File>();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("--route-relations")) {
                relationFiles.add(new File(args[++i]));
                continue;
            }
            if (args[i].equals("--min-dist")) {
                MINIMAL_DISTANCE = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("--pref-dist")) {
                PREFERRED_DISTANCE = Integer.parseInt(args[++i]);
                continue;
            }
            filesToRead.add(new File(args[i]));
        }
        LOG.info((Object)String.format("Preffered road distance: %d, minimal road distance: %d", PREFERRED_DISTANCE, MINIMAL_DISTANCE));
        File write = new File(fileToWrite);
        write.createNewFile();
        new FixBasemapRoads().process(write, filesToRead, relationFiles);
    }

    private void process(File write, List<File> filesToRead, List<File> relationFiles) throws IOException, XMLStreamException, XmlPullParserException, SQLException {
        MapRenderingTypesEncoder renderingTypes = new MapRenderingTypesEncoder("basemap");
        OsmandRegions or = this.prepareRegions();
        RelationTagsPropagation transformer = new RelationTagsPropagation();
        for (File relFile : relationFiles) {
            LOG.info((Object)("Parse relations file " + relFile.getName()));
            OsmBaseStorage storage = this.parseOsmFile(relFile);
            int total = 0;
            for (Entity.EntityId e : storage.getRegisteredEntities().keySet()) {
                if (e.getType() != Entity.EntityType.RELATION) continue;
                if (++total % 1000 == 0) {
                    LOG.info((Object)("Processed " + total + " relations"));
                }
                Relation es = (Relation)storage.getRegisteredEntities().get(e);
                transformer.handleRelationPropogatedTags(es, renderingTypes, null, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
            }
        }
        HashMap<Entity.EntityId, Entity> mainEntities = new HashMap<Entity.EntityId, Entity>();
        HashMap<Entity.EntityId, EntityInfo> mainEntityInfo = new HashMap<Entity.EntityId, EntityInfo>();
        int total = 0;
        long nid = -10000000000L;
        for (File read : filesToRead) {
            LOG.info((Object)("Parse file " + read.getName()));
            OsmBaseStorage storage = this.parseOsmFile(read);
            Map entities = storage.getRegisteredEntities();
            Map infos = storage.getRegisteredEntityInfo();
            for (Entity e : entities.values()) {
                if (!(e instanceof Way)) continue;
                Way w = (Way)e;
                boolean missingNode = false;
                Entity.EntityId eid = Entity.EntityId.valueOf((Entity)e);
                EntityInfo info = (EntityInfo)infos.get(Entity.EntityId.valueOf((Entity)e));
                Way way = mainEntities.containsKey(eid) ? new Way(nid++) : new Way(w.getId());
                way.copyTags((Entity)w);
                for (Node n : w.getNodes()) {
                    if (n == null) {
                        missingNode = true;
                        break;
                    }
                    Node nnode = new Node(n, nid++);
                    way.addNode(nnode);
                    mainEntities.put(Entity.EntityId.valueOf((Entity)nnode), (Entity)nnode);
                }
                mainEntities.put(Entity.EntityId.valueOf((Entity)way), (Entity)way);
                mainEntityInfo.put(Entity.EntityId.valueOf((Entity)way), info);
                if (missingNode) {
                    LOG.info((Object)String.format("Missing node for way %d", w.getId()));
                    continue;
                }
                if (++total % 1000 == 0) {
                    LOG.info((Object)("Processed " + total + " ways"));
                }
                this.addRegionTag(or, way);
                Map<String, String> ntags = transformer.addPropogatedTags(renderingTypes, MapRenderingTypesEncoder.EntityConvertApplyType.MAP, (Entity)way, way.getModifiableTags());
                ntags = renderingTypes.transformTags(ntags, Entity.EntityType.WAY, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
                if (way.getModifiableTags() != ntags) {
                    way.getModifiableTags().putAll(ntags);
                }
                this.processWay(way);
            }
        }
        ArrayList<Entity.EntityId> toWrite = new ArrayList<Entity.EntityId>();
        this.processRegion(toWrite);
        OsmStorageWriter writer = new OsmStorageWriter();
        LOG.info((Object)"Writing file... ");
        writer.saveStorage(new FileOutputStream(write), mainEntities, mainEntityInfo, toWrite, true);
        LOG.info((Object)"DONE");
    }

    private OsmandRegions prepareRegions() throws IOException {
        OsmandRegions or = new OsmandRegions();
        or.prepareFile();
        or.cacheAllCountries();
        return or;
    }

    private OsmBaseStorage parseOsmFile(File read) throws FileNotFoundException, IOException, XmlPullParserException {
        FilterInputStream stream;
        OsmBaseStorage storage = new OsmBaseStorage();
        BufferedInputStream streamFile = stream = new BufferedInputStream(new FileInputStream(read), 32768);
        if (read.getName().endsWith(".bz2")) {
            stream = new BZip2CompressorInputStream((InputStream)stream);
        } else if (read.getName().endsWith(".gz")) {
            stream = new GZIPInputStream(stream);
        }
        storage.getFilters().add(new IOsmStorageFilter(){
            boolean nodeAccepted = true;

            public boolean acceptEntityToLoad(OsmBaseStorage storage, Entity.EntityId entityId, Entity entity) {
                if (!FILTER_BBOX) {
                    return true;
                }
                if (entity instanceof Node) {
                    double lat = ((Node)entity).getLatitude();
                    double lon = ((Node)entity).getLongitude();
                    if (lat > TOP_LAT || lat < BOTTOM_LAT) {
                        this.nodeAccepted = false;
                        return false;
                    }
                    if (lon > RIGHT_LON || lon < LEFT_LON) {
                        this.nodeAccepted = false;
                        return false;
                    }
                    return true;
                }
                if (this.nodeAccepted) {
                    return true;
                }
                this.nodeAccepted = true;
                return false;
            }
        });
        storage.parseOSM((InputStream)stream, (IProgress)new ConsoleProgressImplementation(), (InputStream)streamFile, true);
        return storage;
    }

    public static long convertLatLon(LatLon l) {
        long lx = (long)MapUtils.get31TileNumberY((double)l.getLatitude()) >> 0;
        lx = lx << 31 | (long)(MapUtils.get31TileNumberX((double)l.getLongitude()) >> 0);
        return lx;
    }

    private void processRegion(List<Entity.EntityId> toWrite) throws IOException {
        EnumSet<RoadSimplifyStages> stages = EnumSet.of(RoadSimplifyStages.MERGE_UNIQUE, RoadSimplifyStages.MERGE_BEST);
        Collection<RoadInfo> infos = this.roadInfoMap.values();
        this.processRoadInfoByStages(infos, stages);
        RoadInfo global = new RoadInfo("", RoadInfoRefType.REF);
        for (RoadInfo l : this.roadInfoMap.values()) {
            for (RoadLine rl : l.roadLines) {
                global.registerRoadLine(rl);
            }
        }
        this.processRoadInfoByStages(Collections.singleton(global), stages);
        this.writeWays(toWrite, global);
    }

    private void processRoadInfoByStages(Collection<RoadInfo> infos, EnumSet<RoadSimplifyStages> stages) {
        for (RoadSimplifyStages stage : stages) {
            for (RoadInfoRefType tp : RoadInfoRefType.values()) {
                for (RoadInfo ri : infos) {
                    if (ri.type != tp) continue;
                    this.processRoadsByRef(stage, ri);
                }
            }
        }
    }

    private void processRoadsByRef(RoadSimplifyStages stage, RoadInfo ri) {
        block7: {
            boolean verbose;
            block8: {
                boolean bl = verbose = ri.getTotalDistance() > 40000.0;
                if (RoadSimplifyStages.MERGE_UNIQUE != stage) break block8;
                if (verbose) {
                    System.out.println(ri.toString("Initial:"));
                }
                int merged = this.combineRoadsWithLongestRoad(ri, true);
                if (verbose) {
                    System.out.println(String.format("After combine unique merged (%d): ", merged));
                }
                for (RoadLine r : ri.roadLines) {
                    if (!(r.distance < 150.0) || r.isDeleted()) continue;
                    for (Way way : r.combinedWays) {
                        this.addRoadToRoundabouts(way);
                    }
                    r.delete();
                }
                break block7;
            }
            if (RoadSimplifyStages.MERGE_BEST != stage) break block7;
            int RUNS = 1;
            for (int run = 0; run < RUNS; ++run) {
                int merged = this.combineRoadsWithLongestRoad(ri, false);
                if (verbose) {
                    System.out.println(ri.toString(String.format("After combine %d best merged (%d): ", run + 1, merged)));
                }
                if (merged != 0) {
                    continue;
                }
                break;
            }
        }
    }

    private void writeWays(List<Entity.EntityId> toWrite, RoadInfo ri) {
        ri.compactDeleted();
        for (RoadLine ls : ri.roadLines) {
            if (!(ls.distance > (double)MINIMAL_DISTANCE)) continue;
            ls.combineWaysIntoOneWay();
            Way w = ls.getFirstWay();
            String hw = w.getTag(OSMSettings.OSMTagKey.HIGHWAY);
            if (hw != null && hw.endsWith("_link")) {
                w.putTag("highway", hw.substring(0, hw.length() - "_link".length()));
            }
            toWrite.add(ls.getFirstWayId());
        }
    }

    private void addRegionTag(OsmandRegions or, Way firstWay) throws IOException {
        QuadRect qr = firstWay.getLatLonBBox();
        int lx = MapUtils.get31TileNumberX((double)qr.left);
        int rx = MapUtils.get31TileNumberX((double)qr.right);
        int by = MapUtils.get31TileNumberY((double)qr.bottom);
        int ty = MapUtils.get31TileNumberY((double)qr.top);
        List bbox = or.query(lx, rx, ty, by);
        TreeSet<String> lst = new TreeSet<String>();
        for (BinaryMapDataObject bo : bbox) {
            String dw = or.getDownloadName(bo);
            if (Algorithms.isEmpty((CharSequence)dw) || !or.isDownloadOfType(bo, "region_map")) continue;
            lst.add(dw);
        }
        firstWay.putTag("osmand_region_name", FixBasemapRoads.serialize(lst));
    }

    private static String serialize(TreeSet<String> lst) {
        StringBuilder bld = new StringBuilder();
        for (String next : lst) {
            if (bld.length() > 0) {
                bld.append(",");
            }
            bld.append(next);
        }
        return bld.toString();
    }

    private double directionRoute(List<Node> ns) {
        double x = MapUtils.get31TileNumberX((double)ns.get(0).getLongitude());
        double y = MapUtils.get31TileNumberY((double)ns.get(0).getLatitude());
        double px = MapUtils.get31TileNumberX((double)ns.get(ns.size() - 1).getLongitude());
        double py = MapUtils.get31TileNumberY((double)ns.get(ns.size() - 1).getLatitude());
        if (x == px && y == py) {
            return 0.0;
        }
        return -Math.atan2(x - px, y - py);
    }

    private int combineRoadsWithLongestRoad(RoadInfo ri, boolean combineOnlyUnique) {
        boolean merged = true;
        Collections.sort(ri.roadLines, new Comparator<RoadLine>(){

            @Override
            public int compare(RoadLine o1, RoadLine o2) {
                return -Double.compare(o1.distance, o2.distance);
            }
        });
        int mergedCnt = 0;
        while (merged) {
            merged = false;
            int inc = 1;
            for (int i = 0; i < ri.roadLines.size(); i += inc) {
                RoadLine longRoadToKeep = ri.roadLines.get(i);
                inc = 1;
                if (longRoadToKeep.isDeleted()) continue;
                boolean attachedToEnd = this.findRoadToCombine(ri, longRoadToKeep, combineOnlyUnique, true);
                boolean attachedToStart = this.findRoadToCombine(ri, longRoadToKeep, combineOnlyUnique, false);
                if (!attachedToEnd && !attachedToStart) continue;
                merged = true;
                ++mergedCnt;
                inc = 0;
            }
        }
        return mergedCnt;
    }

    private int getConnectionType(RoadLine longRoadToKeep, RoadLine candidate, boolean onlyUnique) {
        boolean differentHighway;
        boolean refEqual = Algorithms.stringsEqual((String)longRoadToKeep.getSimpleRef(), (String)candidate.getSimpleRef());
        boolean intRefEqual = Algorithms.stringsEqual((String)longRoadToKeep.getIntRef(), (String)candidate.getIntRef());
        boolean intRefEqualNotNull = intRefEqual && longRoadToKeep.getIntRef() != null;
        boolean bl = differentHighway = !Algorithms.stringsEqual((String)longRoadToKeep.getHighway(), (String)candidate.getHighway());
        if (differentHighway) {
            if (!onlyUnique && (refEqual || intRefEqualNotNull) && candidate.distance < (double)MINIMAL_DISTANCE) {
                return 4;
            }
            return 0;
        }
        if (refEqual && intRefEqual) {
            return 1;
        }
        if (refEqual && (longRoadToKeep.getIntRef() == null || candidate.getIntRef() == null)) {
            return 2;
        }
        if (candidate.distance < (double)MINIMAL_DISTANCE && intRefEqual) {
            return 3;
        }
        if (!onlyUnique && candidate.distance < (double)MINIMAL_DISTANCE && longRoadToKeep.distance > (double)PREFERRED_DISTANCE) {
            return 4;
        }
        return 0;
    }

    private boolean findRoadToCombine(RoadInfo ri, RoadLine longRoadToKeep, boolean onlyUnique, boolean attachToEnd) {
        double continuationMetric;
        double dist;
        int connectionType;
        boolean straight;
        double angle;
        long point = attachToEnd ? longRoadToKeep.endPoint : longRoadToKeep.beginPoint;
        double direction = this.directionRoute(attachToEnd ? longRoadToKeep.getLastPoints(150.0) : longRoadToKeep.getFirstPoints(150.0));
        ArrayList<RoadLineConnection> candidates = new ArrayList<RoadLineConnection>();
        for (RoadLine roadToAttach : ri.getConnectedLinesStart(point)) {
            if (roadToAttach.isDeleted() || roadToAttach == longRoadToKeep) continue;
            candidates.add(new RoadLineConnection(roadToAttach, true, !attachToEnd));
        }
        for (RoadLine roadToAttach : ri.getConnectedLinesEnd(point)) {
            if (roadToAttach.isDeleted() || roadToAttach == longRoadToKeep) continue;
            candidates.add(new RoadLineConnection(roadToAttach, false, attachToEnd));
        }
        RoadLineConnection merge = null;
        double bestContinuationMetric = 0.0;
        for (RoadLineConnection r : candidates) {
            angle = Math.abs(MapUtils.alignAngleDifference((double)(direction - r.direction)));
            straight = angle < 2.0943951023931953;
            connectionType = this.getConnectionType(longRoadToKeep, r.rl, onlyUnique);
            if (!straight || connectionType == 0) continue;
            dist = MapUtils.getDistance((LatLon)longRoadToKeep.getEdgePoint(!attachToEnd), (LatLon)r.getStartPoint());
            continuationMetric = this.metric(connectionType, angle, dist, longRoadToKeep.distance, r.rl.distance);
            if (merge == null) {
                merge = r;
                bestContinuationMetric = continuationMetric;
                continue;
            }
            if (onlyUnique) {
                merge = null;
                break;
            }
            if (!(bestContinuationMetric > continuationMetric)) continue;
            merge = r;
            bestContinuationMetric = continuationMetric;
        }
        if (merge != null) {
            for (RoadLineConnection r : candidates) {
                angle = Math.abs(MapUtils.alignAngleDifference((double)(merge.direction - r.direction - Math.PI)));
                straight = angle < 2.0943951023931953;
                connectionType = this.getConnectionType(merge.rl, r.rl, onlyUnique);
                if (!straight || connectionType == 0) continue;
                dist = MapUtils.getDistance((LatLon)merge.getStartPoint(), (LatLon)r.getStartPoint());
                continuationMetric = this.metric(connectionType, angle, dist, merge.rl.distance, r.rl.distance);
                if (onlyUnique) {
                    merge = null;
                    break;
                }
                if (!(bestContinuationMetric > continuationMetric)) continue;
                merge = null;
                break;
            }
        }
        if (merge != null) {
            if (merge.reverse) {
                ri.reverseRoad(merge.rl);
            }
            ri.mergeRoadInto(merge.rl, longRoadToKeep, attachToEnd);
            return true;
        }
        return false;
    }

    private double metric(int connType, double angleDiff, double distBetween, double l1, double l2) {
        double metrics = distBetween;
        metrics += this.penaltyDist(l1);
        metrics += this.penaltyDist(l2);
        if (angleDiff > 0.5235987755982988) {
            metrics += angleDiff / 1.5707963267948966 * 50.0;
        }
        return metrics + (double)(connType * 10000);
    }

    private double penaltyDist(double l1) {
        double metrics = l1 < 100.0 ? 100.0 : (l1 > 5000.0 ? -100.0 : 100.0 + (l1 - 100.0) / 4900.0 * -200.0);
        return metrics;
    }

    private void processWay(Way way) {
        RoadInfo ri;
        boolean isLink;
        Object ref = way.getTag("ref");
        String hw = way.getTag("highway");
        boolean bl = isLink = hw != null && hw.endsWith("_link");
        if (isLink) {
            hw = hw.substring(0, hw.length() - "_link".length());
        }
        if (FixBasemapRoads.convertLatLon(way.getFirstNode().getLatLon()) == FixBasemapRoads.convertLatLon(way.getLastNode().getLatLon()) || "roundabout".equals(way.getTag("junction")) || isLink) {
            this.addRoadToRoundabouts(way);
            return;
        }
        RoadInfoRefType type = RoadInfoRefType.REF;
        String int_ref = way.getTag("int_ref");
        if (ref == null || ((String)ref).isEmpty()) {
            type = RoadInfoRefType.INT_REF;
            ref = int_ref;
        }
        if (ref == null || ((String)ref).isEmpty()) {
            type = RoadInfoRefType.EMPTY_REF;
        } else if (((String)ref).indexOf(59) != -1) {
            ref = ((String)ref).substring(0, ((String)ref).indexOf(59));
        }
        String originalRef = ref;
        if (hw != null) {
            ref = (String)ref + "_" + hw;
        }
        if (type == RoadInfoRefType.REF && int_ref != null && !int_ref.isEmpty()) {
            ref = (String)ref + "_" + int_ref;
        }
        if (ref != null) {
            ref = ((String)ref).replace("-", "").replace(" ", "");
        }
        if (ref == null || ((String)ref).isEmpty() || way.getTag("railway") != null) {
            LatLon lt = way.getLatLon();
            if (way.getTag("admin_level") != null) {
                type = RoadInfoRefType.ADMIN_LEVEL;
                ref = way.getTag("admin_level");
                ref = (String)ref + (int)MapUtils.getTileNumberY((float)4.0f, (double)lt.getLatitude()) + " " + (int)MapUtils.getTileNumberX((float)4.0f, (double)lt.getLongitude());
            } else {
                ref = way.getTag("railway") != null ? (int)MapUtils.getTileNumberY((float)4.0f, (double)lt.getLatitude()) + " " + (int)MapUtils.getTileNumberX((float)4.0f, (double)lt.getLongitude()) : (int)MapUtils.getTileNumberY((float)6.0f, (double)lt.getLatitude()) + " " + (int)MapUtils.getTileNumberX((float)6.0f, (double)lt.getLongitude());
            }
        }
        if ((ri = this.roadInfoMap.get(ref)) == null) {
            ri = new RoadInfo((String)ref, type);
            this.roadInfoMap.put((String)ref, ri);
        }
        ri.registerRoadLine(new RoadLine(way, originalRef, hw, int_ref));
    }

    private void addRoadToRoundabouts(Way way) {
        List wn = way.getNodes();
        TLongHashSet allPointSet = new TLongHashSet();
        for (Node n : wn) {
            if (n == null) continue;
            long pnt = FixBasemapRoads.convertLatLon(n.getLatLon());
            allPointSet.add(pnt);
            TLongHashSet prev = (TLongHashSet)this.roundabouts.put(pnt, (Object)allPointSet);
            if (prev == null || prev == allPointSet) continue;
            allPointSet.addAll((TLongCollection)prev);
            for (long pntP : prev) {
                TLongHashSet prevPnts = (TLongHashSet)this.roundabouts.put(pntP, (Object)allPointSet);
                if (allPointSet.containsAll((TLongCollection)prevPnts)) continue;
                throw new IllegalStateException("Error in algorithm");
            }
        }
    }

    public static enum RoadSimplifyStages {
        MERGE_UNIQUE,
        MERGE_BEST,
        MERGE_WITH_OTHER_REF,
        WRITE;

    }

    class RoadInfo {
        final String ref;
        final RoadInfoRefType type;
        List<RoadLine> roadLines = new ArrayList<RoadLine>();
        TLongObjectHashMap<List<RoadLine>> startPoints = new TLongObjectHashMap();
        TLongObjectHashMap<List<RoadLine>> endPoints = new TLongObjectHashMap();

        public RoadInfo(String rf, RoadInfoRefType type) {
            this.ref = rf;
            this.type = type;
        }

        public int countRoadLines() {
            int i = 0;
            for (RoadLine r : this.roadLines) {
                if (r.isDeleted()) continue;
                ++i;
            }
            return i;
        }

        public void compactDeleted() {
            Iterator<RoadLine> it = this.roadLines.iterator();
            while (it.hasNext()) {
                if (!it.next().isDeleted()) continue;
                it.remove();
            }
        }

        private void registerRoadLine(RoadLine r) {
            if (r.first != null && r.last != null) {
                this.roadLines.add(r);
                this.registerPoints(r);
            }
        }

        private void registerPoints(RoadLine r) {
            if (!this.startPoints.containsKey(r.beginPoint)) {
                this.startPoints.put(r.beginPoint, new ArrayList());
            }
            ((List)this.startPoints.get(r.beginPoint)).add(r);
            if (!this.endPoints.containsKey(r.endPoint)) {
                this.endPoints.put(r.endPoint, new ArrayList());
            }
            ((List)this.endPoints.get(r.endPoint)).add(r);
        }

        public void mergeRoadInto(RoadLine toMerge, RoadLine toKeep, boolean mergeToEnd) {
            if (!Algorithms.objectEquals((Object)toMerge.ref, (Object)toKeep.ref)) {
                if (toKeep.distance > (double)MINIMAL_DISTANCE || toMerge.distance > (double)MINIMAL_DISTANCE) {
                    toKeep.ref = null;
                    toKeep.int_ref = null;
                } else if (toMerge.distance > toKeep.distance) {
                    toKeep.ref = toMerge.ref;
                    toKeep.int_ref = toMerge.int_ref;
                }
                if (toKeep.distance > (double)PREFERRED_DISTANCE && !mergeToEnd) {
                    toKeep.idWayTagsSource += toMerge.combinedWays.size();
                }
            }
            if (toMerge.distance > toKeep.distance) {
                toKeep.highway = toMerge.highway;
            }
            if (mergeToEnd) {
                long op = toKeep.endPoint;
                toKeep.insertInToEnd(toMerge);
                ((List)this.endPoints.get(op)).remove(toKeep);
                ((List)this.endPoints.get(toKeep.endPoint)).add(toKeep);
            } else {
                long op = toKeep.beginPoint;
                toKeep.insertInBeginning(toMerge);
                ((List)this.startPoints.get(op)).remove(toKeep);
                ((List)this.startPoints.get(toKeep.beginPoint)).add(toKeep);
            }
            ((List)this.startPoints.get(toMerge.beginPoint)).remove(toMerge);
            ((List)this.endPoints.get(toMerge.endPoint)).remove(toMerge);
            toMerge.delete();
        }

        public List<RoadLine> getConnectedLinesStart(long point) {
            TLongHashSet rs = (TLongHashSet)FixBasemapRoads.this.roundabouts.get(point);
            if (rs == null) {
                List res = (List)this.startPoints.get(point);
                if (res != null) {
                    return res;
                }
                return Collections.emptyList();
            }
            ArrayList<RoadLine> newL = new ArrayList<RoadLine>();
            TLongIterator it = rs.iterator();
            while (it.hasNext()) {
                List lt = (List)this.startPoints.get(it.next());
                if (lt == null) continue;
                newL.addAll(lt);
            }
            return newL;
        }

        public List<RoadLine> getConnectedLinesEnd(long point) {
            TLongHashSet rs = (TLongHashSet)FixBasemapRoads.this.roundabouts.get(point);
            if (rs == null) {
                List res = (List)this.endPoints.get(point);
                if (res != null) {
                    return res;
                }
                return Collections.emptyList();
            }
            ArrayList<RoadLine> newL = new ArrayList<RoadLine>();
            TLongIterator it = rs.iterator();
            while (it.hasNext()) {
                List lt = (List)this.endPoints.get(it.next());
                if (lt == null) continue;
                newL.addAll(lt);
            }
            return newL;
        }

        public void reverseRoad(RoadLine roadLine) {
            ((List)this.startPoints.get(roadLine.beginPoint)).remove(roadLine);
            ((List)this.endPoints.get(roadLine.endPoint)).remove(roadLine);
            roadLine.reverse();
            this.registerPoints(roadLine);
        }

        public double getTotalDistance() {
            double d = 0.0;
            for (RoadLine rl : this.roadLines) {
                if (rl.isDeleted()) continue;
                d += rl.distance;
            }
            return d;
        }

        public String toString(String msg) {
            return String.format("Road %s - %s %d - segments, %.2f dist", this.ref, msg, this.countRoadLines(), this.getTotalDistance());
        }
    }

    public static enum RoadInfoRefType {
        EMPTY_REF,
        REF,
        INT_REF,
        ADMIN_LEVEL;

    }

    static class RoadLine {
        ArrayList<Way> combinedWays = new ArrayList();
        Node last;
        long beginPoint;
        Node first;
        long endPoint;
        String highway;
        String ref;
        String int_ref;
        int idWayTagsSource = 0;
        double distance = 0.0;
        boolean deleted = false;
        boolean isLink = false;

        RoadLine(Way w, String ref, String hwType, String int_ref) {
            this.combinedWays.add(w);
            this.ref = ref;
            this.highway = hwType;
            this.int_ref = int_ref;
            this.updateData();
        }

        public String getHighway() {
            return this.highway;
        }

        public String getSimpleRef() {
            if (this.ref != null) {
                return this.ref.replace("-", "").replace(" ", "");
            }
            return this.ref;
        }

        public String getIntRef() {
            if (this.int_ref != null) {
                return this.int_ref.replace("-", "").replace(" ", "");
            }
            return this.int_ref;
        }

        private void updateData() {
            this.distance = 0.0;
            this.first = null;
            this.last = null;
            for (int j = 0; j < this.combinedWays.size(); ++j) {
                Way w = this.combinedWays.get(j);
                List nodes = w.getNodes();
                for (int i = 1; i < nodes.size(); ++i) {
                    if (this.first == null) {
                        this.first = (Node)nodes.get(i - 1);
                    }
                    this.last = (Node)nodes.get(i);
                    if (nodes.get(i - 1) == null || nodes.get(i) == null) continue;
                    this.distance += OsmMapUtils.getDistance((Node)((Node)nodes.get(i - 1)), (Node)((Node)nodes.get(i)));
                }
            }
            if (this.first != null) {
                this.beginPoint = FixBasemapRoads.convertLatLon(this.first.getLatLon());
            }
            if (this.last != null) {
                this.endPoint = FixBasemapRoads.convertLatLon(this.last.getLatLon());
            }
        }

        Entity.EntityId getFirstWayId() {
            return Entity.EntityId.valueOf((Entity)((Entity)this.combinedWays.get(0)));
        }

        Way getFirstWay() {
            return this.combinedWays.get(0);
        }

        Way getLastWay() {
            return this.combinedWays.get(this.combinedWays.size() - 1);
        }

        void delete() {
            this.deleted = true;
        }

        boolean isDeleted() {
            return this.deleted;
        }

        List<Node> getFirstPoints(double distance) {
            ArrayList<Node> ns = new ArrayList<Node>();
            Node prev = null;
            double ds = 0.0;
            block0: for (int j = 0; j < this.combinedWays.size(); ++j) {
                List nps = this.combinedWays.get(j).getNodes();
                for (int i = 0; i < nps.size() - 1 || i < nps.size() && j == this.combinedWays.size() - 1; ++i) {
                    Node np = (Node)nps.get(i);
                    if (np == null) continue;
                    ns.add(np);
                    if (prev != null && (ds += OsmMapUtils.getDistance((Node)np, (Node)prev)) > distance) break block0;
                    prev = np;
                }
            }
            return ns;
        }

        List<Node> getLastPoints(double distance) {
            ArrayList<Node> ns = new ArrayList<Node>();
            Node prev = null;
            double ds = 0.0;
            block0: for (int j = this.combinedWays.size() - 1; j >= 0; --j) {
                List nps = this.combinedWays.get(j).getNodes();
                for (int i = nps.size() - 1; i > 0 || i == 0 && j == 0; --i) {
                    Node np = (Node)nps.get(i);
                    if (np == null) continue;
                    ns.add(np);
                    if (prev != null && (ds += OsmMapUtils.getDistance((Node)np, (Node)prev)) > distance) break block0;
                    prev = np;
                }
            }
            Collections.reverse(ns);
            return ns;
        }

        public void insertInBeginning(RoadLine toMerge) {
            this.combinedWays.addAll(0, toMerge.combinedWays);
            this.first = toMerge.first;
            this.distance += toMerge.distance;
            this.beginPoint = toMerge.beginPoint;
            this.isLink = toMerge.isLink && this.isLink;
        }

        public void insertInToEnd(RoadLine toMerge) {
            this.combinedWays.addAll(toMerge.combinedWays);
            this.last = toMerge.last;
            this.distance += toMerge.distance;
            this.endPoint = toMerge.endPoint;
            this.isLink = toMerge.isLink && this.isLink;
        }

        public void combineWaysIntoOneWay() {
            Way first = this.combinedWays.get(0);
            for (int i = 1; i < this.combinedWays.size(); ++i) {
                boolean f = true;
                for (Node n : this.combinedWays.get(i).getNodes()) {
                    if (n != null && !f) {
                        first.addNode(n);
                    }
                    f = false;
                }
            }
            Way way = this.combinedWays.get(this.idWayTagsSource);
            if (way != null) {
                first.replaceTags(way.getTags());
            }
            first.removeTag("name");
            first.removeTag("junction");
            if (this.highway == null) {
                first.removeTag("highway");
            } else {
                first.putTag("highway", this.highway);
            }
            if (this.ref == null) {
                first.removeTag("ref");
            } else {
                first.putTag("ref", this.ref);
            }
            if (this.int_ref == null) {
                first.removeTag("int_ref");
            } else {
                first.putTag("int_ref", this.int_ref);
            }
        }

        public void reverse() {
            Collections.reverse(this.combinedWays);
            for (Way w : this.combinedWays) {
                w.reverseNodes();
            }
            Node n = this.first;
            this.first = this.last;
            this.last = n;
            long np = this.beginPoint;
            this.beginPoint = this.endPoint;
            this.endPoint = np;
        }

        private LatLon getEdgePoint(boolean start) {
            if (start) {
                return this.getFirstWay().getFirstNode().getLatLon();
            }
            return this.getLastWay().getLastNode().getLatLon();
        }
    }

    private class RoadLineConnection {
        RoadLine rl;
        boolean reverse;
        double direction;
        boolean startPoints;

        public RoadLineConnection(RoadLine rl, boolean startPoints, boolean reverse) {
            this.startPoints = startPoints;
            this.reverse = reverse;
            this.rl = rl;
            this.direction = FixBasemapRoads.this.directionRoute(startPoints ? rl.getFirstPoints(150.0) : rl.getLastPoints(150.0));
            if (reverse) {
                this.direction -= Math.PI;
            }
        }

        public LatLon getStartPoint() {
            return this.rl.getEdgePoint(this.startPoints);
        }
    }

    public static enum RoadType {
        MOTORWAY("motorway", 3.0),
        TRUNK("trunk", 2.0),
        PRIMARY("primary", 1.5);

        private String highwayVal;
        private double weight;

        private RoadType(String highwayVal, double weight) {
            this.highwayVal = highwayVal;
            this.weight = weight;
        }

        public double getWeight() {
            return this.weight;
        }

        public String getTag() {
            return this.highwayVal;
        }
    }
}

