/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.filters.BaseTrackFilter;
import net.osmand.shared.gpx.filters.FilterChangedListener;
import net.osmand.shared.gpx.filters.OtherTrackFilter$;
import net.osmand.shared.gpx.filters.OtherTrackParam;
import net.osmand.shared.gpx.filters.TrackFilterType;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 82\u00020\u0001:\u000278B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B]\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0006\u0010\u0014J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\fJ\u0016\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000fJ\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0016J\u0006\u0010)\u001a\u00020\tJ\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0001H\u0016J\u0013\u0010,\u001a\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\b\u0010/\u001a\u00020\tH\u0016J%\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0001\u00a2\u0006\u0002\b6R*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0018\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u0016R\u0018\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001d\u0010\u0016R\u0018\u0010\u0011\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001e\u0010\u0016\u00a8\u00069"}, d2={"Lnet/osmand/shared/gpx/filters/OtherTrackFilter;", "Lnet/osmand/shared/gpx/filters/BaseTrackFilter;", "trackFilterType", "Lnet/osmand/shared/gpx/filters/TrackFilterType;", "filterChangedListener", "Lnet/osmand/shared/gpx/filters/FilterChangedListener;", "<init>", "(Lnet/osmand/shared/gpx/filters/TrackFilterType;Lnet/osmand/shared/gpx/filters/FilterChangedListener;)V", "seen0", "", "selectedParams", "Ljava/util/ArrayList;", "Lnet/osmand/shared/gpx/filters/OtherTrackParam;", "parameters", "isVisibleOnMap", "", "hasWaypoints", "hasVM", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/osmand/shared/gpx/filters/TrackFilterType;Ljava/util/ArrayList;Ljava/util/ArrayList;ZZZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSelectedParams$annotations", "()V", "getSelectedParams", "()Ljava/util/ArrayList;", "setSelectedParams", "(Ljava/util/ArrayList;)V", "getParameters", "isVisibleOnMap$annotations", "getHasWaypoints$annotations", "getHasVM$annotations", "isEnabled", "isParamSelected", "param", "setItemSelected", "", "selected", "isTrackParamAccepted", "trackItem", "Lnet/osmand/shared/gpx/TrackItem;", "isTrackAccepted", "getSelectedParamsCount", "initWithValue", "value", "equals", "other", "", "hashCode", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$OsmAnd_shared", "$serializer", "Companion", "OsmAnd-shared"})
public final class OtherTrackFilter
extends BaseTrackFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<OtherTrackParam> selectedParams;
    @NotNull
    private final ArrayList<OtherTrackParam> parameters;
    private boolean isVisibleOnMap;
    private boolean hasWaypoints;
    private boolean hasVM;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public OtherTrackFilter(@NotNull TrackFilterType trackFilterType, @Nullable FilterChangedListener filterChangedListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)trackFilterType), (String)"trackFilterType");
        super(trackFilterType, filterChangedListener, null);
        this.selectedParams = new ArrayList();
        this.parameters = new ArrayList();
        if (this.getTrackFilterType().getAdditionalData() instanceof List) {
            for (Object nameResId : (List)this.getTrackFilterType().getAdditionalData()) {
                if (nameResId instanceof OtherTrackParam) {
                    this.parameters.add((OtherTrackParam)((Object)nameResId));
                    continue;
                }
                throw new IllegalArgumentException(this.getTrackFilterType() + "'s additionalParams should contain list of NonDbTrackParam elements");
            }
        }
    }

    @NotNull
    public final ArrayList<OtherTrackParam> getSelectedParams() {
        return this.selectedParams;
    }

    public final void setSelectedParams(@NotNull ArrayList<OtherTrackParam> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.selectedParams = arrayList;
    }

    @Serializable
    public static /* synthetic */ void getSelectedParams$annotations() {
    }

    @NotNull
    public final ArrayList<OtherTrackParam> getParameters() {
        return this.parameters;
    }

    @Serializable
    private static /* synthetic */ void isVisibleOnMap$annotations() {
    }

    @Serializable
    private static /* synthetic */ void getHasWaypoints$annotations() {
    }

    @Serializable
    private static /* synthetic */ void getHasVM$annotations() {
    }

    @Override
    public boolean isEnabled() {
        return !KAlgorithms.INSTANCE.isEmpty((Collection)this.selectedParams);
    }

    public final boolean isParamSelected(@NotNull OtherTrackParam param) {
        Intrinsics.checkNotNullParameter((Object)((Object)param), (String)"param");
        return this.selectedParams.contains((Object)param);
    }

    public final void setItemSelected(@NotNull OtherTrackParam param, boolean selected) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)param), (String)"param");
            ArrayList<OtherTrackParam> newList = new ArrayList<OtherTrackParam>((Collection)this.selectedParams);
            if (selected) {
                if (!newList.contains((Object)param)) {
                    newList.add(param);
                }
            } else {
                newList.remove((Object)param);
            }
            this.selectedParams = newList;
            FilterChangedListener filterChangedListener = this.getFilterChangedListener();
            if (filterChangedListener == null) break block3;
            filterChangedListener.onFilterChanged();
        }
    }

    private final boolean isTrackParamAccepted(TrackItem trackItem, OtherTrackParam param) {
        return switch (WhenMappings.$EnumSwitchMapping$0[param.ordinal()]) {
            case 1 -> PlatformUtil.INSTANCE.getOsmAndContext().isGpxFileVisible(trackItem.getPath());
            case 2 -> {
                int wptPointsCount;
                Object v1 = trackItem.getDataItem();
                int v2 = v1 != null && (v1 = ((GpxDataItem)v1).getAnalysis()) != null ? ((GpxTrackAnalysis)v1).getWptPoints() : (wptPointsCount = 0);
                if (wptPointsCount != 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                Object v3 = trackItem.getDataItem();
                if (v3 != null && (v3 = ((GpxDataItem)v3).getAnalysis()) != null) {
                    yield ((GpxTrackAnalysis)v3).hasAnyObdMetric();
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean isTrackAccepted(@NotNull TrackItem trackItem) {
        Intrinsics.checkNotNullParameter((Object)trackItem, (String)"trackItem");
        Iterator<OtherTrackParam> iterator = this.selectedParams.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<OtherTrackParam> iterator2 = iterator;
        while (iterator2.hasNext()) {
            OtherTrackParam parameter;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)iterator2.next()), (String)"next(...)");
            if (this.isTrackParamAccepted(trackItem, parameter)) continue;
            return false;
        }
        return true;
    }

    public final int getSelectedParamsCount() {
        return this.selectedParams.size();
    }

    @Override
    public void initWithValue(@NotNull BaseTrackFilter value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof OtherTrackFilter) {
            if (((OtherTrackFilter)value).selectedParams != null) {
                this.selectedParams = new ArrayList(((OtherTrackFilter)value).selectedParams);
            } else {
                this.selectedParams = new ArrayList();
                if (((OtherTrackFilter)value).isVisibleOnMap) {
                    this.selectedParams.add(OtherTrackParam.VISIBLE_ON_MAP);
                }
                if (((OtherTrackFilter)value).hasWaypoints) {
                    this.selectedParams.add(OtherTrackParam.WITH_WAYPOINTS);
                }
                if (((OtherTrackFilter)value).hasVM) {
                    this.selectedParams.add(OtherTrackParam.HAS_VEHICLE_METRICS);
                }
            }
            super.initWithValue(value);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return super.equals(other) && other instanceof OtherTrackFilter && ((OtherTrackFilter)other).getTrackFilterType() == this.getTrackFilterType() && this.selectedParams.size() == ((OtherTrackFilter)other).selectedParams.size() && this.selectedParams.containsAll((Collection)((OtherTrackFilter)other).selectedParams);
    }

    @Override
    public int hashCode() {
        return this.selectedParams.hashCode();
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$OsmAnd_shared(OtherTrackFilter self, CompositeEncoder output, SerialDescriptor serialDesc) {
        BaseTrackFilter.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual(self.selectedParams, new ArrayList())) {
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.selectedParams);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual(self.parameters, new ArrayList())) {
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)kSerializerArray[2], self.parameters);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.isVisibleOnMap) {
            output.encodeBooleanElement(serialDesc, 3, self.isVisibleOnMap);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.hasWaypoints) {
            output.encodeBooleanElement(serialDesc, 4, self.hasWaypoints);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.hasVM) {
            output.encodeBooleanElement(serialDesc, 5, self.hasVM);
        }
    }

    public /* synthetic */ OtherTrackFilter(int seen0, TrackFilterType trackFilterType, ArrayList selectedParams, ArrayList parameters, boolean isVisibleOnMap, boolean hasWaypoints, boolean hasVM, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, trackFilterType, serializationConstructorMarker);
        this.selectedParams = (seen0 & 2) == 0 ? new ArrayList() : selectedParams;
        this.parameters = (seen0 & 4) == 0 ? new ArrayList() : parameters;
        this.isVisibleOnMap = (seen0 & 8) == 0 ? false : isVisibleOnMap;
        this.hasWaypoints = (seen0 & 0x10) == 0 ? false : hasWaypoints;
        this.hasVM = (seen0 & 0x20) == 0 ? false : hasVM;
        if (this.getTrackFilterType().getAdditionalData() instanceof List) {
            for (Object nameResId : (List)this.getTrackFilterType().getAdditionalData()) {
                if (nameResId instanceof OtherTrackParam) {
                    this.parameters.add((OtherTrackParam)((Object)nameResId));
                    continue;
                }
                throw new IllegalArgumentException(this.getTrackFilterType() + "'s additionalParams should contain list of NonDbTrackParam elements");
            }
        }
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{TrackFilterType.Companion.serializer(), new ArrayListSerializer(EnumsKt.createSimpleEnumSerializer((String)"net.osmand.shared.gpx.filters.OtherTrackParam", (Enum[])OtherTrackParam.values())), new ArrayListSerializer(EnumsKt.createSimpleEnumSerializer((String)"net.osmand.shared.gpx.filters.OtherTrackParam", (Enum[])OtherTrackParam.values())), null, null, null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/gpx/filters/OtherTrackFilter$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/gpx/filters/OtherTrackFilter;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<OtherTrackFilter> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OtherTrackParam.values().length];
            try {
                nArray[OtherTrackParam.VISIBLE_ON_MAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OtherTrackParam.WITH_WAYPOINTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OtherTrackParam.HAS_VEHICLE_METRICS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

