/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.util.Algorithms;

public class BinaryMapIndexReaderStats {

    public static class MapObjectStat {
        public int lastStringNamesSize;
        public int lastObjectIdSize;
        public int lastObjectHeaderInfo;
        public int lastObjectAdditionalTypes;
        public int lastObjectTypes;
        public int lastObjectCoordinates;
        public int lastObjectLabelCoordinates;
        public int lastObjectSize;
        public int lastBlockStringTableSize;
        public int lastBlockHeaderInfo;

        public void addBlockHeader(int typesFieldNumber, int sizeL) {
            this.lastBlockHeaderInfo += CodedOutputStream.computeTagSize(typesFieldNumber) + CodedOutputStream.computeRawVarint32Size(sizeL);
        }

        public void addTagHeader(int typesFieldNumber, int sizeL) {
            this.lastObjectHeaderInfo += CodedOutputStream.computeTagSize(typesFieldNumber) + CodedOutputStream.computeRawVarint32Size(sizeL);
        }

        public void clearObjectStats() {
            this.lastStringNamesSize = 0;
            this.lastObjectIdSize = 0;
            this.lastObjectHeaderInfo = 0;
            this.lastObjectAdditionalTypes = 0;
            this.lastObjectTypes = 0;
            this.lastObjectCoordinates = 0;
            this.lastObjectLabelCoordinates = 0;
        }
    }

    public static class SearchStat {
        long lastReq = 0L;
        public long totalTime = 0L;
        public long totalBytes = 0L;
        public int prevResultsSize = 0;
        public String requestWord = "";
        Map<BinaryMapIndexReaderApiName, StatByAPI> byApis = new HashMap<BinaryMapIndexReaderApiName, StatByAPI>();
        Map<String, WordSearchStat> wordStats = new HashMap<String, WordSearchStat>();

        public Map<String, WordSearchStat> getWordStats() {
            return this.wordStats;
        }

        public long beginSearchStats(BinaryMapIndexReaderApiName api, BinaryMapIndexReader.SearchRequest<?> req, BinaryIndexPart part, CodedInputStream codedIS, String extraInfo) {
            this.lastReq = System.nanoTime();
            codedIS.resetBytesCounter();
            this.prevResultsSize = req != null && req.getSearchResults() != null ? req.getSearchResults().size() : 0;
            this.requestWord = req != null && !Algorithms.isEmpty(req.nameQuery) ? req.nameQuery : "";
            return this.lastReq;
        }

        public void endSearchStats(long statReq, BinaryMapIndexReaderApiName api, List<?> objects, BinaryIndexPart part, CodedInputStream codedIS, String extraInfo) {
            WordSearchStat wordStat;
            if (statReq != this.lastReq) {
                System.err.println("ERROR: in stats counting to fix ! " + statReq + " != " + this.lastReq);
            }
            if (this.requestWord == null) {
                this.requestWord = "";
            }
            if ((wordStat = this.wordStats.get(this.requestWord)) == null) {
                wordStat = new WordSearchStat();
                wordStat.requestWord = this.requestWord;
                this.wordStats.put(this.requestWord, wordStat);
            }
            ++wordStat.apis;
            wordStat.results += objects.size();
            wordStat.apiCalls.compute(api, (k, cnt) -> cnt == null ? 1 : cnt + 1);
            for (Object o : objects) {
                wordStat.resultCounts.compute(o.getClass().getSimpleName(), (k, cnt) -> cnt == null ? 1 : cnt + 1);
            }
            long timeCall = System.nanoTime() - statReq;
            long bytes = codedIS.getBytesCounter();
            this.totalTime += timeCall;
            this.totalBytes += bytes;
            StatByAPI statByAPI = this.byApis.get((Object)api);
            if (statByAPI == null) {
                statByAPI = new StatByAPI();
                statByAPI.api = api;
                this.byApis.put(api, statByAPI);
            }
            statByAPI.bytes += bytes;
            ++statByAPI.calls;
            statByAPI.time += timeCall;
        }

        public String toString() {
            return String.format("Search stat: time %.3f, bytes %,d KB, by apis - %s; words %s", (double)this.totalTime / 1.0E9, this.totalBytes / 1024L, this.byApis.values(), this.wordStats);
        }
    }

    public static class WordSearchStat {
        public int results;
        public int apis;
        public Map<String, Integer> resultCounts = new HashMap<String, Integer>();
        public Map<BinaryMapIndexReaderApiName, Integer> apiCalls = new HashMap<BinaryMapIndexReaderApiName, Integer>();
        public String requestWord;

        public String toString() {
            return String.format("api %s, results %s ", this.apiCalls, this.resultCounts);
        }
    }

    private static class StatByAPI {
        BinaryMapIndexReaderApiName api;
        int calls;
        long time;
        long bytes;
        Map<String, SubStatByAPI> subapis = new HashMap<String, SubStatByAPI>();

        private StatByAPI() {
        }

        public SubStatByAPI getSubApi(String mapName, BinaryMapIndexReaderSubApiName api) {
            String key = api.name() + "_" + mapName;
            SubStatByAPI subapi = this.subapis.get(key);
            if (!this.subapis.containsKey(key)) {
                subapi = new SubStatByAPI();
                subapi.mapName = mapName;
                subapi.api = api;
                this.subapis.put(key, subapi);
            }
            return subapi;
        }

        public String toString() {
            return String.format("API %s [call %d, time %.2f, %,d KB]", new Object[]{this.api, this.calls, (double)this.time / 1.0E9, this.bytes / 1024L});
        }
    }

    private static class SubStatByAPI {
        BinaryMapIndexReaderSubApiName api;
        String mapName;
        int calls;
        long time;

        private SubStatByAPI() {
        }
    }

    public static enum BinaryMapIndexReaderSubApiName {
        ADDRESS_NAME_INDEX,
        ADDRESS_NAME_REFERENCES,
        ADDRESS_NAME_OBJECTS,
        POI_NAME_INDEX,
        POI_NAME_REFERENCES,
        POI_NAME_OBJECTS;

    }

    public static enum BinaryMapIndexReaderApiName {
        ADDRESS_BY_NAME,
        POI_BY_NAME,
        LOAD_STREETS,
        LOAD_CITIES,
        LOAD_BUILDINGS,
        POI_BY_TYPE;

    }
}

