/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import gnu.trove.TLongCollection;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GeneralRouter;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.util.MapUtils;

public class ManyToOneRoadCalculation {
    private static final int THRESHOLD_DISCONNECTED = 200;

    public static void main(String[] args) throws IOException, InterruptedException {
        File fl = new File("/home/victor/projects/osmand/osm-gen/Netherlands_europe_2.obf");
        RandomAccessFile raf = new RandomAccessFile(fl, "r");
        BinaryMapIndexReader reader = new BinaryMapIndexReader(raf, fl);
        int zoom = 9;
        double top = 53.2949;
        double bottom = MapUtils.getLatitudeFromTile((float)zoom, (double)(MapUtils.getTileNumberY((float)zoom, (double)top) + 1.0));
        System.out.println(top + " - " + bottom);
        new ManyToOneRoadCalculation().manyToManyCalculation(reader, top, bottom);
    }

    private void manyToManyCalculation(BinaryMapIndexReader reader, double top, double bottom) throws IOException {
        RoutePlannerFrontEnd frontEnd = new RoutePlannerFrontEnd();
        RoutingConfiguration.RoutingMemoryLimits memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(1000, 2560);
        RoutingConfiguration config = RoutingConfiguration.getDefault().build("car", memoryLimit);
        RoutePlannerFrontEnd.RouteCalculationMode mode = RoutePlannerFrontEnd.RouteCalculationMode.BASE;
        RoutingContext ctx = frontEnd.buildRoutingContext(config, null, new BinaryMapIndexReader[]{reader}, mode);
        BinaryMapRouteReaderAdapter.RouteRegion reg = (BinaryMapRouteReaderAdapter.RouteRegion)reader.getRoutingIndexes().get(0);
        List baseSubregions = reg.getBaseSubregions();
        ArrayList<RoutingContext.RoutingSubregionTile> tiles = new ArrayList<RoutingContext.RoutingSubregionTile>();
        for (BinaryMapRouteReaderAdapter.RouteSubregion s : baseSubregions) {
            List loadTiles = ctx.loadAllSubregionTiles(reader, s);
            tiles.addAll(loadTiles);
        }
        int st = MapUtils.get31TileNumberY((double)top);
        int sb = MapUtils.get31TileNumberY((double)bottom);
        ArrayList<ManyToManySegment> topIntersects = new ArrayList<ManyToManySegment>();
        ArrayList<ManyToManySegment> bottomIntersects = new ArrayList<ManyToManySegment>();
        TLongObjectHashMap<ManyToManySegment> allSegments = this.initSegments(st, sb, ctx, tiles, topIntersects, bottomIntersects);
        this.filterDisconnected(ctx, allSegments, topIntersects);
        this.filterDisconnected(ctx, allSegments, topIntersects);
        System.out.println("TOP " + topIntersects.size());
        System.out.println("BOTTOM " + bottomIntersects.size());
        this.calculateManyToMany(ctx, allSegments, topIntersects, bottomIntersects, st, sb);
    }

    private void filterDisconnected(RoutingContext ctx, TLongObjectHashMap<ManyToManySegment> allSegments, List<ManyToManySegment> initialSegments) {
        Iterator<ManyToManySegment> it = initialSegments.iterator();
        while (it.hasNext()) {
            ManyToManySegment init = it.next();
            int iterations = 0;
            int threshold = 200;
            LinkedList<ManyToManySegment> mms = new LinkedList<ManyToManySegment>();
            TLongHashSet visited = new TLongHashSet();
            mms.push(init);
            while (iterations < threshold && !mms.isEmpty()) {
                ManyToManySegment o = (ManyToManySegment)mms.poll();
                if (!visited.add(o.road.id)) continue;
                int ow = ctx.config.router.isOneWay(o.road);
                int start = ow > 0 ? o.segmentIndex : 0;
                int end = ow < 0 ? o.segmentIndex : o.road.getPointsLength();
                for (int i = start; i < end; ++i) {
                    long calcLong = this.calcLong(o.road.getPoint31XTile(i), o.road.getPoint31YTile(i));
                    ManyToManySegment ind = (ManyToManySegment)allSegments.get(calcLong);
                    while (ind != null) {
                        if (!visited.contains(ind.road.id)) {
                            mms.push(ind);
                        }
                        ind = ind.next;
                    }
                }
                ++iterations;
            }
            if (iterations >= threshold) continue;
            it.remove();
        }
    }

    public static double squareRootDist(int x1, int y1, int x2, int y2) {
        return MapUtils.squareRootDist31((int)x1, (int)y1, (int)x2, (int)y2);
    }

    private void calculateManyToMany(RoutingContext ctx, TLongObjectHashMap<ManyToManySegment> allSegments, List<ManyToManySegment> topIntersects, List<ManyToManySegment> bottomIntersects, int stop, int sbottom) {
        GeneralRouter router = ctx.config.router;
        float DISTANCE_THRESHOLD = 50000.0f;
        ArrayList<TLongArrayList> sets = new ArrayList<TLongArrayList>();
        for (int i = 0; i < topIntersects.size(); ++i) {
            ManyToManySegment oneTop = topIntersects.get(i);
            this.clearAllSegments(allSegments);
            List<ManyToManySegment> finalSegmentResult = this.calculateOneToMany(allSegments, bottomIntersects, sbottom, router, oneTop);
            for (ManyToManySegment fnsResult : finalSegmentResult) {
                TLongArrayList set = this.convertToRoadIds(fnsResult, DISTANCE_THRESHOLD / router.getMaxSpeed());
                this.combineWithLocal(sets, set);
            }
            System.out.println(oneTop.road.getHighway() + " " + oneTop.road.id + " " + oneTop.segmentIndex + " common ways=" + sets.size());
        }
        System.out.println(sets.size());
        for (TLongArrayList s : sets) {
            System.out.println(s);
        }
    }

    private void combineWithLocal(List<TLongArrayList> sets, TLongArrayList source) {
        boolean found = false;
        TLongHashSet set = new TLongHashSet((TLongCollection)source);
        for (TLongArrayList oneList : sets) {
            int k;
            for (k = 0; k < oneList.size() && !set.contains(oneList.get(k)); ++k) {
            }
            if (k < oneList.size()) {
                oneList.remove(0, k);
                for (k = 0; k < oneList.size() && set.contains(oneList.get(k)); ++k) {
                }
                if (k < oneList.size()) {
                    oneList.remove(k, oneList.size() - k);
                }
                found = true;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            sets.add(source);
        }
    }

    private void clearAllSegments(TLongObjectHashMap<ManyToManySegment> allSegments) {
        Iterator iterator = allSegments.valueCollection().iterator();
        while (iterator.hasNext()) {
            ManyToManySegment m;
            ManyToManySegment mp = m = (ManyToManySegment)iterator.next();
            while (mp != null) {
                mp.parentEndIndex = 0;
                mp.parentSegment = null;
                mp.distanceFromStart = Double.POSITIVE_INFINITY;
                mp = mp.next;
            }
        }
    }

    private List<ManyToManySegment> calculateOneToMany(TLongObjectHashMap<ManyToManySegment> allSegments, List<ManyToManySegment> bottomIntersects, int sbottom, GeneralRouter router, ManyToManySegment oneTop) {
        if (router.isOneWay(oneTop.road) > 0 && oneTop.segmentIndex == oneTop.road.getPointsLength() - 1) {
            s = oneTop.segmentIndex - 1;
            key = this.calcLong(oneTop.road.getPoint31XTile(s), oneTop.road.getPoint31YTile(s));
            oneTop = this.find((ManyToManySegment)allSegments.get(key), oneTop.road.id);
        } else if (router.isOneWay(oneTop.road) < 0 && oneTop.segmentIndex == 0) {
            s = oneTop.segmentIndex + 1;
            key = this.calcLong(oneTop.road.getPoint31XTile(s), oneTop.road.getPoint31YTile(s));
            oneTop = this.find((ManyToManySegment)allSegments.get(key), oneTop.road.id);
        }
        PriorityQueue<ManyToManySegment> queue = new PriorityQueue<ManyToManySegment>(100, new Comparator<ManyToManySegment>(){

            @Override
            public int compare(ManyToManySegment arg0, ManyToManySegment arg1) {
                return Double.compare(arg0.distanceFromStart, arg1.distanceFromStart);
            }
        });
        TLongHashSet finalSegments = new TLongHashSet();
        for (ManyToManySegment fs : bottomIntersects) {
            finalSegments.add(fs.road.id);
        }
        oneTop.distanceFromStart = 0.0;
        queue.add(oneTop);
        TLongHashSet visitedSegments = new TLongHashSet();
        ArrayList<ManyToManySegment> finalSegmentResult = new ArrayList<ManyToManySegment>();
        while (!queue.isEmpty()) {
            ManyToManySegment seg = queue.poll();
            if (finalSegments.contains(seg.road.id)) {
                finalSegmentResult.add(seg);
                finalSegments.remove(seg.road.id);
                if (finalSegments.size() != 0) continue;
                break;
            }
            int oneWay = router.isOneWay(seg.road);
            if (oneWay >= 0) {
                this.processRoadSegment(queue, router, sbottom, seg, true, allSegments, visitedSegments);
            }
            if (oneWay > 0) continue;
            this.processRoadSegment(queue, router, sbottom, seg, false, allSegments, visitedSegments);
        }
        return finalSegmentResult;
    }

    private ManyToManySegment find(ManyToManySegment ms, long id) {
        while (ms != null && ms.road.id != id) {
            ms = ms.next;
        }
        return ms;
    }

    private TLongArrayList convertToRoadIds(ManyToManySegment fnsResult, float distanceFromStart) {
        TLongArrayList set = new TLongArrayList();
        ManyToManySegment ms = fnsResult;
        while (ms != null) {
            set.add(ms.road.id);
            ms = ms.parentSegment;
            if (!(ms.distanceFromStart < (double)distanceFromStart)) continue;
            break;
        }
        return set;
    }

    private void processRoadSegment(PriorityQueue<ManyToManySegment> queue, GeneralRouter router, int sbottom, ManyToManySegment seg, boolean direction, TLongObjectHashMap<ManyToManySegment> allSegments, TLongHashSet visitedSegments) {
        int p = seg.segmentIndex;
        double dist = 0.0;
        double speed = router.defineRoutingSpeed(seg.road, direction);
        boolean continueMovement = true;
        while (continueMovement) {
            int pp = p;
            visitedSegments.add(this.calcSegmentId(seg));
            int n = p = direction ? p + 1 : p - 1;
            if (p >= seg.road.getPointsLength() || p < 0) break;
            int px = seg.road.getPoint31XTile(p);
            int py = seg.road.getPoint31YTile(p);
            long key = this.calcLong(px, py);
            ManyToManySegment sgs = (ManyToManySegment)allSegments.get(key);
            double distFromStart = seg.distanceFromStart + (dist += ManyToOneRoadCalculation.squareRootDist(seg.road.getPoint31XTile(pp), seg.road.getPoint31YTile(pp), px, py)) / speed;
            while (sgs != null) {
                boolean visited = visitedSegments.contains(this.calcSegmentId(sgs));
                if (sgs.road != seg.road) {
                    boolean viewed;
                    boolean bl = viewed = !Double.isInfinite(sgs.distanceFromStart);
                    if (!viewed || sgs.distanceFromStart > distFromStart) {
                        if (visited) {
                            if (sgs.distanceFromStart > distFromStart * 1.1) {
                                System.err.println("Prev " + sgs.distanceFromStart + " ? current " + distFromStart + " " + seg.distanceFromStart + " " + sgs.road.id + " : prev " + sgs.parentSegment.road.id + " current " + seg.road.id);
                            }
                        } else {
                            if (viewed) {
                                queue.remove(sgs);
                            }
                            if (sgs.distanceFromStart < distFromStart) {
                                throw new IllegalArgumentException();
                            }
                            sgs.distanceFromStart = distFromStart;
                            sgs.parentEndIndex = pp;
                            sgs.parentSegment = seg;
                            queue.add(sgs);
                        }
                    }
                } else if (sgs.distanceFromStart > distFromStart) {
                    if (visited) {
                        System.err.println("!Prev " + sgs.distanceFromStart + " ? current " + distFromStart + " " + seg.distanceFromStart + " " + sgs.road.id + " : prev " + sgs.parentSegment.road.id + " current " + seg.road.id);
                    } else {
                        sgs.parentSegment = seg.parentSegment;
                        sgs.distanceFromStart = distFromStart;
                    }
                } else {
                    continueMovement = false;
                }
                sgs = sgs.next;
            }
        }
    }

    private long calcSegmentId(ManyToManySegment seg) {
        return (seg.road.id << 10) + (long)seg.segmentIndex;
    }

    private TLongObjectHashMap<ManyToManySegment> initSegments(int stop, int sbottom, RoutingContext ctx, List<RoutingContext.RoutingSubregionTile> tiles, List<ManyToManySegment> topIntersects, List<ManyToManySegment> bottomIntersects) {
        TLongObjectHashMap res = new TLongObjectHashMap();
        ArrayList startObjects = new ArrayList();
        for (RoutingContext.RoutingSubregionTile st : tiles) {
            if (st.subregion.top > sbottom || st.subregion.bottom < stop) continue;
            ctx.loadSubregionTile(st, false, startObjects, null);
        }
        System.out.println("Roads in layer " + startObjects.size());
        for (RouteDataObject ro : startObjects) {
            boolean topCheck = false;
            boolean bottomCheck = false;
            for (int i = 0; i < ro.getPointsLength(); ++i) {
                long key;
                ManyToManySegment sm;
                ManyToManySegment sg = new ManyToManySegment();
                sg.road = ro;
                sg.segmentIndex = i;
                int px = ro.getPoint31XTile(i);
                int py = ro.getPoint31YTile(i);
                if (i > 0) {
                    int prevY;
                    int prevX = ro.getPoint31XTile(i - 1);
                    if (this.checkIntersection(prevX, prevY = ro.getPoint31YTile(i - 1), px, py, 0, Integer.MAX_VALUE, stop, stop) && !topCheck) {
                        topIntersects.add(sg);
                        topCheck = true;
                    }
                    if (this.checkIntersection(prevX, prevY, px, py, 0, Integer.MAX_VALUE, sbottom, sbottom) && !bottomCheck) {
                        bottomIntersects.add(sg);
                        bottomCheck = true;
                    }
                }
                if ((sm = (ManyToManySegment)res.get(key = this.calcLong(px, py))) != null) {
                    while (sm.next != null) {
                        sm = sm.next;
                    }
                    sm.next = sg;
                    continue;
                }
                res.put(key, (Object)sg);
            }
        }
        return res;
    }

    private boolean checkIntersection(int prevx, int prevy, int px, int py, int l, int r, int t, int b) {
        boolean intersectY;
        int xin;
        int pyin;
        int pxin;
        int n = prevx <= l ? -1 : (pxin = prevx >= r ? 1 : 0);
        int n2 = prevy <= t ? -1 : (pyin = prevy >= b ? 1 : 0);
        int n3 = px <= l ? -1 : (xin = px >= r ? 1 : 0);
        int yin = py <= t ? -1 : (py >= b ? 1 : 0);
        boolean intersectX = xin != pxin && (yin != pyin || yin == 0);
        boolean bl = intersectY = yin != pyin && (xin != pxin || xin == 0);
        return intersectY || intersectX;
    }

    private long calcLong(int x31, int y31) {
        return ((long)x31 << 31) + (long)y31;
    }

    private void cut(BinaryMapIndexReader reader) throws IOException {
        RoutePlannerFrontEnd frontEnd = new RoutePlannerFrontEnd();
        RoutingConfiguration.RoutingMemoryLimits memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(1000, 2560);
        RoutingConfiguration config = RoutingConfiguration.getDefault().build("car", memoryLimit);
        RoutePlannerFrontEnd.RouteCalculationMode mode = RoutePlannerFrontEnd.RouteCalculationMode.BASE;
        RoutingContext ctx = frontEnd.buildRoutingContext(config, null, new BinaryMapIndexReader[]{reader}, mode);
        BinaryMapRouteReaderAdapter.RouteRegion reg = (BinaryMapRouteReaderAdapter.RouteRegion)reader.getRoutingIndexes().get(0);
        List baseSubregions = reg.getBaseSubregions();
        ArrayList<RoutingContext.RoutingSubregionTile> tiles = new ArrayList<RoutingContext.RoutingSubregionTile>();
        for (BinaryMapRouteReaderAdapter.RouteSubregion s : baseSubregions) {
            List loadTiles = ctx.loadAllSubregionTiles(reader, s);
            tiles.addAll(loadTiles);
        }
        int zoom = 9;
        int ty = (int)MapUtils.getTileNumberY((float)zoom, (double)reg.getTopLatitude());
        int by = (int)MapUtils.getTileNumberY((float)zoom, (double)reg.getBottomLatitude()) + 1;
        int lx = (int)MapUtils.getTileNumberX((float)zoom, (double)reg.getLeftLongitude());
        int rx = (int)MapUtils.getTileNumberX((float)zoom, (double)reg.getRightLongitude()) + 1;
        for (int ky = ty + 1; ky < by; ++ky) {
            for (int kx = lx + 1; kx < rx; ++kx) {
                this.cutByQuadrant(kx - 1 << 31 - zoom, ky - 1 << 31 - zoom, kx << 31 - zoom, ky << 31 - zoom, ctx, tiles);
            }
        }
    }

    private void cutByQuadrant(int px, int py, int sx, int sy, RoutingContext ctx, List<RoutingContext.RoutingSubregionTile> tiles) {
        int bc = 0;
        int rc = 0;
        LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
        for (RoutingContext.RoutingSubregionTile st : tiles) {
            if (st.subregion.left > sx || st.subregion.right < px || st.subregion.top > sy || st.subregion.bottom < py) continue;
            ArrayList<RouteDataObject> startObjects = new ArrayList<RouteDataObject>();
            ctx.loadSubregionTile(st, false, startObjects, null);
            List<BinaryRoutePlanner.RouteSegment> res = this.filterIntersections(px, sx, sy, sy, startObjects);
            bc += res.size();
            this.updateCounts(counts, res);
            res = this.filterIntersections(sx, sx, py, sy, startObjects);
            rc += res.size();
            this.updateCounts(counts, res);
        }
        if (bc + rc > 0) {
            System.out.println("Q " + (float)MapUtils.get31LatitudeY((int)sy) + " " + (float)MapUtils.get31LongitudeX((int)sx) + " \t  B=" + bc + " R=" + rc + " " + String.valueOf(counts));
        }
    }

    private void updateCounts(Map<String, Integer> counts, List<BinaryRoutePlanner.RouteSegment> res) {
        for (BinaryRoutePlanner.RouteSegment r : res) {
            Integer c;
            String key = r.getRoad().getHighway();
            if (key == null) {
                key = r.getRoad().getRoute();
            }
            if ((c = counts.get(key)) == null) {
                c = 0;
            }
            c = c + 1;
            counts.put(key, c);
        }
    }

    private List<BinaryRoutePlanner.RouteSegment> filterIntersections(int l, int r, int t, int b, List<RouteDataObject> startObjects) {
        ArrayList<BinaryRoutePlanner.RouteSegment> intersections = new ArrayList<BinaryRoutePlanner.RouteSegment>();
        block0: for (RouteDataObject rdo : startObjects) {
            if (rdo == null) continue;
            int pxin = 0;
            int pyin = 0;
            for (int i = 0; i < rdo.getPointsLength(); ++i) {
                int yin;
                int xin;
                int x = rdo.getPoint31XTile(i);
                int y = rdo.getPoint31YTile(i);
                int n = x <= l ? -1 : (xin = x >= r ? 1 : 0);
                int n2 = y <= t ? -1 : (yin = y >= b ? 1 : 0);
                if (i > 0) {
                    boolean intersectY;
                    boolean intersectX = xin != pxin && (yin != pyin || yin == 0);
                    boolean bl = intersectY = yin != pyin && (xin != pxin || xin == 0);
                    if (intersectY || intersectX) {
                        intersections.add(new BinaryRoutePlanner.RouteSegment(rdo, rdo.getOneway() >= 0 ? i - 1 : i));
                        continue block0;
                    }
                }
                pxin = xin;
                pyin = yin;
            }
        }
        return intersections;
    }

    private List<ManyToManySegment> filterIntersectionSegments(int l, int r, int t, int b, List<RouteDataObject> startObjects) {
        ArrayList<ManyToManySegment> intersections = new ArrayList<ManyToManySegment>();
        block0: for (RouteDataObject rdo : startObjects) {
            if (rdo == null) continue;
            int pxin = 0;
            int pyin = 0;
            for (int i = 0; i < rdo.getPointsLength(); ++i) {
                int yin;
                int xin;
                int x = rdo.getPoint31XTile(i);
                int y = rdo.getPoint31YTile(i);
                int n = x <= l ? -1 : (xin = x >= r ? 1 : 0);
                int n2 = y <= t ? -1 : (yin = y >= b ? 1 : 0);
                if (i > 0) {
                    boolean intersectY;
                    boolean intersectX = xin != pxin && (yin != pyin || yin == 0);
                    boolean bl = intersectY = yin != pyin && (xin != pxin || xin == 0);
                    if (intersectY || intersectX) {
                        ManyToManySegment segment = new ManyToManySegment();
                        segment.segmentIndex = rdo.getOneway() >= 0 ? i - 1 : i;
                        segment.road = rdo;
                        intersections.add(segment);
                        continue block0;
                    }
                }
                pxin = xin;
                pyin = yin;
            }
        }
        return intersections;
    }

    public class ManyToManySegment {
        public RouteDataObject road;
        public int segmentIndex;
        public double distanceFromStart = Double.POSITIVE_INFINITY;
        public ManyToManySegment next;
        public ManyToManySegment parentSegment;
        public int parentEndIndex;

        public double estimateDistanceEnd(GeneralRouter router, int sbottom) {
            return ManyToOneRoadCalculation.squareRootDist(0, this.road.getPoint31YTile(this.segmentIndex), 0, sbottom) / (double)router.getMaxSpeed();
        }
    }
}

