/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.IMapDataProvider;
import net.osmand.core.jni.IMapTiledDataProvider;
import net.osmand.core.jni.MapObjectList;
import net.osmand.core.jni.MapSurfaceType;
import net.osmand.core.jni.Metric;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t;
import net.osmand.core.jni.TileId;
import net.osmand.core.jni.ZoomLevel;

public class IMapObjectsProvider
extends IMapTiledDataProvider {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected IMapObjectsProvider(long l, boolean bl) {
        super(OsmAndCoreJNI.IMapObjectsProvider_SWIGSmartPtrUpcast(l), true);
        this.swigCMemOwnDerived = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(IMapObjectsProvider iMapObjectsProvider) {
        return iMapObjectsProvider == null ? 0L : iMapObjectsProvider.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwnDerived = bl;
        super.swigSetCMemOwn(bl);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                OsmAndCoreJNI.delete_IMapObjectsProvider(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public boolean obtainTiledMapObjects(IMapTiledDataProvider.Request request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t, Metric metric) {
        return OsmAndCoreJNI.IMapObjectsProvider_obtainTiledMapObjects__SWIG_0(this.swigCPtr, this, IMapTiledDataProvider.Request.getCPtr(request), request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t.getCPtr(sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t), Metric.getCPtr(metric), metric);
    }

    public boolean obtainTiledMapObjects(IMapTiledDataProvider.Request request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t) {
        return OsmAndCoreJNI.IMapObjectsProvider_obtainTiledMapObjects__SWIG_1(this.swigCPtr, this, IMapTiledDataProvider.Request.getCPtr(request), request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t.getCPtr(sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapObjectsProvider__Data_t));
    }

    public static class Data
    extends IMapTiledDataProvider.Data {
        private transient long swigCPtr;

        protected Data(long l, boolean bl) {
            super(OsmAndCoreJNI.IMapObjectsProvider_Data_SWIGUpcast(l), bl);
            this.swigCPtr = l;
        }

        protected static long getCPtr(Data data) {
            return data == null ? 0L : data.swigCPtr;
        }

        protected static long swigRelease(Data data) {
            long l = 0L;
            if (data != null) {
                if (!data.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = data.swigCPtr;
                data.swigCMemOwn = false;
                data.delete();
            }
            return l;
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_IMapObjectsProvider_Data(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public Data(TileId tileId, ZoomLevel zoomLevel, MapSurfaceType mapSurfaceType, MapObjectList mapObjectList, IMapDataProvider.RetainableCacheMetadata retainableCacheMetadata) {
            this(OsmAndCoreJNI.new_IMapObjectsProvider_Data__SWIG_0(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue(), mapSurfaceType.swigValue(), MapObjectList.getCPtr(mapObjectList), mapObjectList, IMapDataProvider.RetainableCacheMetadata.getCPtr(retainableCacheMetadata), retainableCacheMetadata), true);
        }

        public Data(TileId tileId, ZoomLevel zoomLevel, MapSurfaceType mapSurfaceType, MapObjectList mapObjectList) {
            this(OsmAndCoreJNI.new_IMapObjectsProvider_Data__SWIG_1(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue(), mapSurfaceType.swigValue(), MapObjectList.getCPtr(mapObjectList), mapObjectList), true);
        }

        public void setTileSurfaceType(MapSurfaceType mapSurfaceType) {
            OsmAndCoreJNI.IMapObjectsProvider_Data_tileSurfaceType_set(this.swigCPtr, this, mapSurfaceType.swigValue());
        }

        public MapSurfaceType getTileSurfaceType() {
            return MapSurfaceType.swigToEnum(OsmAndCoreJNI.IMapObjectsProvider_Data_tileSurfaceType_get(this.swigCPtr, this));
        }

        public void setMapObjects(MapObjectList mapObjectList) {
            OsmAndCoreJNI.IMapObjectsProvider_Data_mapObjects_set(this.swigCPtr, this, MapObjectList.getCPtr(mapObjectList), mapObjectList);
        }

        public MapObjectList getMapObjects() {
            long l = OsmAndCoreJNI.IMapObjectsProvider_Data_mapObjects_get(this.swigCPtr, this);
            return l == 0L ? null : new MapObjectList(l, false);
        }
    }
}

