/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import net.osmand.util.MapUtils;

public abstract class ElevationApproximator {
    private static final double SLOPE_THRESHOLD = 70.0;
    private double[] distances;
    private double[] elevations;

    public abstract double getPointLatitude(int var1);

    public abstract double getPointLongitude(int var1);

    public abstract double getPointElevation(int var1);

    public abstract int getPointsCount();

    public double[] getDistances() {
        return this.distances;
    }

    public double[] getElevations() {
        return this.elevations;
    }

    public boolean approximate() {
        int i;
        int pointsCount = this.getPointsCount();
        if (pointsCount < 4) {
            return false;
        }
        boolean[] survived = new boolean[pointsCount];
        int lastSurvived = 0;
        int survidedCount = 0;
        for (i = 1; i < pointsCount - 1; ++i) {
            double eleNext;
            double prevEle = this.getPointElevation(lastSurvived);
            double ele = this.getPointElevation(i);
            if (!((ele - prevEle) * ((eleNext = this.getPointElevation(i + 1)) - ele) > 0.0)) continue;
            survived[i] = true;
            lastSurvived = i;
            ++survidedCount;
        }
        if (survidedCount < 2) {
            return false;
        }
        lastSurvived = 0;
        survidedCount = 0;
        for (i = 1; i < pointsCount - 1; ++i) {
            double dist;
            double prevEle;
            if (!survived[i]) continue;
            double ele = this.getPointElevation(i);
            double slope = (ele - (prevEle = this.getPointElevation(lastSurvived))) * 100.0 / (dist = MapUtils.getDistance(this.getPointLatitude(i), this.getPointLongitude(i), this.getPointLatitude(lastSurvived), this.getPointLongitude(lastSurvived)));
            if (Math.abs(slope) > 70.0) {
                survived[i] = false;
                continue;
            }
            lastSurvived = i;
            ++survidedCount;
        }
        if (survidedCount < 2) {
            return false;
        }
        survived[0] = true;
        survived[pointsCount - 1] = true;
        double[] distances = new double[survidedCount + 2];
        double[] elevations = new double[survidedCount + 2];
        int k = 0;
        lastSurvived = 0;
        for (int i2 = 0; i2 < pointsCount; ++i2) {
            if (!survived[i2]) continue;
            distances[k] = lastSurvived == 0 ? 0.0 : MapUtils.getDistance(this.getPointLatitude(i2), this.getPointLongitude(i2), this.getPointLatitude(lastSurvived), this.getPointLongitude(lastSurvived));
            elevations[k] = this.getPointElevation(i2);
            ++k;
            lastSurvived = i2;
        }
        this.distances = distances;
        this.elevations = elevations;
        return true;
    }
}

