/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GpxRouteApproximation;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.util.MapUtils;

public class GpxPointsMatchApproximation {
    private final int LOOKUP_AHEAD = 10;
    private final boolean TEST_SHIFT_GPX_POINTS = false;
    private final double DILUTE_BY_SEGMENT_DISTANCE = 0.001;

    public GpxRouteApproximation gpxApproximation(RoutePlannerFrontEnd frontEnd, GpxRouteApproximation gctx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints) throws IOException {
        long timeToCalculate = System.nanoTime();
        this.initGpxPointsXY31(gpxPoints);
        float minPointApproximation = gctx.ctx.config.minPointApproximation;
        RoutePlannerFrontEnd.GpxPoint currentPoint = this.findNextRoutablePoint(frontEnd, gctx, minPointApproximation, gpxPoints, 0);
        while (currentPoint != null && currentPoint.pnt != null) {
            double minDistSqrSegment = 0.0;
            RouteSegmentResult fres = null;
            int minNextInd = -1;
            for (int j = currentPoint.ind + 1; j < Math.min(currentPoint.ind + 10, gpxPoints.size()); ++j) {
                RouteSegmentResult[] res = new RouteSegmentResult[1];
                double minDistSqr = Double.POSITIVE_INFINITY;
                RoutePlannerFrontEnd.GpxPoint ps = gpxPoints.get(j);
                minDistSqr = this.minDistResult(res, minDistSqr, currentPoint.pnt, ps);
                if (currentPoint.pnt.others != null) {
                    for (BinaryRoutePlanner.RouteSegmentPoint oth : currentPoint.pnt.others) {
                        minDistSqr = this.minDistResult(res, minDistSqr, oth, ps);
                    }
                }
                if (fres == null || minDistSqr <= minDistSqrSegment) {
                    fres = res[0];
                    minDistSqrSegment = minDistSqr;
                    minNextInd = j;
                }
                if (MapUtils.getDistance(currentPoint.loc, gpxPoints.get((int)j).loc) > (double)minPointApproximation) break;
            }
            if (minNextInd < 0) break;
            if (minDistSqrSegment > (double)(minPointApproximation * minPointApproximation)) {
                int nextIndex = currentPoint.ind + 1;
                currentPoint = this.findNextRoutablePoint(frontEnd, gctx, minPointApproximation, gpxPoints, nextIndex);
                continue;
            }
            currentPoint.routeToTarget = new ArrayList<RouteSegmentResult>();
            fres.setGpxPointIndex(currentPoint.ind);
            currentPoint.routeToTarget.add(fres);
            currentPoint.targetInd = minNextInd;
            currentPoint = gpxPoints.get(minNextInd);
            for (BinaryRoutePlanner.RouteSegment sg = gctx.ctx.loadRouteSegment(fres.getEndPointX(), fres.getEndPointY(), gctx.ctx.config.memoryLimitation); sg != null; sg = sg.getNext()) {
                if (sg.getRoad().getId() == fres.getObject().getId() && sg.getSegmentEnd() == fres.getEndPointIndex()) continue;
                BinaryRoutePlanner.RouteSegmentPoint p = new BinaryRoutePlanner.RouteSegmentPoint(sg.getRoad(), sg.getSegmentStart(), sg.getSegmentEnd(), 0.0);
                if (currentPoint.pnt == null) {
                    currentPoint.pnt = p;
                    continue;
                }
                if (currentPoint.pnt.others == null) {
                    currentPoint.pnt.others = new ArrayList<BinaryRoutePlanner.RouteSegmentPoint>();
                }
                currentPoint.pnt.others.add(p);
            }
        }
        if (gctx.ctx.calculationProgress != null) {
            gctx.ctx.calculationProgress.timeToCalculate = System.nanoTime() - timeToCalculate;
        }
        System.out.printf("Approximation took %.2f seconds (%d route points searched)\n", (double)(System.nanoTime() - timeToCalculate) / 1.0E9, gctx.routePointsSearched);
        return gctx;
    }

    private boolean initRoutingPoint(RoutePlannerFrontEnd frontEnd, GpxRouteApproximation gctx, RoutePlannerFrontEnd.GpxPoint start, double distThreshold) throws IOException {
        if (start != null && start.pnt == null) {
            ++gctx.routePointsSearched;
            BinaryRoutePlanner.RouteSegmentPoint rsp = frontEnd.findRouteSegment(start.loc.getLatitude(), start.loc.getLongitude(), gctx.ctx, null, false);
            if (rsp != null && MapUtils.getDistance(rsp.getPreciseLatLon(), start.loc) < distThreshold) {
                start.pnt = rsp;
            }
        }
        return start != null && start.pnt != null;
    }

    private double minDistResult(RouteSegmentResult[] res, double minDistSqr, BinaryRoutePlanner.RouteSegmentPoint pnt, RoutePlannerFrontEnd.GpxPoint loc) {
        short segmentEnd = -1;
        double dist = 0.0;
        short start = Math.max(0, pnt.getSegmentStart() - 10);
        int end = Math.min(pnt.getRoad().getPointsLength(), pnt.getSegmentStart() + 10);
        for (short i = start; i < end; ++i) {
            if (i == pnt.getSegmentStart()) continue;
            double d = MapUtils.squareDist31TileMetric(loc.x31, loc.y31, pnt.getRoad().getPoint31XTile(i), pnt.getRoad().getPoint31YTile(i));
            if (segmentEnd >= 0 && !(d < dist)) continue;
            segmentEnd = i;
            dist = d;
        }
        dist += pnt.distToProj;
        dist += this.sumPntDistanceSqr(pnt, pnt.getSegmentStart(), segmentEnd) * 0.001;
        if ((res[0] == null || dist < minDistSqr) && segmentEnd >= 0) {
            minDistSqr = dist;
            res[0] = new RouteSegmentResult(pnt.getRoad(), pnt.getSegmentStart(), segmentEnd);
        }
        return minDistSqr;
    }

    private double sumPntDistanceSqr(BinaryRoutePlanner.RouteSegmentPoint pnt, int start, int end) {
        if (start == end) {
            return 0.0;
        }
        if (start > end) {
            int swap = start;
            start = end;
            end = swap;
        }
        double dist = 0.0;
        for (int i = start; i < end; ++i) {
            dist += MapUtils.squareRootDist31(pnt.getRoad().getPoint31XTile(i), pnt.getRoad().getPoint31YTile(i), pnt.getRoad().getPoint31XTile(i + 1), pnt.getRoad().getPoint31YTile(i + 1));
        }
        return dist * dist;
    }

    private RoutePlannerFrontEnd.GpxPoint findNextRoutablePoint(RoutePlannerFrontEnd frontEnd, GpxRouteApproximation gctx, double distThreshold, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints, int searchStart) throws IOException {
        for (int i = searchStart; i < gpxPoints.size(); ++i) {
            if (!this.initRoutingPoint(frontEnd, gctx, gpxPoints.get(i), distThreshold)) continue;
            return gpxPoints.get(i);
        }
        return null;
    }

    private void initGpxPointsXY31(List<RoutePlannerFrontEnd.GpxPoint> gpxPoints) {
        for (RoutePlannerFrontEnd.GpxPoint p : gpxPoints) {
            p.x31 = MapUtils.get31TileNumberX(p.loc.getLongitude());
            p.y31 = MapUtils.get31TileNumberY(p.loc.getLatitude());
        }
    }
}

