/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.osmand.IProgress;
import net.osmand.obf.preparation.BasemapProcessor;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.util.MapUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.xmlpull.v1.XmlPullParserException;

public class OceanTilesCreator {
    public static final byte TILE_ZOOMLEVEL = 12;
    private static final byte BITMASK = 3;
    private static final int BITS_COUNT = 0x1000000;
    private static final byte SEA = 2;
    private static final byte LAND = 1;

    public static void main(String[] args) throws Exception {
        OceanTilesCreator.createJOSMFile(new String[]{"/Users/victorshcherb/osmand/maps/oceantiles.osm", null});
    }

    public static void checkOceanTile(String[] args) {
        double[] lat = new double[]{Double.parseDouble(args[0])};
        double[] lon = new double[]{Double.parseDouble(args[1])};
        int zoom = 11;
        if (args.length > 2) {
            zoom = Integer.parseInt(args[2]);
        }
        BasemapProcessor bmp = new BasemapProcessor();
        bmp.constructBitSetInfo(null);
        for (int i = 0; i < lat.length && i < lon.length; ++i) {
            int x = (int)MapUtils.getTileNumberX((float)zoom, (double)lon[i]);
            int y = (int)MapUtils.getTileNumberY((float)zoom, (double)lat[i]);
            System.out.println("Tile is sea (1) or land (0): " + bmp.getSeaTile(x, y, zoom));
        }
    }

    public static boolean ccw(double ax, double ay, double bx, double by, double cx, double cy) {
        return (cy - ay) * (bx - ax) > (by - ay) * (cx - ax);
    }

    public static boolean intersect2Segments(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy) {
        return OceanTilesCreator.ccw(ax, ay, cx, cy, dx, dy) != OceanTilesCreator.ccw(bx, by, cx, cy, dx, dy) && OceanTilesCreator.ccw(ax, ay, bx, by, cx, cy) != OceanTilesCreator.ccw(ax, ay, bx, by, dx, dy);
    }

    public static void createTilesFile(String coastlinesInput, String result) throws IOException, XmlPullParserException {
        BufferedInputStream stream;
        if (result == null) {
            result = "oceantiles_12.dat";
        }
        File readFile = new File(coastlinesInput);
        BufferedInputStream streamFile = stream = new BufferedInputStream(new FileInputStream(readFile), 32768);
        long st = System.currentTimeMillis();
        if (readFile.getName().endsWith(".bz2")) {
            stream = new BZip2CompressorInputStream((InputStream)stream);
        }
        OsmBaseStorage bs = new OsmBaseStorage();
        bs.parseOSM((InputStream)stream, IProgress.EMPTY_PROGRESS);
        int c = 0;
        int ns = 0;
        TLongObjectHashMap map = new TLongObjectHashMap();
        for (Entity e : bs.getRegisteredEntities().values()) {
            if (!(e instanceof Way)) continue;
            Way w = (Way)e;
            List nodes = w.getNodes();
            for (int i = 1; i < nodes.size(); ++i) {
                double tx = MapUtils.getTileNumberX((float)12.0f, (double)((Node)nodes.get(i)).getLongitude());
                double ty = MapUtils.getTileNumberY((float)12.0f, (double)((Node)nodes.get(i)).getLatitude());
                double px = MapUtils.getTileNumberX((float)12.0f, (double)((Node)nodes.get(i - 1)).getLongitude());
                double py = MapUtils.getTileNumberY((float)12.0f, (double)((Node)nodes.get(i - 1)).getLatitude());
                int x = (int)Math.min(tx, px);
                while ((double)x <= Math.max(tx, px)) {
                    int y = (int)Math.min(ty, py);
                    while ((double)y <= Math.max(ty, py)) {
                        long key = ((long)x << 12) + (long)y;
                        if (OceanTilesCreator.intersect2Segments(tx, ty, px, py, x, (double)y + 0.5, x + 1, (double)y + 0.5)) {
                            ++OceanTilesCreator.getOrCreate((TLongObjectHashMap<OceanTileInfo>)map, (long)key).linesIntersectMedian;
                            OceanTilesCreator.getOrCreate((TLongObjectHashMap<OceanTileInfo>)map, (long)key).type = OceanTileInfo.MIXED;
                        } else if (OceanTilesCreator.intersect2Segments(tx, ty, px, py, x, y, x + 1, y)) {
                            OceanTilesCreator.getOrCreate((TLongObjectHashMap<OceanTileInfo>)map, (long)key).type = OceanTileInfo.MIXED;
                        } else if (OceanTilesCreator.intersect2Segments(tx, ty, px, py, x, y + 1, x + 1, y + 1)) {
                            OceanTilesCreator.getOrCreate((TLongObjectHashMap<OceanTileInfo>)map, (long)key).type = OceanTileInfo.MIXED;
                        } else if (OceanTilesCreator.intersect2Segments(tx, ty, px, py, x, y, x, y + 1)) {
                            OceanTilesCreator.getOrCreate((TLongObjectHashMap<OceanTileInfo>)map, (long)key).type = OceanTileInfo.MIXED;
                        } else if (OceanTilesCreator.intersect2Segments(tx, ty, px, py, x + 1, y, x + 1, y + 1)) {
                            OceanTilesCreator.getOrCreate((TLongObjectHashMap<OceanTileInfo>)map, (long)key).type = OceanTileInfo.MIXED;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            ++c;
            ns += w.getNodeIds().size();
        }
        OceanTilesCreator.writeResult((TLongObjectHashMap<OceanTileInfo>)map, result);
        System.out.println(c + " " + ns + " coastlines " + map.size());
    }

    private static void writeResult(TLongObjectHashMap<OceanTileInfo> map, String result) throws IOException {
        int currentByte = 0;
        FileOutputStream rf = new FileOutputStream(result);
        int maxT = 4096;
        double antarcticaStart = MapUtils.getTileNumberY((float)12.0f, (double)-84.35);
        for (int y = 0; y < maxT; ++y) {
            boolean previousSea = true;
            if ((double)y >= antarcticaStart) {
                previousSea = false;
            }
            for (int x = 0; x < maxT; ++x) {
                long key = ((long)x << 12) + (long)y;
                OceanTileInfo oc = (OceanTileInfo)map.get(key);
                int vl = 0;
                if (oc == null || oc.type == OceanTileInfo.UNDEFINED) {
                    vl = previousSea ? 2 : 1;
                } else {
                    boolean odd;
                    vl = 3;
                    boolean bl = odd = oc.linesIntersectMedian % 2 == 0;
                    if (!odd) {
                        previousSea = !previousSea;
                    }
                }
                currentByte = currentByte << 2 | vl & 3;
                if (x % 4 != 3) continue;
                rf.write(currentByte);
                currentByte = 0;
            }
        }
        rf.close();
    }

    private static OceanTileInfo getOrCreate(TLongObjectHashMap<OceanTileInfo> map, long key) {
        if (!map.containsKey(key)) {
            map.put(key, (Object)new OceanTileInfo());
        }
        return (OceanTileInfo)map.get(key);
    }

    public static long getNodeId(int x, int y, int z) {
        return (long)x << 25 | (long)y << 5 | (long)z;
    }

    public static Node getNode(long id) {
        int x = (int)(id >> 25);
        int y = (int)(id - OceanTilesCreator.getNodeId(x, 0, 0) >> 5);
        int z = (int)(id - OceanTilesCreator.getNodeId(x, y, 0));
        Node nod = new Node(MapUtils.getLatitudeFromTile((float)z, (double)y), MapUtils.getLongitudeFromTile((double)z, (double)x), id);
        return nod;
    }

    public static void createJOSMFile(String[] args) throws XMLStreamException, IOException {
        String fileLocation = args.length == 0 ? "oceanTiles.osm" : args[0];
        int z = 12;
        BasemapProcessor bmp = new BasemapProcessor();
        bmp.constructBitSetInfo(args.length > 1 ? args[1] : null);
        OsmBaseStorage st = new OsmBaseStorage();
        LinkedHashSet<Entity.EntityId> s = new LinkedHashSet<Entity.EntityId>();
        TLongHashSet nodeIds = new TLongHashSet();
        int minzoom = 4;
        BasemapProcessor.SimplisticQuadTree quadTree = bmp.constructTilesQuadTree(z);
        for (int zm = minzoom; zm <= z; ++zm) {
            int pz = 1 << zm;
            for (int x = 0; x < pz; ++x) {
                for (int y = 0; y < pz; ++y) {
                    boolean parentWater = bmp.isWaterTile(x >> 1, y >> 1, zm - 1);
                    boolean parentLand = bmp.isLandTile(x >> 1, y >> 1, zm - 1);
                    if (zm > minzoom && (parentLand || parentWater)) continue;
                    boolean landTile = bmp.isLandTile(x, y, zm);
                    boolean waterTile = bmp.isWaterTile(x, y, zm);
                    if (!waterTile && !landTile) continue;
                    Way w = new Way(-OceanTilesCreator.getNodeId(x, y, zm));
                    OceanTilesCreator.addNode(w, nodeIds, x, y, zm);
                    OceanTilesCreator.addNode(w, nodeIds, x, y + 1, zm);
                    OceanTilesCreator.addNode(w, nodeIds, x + 1, y + 1, zm);
                    OceanTilesCreator.addNode(w, nodeIds, x + 1, y, zm);
                    OceanTilesCreator.addNode(w, nodeIds, x, y, zm);
                    if (waterTile) {
                        w.putTag("natural", "water");
                    } else if (landTile) {
                        w.putTag("landuse", "grass");
                    }
                    w.putTag("name", x + " " + y + " " + zm + " " + (waterTile ? 1 : 0));
                    s.addAll(w.getEntityIds());
                    s.add(Entity.EntityId.valueOf((Entity)w));
                    st.registerEntity((Entity)w, null);
                }
            }
        }
        for (long l : nodeIds.toArray()) {
            st.registerEntity((Entity)OceanTilesCreator.getNode(l), null);
        }
        new OsmStorageWriter().saveStorage(new FileOutputStream(fileLocation), st, s, true);
    }

    private static void addNode(Way w, TLongHashSet nodeIds, int x, int y, int zm) {
        long nodeId = OceanTilesCreator.getNodeId(x, y, zm);
        w.addNode(nodeId);
        nodeIds.add(nodeId);
    }

    private static void runFixOceanTiles() throws IOException {
        final int[] land = new int[]{};
        OceanTilesCreator.fixOceanTiles(new FixTileData(){
            int c = 0;

            @Override
            public int compareTileData(int x, int y, int z, int origValue) {
                int sh = z - 7;
                int ty = y >> sh;
                int tx = x >> sh;
                if ((tx == 44 && ty == 113 || tx == 45 && ty == 112) && origValue != 2) {
                    ++this.c;
                    System.out.println("S " + this.c + ". " + ty + " " + y + " " + x);
                    return 2;
                }
                for (int i = 0; i < land.length; i += 2) {
                    if (land[i] != tx || land[i] != ty || origValue == 1) continue;
                    ++this.c;
                    System.out.println("L " + this.c + ". " + ty + " " + y + " " + x);
                    return 1;
                }
                return 0;
            }
        }, false);
    }

    private static int getTileX(int i) {
        return i % 4096;
    }

    private static int getTileY(int i) {
        return i / 4096;
    }

    private static void fixOceanTiles(FixTileData fx, boolean dryRun) throws IOException {
        RandomAccessFile rf = new RandomAccessFile("../tools/OsmAndMapCreator/oceantiles_12.dat", "rw");
        int[] cs = new int[4];
        int[] vs = new int[4];
        int changedT = 0;
        for (int i = 0; i < 0x400000; ++i) {
            int currentByte = rf.readByte();
            int x = OceanTilesCreator.getTileX(i);
            int y = OceanTilesCreator.getTileY(i);
            vs[0] = currentByte >> 6 & 3;
            vs[1] = currentByte >> 4 & 3;
            vs[2] = currentByte >> 2 & 3;
            vs[3] = currentByte >> 0 & 3;
            cs[0] = i * 4;
            cs[1] = i * 4 + 1;
            cs[2] = i * 4 + 2;
            cs[3] = i * 4 + 3;
            boolean changed = false;
            for (int k = 0; k < cs.length; ++k) {
                int ty;
                int tx = OceanTilesCreator.getTileX(cs[k]);
                int c = fx.compareTileData(tx, ty = OceanTilesCreator.getTileY(cs[k]), 12, vs[k]);
                if (c == 0) continue;
                vs[k] = c;
                changed = true;
            }
            if (!changed || dryRun) continue;
            currentByte = 0;
            currentByte = currentByte << 2 | vs[0];
            currentByte = currentByte << 2 | vs[1];
            currentByte = currentByte << 2 | vs[2];
            currentByte = currentByte << 2 | vs[3];
            rf.seek(rf.getFilePointer() - 1L);
            rf.writeByte(currentByte);
            ++changedT;
        }
        System.out.println("Changed " + changedT + " bytes");
    }

    static class OceanTileInfo {
        int linesIntersectMedian = 0;
        static int UNDEFINED = 0;
        static int MIXED = 1;
        int type = UNDEFINED;

        OceanTileInfo() {
        }
    }

    private static interface FixTileData {
        public int compareTileData(int var1, int var2, int var3, int var4);
    }
}

