/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.IProgress;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.MapZooms;
import net.osmand.binary.OsmandOdb;
import net.osmand.data.LatLon;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;
import net.osmand.data.QuadRect;
import net.osmand.data.Ring;
import net.osmand.obf.preparation.AbstractIndexPartCreator;
import net.osmand.obf.preparation.BasemapProcessor;
import net.osmand.obf.preparation.BinaryFileReference;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexCreationContext;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.obf.preparation.OverpassFetcher;
import net.osmand.obf.preparation.PropagateToNodes;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.RelationTagsPropagation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import rtree.Element;
import rtree.IllegalValueException;
import rtree.LeafElement;
import rtree.RTree;
import rtree.RTreeException;
import rtree.RTreeInsertException;
import rtree.Rect;

public class IndexVectorMapCreator
extends AbstractIndexPartCreator {
    private static final Log log = LogFactory.getLog(IndexVectorMapCreator.class);
    private static final int MAP_LEVELS_POWER = 3;
    private static final int MAP_LEVELS_MAX = 8;
    private static final int LOW_LEVEL_COMBINE_WAY_POINS_LIMIT = 10000;
    private static final int LOW_LEVEL_ZOOM_TO_COMBINE = 13;
    private static final int LOW_LEVEL_ZOOM_COASTLINE = 1;
    private final Log logMapDataWarn;
    protected MapRenderingTypesEncoder renderingTypes;
    private MapZooms mapZooms;
    private IndexCreatorSettings settings;
    private static final String YES = "yes";
    private static final String ROLE = "role";
    private static final String OUTLINE = "outline";
    private static final String BUILDING = "building";
    private static final String BUILDING_PART = "building:part";
    private static final String BUILDING_OUTLINE_TYPE = "building_outline_type";
    private static final String MULTIPOLYGON = "multipolygon";
    Map<Long, TIntArrayList> multiPolygonsWays = new LinkedHashMap<Long, TIntArrayList>();
    TIntArrayList typeUse = new TIntArrayList(8);
    List<MapRenderingTypes.MapRulType> tempNameUse = new ArrayList<MapRenderingTypes.MapRulType>();
    TreeMap<MapRenderingTypes.MapRulType, String> namesUse = new TreeMap(new Comparator<MapRenderingTypes.MapRulType>(){

        @Override
        public int compare(MapRenderingTypes.MapRulType o1, MapRenderingTypes.MapRulType o2) {
            int rhs;
            int lhs = o1.getOrder();
            if (lhs == (rhs = o2.getOrder())) {
                lhs = o1.getInternalId();
                rhs = o2.getInternalId();
            }
            return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
        }
    });
    RelationTagsPropagation tagsTransformer = new RelationTagsPropagation();
    TIntArrayList addtypeUse = new TIntArrayList(8);
    private PreparedStatement mapBinaryStat;
    private PreparedStatement mapLowLevelBinaryStat;
    private int lowLevelWays = -1;
    private RTree[] mapTree = null;
    private Connection mapConnection;
    private static int DUPLICATE_SPLIT = 5;
    public TLongHashSet generatedIds = new TLongHashSet();
    private static boolean VALIDATE_DUPLICATE = false;
    private TLongObjectHashMap<Long> duplicateIds = new TLongObjectHashMap();
    private BasemapProcessor checkSeaTile;
    private PropagateToNodes propagateToNodes;
    private final Long lastModifiedDate;
    private static final char SPECIAL_CHAR = '\u0000';

    public IndexVectorMapCreator(Log logMapDataWarn, MapZooms mapZooms, MapRenderingTypesEncoder renderingTypes, IndexCreatorSettings settings, PropagateToNodes propagateToNodes, Long lastModifiedDate) {
        this.logMapDataWarn = logMapDataWarn;
        this.mapZooms = mapZooms;
        this.settings = settings;
        this.renderingTypes = renderingTypes;
        this.propagateToNodes = propagateToNodes;
        this.lastModifiedDate = lastModifiedDate;
        this.lowLevelWays = -1;
    }

    private long assignIdForMultipolygon(Relation orig) {
        long ll = orig.getId();
        long sum = 0L;
        for (Entity d : orig.getMemberEntities(null)) {
            LatLon l = d instanceof Way ? OsmMapUtils.getWeightCenterForNodes((Collection)((Way)d).getNodes()) : d.getLatLon();
            if (l == null) continue;
            int y = MapUtils.get31TileNumberY((double)l.getLatitude());
            int x = MapUtils.get31TileNumberX((double)l.getLongitude());
            sum += (long)(x + y);
        }
        return this.genId(43, (ll << 6) + sum % 63L);
    }

    private long assignIdBasedOnOriginalSplit(Entity.EntityId originalId) {
        return this.genId(41, originalId.getId());
    }

    private long genId(int baseShift, long id) {
        long gen = (id << DUPLICATE_SPLIT) + (1L << baseShift - 1);
        while (this.generatedIds.contains(gen)) {
            gen += 2L;
        }
        this.generatedIds.add(gen);
        return gen;
    }

    public void indexMapRelationsAndMultiPolygons(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        if (e instanceof Relation) {
            Relation relation = (Relation)e;
            long ts = System.currentTimeMillis();
            this.processBuildingRelationRole(relation, ctx);
            Map<String, String> tags = this.renderingTypes.transformTags(e.getTags(), Entity.EntityType.RELATION, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
            if (!this.settings.keepOnlyRouteRelationObjects && this.settings.indexMultipolygon) {
                this.indexMultiPolygon(relation, tags, ctx);
            }
            this.tagsTransformer.handleRelationPropogatedTags(relation, this.renderingTypes, ctx, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
            long tm = (System.currentTimeMillis() - ts) / 1000L;
            if (tm > 15L) {
                log.warn((Object)String.format("Relation %d took %d seconds to process", e.getId(), tm));
            }
            this.handlePublicTransportStopExits(e, ctx);
        }
    }

    private void processBuildingRelationRole(Relation e, OsmDbAccessorContext ctx) throws SQLException {
        boolean hasMultipolygonBuilding;
        boolean hasTypeBuilding = BUILDING.equals(e.getTag(OSMSettings.OSMTagKey.TYPE));
        boolean bl = hasMultipolygonBuilding = MULTIPOLYGON.equals(e.getTag(OSMSettings.OSMTagKey.TYPE)) && (e.getTag(BUILDING) != null || e.getTag(BUILDING_PART) != null);
        if (hasTypeBuilding || hasMultipolygonBuilding) {
            ctx.loadEntityRelation(e);
            String buildingOutlineType = null;
            for (Relation.RelationMember entry : e.getMembers()) {
                Entity entity = entry.getEntity();
                if (entity == null || !OUTLINE.equals(entry.getRole())) continue;
                buildingOutlineType = entity.getTag(BUILDING);
                break;
            }
            for (Relation.RelationMember entry : e.getMembers()) {
                String role = entry.getRole();
                Entity entity = entry.getEntity();
                if (entity == null || !Algorithms.isEmpty((CharSequence)role)) continue;
                RelationTagsPropagation.PropagateEntityTags p = this.tagsTransformer.getPropogateTagForEntity(entry.getEntityId());
                if (buildingOutlineType != null && YES.equals(entity.getTag(BUILDING_PART))) {
                    p.putThroughTags.put(BUILDING_OUTLINE_TYPE, buildingOutlineType);
                }
                p.putThroughTags.put("role_" + role, YES);
            }
        }
    }

    private void handlePublicTransportStopExits(Entity e, OsmDbAccessorContext ctx) throws SQLException {
        if ("public_transport".equals(e.getTag("type")) && ctx != null) {
            ctx.loadEntityRelation((Relation)e);
            boolean hasExits = false;
            for (Relation.RelationMember ch : ((Relation)e).getMembers()) {
                if (ch.getEntity() == null || !"subway_entrance".equals(ch.getEntity().getTag("railway"))) continue;
                hasExits = true;
                break;
            }
            if (hasExits) {
                for (Relation.RelationMember ch : ((Relation)e).getMembers()) {
                    if (ch.getEntity() == null || !"station".equals(ch.getEntity().getTag("railway")) && !"subway".equals(ch.getEntity().getTag("station"))) continue;
                    RelationTagsPropagation.PropagateEntityTags p = this.tagsTransformer.getPropogateTagForEntity(ch.getEntityId());
                    p.putThroughTags.put("with_exits", YES);
                }
            }
        }
    }

    private void indexMultiPolygon(Relation e, Map<String, String> tags, OsmDbAccessorContext ctx) throws SQLException {
        if (!OsmMapUtils.isMultipolygon(tags)) {
            return;
        }
        if (tags.get(OSMSettings.OSMTagKey.ADMIN_LEVEL.getValue()) != null) {
            return;
        }
        boolean polygonIsland = MULTIPOLYGON.equals((tags = new LinkedHashMap<String, String>(tags)).get(OSMSettings.OSMTagKey.TYPE.getValue())) && "island".equals(tags.get(OSMSettings.OSMTagKey.PLACE.getValue()));
        ctx.loadEntityRelation(e);
        OverpassFetcher.getInstance().fetchCompleteGeometryRelation(e, ctx, this.lastModifiedDate);
        if (polygonIsland) {
            int coastlines = 0;
            int otherWays = 0;
            List me = e.getMemberEntities("outer");
            for (Entity es : me) {
                if (!(es instanceof Way) || ((Way)es).getEntityIds().isEmpty()) continue;
                boolean coastline = "coastline".equals(tags.get(OSMSettings.OSMTagKey.NATURAL.getValue()));
                if (coastline) {
                    ++coastlines;
                    continue;
                }
                ++otherWays;
            }
            if (coastlines > 0) {
                if (otherWays != 0) {
                    log.error((Object)String.format("Wrong coastline (island) relation %d has %d coastlines out of %d entries", e.getId(), coastlines, otherWays + coastlines));
                    return;
                }
                if (e.getMembers("inner").size() > 0) {
                    log.error((Object)String.format("Wrong coastline (island) relation %d has inner ways", e.getId()));
                    return;
                }
                log.info((Object)String.format("Relation %s %d consists only of coastlines so it was skipped.", tags.get(OSMSettings.OSMTagKey.NAME.getValue()), e.getId()));
                return;
            }
        }
        MultipolygonBuilder original = new MultipolygonBuilder();
        original.setId(e.getId());
        boolean climbing = MultipolygonBuilder.isClimbingMultipolygon((Entity)e);
        if (climbing) {
            Map<Long, Node> allNodes = ctx.retrieveAllRelationNodes(e);
            original.createClimbingOuterWay((Entity)e, new ArrayList<Node>(allNodes.values()));
        } else {
            original.createInnerAndOuterWays((Entity)e);
        }
        try {
            this.renderingTypes.encodeEntityWithType(false, tags, this.mapZooms.getLevel(0).getMaxZoom(), this.typeUse, this.addtypeUse, this.namesUse, this.tempNameUse);
        }
        catch (RuntimeException es) {
            es.printStackTrace();
            return;
        }
        List<Map<String, String>> splitEntities = this.renderingTypes.splitTags(tags, Entity.EntityType.valueOf((Entity)e));
        if (this.typeUse.size() == 0) {
            return;
        }
        this.excludeFromMainIteration(original.getOuterWays());
        if (this.settings.keepOnlySeaObjects && !this.checkBelongsToSeaWays(original.getOuterWays())) {
            return;
        }
        List multipolygons = original.splitPerOuterRing(this.logMapDataWarn);
        for (Multipolygon m : multipolygons) {
            Ring out;
            assert (m.getOuterRings().size() == 1);
            if (!m.areRingsComplete()) {
                this.logMapDataWarn.warn((Object)("In multipolygon " + e.getId() + " there are incompleted ways"));
            }
            if ((out = (Ring)m.getOuterRings().get(0)).getBorder().size() == 0) {
                this.logMapDataWarn.warn((Object)("Multipolygon has an outer ring that can't be formed: " + e.getId()));
                continue;
            }
            ArrayList<List<Node>> innerWays = new ArrayList<List<Node>>();
            for (Ring r : m.getInnerRings()) {
                innerWays.add(r.getBorder());
            }
            Map<String, String> stags = splitEntities == null ? tags : splitEntities.get(0);
            long assignId = this.assignIdForMultipolygon(e);
            if (multipolygons.size() > 1) {
                stags.put("route_id", "R" + e.getId());
            }
            this.createMultipolygonObject(stags, out, innerWays, assignId);
            if (splitEntities == null) continue;
            for (int i = 1; i < splitEntities.size(); ++i) {
                Map<String, String> splitTags = splitEntities.get(i);
                while (this.generatedIds.contains(assignId)) {
                    assignId += 2L;
                }
                this.generatedIds.add(assignId);
                this.createMultipolygonObject(splitTags, out, innerWays, assignId);
            }
        }
    }

    protected void createMultipolygonObject(Map<String, String> tags, Ring out, List<List<Node>> innerWays, long baseId) throws SQLException {
        for (int level = 0; level < this.mapZooms.size(); ++level) {
            this.renderingTypes.encodeEntityWithType(false, tags, this.mapZooms.getLevel(level).getMaxZoom(), this.typeUse, this.addtypeUse, this.namesUse, this.tempNameUse);
            if (this.typeUse.isEmpty()) continue;
            long id = this.convertBaseIdToGeneratedId(baseId, level);
            List<Node> outerWay = out.getBorder();
            int zoomToSimplify = this.mapZooms.getLevel(level).getMaxZoom() - 1;
            if (zoomToSimplify < 15) {
                if ((outerWay = IndexVectorMapCreator.simplifyCycleWay(outerWay, zoomToSimplify, this.settings.zoomWaySmoothness)) == null) continue;
                ArrayList<List<Node>> newinnerWays = new ArrayList<List<Node>>();
                for (List<Node> ls : innerWays) {
                    if ((ls = IndexVectorMapCreator.simplifyCycleWay(ls, zoomToSimplify, this.settings.zoomWaySmoothness)) == null) continue;
                    newinnerWays.add(ls);
                }
                innerWays = newinnerWays;
            }
            this.insertBinaryMapRenderObjectIndex(this.mapTree[level], outerWay, innerWays, this.namesUse, id, true, this.typeUse, this.addtypeUse, true, true);
        }
    }

    private void excludeFromMainIteration(List<Way> l) {
        for (Way w : l) {
            if (!this.multiPolygonsWays.containsKey(w.getId())) {
                this.multiPolygonsWays.put(w.getId(), new TIntArrayList());
            }
            this.multiPolygonsWays.get(w.getId()).addAll((TIntCollection)this.typeUse);
        }
    }

    public static List<Node> simplifyCycleWay(List<Node> ns, int zoom, int zoomWaySmoothness) throws SQLException {
        if (IndexVectorMapCreator.checkForSmallAreas(ns, zoom + Math.min(zoomWaySmoothness / 2, 3), 2, 4)) {
            return null;
        }
        ArrayList<Node> res = new ArrayList<Node>();
        OsmMapUtils.simplifyDouglasPeucker(ns, (int)(zoom + 8 + zoomWaySmoothness), (int)3, res, (boolean)false);
        if (res.size() < 2) {
            return null;
        }
        return res;
    }

    public int getLowLevelWays() {
        return this.lowLevelWays;
    }

    private void loadNodes(byte[] nodes, List<Float> toPut) {
        toPut.clear();
        for (int i = 0; i < nodes.length; i += 4) {
            int lat = Algorithms.parseIntFromBytes((byte[])nodes, (int)i);
            int lon = Algorithms.parseIntFromBytes((byte[])nodes, (int)(i += 4));
            toPut.add(Float.valueOf(Float.intBitsToFloat(lat)));
            toPut.add(Float.valueOf(Float.intBitsToFloat(lon)));
        }
    }

    private void parseAndSort(TIntArrayList ts, byte[] bs) {
        ts.clear();
        if (bs != null && bs.length > 0) {
            for (int j = 0; j < bs.length; j += 2) {
                ts.add(Algorithms.parseSmallIntFromBytes((byte[])bs, (int)j));
            }
        }
        ts.sort();
    }

    public List<LowLevelWayCandidate> readLowLevelCandidates(ResultSet fs, List<LowLevelWayCandidate> l, TIntArrayList temp, TIntArrayList tempAdd, TLongHashSet visitedWays) throws SQLException {
        l.clear();
        while (fs.next()) {
            if (visitedWays.contains(fs.getLong(1))) continue;
            this.parseAndSort(temp, fs.getBytes(5));
            this.parseAndSort(tempAdd, fs.getBytes(6));
            if (!temp.equals((Object)this.typeUse) || !tempAdd.equals((Object)this.addtypeUse)) continue;
            LowLevelWayCandidate llwc = new LowLevelWayCandidate();
            llwc.wayId = fs.getLong(1);
            llwc.names = this.decodeNames(fs.getString(4), new HashMap<MapRenderingTypes.MapRulType, String>());
            llwc.nodes = fs.getBytes(3);
            llwc.otherNodeId = fs.getLong(2);
            for (MapRenderingTypes.MapRulType mr : this.namesUse.keySet()) {
                if (!Algorithms.objectEquals((Object)this.namesUse.get(mr), (Object)llwc.names.get(mr))) continue;
                ++llwc.namesCount;
            }
            l.add(llwc);
        }
        return l;
    }

    public void processingLowLevelWays(IProgress progress) throws SQLException {
        this.mapLowLevelBinaryStat.executeBatch();
        this.mapLowLevelBinaryStat.close();
        this.pStatements.remove(this.mapLowLevelBinaryStat);
        this.mapLowLevelBinaryStat = null;
        this.mapConnection.commit();
        PreparedStatement startStat = this.mapConnection.prepareStatement("SELECT id, end_node, nodes, name, type, addType FROM low_level_map_objects WHERE start_node = ? AND level = ?");
        PreparedStatement endStat = this.mapConnection.prepareStatement("SELECT id, start_node, nodes, name, type, addType FROM low_level_map_objects WHERE end_node = ? AND level = ?");
        Statement selectStatement = this.mapConnection.createStatement();
        ResultSet rs = selectStatement.executeQuery("SELECT id, start_node, end_node, nodes, name, type, addType, level FROM low_level_map_objects");
        TLongHashSet visitedWays = new TLongHashSet();
        ArrayList<Float> list = new ArrayList<Float>(100);
        TIntArrayList temp = new TIntArrayList();
        TIntArrayList tempAdd = new TIntArrayList();
        while (rs.next()) {
            boolean cycle;
            LowLevelWayCandidate cand;
            ResultSet fs;
            boolean combined;
            long id;
            if (this.lowLevelWays != -1) {
                progress.progress(1);
            }
            if (visitedWays.contains(id = rs.getLong(1))) continue;
            visitedWays.add(id);
            int level = rs.getInt(8);
            int zoom = this.mapZooms.getLevel(level).getMaxZoom();
            int minZoom = this.mapZooms.getLevel(level).getMinZoom();
            long startNode = rs.getLong(2);
            long endNode = rs.getLong(3);
            this.namesUse.clear();
            this.decodeNames(rs.getString(5), this.namesUse);
            this.parseAndSort(this.typeUse, rs.getBytes(6));
            this.parseAndSort(this.addtypeUse, rs.getBytes(7));
            this.loadNodes(rs.getBytes(4), list);
            ArrayList<Float> wayNodes = new ArrayList<Float>(list);
            ArrayList<LowLevelWayCandidate> candidates = new ArrayList<LowLevelWayCandidate>();
            Comparator<LowLevelWayCandidate> cmpCandidates = new Comparator<LowLevelWayCandidate>(){

                @Override
                public int compare(LowLevelWayCandidate o1, LowLevelWayCandidate o2) {
                    return -Integer.compare(o1.namesCount, o2.namesCount);
                }
            };
            boolean dontCombine = false;
            if (minZoom >= 13) {
                dontCombine = true;
            }
            if (minZoom >= 1 && this.typeUse.contains(this.renderingTypes.getCoastlineRuleType().getInternalId())) {
                dontCombine = true;
            }
            boolean bl = combined = !dontCombine;
            while (combined && wayNodes.size() < 10000) {
                combined = false;
                endStat.setLong(1, startNode);
                endStat.setShort(2, (short)level);
                fs = endStat.executeQuery();
                this.readLowLevelCandidates(fs, candidates, temp, tempAdd, visitedWays);
                fs.close();
                cand = this.getCandidate(candidates, cmpCandidates);
                if (cand == null) continue;
                combined = true;
                startNode = cand.otherNodeId;
                visitedWays.add(cand.wayId);
                this.loadNodes(cand.nodes, list);
                ArrayList<Float> li = new ArrayList<Float>(list);
                wayNodes.remove(0);
                wayNodes.remove(0);
                li.addAll(wayNodes);
                wayNodes = li;
                for (MapRenderingTypes.MapRulType rt : new ArrayList<MapRenderingTypes.MapRulType>(this.namesUse.keySet())) {
                    if (Algorithms.objectEquals((Object)this.namesUse.get(rt), (Object)cand.names.get(rt)) || this.checkOneLocaleHasSameName(this.namesUse, cand.names, rt)) continue;
                    this.namesUse.remove(rt);
                }
            }
            boolean bl2 = combined = !dontCombine;
            while (combined && wayNodes.size() < 10000) {
                combined = false;
                startStat.setLong(1, endNode);
                startStat.setShort(2, (short)level);
                fs = startStat.executeQuery();
                this.readLowLevelCandidates(fs, candidates, temp, tempAdd, visitedWays);
                fs.close();
                cand = this.getCandidate(candidates, cmpCandidates);
                if (cand == null) continue;
                combined = true;
                endNode = cand.otherNodeId;
                visitedWays.add(cand.wayId);
                this.loadNodes(cand.nodes, list);
                for (int i = 2; i < list.size(); ++i) {
                    wayNodes.add(list.get(i));
                }
                for (MapRenderingTypes.MapRulType rt : new ArrayList<MapRenderingTypes.MapRulType>(this.namesUse.keySet())) {
                    if (Algorithms.objectEquals((Object)this.namesUse.get(rt), (Object)cand.names.get(rt)) || this.checkOneLocaleHasSameName(this.namesUse, cand.names, rt)) continue;
                    this.namesUse.remove(rt);
                }
            }
            ArrayList<Node> wNodes = new ArrayList<Node>();
            int wNsize = wayNodes.size();
            for (int i = 0; i < wNsize; i += 2) {
                wNodes.add(new Node((double)wayNodes.get(i).floatValue(), (double)wayNodes.get(i + 1).floatValue(), i == 0 ? startNode : endNode));
            }
            boolean skip = false;
            boolean bl3 = cycle = startNode == endNode;
            if (cycle) {
                skip = IndexVectorMapCreator.checkForSmallAreas(wNodes, zoom + Math.min(this.settings.zoomWaySmoothness / 2, 3), 3, 4);
            } else if (!this.typeUse.contains(this.renderingTypes.getCoastlineRuleType().getInternalId())) {
                skip = IndexVectorMapCreator.checkForSmallAreas(wNodes, zoom + Math.min(this.settings.zoomWaySmoothness / 2, 3), 2, 8);
            }
            if (skip) continue;
            ArrayList<Node> res = new ArrayList<Node>();
            OsmMapUtils.simplifyDouglasPeucker(wNodes, (int)(zoom - 1 + 8 + this.settings.zoomWaySmoothness), (int)3, res, (boolean)false);
            if (res.size() <= 0) continue;
            this.insertBinaryMapRenderObjectIndex(this.mapTree[level], res, null, this.namesUse, id, false, this.typeUse, this.addtypeUse, false, cycle);
        }
    }

    private boolean checkOneLocaleHasSameName(TreeMap<MapRenderingTypes.MapRulType, String> nu1, Map<MapRenderingTypes.MapRulType, String> nu2, MapRenderingTypes.MapRulType rt) {
        String tg = rt.getTag();
        if (tg.startsWith("name:") || tg.equals("name")) {
            for (MapRenderingTypes.MapRulType r : nu1.keySet()) {
                if (!r.getTag().startsWith("name:") && !r.getTag().equals("name") || !Algorithms.objectEquals((Object)nu1.get(r), (Object)nu2.get(r)) || Algorithms.isBlank((String)nu1.get(r))) continue;
                return true;
            }
        }
        return false;
    }

    private LowLevelWayCandidate getCandidate(List<LowLevelWayCandidate> candidates, Comparator<LowLevelWayCandidate> cmpCandidates) {
        if (candidates.size() > 0) {
            Collections.sort(candidates, cmpCandidates);
            LowLevelWayCandidate cand = candidates.get(0);
            if (cand.namesCount > 0) {
                return cand;
            }
            if (cand.names.isEmpty() && this.namesUse.isEmpty()) {
                return cand;
            }
        }
        return null;
    }

    public static boolean checkForSmallAreas(List<Node> nodes, int zoom, int minz, int maxz) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int c = 0;
        int nsize = nodes.size();
        for (int i = 0; i < nsize; ++i) {
            if (nodes.get(i) == null) continue;
            ++c;
            int x = (int)(MapUtils.getTileNumberX((float)zoom, (double)nodes.get(i).getLongitude()) * 256.0);
            int y = (int)(MapUtils.getTileNumberY((float)zoom, (double)nodes.get(i).getLatitude()) * 256.0);
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        if (c < 2) {
            return true;
        }
        return maxX - minX <= minz && maxY - minY <= maxz || maxX - minX <= maxz && maxY - minY <= minz;
    }

    private boolean checkBelongsToSeaWays(List<Way> ways) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Way w : ways) {
            if (w == null) continue;
            for (Node n : w.getNodes()) {
                if (n == null) continue;
                nodes.add(n);
            }
        }
        return this.checkBelongsToSea(nodes);
    }

    private boolean checkBelongsToSea(List<Node> nodes) {
        int zoom;
        if (nodes == null || nodes.isEmpty()) {
            return false;
        }
        if (this.checkSeaTile == null) {
            this.checkSeaTile = new BasemapProcessor();
            this.checkSeaTile.constructBitSetInfo(null);
        }
        int x = MapUtils.get31TileNumberX((double)nodes.get(0).getLongitude());
        int y = MapUtils.get31TileNumberY((double)nodes.get(0).getLatitude());
        int minX = x;
        int minY = y;
        int maxX = x;
        int maxY = y;
        for (Node n : nodes) {
            int sx = MapUtils.get31TileNumberX((double)n.getLongitude());
            int sy = MapUtils.get31TileNumberY((double)n.getLatitude());
            if (maxX < sx) {
                maxX = sx;
            } else if (sx < minX) {
                minX = sx;
            }
            if (maxY < sy) {
                maxY = sy;
                continue;
            }
            if (sy >= minY) continue;
            minY = sy;
        }
        for (zoom = 31; minX != maxX && minY != maxY || zoom >= 11; --zoom, minX >>= 1, maxX >>= 1, minY >>= 1, maxY >>= 1) {
        }
        return !this.checkSeaTile.isLandTile(minX, minY, zoom);
    }

    public void iterateMainEntity(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        if ((e instanceof Way || e instanceof Node) && !this.settings.keepOnlyRouteRelationObjects) {
            Map<String, String> tags = this.tagsTransformer.addPropogatedTags(this.renderingTypes, MapRenderingTypesEncoder.EntityConvertApplyType.MAP, e, e.getTags());
            tags = icc.getIndexRouteRelationCreator().addClickableWayTags(icc, e, tags, false);
            long originalId = e.getId();
            long assignedId = e.getId();
            for (int level = 0; level < this.mapZooms.size(); ++level) {
                this.processMainEntity(e, originalId, assignedId, level, tags, icc);
            }
            this.createCenterNodeForSmallIsland(e, tags, originalId, icc);
        }
    }

    private void createCenterNodeForSmallIsland(Entity e, Map<String, String> tags, long originalId, IndexCreationContext icc) throws SQLException {
        QuadRect bbox;
        if (e instanceof Way && tags.size() > 2 && "coastline".equals(tags.get("natural")) && ("island".equals(tags.get("place")) || "islet".equals(tags.get("place"))) && (bbox = ((Way)e).getLatLonBBox()) != null) {
            Node node = new Node(bbox.centerY(), bbox.centerX(), e.getId());
            node.copyTags(e);
            node.removeTag("natural");
            Map nodeTags = node.getTags();
            Entity.EntityId eid = Entity.EntityId.valueOf((Entity)e);
            long assignedId = this.assignIdBasedOnOriginalSplit(eid);
            for (int level = 0; level < this.mapZooms.size(); ++level) {
                this.processMainEntity((Entity)node, originalId, assignedId, level, nodeTags, icc);
            }
        }
    }

    protected void processMainEntity(Entity e, long originalId, long assignedId, int level, Map<String, String> tags, IndexCreationContext icc) throws SQLException {
        boolean hasMulti;
        if (this.settings.keepOnlySeaObjects) {
            if ("coastline".equals(tags.get("natural"))) {
                tags = new LinkedHashMap<String, String>(tags);
                tags.remove("natural", "coastline");
            }
            if (e instanceof Node && !this.checkBelongsToSea(Collections.singletonList((Node)e))) {
                return;
            }
            if (e instanceof Way && !this.checkBelongsToSea(((Way)e).getNodes())) {
                return;
            }
        }
        boolean area = this.renderingTypes.encodeEntityWithType(e instanceof Node, tags, this.mapZooms.getLevel(level).getMaxZoom(), this.typeUse, this.addtypeUse, this.namesUse, this.tempNameUse);
        if (this.typeUse.isEmpty()) {
            return;
        }
        boolean bl = hasMulti = e instanceof Way && this.multiPolygonsWays.containsKey(originalId);
        if (hasMulti) {
            TIntArrayList set = this.multiPolygonsWays.get(originalId);
            this.typeUse.removeAll((TIntCollection)set);
        }
        if (this.typeUse.isEmpty()) {
            return;
        }
        if (icc.bboxFilter.shouldFilterMapEntity(e)) {
            icc.bboxFilter.logEntity(e);
            return;
        }
        long id = this.convertBaseIdToGeneratedId(assignedId, level);
        List<Node> res = null;
        boolean cycle = false;
        if (e instanceof Node) {
            res = Collections.singletonList((Node)e);
        } else {
            boolean mostDetailedLevel;
            id |= 1L;
            cycle = ((Way)e).getFirstNodeId() == ((Way)e).getLastNodeId();
            boolean bl2 = mostDetailedLevel = level == 0 && !this.mapZooms.isDetailedZoomSimplified();
            if (!mostDetailedLevel) {
                int zoomToSimplify = this.mapZooms.getLevel(level).getMaxZoom() - 1;
                if (cycle) {
                    res = IndexVectorMapCreator.simplifyCycleWay(((Way)e).getNodes(), zoomToSimplify, this.settings.zoomWaySmoothness);
                    if (this.isClockwiseBroken(tags, (Way)e, res)) {
                        res = null;
                    }
                } else {
                    this.validateDuplicate(originalId, id);
                    this.insertLowLevelMapBinaryObject(level, zoomToSimplify, this.typeUse, this.addtypeUse, id, ((Way)e).getNodes(), this.namesUse);
                }
            } else {
                res = ((Way)e).getNodes();
            }
        }
        if (res != null) {
            this.validateDuplicate(originalId, id);
            this.insertBinaryMapRenderObjectIndex(this.mapTree[level], (Collection<Node>)res, null, this.namesUse, id, area, this.typeUse, this.addtypeUse, true, cycle);
        }
    }

    private void validateDuplicate(long originalId, long assignedId) {
        if (VALIDATE_DUPLICATE) {
            if (this.duplicateIds.contains(assignedId)) {
                throw new IllegalStateException("Duplicate id='" + assignedId + "' from '" + String.valueOf(this.duplicateIds.get(assignedId)) + "' and '" + originalId + "'");
            }
            this.duplicateIds.put(assignedId, (Object)originalId);
        }
    }

    public void writeBinaryMapIndex(BinaryMapIndexWriter writer, String regionName) throws IOException, SQLException {
        this.closePreparedStatements(this.mapBinaryStat, this.mapLowLevelBinaryStat);
        this.mapConnection.commit();
        try {
            writer.startWriteMapIndex(regionName);
            writer.writeMapEncodingRules(this.renderingTypes.getEncodingRuleTypes());
            PreparedStatement selectData = this.mapConnection.prepareStatement("SELECT area, coordinates, innerPolygons, types, additionalTypes, name, labelCoordinates FROM binary_map_objects WHERE id = ?");
            TLongObjectHashMap treeHeader = new TLongObjectHashMap();
            for (int i = 0; i < this.mapZooms.size(); ++i) {
                RTree rtree = this.mapTree[i];
                long rootIndex = rtree.getFileHdr().getRootIndex();
                rtree.Node root = rtree.getReadNode(rootIndex);
                Rect rootBounds = IndexVectorMapCreator.calcBounds(root);
                if (rootBounds == null) continue;
                writer.startWriteMapLevelIndex(this.mapZooms.getLevel(i).getMinZoom(), this.mapZooms.getLevel(i).getMaxZoom(), rootBounds.getMinX(), rootBounds.getMaxX(), rootBounds.getMinY(), rootBounds.getMaxY());
                IndexVectorMapCreator.writeBinaryMapTree(root, rootBounds, rtree, writer, (TLongObjectHashMap<BinaryFileReference>)treeHeader);
                this.writeBinaryMapBlock(root, rootBounds, rtree, writer, selectData, (TLongObjectHashMap<BinaryFileReference>)treeHeader, new LinkedHashMap<String, Integer>(), new LinkedHashMap<MapRenderingTypes.MapRulType, String>(), this.mapZooms.getLevel(i));
                writer.endWriteMapLevelIndex();
            }
            selectData.close();
            writer.endWriteMapIndex();
            writer.flush();
        }
        catch (RTreeException e) {
            throw new IllegalStateException(e);
        }
    }

    private long convertBaseIdToGeneratedId(long baseId, int level) {
        if (level >= 8) {
            throw new IllegalArgumentException("Number of zoom levels " + level + " exceeds allowed maximum : 8");
        }
        return (baseId << 3 | (long)level) << 1;
    }

    public long convertGeneratedIdToObfWrite(long id) {
        return (id >> 3) + (id & 1L);
    }

    private String encodeNames(Map<MapRenderingTypes.MapRulType, String> tempNames) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<MapRenderingTypes.MapRulType, String> e : tempNames.entrySet()) {
            if (e.getValue() == null) continue;
            b.append('\u0000').append((char)e.getKey().getInternalId()).append(e.getValue());
        }
        return b.toString();
    }

    private Map<MapRenderingTypes.MapRulType, String> decodeNames(String name, Map<MapRenderingTypes.MapRulType, String> tempNames) {
        int i = name.indexOf(0);
        while (i != -1) {
            int n = name.indexOf(0, i + 2);
            short ch = (short)name.charAt(i + 1);
            MapRenderingTypes.MapRulType rt = this.renderingTypes.getTypeByInternalId(ch);
            if (n == -1) {
                tempNames.put(rt, name.substring(i + 2));
            } else {
                tempNames.put(rt, name.substring(i + 2, n));
            }
            i = n;
        }
        return tempNames;
    }

    public void writeBinaryMapBlock(rtree.Node parent, Rect parentBounds, RTree r, BinaryMapIndexWriter writer, PreparedStatement selectData, TLongObjectHashMap<BinaryFileReference> bounds, Map<String, Integer> tempStringTable, LinkedHashMap<MapRenderingTypes.MapRulType, String> tempNames, MapZooms.MapZoomPair level) throws IOException, RTreeException, SQLException {
        int i;
        Element[] e = parent.getAllElements();
        OsmandOdb.MapDataBlock.Builder dataBlock = null;
        BinaryFileReference ref = (BinaryFileReference)bounds.get(parent.getNodeIndex());
        long baseId = 0L;
        for (i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() != 1) continue;
            long id = e[i].getPtr();
            selectData.setLong(1, id);
            ResultSet rs = selectData.executeQuery();
            if (rs.next()) {
                OsmandOdb.MapData mapData;
                long cid = this.convertGeneratedIdToObfWrite(id);
                boolean allowWaySimplification = level.getMaxZoom() > 15;
                byte[] types = rs.getBytes(4);
                ArrayList<MapRenderingTypes.MapRulType> mainTypes = new ArrayList<MapRenderingTypes.MapRulType>();
                for (int j = 0; j < types.length; j += 2) {
                    int ids = Algorithms.parseSmallIntFromBytes((byte[])types, (int)j);
                    MapRenderingTypes.MapRulType mapRulType = this.renderingTypes.getTypeByInternalId(ids);
                    if ("railway".equals(mapRulType.getTag()) && "tram".equals(mapRulType.getValue())) {
                        allowWaySimplification = false;
                    }
                    mainTypes.add(mapRulType);
                }
                boolean ignore = false;
                if (cid % 2L == 0L && this.propagateToNodes.getPropagateByNodeId(cid >> 1) != null) {
                    this.propagateToNodes.calculateBorderPointMainTypes(cid >> 1, mainTypes);
                    if (mainTypes.size() == 0) {
                        ignore = true;
                    }
                }
                if (dataBlock == null) {
                    baseId = cid;
                    dataBlock = writer.createWriteMapDataBlock(baseId);
                    tempStringTable.clear();
                }
                tempNames.clear();
                this.decodeNames(rs.getString(6), tempNames);
                int[] typeUse = new int[mainTypes.size()];
                for (int k = 0; k < typeUse.length; ++k) {
                    typeUse[k] = ((MapRenderingTypes.MapRulType)mainTypes.get(k)).getTargetId();
                }
                byte[] addTypes = rs.getBytes(5);
                int[] addtypeUse = null;
                if (addTypes != null) {
                    addtypeUse = new int[addTypes.length / 2];
                    for (int j = 0; j < addTypes.length; j += 2) {
                        int ids = Algorithms.parseSmallIntFromBytes((byte[])addTypes, (int)j);
                        MapRenderingTypes.MapRulType mapRulType = this.renderingTypes.getTypeByInternalId(ids);
                        addtypeUse[j / 2] = mapRulType.getTargetId();
                    }
                }
                if ((mapData = writer.writeMapData(cid - baseId, parentBounds.getMinX(), parentBounds.getMinY(), rs.getBoolean(1), rs.getBytes(2), rs.getBytes(3), typeUse, addtypeUse, tempNames, rs.getBytes(7), null, tempStringTable, dataBlock, allowWaySimplification)) == null || ignore) continue;
                dataBlock.addDataObjects(mapData);
                continue;
            }
            this.logMapDataWarn.error((Object)("Something goes wrong with id = " + id));
        }
        if (dataBlock != null) {
            writer.writeMapDataBlock(dataBlock, tempStringTable, ref);
        }
        for (i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() == 1) continue;
            long ptr = e[i].getPtr();
            rtree.Node ns = r.getReadNode(ptr);
            this.writeBinaryMapBlock(ns, e[i].getRect(), r, writer, selectData, bounds, tempStringTable, tempNames, level);
        }
    }

    public static void writeBinaryMapTree(rtree.Node parent, Rect re, RTree r, BinaryMapIndexWriter writer, TLongObjectHashMap<BinaryFileReference> bounds) throws IOException, RTreeException {
        Element[] e = parent.getAllElements();
        boolean containsLeaf = false;
        for (int i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() != 1) continue;
            containsLeaf = true;
        }
        BinaryFileReference ref = writer.startMapTreeElement(re.getMinX(), re.getMaxX(), re.getMinY(), re.getMaxY(), containsLeaf);
        if (ref != null) {
            bounds.put(parent.getNodeIndex(), (Object)ref);
        }
        for (int i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() == 1) continue;
            rtree.Node chNode = r.getReadNode(e[i].getPtr());
            IndexVectorMapCreator.writeBinaryMapTree(chNode, e[i].getRect(), r, writer, bounds);
        }
        writer.endWriteMapTreeElement();
    }

    public static Rect calcBounds(rtree.Node n) {
        Rect r = null;
        Element[] e = n.getAllElements();
        for (int i = 0; i < n.getTotalElements(); ++i) {
            Rect re = e[i].getRect();
            if (r == null) {
                try {
                    r = new Rect(re.getMinX(), re.getMinY(), re.getMaxX(), re.getMaxY());
                }
                catch (IllegalValueException illegalValueException) {}
                continue;
            }
            r.expandToInclude(re);
        }
        return r;
    }

    public static void writeBinaryMapBlock(rtree.Node parent, Rect parentBounds, RTree r, BinaryMapIndexWriter writer, TLongObjectHashMap<BinaryFileReference> bounds, TLongObjectHashMap<BinaryMapDataObject> objects, MapZooms.MapZoomPair pair, boolean doNotSimplify) throws IOException, RTreeException {
        int i;
        Element[] e = parent.getAllElements();
        OsmandOdb.MapDataBlock.Builder dataBlock = null;
        BinaryFileReference ref = (BinaryFileReference)bounds.get(parent.getNodeIndex());
        long baseId = 0L;
        LinkedHashMap<String, Integer> tempStringTable = new LinkedHashMap<String, Integer>();
        for (i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() != 1) continue;
            long id = e[i].getPtr();
            if (objects.containsKey(id)) {
                OsmandOdb.MapData mapData;
                byte[] labelCoordinates;
                long cid = id;
                BinaryMapDataObject mdo = (BinaryMapDataObject)objects.get(id);
                if (dataBlock == null) {
                    baseId = cid;
                    dataBlock = writer.createWriteMapDataBlock(baseId);
                    tempStringTable.clear();
                }
                int[] typeUse = mdo.getTypes();
                int[] addtypeUse = mdo.getAdditionalTypes();
                byte[] coordinates = new byte[8 * mdo.getPointsLength()];
                for (int t = 0; t < mdo.getPointsLength(); ++t) {
                    Algorithms.putIntToBytes((byte[])coordinates, (int)(8 * t), (int)mdo.getPoint31XTile(t));
                    Algorithms.putIntToBytes((byte[])coordinates, (int)(8 * t + 4), (int)mdo.getPoint31YTile(t));
                }
                if (mdo.isLabelSpecified()) {
                    labelCoordinates = new byte[8];
                    Algorithms.putIntToBytes((byte[])labelCoordinates, (int)0, (int)mdo.getLabelX());
                    Algorithms.putIntToBytes((byte[])labelCoordinates, (int)4, (int)mdo.getLabelY());
                } else {
                    labelCoordinates = new byte[]{};
                }
                byte[] innerPolygonTypes = new byte[]{};
                int[][] pip = mdo.getPolygonInnerCoordinates();
                if (pip != null && pip.length > 0) {
                    ByteArrayOutputStream bous = new ByteArrayOutputStream();
                    for (int s = 0; s < pip.length; ++s) {
                        int[] st = pip[s];
                        for (int t = 0; t < st.length; ++t) {
                            Algorithms.writeInt((OutputStream)bous, (int)st[t]);
                        }
                        Algorithms.writeInt((OutputStream)bous, (int)0);
                        Algorithms.writeInt((OutputStream)bous, (int)0);
                    }
                    innerPolygonTypes = bous.toByteArray();
                }
                if ((mapData = writer.writeMapData(cid - baseId, parentBounds.getMinX(), parentBounds.getMinY(), mdo.isArea(), coordinates, innerPolygonTypes, typeUse, addtypeUse, null, labelCoordinates, mdo.getOrderedObjectNames(), tempStringTable, dataBlock, !doNotSimplify && pair.getMaxZoom() > 15)) == null) continue;
                dataBlock.addDataObjects(mapData);
                continue;
            }
            log.error((Object)("Something goes wrong with id = " + id));
        }
        if (dataBlock != null) {
            writer.writeMapDataBlock(dataBlock, tempStringTable, ref);
        }
        for (i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() == 1) continue;
            long ptr = e[i].getPtr();
            rtree.Node ns = r.getReadNode(ptr);
            IndexVectorMapCreator.writeBinaryMapBlock(ns, e[i].getRect(), r, writer, bounds, objects, pair, doNotSimplify);
        }
    }

    public void createDatabaseStructure(Connection mapConnection, DBDialect dialect, String rtreeMapIndexNonPackFileName) throws SQLException, IOException {
        this.createMapIndexStructure(mapConnection);
        this.mapConnection = mapConnection;
        this.mapBinaryStat = this.createStatementMapBinaryInsert(mapConnection);
        this.mapLowLevelBinaryStat = this.createStatementLowLevelMapBinaryInsert(mapConnection);
        try {
            this.mapTree = new RTree[this.mapZooms.size()];
            for (int i = 0; i < this.mapZooms.size(); ++i) {
                File file = new File(rtreeMapIndexNonPackFileName + i);
                if (file.exists()) {
                    file.delete();
                }
                this.mapTree[i] = new RTree(rtreeMapIndexNonPackFileName + i);
            }
        }
        catch (RTreeException e) {
            throw new IOException(e);
        }
        this.pStatements.put(this.mapBinaryStat, 0);
        this.pStatements.put(this.mapLowLevelBinaryStat, 0);
    }

    public void createMapIndexTableIndexes(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.executeUpdate("create index binary_map_objects_ind on binary_map_objects (id)");
        stat.executeUpdate("create index low_level_map_objects_ind on low_level_map_objects (id)");
        stat.executeUpdate("create index low_level_map_objects_ind_st on low_level_map_objects (start_node, type)");
        stat.executeUpdate("create index low_level_map_objects_ind_end on low_level_map_objects (end_node, type)");
        stat.close();
    }

    private void createMapIndexStructure(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.executeUpdate("create table binary_map_objects (id bigint primary key, name varchar(4096), area smallint, types binary, additionalTypes binary, coordinates binary, innerPolygons binary, labelCoordinates binary)");
        stat.executeUpdate("create table low_level_map_objects (id bigint primary key, start_node bigint, end_node bigint, name varchar(1024), nodes binary, type binary, addType binary, level smallint)");
        stat.close();
    }

    private PreparedStatement createStatementMapBinaryInsert(Connection conn) throws SQLException {
        return conn.prepareStatement("insert into binary_map_objects(id, area, coordinates, innerPolygons, types, additionalTypes, name, labelCoordinates) values(?, ?, ?, ?, ?, ?, ?, ?)");
    }

    private PreparedStatement createStatementLowLevelMapBinaryInsert(Connection conn) throws SQLException {
        return conn.prepareStatement("insert into low_level_map_objects(id, start_node, end_node, name, nodes, type, addType, level) values(?, ?, ?, ?, ?, ?, ?, ?)");
    }

    private void insertLowLevelMapBinaryObject(int level, int zoom, TIntArrayList types, TIntArrayList addTypes, long id, List<Node> in, TreeMap<MapRenderingTypes.MapRulType, String> namesUse) throws SQLException {
        int j;
        ++this.lowLevelWays;
        ArrayList nodes = new ArrayList();
        OsmMapUtils.simplifyDouglasPeucker(in, (int)(zoom + 8 + this.settings.zoomWaySmoothness), (int)3, nodes, (boolean)false);
        boolean first = true;
        long firstId = -1L;
        long lastId = -1L;
        ByteArrayOutputStream bNodes = new ByteArrayOutputStream();
        ByteArrayOutputStream bTypes = new ByteArrayOutputStream();
        ByteArrayOutputStream bAddtTypes = new ByteArrayOutputStream();
        try {
            for (Node n : nodes) {
                if (n == null) continue;
                if (first) {
                    firstId = n.getId();
                    first = false;
                }
                lastId = n.getId();
                Algorithms.writeInt((OutputStream)bNodes, (int)Float.floatToRawIntBits((float)n.getLatitude()));
                Algorithms.writeInt((OutputStream)bNodes, (int)Float.floatToRawIntBits((float)n.getLongitude()));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (firstId == -1L) {
            return;
        }
        for (j = 0; j < types.size(); ++j) {
            try {
                Algorithms.writeSmallInt((OutputStream)bTypes, (int)types.get(j));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (j = 0; j < addTypes.size(); ++j) {
            try {
                Algorithms.writeSmallInt((OutputStream)bAddtTypes, (int)addTypes.get(j));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mapLowLevelBinaryStat.setLong(1, id);
        this.mapLowLevelBinaryStat.setLong(2, firstId);
        this.mapLowLevelBinaryStat.setLong(3, lastId);
        this.mapLowLevelBinaryStat.setString(4, this.encodeNames(namesUse));
        this.mapLowLevelBinaryStat.setBytes(5, bNodes.toByteArray());
        this.mapLowLevelBinaryStat.setBytes(6, bTypes.toByteArray());
        this.mapLowLevelBinaryStat.setBytes(7, bAddtTypes.toByteArray());
        this.mapLowLevelBinaryStat.setShort(8, (short)level);
        this.addBatch(this.mapLowLevelBinaryStat);
    }

    private void insertBinaryMapRenderObjectIndex(RTree mapTree, Collection<Node> nodes, List<List<Node>> innerWays, Map<MapRenderingTypes.MapRulType, String> names, long id, boolean area, TIntArrayList types, TIntArrayList addTypes, boolean commit, boolean cycle) throws SQLException {
        boolean init = false;
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        ByteArrayOutputStream bcoordinates = new ByteArrayOutputStream();
        ByteArrayOutputStream binnercoord = new ByteArrayOutputStream();
        ByteArrayOutputStream btypes = new ByteArrayOutputStream();
        ByteArrayOutputStream badditionalTypes = new ByteArrayOutputStream();
        ByteArrayOutputStream blabelCoordinates = new ByteArrayOutputStream();
        try {
            int j;
            for (j = 0; j < types.size(); ++j) {
                Algorithms.writeSmallInt((OutputStream)btypes, (int)types.get(j));
            }
            for (j = 0; j < addTypes.size(); ++j) {
                Algorithms.writeSmallInt((OutputStream)badditionalTypes, (int)addTypes.get(j));
            }
            for (Node node : nodes) {
                if (node == null) continue;
                int y = MapUtils.get31TileNumberY((double)node.getLatitude());
                int x = MapUtils.get31TileNumberX((double)node.getLongitude());
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
                init = true;
                Algorithms.writeInt((OutputStream)bcoordinates, (int)x);
                Algorithms.writeInt((OutputStream)bcoordinates, (int)y);
            }
            if (cycle && !Algorithms.isEmpty(nodes)) {
                LatLon labelll = OsmMapUtils.getComplexPolyCenter(nodes, innerWays);
                Algorithms.writeInt((OutputStream)blabelCoordinates, (int)MapUtils.get31TileNumberX((double)labelll.getLongitude()));
                Algorithms.writeInt((OutputStream)blabelCoordinates, (int)MapUtils.get31TileNumberY((double)labelll.getLatitude()));
            }
            if (innerWays != null) {
                for (List list : innerWays) {
                    boolean exist = false;
                    if (list != null) {
                        for (Node n : list) {
                            if (n == null) continue;
                            exist = true;
                            int y = MapUtils.get31TileNumberY((double)n.getLatitude());
                            int x = MapUtils.get31TileNumberX((double)n.getLongitude());
                            Algorithms.writeInt((OutputStream)binnercoord, (int)x);
                            Algorithms.writeInt((OutputStream)binnercoord, (int)y);
                        }
                    }
                    if (!exist) continue;
                    Algorithms.writeInt((OutputStream)binnercoord, (int)0);
                    Algorithms.writeInt((OutputStream)binnercoord, (int)0);
                }
            }
        }
        catch (IOException es) {
            throw new IllegalStateException(es);
        }
        if (init) {
            this.mapBinaryStat.setLong(1, id);
            this.mapBinaryStat.setBoolean(2, area);
            this.mapBinaryStat.setBytes(3, bcoordinates.toByteArray());
            this.mapBinaryStat.setBytes(4, binnercoord.toByteArray());
            this.mapBinaryStat.setBytes(5, btypes.toByteArray());
            this.mapBinaryStat.setBytes(6, badditionalTypes.toByteArray());
            this.mapBinaryStat.setString(7, this.encodeNames(names));
            this.mapBinaryStat.setBytes(8, blabelCoordinates.toByteArray());
            this.addBatch(this.mapBinaryStat, commit);
            try {
                mapTree.insert(new LeafElement(new Rect(minX, minY, maxX, maxY), id));
            }
            catch (RTreeInsertException e1) {
                throw new IllegalArgumentException(e1);
            }
            catch (IllegalValueException e1) {
                throw new IllegalArgumentException(e1);
            }
        }
    }

    public void createRTreeFiles(String rTreeMapIndexPackFileName) throws RTreeException {
        this.mapTree = new RTree[this.mapZooms.size()];
        for (int i = 0; i < this.mapZooms.size(); ++i) {
            this.mapTree[i] = new RTree(rTreeMapIndexPackFileName + i);
        }
    }

    public void packRtreeFiles(String rTreeMapIndexNonPackFileName, String rTreeMapIndexPackFileName) throws IOException {
        for (int i = 0; i < this.mapZooms.size(); ++i) {
            this.mapTree[i] = IndexVectorMapCreator.packRtreeFile(this.mapTree[i], rTreeMapIndexNonPackFileName + i, rTreeMapIndexPackFileName + i);
        }
    }

    public void commitAndCloseFiles(String rTreeMapIndexNonPackFileName, String rTreeMapIndexPackFileName, boolean deleteDatabaseIndexes) throws IOException, SQLException {
        if (this.mapTree != null) {
            int i;
            for (i = 0; i < this.mapTree.length; ++i) {
                if (this.mapTree[i] == null) continue;
                RandomAccessFile file = this.mapTree[i].getFileHdr().getFile();
                file.close();
            }
            for (i = 0; i < this.mapTree.length; ++i) {
                File f = new File(rTreeMapIndexNonPackFileName + i);
                if (f.exists() && deleteDatabaseIndexes) {
                    f.delete();
                }
                if (!(f = new File(rTreeMapIndexPackFileName + i)).exists() || !deleteDatabaseIndexes) continue;
                f.delete();
            }
        }
        this.closeAllPreparedStatements();
    }

    private boolean isClockwiseBroken(Map<String, String> tags, Way e, List<Node> simplyiedNodes) {
        if (!"coastline".equals(tags.get("natural")) || simplyiedNodes == null) {
            return false;
        }
        boolean clockwiseBefore = OsmMapUtils.isClockwiseWay((Way)e);
        boolean clockwiseAfter = OsmMapUtils.isClockwiseWay((Way)new Way(e.getId(), simplyiedNodes));
        return clockwiseAfter != clockwiseBefore;
    }

    private static class LowLevelWayCandidate {
        public byte[] nodes;
        public long wayId;
        public long otherNodeId;
        public Map<MapRenderingTypes.MapRulType, String> names;
        public int namesCount = 0;

        private LowLevelWayCandidate() {
        }
    }
}

